/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public final class CenteredZoomAction
extends WidgetAction.Adapter {
    private double zoomMultiplier;

    public CenteredZoomAction(double d) {
        this.zoomMultiplier = d;
    }

    @Override
    public WidgetAction.State mouseWheelMoved(Widget widget, WidgetAction.WidgetMouseWheelEvent widgetMouseWheelEvent) {
        int n;
        Scene scene = widget.getScene();
        int n2 = scene.getInputBindings().getZoomActionModifiers();
        if ((widgetMouseWheelEvent.getModifiers() & n2) != n2) {
            return WidgetAction.State.REJECTED;
        }
        double d = 1.0;
        for (n = widgetMouseWheelEvent.getWheelRotation(); n > 0; --n) {
            d /= this.zoomMultiplier;
        }
        while (n < 0) {
            d *= this.zoomMultiplier;
            ++n;
        }
        JComponent jComponent = scene.getView();
        if (jComponent != null) {
            Rectangle rectangle = jComponent.getVisibleRect();
            Point point = GeomUtil.center(rectangle);
            point = scene.convertViewToScene(point);
            scene.setZoomFactor(d * scene.getZoomFactor());
            scene.validate();
            point = scene.convertSceneToView(point);
            jComponent.scrollRectToVisible(new Rectangle(point.x - rectangle.width / 2, point.y - rectangle.height / 2, rectangle.width, rectangle.height));
        } else {
            scene.setZoomFactor(d * scene.getZoomFactor());
        }
        return WidgetAction.State.CONSUMED;
    }
}

