/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.schema.XsdNsDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

final class CreateXmlElementIntentionAction
implements IntentionAction {
    private final String myMessageKey;
    private final TypeOrElementOrAttributeReference myRef;
    private boolean myIsAvailableEvaluated;
    private XmlFile myTargetFile;
    private final String myDeclarationTagName;

    CreateXmlElementIntentionAction(@PropertyKey(resourceBundle="messages.XmlAnalysisBundle") @PropertyKey(resourceBundle="messages.XmlAnalysisBundle") String messageKey, @NonNls @NotNull String declarationTagName, TypeOrElementOrAttributeReference ref) {
        if (declarationTagName == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(0);
        }
        this.myMessageKey = messageKey;
        this.myRef = ref;
        this.myDeclarationTagName = declarationTagName;
    }

    @NotNull
    public String getText() {
        String string = XmlAnalysisBundle.message((String)this.myMessageKey, (Object[])new Object[]{XmlUtil.findLocalNameByQualifiedName(this.myRef.getCanonicalText())});
        if (string == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"xml.intention.create.xml.declaration", (Object[])new Object[0]);
        if (string == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(3);
        }
        if (!this.myIsAvailableEvaluated) {
            XsdNsDescriptor descriptor;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myRef.getElement(), XmlTag.class);
            if (tag != null && tag.isValid() && (descriptor = this.myRef.getDescriptor(tag, this.myRef.getCanonicalText(), new boolean[1])) != null && descriptor.getDescriptorFile() != null && descriptor.getDescriptorFile().isWritable()) {
                this.myTargetFile = descriptor.getDescriptorFile();
            }
            this.myIsAvailableEvaluated = true;
        }
        return this.myTargetFile != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        Editor targetEditor;
        if (project2 == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(4);
        }
        XmlTag rootTag = this.myTargetFile.getDocument().getRootTag();
        if (this.myTargetFile.getVirtualFile() == null) {
            targetEditor = editor;
            targetEditor.getDocument().setText((CharSequence)"");
            targetEditor.getCaretModel().moveToOffset(0);
        } else {
            targetEditor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, this.myTargetFile.getVirtualFile(), rootTag.getValue().getTextRange().getEndOffset()), true);
        }
        TemplateManager manager = TemplateManager.getInstance((Project)project2);
        Template template = manager.createTemplate("", "");
        this.addTextTo(template, rootTag);
        manager.startTemplate(targetEditor, template);
    }

    private void addTextTo(Template template, XmlTag rootTag) {
        Object schemaPrefix = rootTag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema");
        if (schemaPrefix == null) {
            schemaPrefix = "";
        }
        if (!((String)schemaPrefix).isEmpty()) {
            schemaPrefix = (String)schemaPrefix + ":";
        }
        template.addTextSegment("<" + (String)schemaPrefix + this.myDeclarationTagName + " name=\"" + XmlUtil.findLocalNameByQualifiedName(this.myRef.getCanonicalText()) + "\">");
        template.addEndVariable();
        template.addTextSegment("</" + (String)schemaPrefix + this.myDeclarationTagName + ">\n");
        template.setToReformat(true);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(5);
        }
        PsiElement copy = PsiTreeUtil.findSameElementInCopy((PsiElement)this.myRef.getElement(), (PsiFile)target);
        PsiReference reference = copy.getReference();
        CreateXmlElementIntentionAction intentionAction = new CreateXmlElementIntentionAction(this.myMessageKey, this.myDeclarationTagName, (TypeOrElementOrAttributeReference)reference);
        intentionAction.myTargetFile = (XmlFile)target;
        CreateXmlElementIntentionAction createXmlElementIntentionAction = intentionAction;
        if (createXmlElementIntentionAction == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(6);
        }
        return createXmlElementIntentionAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationTagName";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/CreateXmlElementIntentionAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/CreateXmlElementIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileModifierForPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6 -> new IllegalStateException(string);
        };
    }
}

