/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.tailwind.util.TailwindUtil;
import org.jetbrains.annotations.NotNull;

public class TailwindAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            TailwindAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            TailwindAnnotator.$$$reportNull$$$0(1);
        }
        if (element.getParent() instanceof CssAtRule && ((CssAtRule)element.getParent()).getName().equals("@apply") && TailwindUtil.canBeTailwindCssClassNamePart(element) || TailwindAnnotator.isThemeFunctionArgumentIdentifier(element)) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(CssHighlighter.CSS_CLASS_NAME).create();
        }
    }

    private static boolean isThemeFunctionArgumentIdentifier(@NotNull PsiElement element) {
        if (element == null) {
            TailwindAnnotator.$$$reportNull$$$0(2);
        }
        if (element instanceof CssString) {
            return false;
        }
        if (element.getNode().getElementType().equals(CssElementTypes.CSS_NUMBER_TERM) && element.getText().contains("%")) {
            return false;
        }
        if (element.getText().equals("[") || element.getText().equals("]")) {
            return false;
        }
        return element.getParent() instanceof CssTerm && element.getParent().getParent() instanceof CssTermList && element.getParent().getParent().getParent() instanceof CssFunction && ((CssFunction)element.getParent().getParent().getParent()).getName().equals("theme");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tailwind/highlighting/TailwindAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isThemeFunctionArgumentIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

