/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointsProjectModel;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.ui.flat.DefaultEndpointsProjectModel;
import com.intellij.microservices.ui.flat.EndpointsView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\b\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"isEndpointsToolwindowAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "getActiveEndpointsView", "Lcom/intellij/microservices/ui/flat/EndpointsView;", "getAvailableEndpointTypes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointsProjectModel", "Lcom/intellij/microservices/endpoints/EndpointsProjectModel;", "intellij.microservices.ui"})
public final class EndpointsToolWindowFactoryKt {
    public static final boolean isEndpointsToolwindowAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        return toolWindowManager.getToolWindow("Endpoints") != null;
    }

    @Nullable
    public static final EndpointsView getActiveEndpointsView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Endpoints");
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (!toolWindow2.isAvailable() || !toolWindow2.isVisible()) {
            return null;
        }
        Content content = toolWindow2.getContentManager().getContent(0);
        JComponent jComponent = content != null ? content.getComponent() : null;
        return jComponent instanceof EndpointsView ? (EndpointsView)((Object)jComponent) : null;
    }

    @NotNull
    public static final Sequence<EndpointType> getAvailableEndpointTypes(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SequencesKt.distinctBy((Sequence)SequencesKt.map((Sequence)EndpointsProvider.Companion.getAvailableProviders(project), EndpointsToolWindowFactoryKt::getAvailableEndpointTypes$lambda$0), EndpointsToolWindowFactoryKt::getAvailableEndpointTypes$lambda$1);
    }

    @NotNull
    public static final EndpointsProjectModel getEndpointsProjectModel() {
        EndpointsProjectModel endpointsProjectModel = (EndpointsProjectModel)CollectionsKt.firstOrNull((List)EndpointsProjectModel.EP_NAME.getExtensionList());
        if (endpointsProjectModel == null) {
            endpointsProjectModel = new DefaultEndpointsProjectModel();
        }
        return endpointsProjectModel;
    }

    private static final EndpointType getAvailableEndpointTypes$lambda$0(EndpointsProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEndpointType();
    }

    private static final String getAvailableEndpointTypes$lambda$1(EndpointType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQueryTag();
    }
}

