/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async.extractor;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.ultimate.async.extractor.AbstractLazyCachingExtractor;
import java.io.File;
import java.io.FileInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ultimate/async/extractor/LazyCachingExtractorFromFile;", "Lcom/intellij/profiler/ultimate/async/extractor/AbstractLazyCachingExtractor;", "Ljava/io/File;", "file", "extraFile", "postProcessor", "Lkotlin/Function1;", "", "<init>", "(Ljava/io/File;Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "extract", "libraryInfo", "isExtra", "", "createDestination", "Lkotlin/Function0;", "fileName", "", "sourceStream", "Ljava/io/FileInputStream;", "intellij.profiler.ultimate.ideaAsyncProfiler"})
public final class LazyCachingExtractorFromFile
extends AbstractLazyCachingExtractor<File> {
    public LazyCachingExtractorFromFile(@NotNull File file, @Nullable File extraFile, @Nullable Function1<? super File, Unit> postProcessor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(file, extraFile, postProcessor);
        if (!(!StringsKt.contains$default((CharSequence)this.fileName(file), (CharSequence)" ", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-LazyCachingExtractorFromFile$32 = false;
            String $i$a$-require-LazyCachingExtractorFromFile$32 = "Library simple file name should not contain spaces: " + file.getAbsolutePath();
            throw new IllegalArgumentException($i$a$-require-LazyCachingExtractorFromFile$32.toString());
        }
        if (!(extraFile == null || !StringsKt.contains$default((CharSequence)this.fileName(extraFile), (CharSequence)" ", (boolean)false, (int)2, null))) {
            boolean bl = false;
            File file2 = extraFile;
            Intrinsics.checkNotNull((Object)file2);
            String string = "Library simple file name should not contain spaces: " + file2.getAbsolutePath();
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ LazyCachingExtractorFromFile(File file, File file2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(file, file2, (Function1<? super File, Unit>)function1);
    }

    @Override
    @NotNull
    protected File extract(@NotNull File libraryInfo, boolean isExtra, @NotNull Function0<? extends File> createDestination) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        Intrinsics.checkNotNullParameter(createDestination, (String)"createDestination");
        String string = libraryInfo.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        if (!(StringsKt.contains$default((CharSequence)string, (CharSequence)" ", (boolean)false, (int)2, null) || isExtra && !FileUtil.filesEqual((File)libraryInfo, (File)((File)createDestination.invoke())))) {
            return libraryInfo;
        }
        return super.extract(libraryInfo, isExtra, createDestination);
    }

    @Override
    @NotNull
    public String fileName(@NotNull File libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        String string = libraryInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public FileInputStream sourceStream(@NotNull File libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        return new FileInputStream(libraryInfo);
    }
}

