/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.jupyterPython.engine;

import com.intellij.dataWrangler.jupyterPython.DataWranglerJupyterPyBundle;
import com.intellij.dataWrangler.jupyterPython.engine.PythonDataWranglerContext;
import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.python.scientific.powerfuldataviewer.editor.DataViewVirtualFile;
import com.intellij.scientific.tables.DSTableDataRetrieverFromDataSourceImpl;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.OutputPsiExpression;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import com.jetbrains.python.PyElementTypes;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 )2\u00020\u0001:\u0001)B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u0011H\u0002J\b\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0011H\u0002J\b\u0010$\u001a\u0004\u0018\u00010\u0011J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0011J\u0014\u0010'\u001a\u0004\u0018\u00010\u00112\b\u0010(\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/dataWrangler/jupyterPython/engine/JupyterPyDataWranglerNotebookContext;", "Lcom/intellij/dataWrangler/jupyterPython/engine/PythonDataWranglerContext;", "project", "Lcom/intellij/openapi/project/Project;", "table", "Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "tableDataRetriever", "Lcom/intellij/scientific/tables/api/DSTableDataRetrieverFromDataSource;", "executor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "dataViewVirtualFile", "Lcom/intellij/python/scientific/powerfuldataviewer/editor/DataViewVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;Lcom/intellij/scientific/tables/api/DSTableDataRetrieverFromDataSource;Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;Lcom/intellij/python/scientific/powerfuldataviewer/editor/DataViewVirtualFile;)V", "variablePsiElement", "Lcom/intellij/scientific/tables/api/OutputPsiExpression;", "tableName", "", "variableCodePreviewName", "initCode", "getVariableCodePreviewName", "getTableName", "getProject", "getInitializationCode", "dispose", "", "getDSDataFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "executeCommand", "commandCode", "generateInitializationCode", "updateTableDataExtractor", "parseTableExpressionName", "tableExpression", "getNotebookName", "addCodeCellAndNavigate", "generatedCode", "getTableNameCodePreview", "element", "Companion", "intellij.dataWrangler.jupyterPython"})
public final class JupyterPyDataWranglerNotebookContext
implements PythonDataWranglerContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DSTableWithStatistics table;
    @NotNull
    private DSTableDataRetrieverFromDataSource tableDataRetriever;
    @NotNull
    private final DSTableCommandExecutor executor;
    @Nullable
    private final DataViewVirtualFile dataViewVirtualFile;
    @Nullable
    private final OutputPsiExpression variablePsiElement;
    @NotNull
    private String tableName;
    @NotNull
    private final String variableCodePreviewName;
    @NotNull
    private final String initCode;
    @NotNull
    private static final String commandName = DataWranglerJupyterPyBundle.message("action.DataWrangler.Jupyter.Notebook.Export.text", new Object[0]);

    public JupyterPyDataWranglerNotebookContext(@NotNull Project project, @NotNull DSTableWithStatistics table, @NotNull DSTableDataRetrieverFromDataSource tableDataRetriever, @NotNull DSTableCommandExecutor executor, @Nullable DataViewVirtualFile dataViewVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)tableDataRetriever, (String)"tableDataRetriever");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.project = project;
        this.table = table;
        this.tableDataRetriever = tableDataRetriever;
        this.executor = executor;
        this.dataViewVirtualFile = dataViewVirtualFile;
        Object object = this.tableDataRetriever.getPanelInfo().getOutputExpression();
        if (object == null) {
            DataViewVirtualFile dataViewVirtualFile2 = this.dataViewVirtualFile;
            object = dataViewVirtualFile2 != null ? dataViewVirtualFile2.getOutputPsiExpression() : null;
        }
        this.variablePsiElement = object;
        this.tableName = "__dw_table_" + this.parseTableExpressionName(this.tableDataRetriever.getInitialTableExpression()) + "_" + System.currentTimeMillis() + "__";
        String string = this.getTableNameCodePreview(this.variablePsiElement);
        if (string == null) {
            string = "df_dw";
        }
        this.variableCodePreviewName = string;
        this.initCode = this.generateInitializationCode();
        this.executor.executeCommand(this.tableName + " = " + this.tableDataRetriever.getInitialTableExpression() + ".copy(deep=True)");
    }

    @Override
    @NotNull
    public String getVariableCodePreviewName() {
        return this.variableCodePreviewName;
    }

    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getInitializationCode() {
        return this.initCode;
    }

    public void dispose() {
        this.executor.executeCommand(this.getCodeDeletePyVariable());
    }

    @Override
    @NotNull
    public DSDataFrameInfo getDSDataFrameInfo() {
        return this.tableDataRetriever.getDataFrameInfo();
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        Object object = this.tableDataRetriever.getPanelInfo().getEditor();
        if (object == null) {
            DataViewVirtualFile dataViewVirtualFile = this.dataViewVirtualFile;
            object = dataViewVirtualFile != null ? dataViewVirtualFile.getOriginalEditor() : null;
        }
        return object != null ? object.getVirtualFile() : null;
    }

    @Override
    public void executeCommand(@NotNull String commandCode) {
        Intrinsics.checkNotNullParameter((Object)commandCode, (String)"commandCode");
        this.executor.executeCommand(commandCode);
        this.updateTableDataExtractor();
    }

    private final String generateInitializationCode() {
        IElementType iElementType;
        Object object = this.variablePsiElement;
        if (object == null) {
            object = "";
        }
        OutputPsiExpression outputPsiExpression = this.variablePsiElement;
        Object object2 = iElementType = outputPsiExpression != null ? outputPsiExpression.getElementType() : null;
        if (Intrinsics.areEqual((Object)iElementType, (Object)PyElementTypes.REFERENCE_EXPRESSION)) {
            return "df_dw = " + this.getVariableCodePreviewName() + ".copy()";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)PyElementTypes.CALL_EXPRESSION)) {
            return "df_dw = " + this.variablePsiElement.getText();
        }
        return "";
    }

    private final void updateTableDataExtractor() {
        String expressionNew = this.getTableName();
        DSTableDataRetrieverFromDataSource preTableDataRetriever = this.tableDataRetriever;
        DSDataFrameInfo newDataFrameInfo = preTableDataRetriever.getTableDataProvider().loadDynamicTableDataFrameInfo(this.executor, expressionNew, "");
        DSTableDataRetrieverFromDataSourceImpl newTableDataRetriever = new DSTableDataRetrieverFromDataSourceImpl(preTableDataRetriever.getDataId(), preTableDataRetriever.getDataManager(), expressionNew, preTableDataRetriever.getTableDataProvider(), this.executor, newDataFrameInfo, preTableDataRetriever.getPanelInfo(), true, null, null, null, null, null, 7936, null);
        this.tableDataRetriever = (DSTableDataRetrieverFromDataSource)newTableDataRetriever;
        this.table.fetchData((DSTableDataRetrieverFromDataSource)newTableDataRetriever, true);
    }

    private final String parseTableExpressionName(String tableExpression) {
        Regex regex = new Regex("Out\\[(\\d+)]");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)tableExpression, (int)0, (int)2, null);
        return matchResult != null ? (String)matchResult.getGroupValues().get(1) : tableExpression;
    }

    @Nullable
    public final String getNotebookName() {
        Object object = this.tableDataRetriever.getPanelInfo().getEditor();
        if (object == null) {
            DataViewVirtualFile dataViewVirtualFile = this.dataViewVirtualFile;
            object = dataViewVirtualFile != null ? dataViewVirtualFile.getOriginalEditor() : null;
            if (object == null) {
                return null;
            }
        }
        Editor editor = object;
        return editor.getVirtualFile().getName();
    }

    public final void addCodeCellAndNavigate(@NotNull String generatedCode) {
        DataViewVirtualFile dataViewVirtualFile;
        Intrinsics.checkNotNullParameter((Object)generatedCode, (String)"generatedCode");
        if (StringsKt.isBlank((CharSequence)generatedCode)) {
            return;
        }
        Object object = this.tableDataRetriever.getPanelInfo().getEditor();
        if (object == null) {
            DataViewVirtualFile dataViewVirtualFile2 = this.dataViewVirtualFile;
            object = dataViewVirtualFile2 != null ? dataViewVirtualFile2.getOriginalEditor() : null;
            if (object == null) {
                return;
            }
        }
        Editor editor = object;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Ref.ObjectRef line = new Ref.ObjectRef();
        Function0 function0 = this.tableDataRetriever.getPanelInfo().getCellLinesIntervalSupplier();
        Object object2 = function0 != null && (function0 = (IntRange)function0.invoke()) != null ? Integer.valueOf(function0.getEndInclusive()) : ((dataViewVirtualFile = this.dataViewVirtualFile) != null && (dataViewVirtualFile = dataViewVirtualFile.getCellLines()) != null ? Integer.valueOf(dataViewVirtualFile.getLast()) : (line.element = null));
        if (line.element == null) {
            NotebookCellLines cellLines = NotebookCellLines.Companion.get(editor);
            line.element = ((NotebookCellLines.Interval)CollectionsKt.last((List)cellLines.getIntervals())).getLines().getLast();
        }
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.getOrNull(editor);
        if (notebookCellLinesEditHelper == null) {
            return;
        }
        NotebookCellLinesEditHelper cellEditHelper = notebookCellLinesEditHelper;
        String string = NotebookCellLinesEditHelper.makeCell$default((NotebookCellLinesEditHelper)cellEditHelper, (String)((Object)StringsKt.trim((CharSequence)generatedCode)).toString(), (NotebookCellLines.CellType)NotebookCellLines.CellType.CODE, null, (int)4, null);
        if (string == null) {
            return;
        }
        String generatedCell = string;
        Integer lastCellLine = (Integer)WriteCommandAction.writeCommandAction((Project)this.project).withName(commandName).compute(() -> JupyterPyDataWranglerNotebookContext.addCodeCellAndNavigate$lambda$0(document2, line, generatedCell));
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        fileEditorManager.openFile(editor.getVirtualFile(), true);
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        Intrinsics.checkNotNull((Object)lastCellLine);
        caretModel2.moveToOffset(document2.getLineEndOffset(lastCellLine.intValue()) + generatedCell.length() + 1);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
    }

    private final String getTableNameCodePreview(OutputPsiExpression element) {
        OutputPsiExpression outputPsiExpression = element;
        if (Intrinsics.areEqual((Object)(outputPsiExpression != null ? outputPsiExpression.getElementType() : null), (Object)PyElementTypes.REFERENCE_EXPRESSION)) {
            return element.getText();
        }
        return null;
    }

    private static final Integer addCodeCellAndNavigate$lambda$0(Document $document, Ref.ObjectRef $line, String $generatedCell) {
        NotebookCellLines.Interval interval;
        NotebookCellLines cellLines = NotebookCellLines.Companion.get($document);
        try {
            interval = (NotebookCellLines.Interval)cellLines.intervalsIterator(((Number)$line.element).intValue()).next();
        }
        catch (NoSuchElementException noSuchElementException) {
            interval = (NotebookCellLines.Interval)CollectionsKt.last((List)cellLines.getIntervals());
        }
        NotebookCellLines.Interval interval2 = interval;
        NotebookCellLines.Interval prevCell = (NotebookCellLines.Interval)cellLines.getIntervals().get(interval2.getOrdinal());
        int lastLine = prevCell.getLines().getLast();
        $document.insertString($document.getLineEndOffset(lastLine), (CharSequence)("\n" + $generatedCell));
        return lastLine;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/dataWrangler/jupyterPython/engine/JupyterPyDataWranglerNotebookContext$Companion;", "", "<init>", "()V", "commandName", "", "Lorg/jetbrains/annotations/Nls;", "intellij.dataWrangler.jupyterPython"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

