/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.applications;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.django.model.applications.DjangoAppConfig;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.NoSuchApplicationException;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public final class DjangoApplicationModel
extends DjangoUnnamedApplicationModel {
    @NotNull
    private final DjangoAppConfig myAppConfig;

    public DjangoApplicationModel(@NotNull DjangoAppConfig appConfig, @NotNull Module djangoModule, @NotNull VirtualFile djangoProjectRoot) throws NoSuchApplicationException {
        if (appConfig == null) {
            DjangoApplicationModel.$$$reportNull$$$0(0);
        }
        if (djangoModule == null) {
            DjangoApplicationModel.$$$reportNull$$$0(1);
        }
        if (djangoProjectRoot == null) {
            DjangoApplicationModel.$$$reportNull$$$0(2);
        }
        super(DjangoApplicationModel.getAppDirectoryByName(appConfig.getName(), djangoModule, djangoProjectRoot));
        this.myAppConfig = appConfig;
    }

    public DjangoApplicationModel(@NotNull DjangoAppConfig appConfig, @NotNull PsiDirectory applicationRootFolder) {
        if (appConfig == null) {
            DjangoApplicationModel.$$$reportNull$$$0(3);
        }
        if (applicationRootFolder == null) {
            DjangoApplicationModel.$$$reportNull$$$0(4);
        }
        super(applicationRootFolder);
        this.myAppConfig = appConfig;
    }

    @NotNull
    public static List<VirtualFile> getFoldersUnderEachApp(@NotNull String folderName, @NotNull DjangoModelApi djangoModelApi) {
        if (folderName == null) {
            DjangoApplicationModel.$$$reportNull$$$0(5);
        }
        if (djangoModelApi == null) {
            DjangoApplicationModel.$$$reportNull$$$0(6);
        }
        ArrayList<VirtualFile> folders = new ArrayList<VirtualFile>();
        for (DjangoApplicationModel application : djangoModelApi.getApplications()) {
            VirtualFile folder = application.myApplicationRootFolder.getVirtualFile().findChild(folderName);
            if (folder == null) continue;
            folders.add(folder);
        }
        ArrayList<VirtualFile> arrayList = folders;
        if (arrayList == null) {
            DjangoApplicationModel.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public String getName() {
        String string = this.myAppConfig.getName();
        if (string == null) {
            DjangoApplicationModel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getVerboseName() {
        String verboseName = this.myAppConfig.getVerboseName();
        String string = verboseName != null ? verboseName : this.myAppConfig.getLabel();
        if (string == null) {
            DjangoApplicationModel.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getLabel() {
        String string = this.myAppConfig.getLabel();
        if (string == null) {
            DjangoApplicationModel.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static PsiDirectory getAppDirectoryByName(@NotNull String name, @NotNull Module djangoModule, @NotNull VirtualFile djangoProjectRoot) throws NoSuchApplicationException {
        if (name == null) {
            DjangoApplicationModel.$$$reportNull$$$0(11);
        }
        if (djangoModule == null) {
            DjangoApplicationModel.$$$reportNull$$$0(12);
        }
        if (djangoProjectRoot == null) {
            DjangoApplicationModel.$$$reportNull$$$0(13);
        }
        QualifiedName qName = QualifiedName.fromDottedString((String)name);
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromModule((Module)djangoModule).copyWithoutStubs();
        List elements = PyResolveImportUtil.resolveQualifiedName((QualifiedName)qName, (PyQualifiedNameResolveContext)context);
        return DjangoApplicationModel.getDirectory(name, elements);
    }

    @NotNull
    private static PsiDirectory getDirectory(@NotNull String name, List<PsiElement> elements) throws NoSuchApplicationException {
        PsiFile file;
        if (name == null) {
            DjangoApplicationModel.$$$reportNull$$$0(14);
        }
        PsiElement element = !elements.isEmpty() ? elements.get(0) : null;
        PsiDirectory dir = null;
        if (element instanceof PyFile) {
            dir = ((PsiFile)element).getParent();
        } else if (element instanceof PsiDirectory) {
            dir = (PsiDirectory)element;
        } else if (element instanceof PyElement && (file = element.getContainingFile()) != null) {
            dir = file.getParent();
        }
        if (dir == null) {
            throw new NoSuchApplicationException("No application named " + name);
        }
        PsiDirectory psiDirectory = dir;
        if (psiDirectory == null) {
            DjangoApplicationModel.$$$reportNull$$$0(15);
        }
        return psiDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DjangoApplicationModel that = (DjangoApplicationModel)o;
        return Objects.equals(this.myApplicationRootFolder, that.myApplicationRootFolder);
    }

    public int hashCode() {
        return Objects.hash(this.myApplicationRootFolder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfig";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModule";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoProjectRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRootFolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModelApi";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/applications/DjangoApplicationModel";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/applications/DjangoApplicationModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldersUnderEachApp";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerboseName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFoldersUnderEachApp";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAppDirectoryByName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 15 -> new IllegalStateException(string);
        };
    }
}

