/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.TranspositionAwareExtractor;
import com.intellij.database.extractors.XlsxValuesExtractorKt;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.util.Out;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 (2\u00020\u0001:\u0006#$%&'(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J:\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00020\u0018\"\u00020\u0007H\u0016JJ\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\f2\n\u0010\u0017\u001a\u00020\u0018\"\u00020\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007H\u0007J\u0010\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor;", "Lcom/intellij/database/extractors/DataExtractor;", "myFormatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "<init>", "(Lcom/intellij/database/extractors/ObjectFormatter;)V", "maxRowsPerSheet", "", "stringsBuffer", "getFileExtension", "", "supportsText", "", "startExtraction", "Lcom/intellij/database/extractors/TranspositionAwareExtractor$TranspositionAwareExtraction;", "out", "Lcom/intellij/database/util/Out;", "allColumns", "", "Lcom/intellij/database/datagrid/GridColumn;", "query", "config", "Lcom/intellij/database/extractors/ExtractionConfig;", "selectedColumns", "", "spawnChildExtraction", "Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxExtraction;", "", "resource", "Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxResource;", "isOriginallyTransposed", "setMaxRowsPerSheet", "", "v", "setStringsBuffer", "XlsxExtraction", "XlsxResource", "SharedStrings", "XlsxWorkbook", "XlsxSheetBuilder", "Companion", "intellij.grid.core.impl"})
public final class XlsxValuesExtractor
implements DataExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectFormatter myFormatter;
    private int maxRowsPerSheet;
    private int stringsBuffer;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String RELS_NAME = "_rels/.rels";
    @NotNull
    public static final String WORKBOOK_NAME = "xl/workbook.xml";
    @NotNull
    public static final String WORKSHEETS_DIR = "xl/worksheets";
    @NotNull
    public static final String WORKBOOK_RELS_NAME = "xl/_rels/workbook.xml.rels";
    @NotNull
    public static final String SHARED_STRINGS_NAME = "xl/sharedStrings.xml";
    @NotNull
    public static final String CONTENT_TYPES_NAME = "[Content_Types].xml";
    @NotNull
    public static final String RELS_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n  <Relationship Id=\"rId1\" Target=\"xl/workbook.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\"/>\n</Relationships>";
    @NotNull
    public static final String WORKBOOK_RELS_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n<Relationship Id=\"rId1\" Target=\"sharedStrings.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings\"/>";
    @NotNull
    public static final String WORKBOOK_RELS_FOOTER = "</Relationships>";
    @NotNull
    public static final String WORKBOOK_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<workbook xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n<workbookPr date1904=\"false\"/><bookViews><workbookView activeTab=\"0\"/></bookViews>\n<sheets>";
    @NotNull
    public static final String WORKBOOK_FOOTER = "</sheets>\n</workbook>";
    @NotNull
    public static final String CONTENT_TYPES_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">\n<Default ContentType=\"application/vnd.openxmlformats-package.relationships+xml\" Extension=\"rels\"/>\n<Default ContentType=\"application/xml\" Extension=\"xml\"/>\n<Override ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml\" PartName=\"/xl/sharedStrings.xml\"/>\n<Override ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\" PartName=\"/xl/workbook.xml\"/>";
    @NotNull
    public static final String CONTENT_TYPES_FOOTER = "</Types>";
    @NotNull
    public static final String SHEET_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"><sheetData>";
    @NotNull
    public static final String SHEET_FOOTER = "</sheetData></worksheet>";
    @NotNull
    public static final String SHARED_STRINGS_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    @NotNull
    private static final Regex INVALID_XML_CHARS;

    public XlsxValuesExtractor(@NotNull ObjectFormatter myFormatter) {
        Intrinsics.checkNotNullParameter((Object)myFormatter, (String)"myFormatter");
        this.myFormatter = myFormatter;
        this.maxRowsPerSheet = 0x100000;
        this.stringsBuffer = 0x500000;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "xlsx";
    }

    @Override
    public boolean supportsText() {
        return false;
    }

    @Override
    @NotNull
    public TranspositionAwareExtractor.TranspositionAwareExtraction startExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, int ... selectedColumns) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter(allColumns, (String)"allColumns");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)selectedColumns, (String)"selectedColumns");
        OutputStream outputStream = out.toOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"toOutputStream(...)");
        return new XlsxExtraction(this.myFormatter, out, allColumns, query, config, selectedColumns, this, new XlsxResource(outputStream, this.maxRowsPerSheet, this.stringsBuffer, query, config), false);
    }

    @NotNull
    public final XlsxExtraction spawnChildExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, @NotNull XlsxResource resource, boolean isOriginallyTransposed, int ... selectedColumns) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter(allColumns, (String)"allColumns");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)selectedColumns, (String)"selectedColumns");
        return new XlsxExtraction(this.myFormatter, out, allColumns, query, config, selectedColumns, this, resource, isOriginallyTransposed);
    }

    @TestOnly
    public final void setMaxRowsPerSheet(int v) {
        this.maxRowsPerSheet = v;
    }

    @TestOnly
    public final void setStringsBuffer(int v) {
        this.stringsBuffer = v;
    }

    static {
        Logger logger = Logger.getInstance(XlsxValuesExtractor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        INVALID_XML_CHARS = new Regex("[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RELS_NAME", "", "WORKBOOK_NAME", "WORKSHEETS_DIR", "WORKBOOK_RELS_NAME", "SHARED_STRINGS_NAME", "CONTENT_TYPES_NAME", "RELS_CONTENT", "WORKBOOK_RELS_HEADER", "WORKBOOK_RELS_FOOTER", "WORKBOOK_HEADER", "WORKBOOK_FOOTER", "CONTENT_TYPES_HEADER", "CONTENT_TYPES_FOOTER", "SHEET_HEADER", "SHEET_FOOTER", "SHARED_STRINGS_HEADER", "INVALID_XML_CHARS", "Lkotlin/text/Regex;", "getINVALID_XML_CHARS", "()Lkotlin/text/Regex;", "intellij.grid.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getINVALID_XML_CHARS() {
            return INVALID_XML_CHARS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0012J\b\u0010!\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\u0005R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\u0005R-\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0003`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$SharedStrings;", "", "stringsBuffer", "", "<init>", "(I)V", "totalStringsCount", "getTotalStringsCount", "()I", "setTotalStringsCount", "uniqueCount", "getUniqueCount", "setUniqueCount", "totalLength", "getTotalLength", "setTotalLength", "sharedStrings", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "getSharedStrings", "()Ljava/util/LinkedHashMap;", "tmpFile", "Ljava/io/File;", "Lorg/jetbrains/annotations/NotNull;", "getTmpFile", "()Ljava/io/File;", "tmpWriter", "Ljava/io/BufferedWriter;", "getTmpWriter", "()Ljava/io/BufferedWriter;", "getId", "v", "flushToTempFile", "", "write", "writer", "intellij.grid.core.impl"})
    @SourceDebugExtension(value={"SMAP\nXlsxValuesExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XlsxValuesExtractor.kt\ncom/intellij/database/extractors/XlsxValuesExtractor$SharedStrings\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,430:1\n381#2,7:431\n1863#3,2:438\n1317#4,2:440\n*S KotlinDebug\n*F\n+ 1 XlsxValuesExtractor.kt\ncom/intellij/database/extractors/XlsxValuesExtractor$SharedStrings\n*L\n180#1:431,7\n191#1:438,2\n212#1:440,2\n*E\n"})
    private static final class SharedStrings {
        private final int stringsBuffer;
        private int totalStringsCount;
        private int uniqueCount;
        private int totalLength;
        @NotNull
        private final LinkedHashMap<String, Integer> sharedStrings;
        @NotNull
        private final File tmpFile;
        @NotNull
        private final BufferedWriter tmpWriter;

        public SharedStrings(int stringsBuffer) {
            this.stringsBuffer = stringsBuffer;
            this.sharedStrings = new LinkedHashMap();
            File file = FileUtil.createTempFile((String)"xlsxExtractor", (String)".gz", (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            this.tmpFile = file;
            this.tmpWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(this.tmpFile)), StandardCharsets.UTF_8));
        }

        public final int getTotalStringsCount() {
            return this.totalStringsCount;
        }

        public final void setTotalStringsCount(int n) {
            this.totalStringsCount = n;
        }

        public final int getUniqueCount() {
            return this.uniqueCount;
        }

        public final void setUniqueCount(int n) {
            this.uniqueCount = n;
        }

        public final int getTotalLength() {
            return this.totalLength;
        }

        public final void setTotalLength(int n) {
            this.totalLength = n;
        }

        @NotNull
        public final LinkedHashMap<String, Integer> getSharedStrings() {
            return this.sharedStrings;
        }

        @NotNull
        public final File getTmpFile() {
            return this.tmpFile;
        }

        @NotNull
        public final BufferedWriter getTmpWriter() {
            return this.tmpWriter;
        }

        public final int getId(@NotNull String v) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            int n = this.totalStringsCount;
            this.totalStringsCount = n + 1;
            Map $this$getOrPut$iv = this.sharedStrings;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(v);
            if (value$iv == null) {
                boolean bl = false;
                this.totalLength += v.length();
                int n2 = this.uniqueCount;
                this.uniqueCount = n2 + 1;
                Integer answer$iv = n2;
                $this$getOrPut$iv.put(v, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            int res = ((Number)object).intValue();
            if (this.totalLength >= this.stringsBuffer) {
                this.flushToTempFile();
            }
            return res;
        }

        private final void flushToTempFile() {
            Set<String> set = this.sharedStrings.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String str = (String)element$iv;
                boolean bl = false;
                Writer writer = this.tmpWriter.append("<si><t>");
                String string = StringUtil.escapeXmlEntities((String)str);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
                CharSequence charSequence = string;
                Regex regex = Companion.getINVALID_XML_CHARS();
                String string2 = "?";
                writer.append(regex.replace(charSequence, string2)).append("</t></si>");
            }
            this.tmpWriter.append("\n");
            this.tmpWriter.flush();
            this.totalLength = 0;
            this.sharedStrings.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void write(@NotNull BufferedWriter writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            if (!((Map)this.sharedStrings).isEmpty()) {
                this.flushToTempFile();
            }
            this.tmpWriter.close();
            writer.append(XlsxValuesExtractor.SHARED_STRINGS_HEADER);
            writer.append("<sst count=\"").append(String.valueOf(this.totalStringsCount)).append("\" uniqueCount=\"").append(String.valueOf(this.uniqueCount)).append("\" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">");
            Closeable closeable = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(this.tmpFile)), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)closeable;
                boolean bl = false;
                Sequence $this$forEach$iv = TextStreamsKt.lineSequence((BufferedReader)reader);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl2 = false;
                    writer.append(line).append("\n");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            writer.append("</sst>");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016JD\u0010.\u001a\u00020/2\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\n\u00101\u001a\u00020\u000e\"\u000202H\u0014J\u001b\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\b06H\u0016\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u0002042\u0006\u00109\u001a\u00020\u0014H\u0014J\u0016\u0010:\u001a\u0002042\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u0007H\u0014J\b\u0010=\u001a\u000204H\u0002J\b\u0010>\u001a\u000204H\u0016J\b\u0010?\u001a\u000204H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001d\"\u0004\b,\u0010-\u00a8\u0006@"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxExtraction;", "Lcom/intellij/database/extractors/TranspositionAwareExtractor$TranspositionAwareExtraction;", "formatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "out", "Lcom/intellij/database/util/Out;", "allColumns", "", "Lcom/intellij/database/datagrid/GridColumn;", "query", "", "config", "Lcom/intellij/database/extractors/ExtractionConfig;", "selectedColumnIndices", "", "xlsxExtractor", "Lcom/intellij/database/extractors/XlsxValuesExtractor;", "resource", "Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxResource;", "isOriginallyTransposed", "", "<init>", "(Lcom/intellij/database/extractors/ObjectFormatter;Lcom/intellij/database/util/Out;Ljava/util/List;Ljava/lang/String;Lcom/intellij/database/extractors/ExtractionConfig;[ILcom/intellij/database/extractors/XlsxValuesExtractor;Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxResource;Z)V", "getFormatter", "()Lcom/intellij/database/extractors/ObjectFormatter;", "getXlsxExtractor", "()Lcom/intellij/database/extractors/XlsxValuesExtractor;", "getResource", "()Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxResource;", "()Z", "zip", "Ljava/util/zip/ZipOutputStream;", "getZip", "()Ljava/util/zip/ZipOutputStream;", "writer", "Ljava/io/BufferedWriter;", "getWriter", "()Ljava/io/BufferedWriter;", "workbook", "Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxWorkbook;", "getWorkbook", "()Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxWorkbook;", "headerAppended", "getHeaderAppended", "setHeaderAppended", "(Z)V", "spawnChildExtraction", "Lcom/intellij/database/extractors/DataExtractor$Extraction;", "", "selectedColumns", "", "updateColumns", "", "columns", "", "([Lcom/intellij/database/datagrid/GridColumn;)V", "doAppendHeader", "appendNewLine", "doAppendData", "rows", "Lcom/intellij/database/datagrid/GridRow;", "setHeader", "complete", "completeBatch", "intellij.grid.core.impl"})
    @SourceDebugExtension(value={"SMAP\nXlsxValuesExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XlsxValuesExtractor.kt\ncom/intellij/database/extractors/XlsxValuesExtractor$XlsxExtraction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,430:1\n11188#2:431\n11523#2,3:432\n11188#2:435\n11523#2,3:436\n*S KotlinDebug\n*F\n+ 1 XlsxValuesExtractor.kt\ncom/intellij/database/extractors/XlsxValuesExtractor$XlsxExtraction\n*L\n122#1:431\n122#1:432,3\n143#1:435\n143#1:436,3\n*E\n"})
    public static final class XlsxExtraction
    extends TranspositionAwareExtractor.TranspositionAwareExtraction {
        @NotNull
        private final ObjectFormatter formatter;
        @NotNull
        private final XlsxValuesExtractor xlsxExtractor;
        @NotNull
        private final XlsxResource resource;
        private final boolean isOriginallyTransposed;
        @NotNull
        private final ZipOutputStream zip;
        @NotNull
        private final BufferedWriter writer;
        @NotNull
        private final XlsxWorkbook workbook;
        private boolean headerAppended;

        public XlsxExtraction(@NotNull ObjectFormatter formatter, @NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, @NotNull int[] selectedColumnIndices, @NotNull XlsxValuesExtractor xlsxExtractor, @NotNull XlsxResource resource, boolean isOriginallyTransposed) {
            Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter(allColumns, (String)"allColumns");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)selectedColumnIndices, (String)"selectedColumnIndices");
            Intrinsics.checkNotNullParameter((Object)xlsxExtractor, (String)"xlsxExtractor");
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            super(out, config, allColumns, query, selectedColumnIndices, xlsxExtractor);
            this.formatter = formatter;
            this.xlsxExtractor = xlsxExtractor;
            this.resource = resource;
            this.isOriginallyTransposed = isOriginallyTransposed;
            this.zip = this.resource.getZip();
            this.writer = this.resource.getWriter();
            this.workbook = this.resource.getWorkbook();
        }

        @NotNull
        public final ObjectFormatter getFormatter() {
            return this.formatter;
        }

        @NotNull
        public final XlsxValuesExtractor getXlsxExtractor() {
            return this.xlsxExtractor;
        }

        @NotNull
        public final XlsxResource getResource() {
            return this.resource;
        }

        public final boolean isOriginallyTransposed() {
            return this.isOriginallyTransposed;
        }

        @NotNull
        public final ZipOutputStream getZip() {
            return this.zip;
        }

        @NotNull
        public final BufferedWriter getWriter() {
            return this.writer;
        }

        @NotNull
        public final XlsxWorkbook getWorkbook() {
            return this.workbook;
        }

        public final boolean getHeaderAppended() {
            return this.headerAppended;
        }

        public final void setHeaderAppended(boolean bl) {
            this.headerAppended = bl;
        }

        @NotNull
        protected DataExtractor.Extraction spawnChildExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, boolean isOriginallyTransposed, int ... selectedColumns) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter(allColumns, (String)"allColumns");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)selectedColumns, (String)"selectedColumns");
            return this.xlsxExtractor.spawnChildExtraction(out, allColumns, query, config, this.resource, isOriginallyTransposed, Arrays.copyOf(selectedColumns, selectedColumns.length));
        }

        @Override
        public void updateColumns(@NotNull GridColumn[] columns) {
            Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
            this.myAllColumns = CollectionsKt.listOf((Object[])Arrays.copyOf(columns, columns.length));
            this.setHeader();
        }

        @Override
        protected void doAppendHeader(boolean appendNewLine) {
            if (!this.headerAppended && !this.isOriginallyTransposed) {
                this.setHeader();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void doAppendData(@NotNull List<? extends GridRow> rows) {
            int[] nArray;
            Intrinsics.checkNotNullParameter(rows, (String)"rows");
            this.doAppendHeader(false);
            if (!this.isOriginallyTransposed) {
                nArray = this.mySelectedColumnIndices;
                Intrinsics.checkNotNullExpressionValue((Object)this.mySelectedColumnIndices, (String)"mySelectedColumnIndices");
            } else {
                int[] res = new int[this.mySelectedColumnIndices.length + 1];
                Intrinsics.checkNotNullExpressionValue((Object)this.mySelectedColumnIndices, (String)"mySelectedColumnIndices");
                ArraysKt.copyInto$default((int[])this.mySelectedColumnIndices, (int[])res, (int)1, (int)0, (int)0, (int)12, null);
                res[0] = 0;
                nArray = res;
            }
            int[] selectedColumnIndicesWithColumnHeader = nArray;
            int[] selectedColumns = GridExtractorsUtilCore.getNonEmptySelection(this.myAllColumns, selectedColumnIndicesWithColumnHeader);
            Int2ObjectMap columnsMap = GridExtractorsUtilCore.getColumnNumsToColumnsMapping(this.myAllColumns);
            for (GridRow gridRow : rows) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNull((Object)selectedColumns);
                int[] nArray2 = selectedColumns;
                XlsxWorkbook xlsxWorkbook = this.workbook;
                boolean $i$f$map = false;
                void var9_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    Serializable serializable;
                    void selectedColumn;
                    void item$iv$iv;
                    void var15_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    GridColumn column = (GridColumn)columnsMap.get((int)selectedColumn);
                    if (column == null) {
                        serializable = null;
                    } else {
                        Object value = column.getValue(gridRow);
                        serializable = value == null || value == ReservedCellValue.UNSET ? null : (value instanceof Number && XlsxValuesExtractorKt.access$fitsIntoXlsxNumber((Number)value) ? (Serializable)value : (value instanceof Boolean ? (Serializable)value : (Serializable)((Object)this.formatter.objectToString(value, column, new DatabaseObjectFormatterConfig(ObjectFormatterMode.DEFAULT)))));
                    }
                    collection.add(serializable);
                }
                xlsxWorkbook.appendRow((List)destination$iv$iv);
            }
            this.writer.flush();
        }

        /*
         * WARNING - void declaration
         */
        private final void setHeader() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            XlsxWorkbook workbook = this.workbook;
            boolean bl = false;
            int[] selectedColumns = GridExtractorsUtilCore.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            Int2ObjectMap columnsMap = GridExtractorsUtilCore.getColumnNumsToColumnsMapping(this.myAllColumns);
            Intrinsics.checkNotNull((Object)selectedColumns);
            int[] nArray = selectedColumns;
            XlsxWorkbook xlsxWorkbook = workbook;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void selectedColumn;
                void item$iv$iv;
                void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                GridColumn gridColumn = (GridColumn)columnsMap.get((int)selectedColumn);
                collection.add(gridColumn != null ? gridColumn.getName() : null);
            }
            xlsxWorkbook.setHeader((List)destination$iv$iv);
            this.headerAppended = true;
        }

        @Override
        public void complete() {
            this.workbook.end();
            this.writer.flush();
            this.zip.finish();
        }

        @Override
        public void completeBatch() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxResource;", "", "out", "Ljava/io/OutputStream;", "maxRowsPerSheet", "", "stringsBuffer", "query", "", "config", "Lcom/intellij/database/extractors/ExtractionConfig;", "<init>", "(Ljava/io/OutputStream;IILjava/lang/String;Lcom/intellij/database/extractors/ExtractionConfig;)V", "zip", "Ljava/util/zip/ZipOutputStream;", "getZip", "()Ljava/util/zip/ZipOutputStream;", "writer", "Ljava/io/BufferedWriter;", "getWriter", "()Ljava/io/BufferedWriter;", "workbook", "Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxWorkbook;", "getWorkbook", "()Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxWorkbook;", "intellij.grid.core.impl"})
    public static final class XlsxResource {
        @NotNull
        private final ZipOutputStream zip;
        @NotNull
        private final BufferedWriter writer;
        @NotNull
        private final XlsxWorkbook workbook;

        public XlsxResource(@NotNull OutputStream out, int maxRowsPerSheet, int stringsBuffer, @NotNull String query, @NotNull ExtractionConfig config) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.zip = new ZipOutputStream(out, StandardCharsets.UTF_8);
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.zip, StandardCharsets.UTF_8));
            this.workbook = new XlsxWorkbook(this.zip, this.writer, maxRowsPerSheet, stringsBuffer, query, config);
        }

        @NotNull
        public final ZipOutputStream getZip() {
            return this.zip;
        }

        @NotNull
        public final BufferedWriter getWriter() {
            return this.writer;
        }

        @NotNull
        public final XlsxWorkbook getWorkbook() {
            return this.workbook;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0013J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxSheetBuilder;", "", "sharedStrings", "Lcom/intellij/database/extractors/XlsxValuesExtractor$SharedStrings;", "<init>", "(Lcom/intellij/database/extractors/XlsxValuesExtractor$SharedStrings;)V", "headerAppended", "", "rowCount", "", "getRowCount", "()I", "setRowCount", "(I)V", "appendRow", "", "writer", "Ljava/io/BufferedWriter;", "row", "", "end", "intellij.grid.core.impl"})
    private static final class XlsxSheetBuilder {
        @NotNull
        private final SharedStrings sharedStrings;
        private boolean headerAppended;
        private int rowCount;

        public XlsxSheetBuilder(@NotNull SharedStrings sharedStrings) {
            Intrinsics.checkNotNullParameter((Object)sharedStrings, (String)"sharedStrings");
            this.sharedStrings = sharedStrings;
        }

        public final int getRowCount() {
            return this.rowCount;
        }

        public final void setRowCount(int n) {
            this.rowCount = n;
        }

        public final void appendRow(@NotNull BufferedWriter writer, @NotNull List<? extends Object> row) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter(row, (String)"row");
            int n = this.rowCount;
            this.rowCount = n + 1;
            if (!this.headerAppended) {
                writer.append(XlsxValuesExtractor.SHEET_HEADER);
                this.headerAppended = true;
            }
            writer.append("<row>");
            for (Object object : row) {
                if (object == null) {
                    writer.append("<c/>");
                    continue;
                }
                String type = null;
                String value = null;
                Object object2 = object;
                if (object2 instanceof Number) {
                    type = "n";
                    value = ((Number)object).toString();
                } else if (object2 instanceof Boolean) {
                    type = "b";
                    value = (Boolean)object != false ? "1" : "0";
                } else {
                    type = "s";
                    value = String.valueOf(this.sharedStrings.getId(object.toString()));
                }
                writer.append("<c t=\"").append(type).append("\"><v>").append(value).append("</v></c>");
            }
            writer.append("</row>");
        }

        public final void end(@NotNull BufferedWriter writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            writer.append(XlsxValuesExtractor.SHEET_FOOTER);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010%\u001a\u00020&2\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010 J\b\u0010(\u001a\u00020&H\u0002J\u0014\u0010)\u001a\u00020\u001e2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\nH\u0002J\u0006\u0010+\u001a\u00020&J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006/"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxWorkbook;", "", "zip", "Ljava/util/zip/ZipOutputStream;", "writer", "Ljava/io/BufferedWriter;", "maxRowsPerSheet", "", "stringsBuffer", "query", "", "config", "Lcom/intellij/database/extractors/ExtractionConfig;", "<init>", "(Ljava/util/zip/ZipOutputStream;Ljava/io/BufferedWriter;IILjava/lang/String;Lcom/intellij/database/extractors/ExtractionConfig;)V", "getZip", "()Ljava/util/zip/ZipOutputStream;", "getWriter", "()Ljava/io/BufferedWriter;", "getMaxRowsPerSheet", "()I", "getQuery", "()Ljava/lang/String;", "getConfig", "()Lcom/intellij/database/extractors/ExtractionConfig;", "sharedStrings", "Lcom/intellij/database/extractors/XlsxValuesExtractor$SharedStrings;", "sheetNames", "", "sheet", "Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxSheetBuilder;", "header", "", "getHeader", "()Ljava/util/List;", "setHeader", "(Ljava/util/List;)V", "appendRow", "", "row", "endSheet", "newSheet", "name", "end", "isValidCellContent", "", "text", "intellij.grid.core.impl"})
    @SourceDebugExtension(value={"SMAP\nXlsxValuesExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XlsxValuesExtractor.kt\ncom/intellij/database/extractors/XlsxValuesExtractor$XlsxWorkbook\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,430:1\n1#2:431\n1872#3,3:432\n*S KotlinDebug\n*F\n+ 1 XlsxValuesExtractor.kt\ncom/intellij/database/extractors/XlsxValuesExtractor$XlsxWorkbook\n*L\n295#1:432,3\n*E\n"})
    public static final class XlsxWorkbook {
        @NotNull
        private final ZipOutputStream zip;
        @NotNull
        private final BufferedWriter writer;
        private final int maxRowsPerSheet;
        @NotNull
        private final String query;
        @NotNull
        private final ExtractionConfig config;
        @NotNull
        private final SharedStrings sharedStrings;
        @NotNull
        private List<String> sheetNames;
        @NotNull
        private XlsxSheetBuilder sheet;
        @Nullable
        private List<String> header;

        public XlsxWorkbook(@NotNull ZipOutputStream zip, @NotNull BufferedWriter writer, int maxRowsPerSheet, int stringsBuffer, @NotNull String query, @NotNull ExtractionConfig config) {
            Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.zip = zip;
            this.writer = writer;
            this.maxRowsPerSheet = maxRowsPerSheet;
            this.query = query;
            this.config = config;
            this.sharedStrings = new SharedStrings(stringsBuffer);
            this.sheetNames = new ArrayList();
            this.sheet = XlsxWorkbook.newSheet$default(this, null, 1, null);
        }

        @NotNull
        public final ZipOutputStream getZip() {
            return this.zip;
        }

        @NotNull
        public final BufferedWriter getWriter() {
            return this.writer;
        }

        public final int getMaxRowsPerSheet() {
            return this.maxRowsPerSheet;
        }

        @NotNull
        public final String getQuery() {
            return this.query;
        }

        @NotNull
        public final ExtractionConfig getConfig() {
            return this.config;
        }

        @Nullable
        public final List<String> getHeader() {
            return this.header;
        }

        public final void setHeader(@Nullable List<String> list) {
            this.header = list;
        }

        public final void appendRow(@NotNull List<? extends Object> row) {
            Intrinsics.checkNotNullParameter(row, (String)"row");
            try {
                if (this.sheet.getRowCount() >= this.maxRowsPerSheet) {
                    this.endSheet();
                    this.sheet = XlsxWorkbook.newSheet$default(this, null, 1, null);
                }
                if (this.sheet.getRowCount() == 0) {
                    List<String> list = this.header;
                    if (list != null) {
                        List<String> h = list;
                        boolean bl = false;
                        this.sheet.appendRow(this.writer, h);
                    }
                }
                this.sheet.appendRow(this.writer, row);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw e;
            }
        }

        private final void endSheet() {
            this.sheet.end(this.writer);
            this.writer.flush();
            this.zip.closeEntry();
        }

        private final XlsxSheetBuilder newSheet(String name) {
            Object object = name;
            if (object == null) {
                object = "Result " + (this.sheetNames.size() + 1);
            }
            this.sheetNames.add((String)object);
            this.zip.putNextEntry(new ZipEntry("xl/worksheets/sheet" + this.sheetNames.size() + ".xml"));
            return new XlsxSheetBuilder(this.sharedStrings);
        }

        static /* synthetic */ XlsxSheetBuilder newSheet$default(XlsxWorkbook xlsxWorkbook, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            return xlsxWorkbook.newSheet(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void end() {
            try {
                this.endSheet();
                if (this.config.getAddQuery() && this.isValidCellContent(this.query)) {
                    this.sheet = this.newSheet("Query");
                    this.sheet.appendRow(this.writer, CollectionsKt.listOf((Object)this.query));
                    this.endSheet();
                }
                XlsxWorkbook.end$entry(this, XlsxValuesExtractor.RELS_NAME, (Function0<Unit>)((Function0)() -> XlsxWorkbook.end$lambda$1(this)));
                XlsxWorkbook.end$entry(this, XlsxValuesExtractor.WORKBOOK_RELS_NAME, (Function0<Unit>)((Function0)() -> XlsxWorkbook.end$lambda$2(this)));
                XlsxWorkbook.end$entry(this, XlsxValuesExtractor.SHARED_STRINGS_NAME, (Function0<Unit>)((Function0)() -> XlsxWorkbook.end$lambda$3(this)));
                XlsxWorkbook.end$entry(this, XlsxValuesExtractor.WORKBOOK_NAME, (Function0<Unit>)((Function0)() -> XlsxWorkbook.end$lambda$5(this)));
                XlsxWorkbook.end$entry(this, XlsxValuesExtractor.CONTENT_TYPES_NAME, (Function0<Unit>)((Function0)() -> XlsxWorkbook.end$lambda$6(this)));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw e;
            }
            finally {
                this.sharedStrings.getTmpFile().delete();
            }
        }

        private final boolean isValidCellContent(String text) {
            return text.length() < Short.MAX_VALUE;
        }

        private static final void end$entry(XlsxWorkbook this$0, String name, Function0<Unit> block) {
            this$0.zip.putNextEntry(new ZipEntry(name));
            block.invoke();
            this$0.writer.flush();
            this$0.zip.closeEntry();
        }

        private static final Unit end$lambda$1(XlsxWorkbook this$0) {
            this$0.writer.append(XlsxValuesExtractor.RELS_CONTENT);
            return Unit.INSTANCE;
        }

        private static final Unit end$lambda$2(XlsxWorkbook this$0) {
            this$0.writer.append(XlsxValuesExtractor.WORKBOOK_RELS_HEADER);
            int n = this$0.sheetNames.size();
            for (int i = 0; i < n; ++i) {
                this$0.writer.append("<Relationship Id=\"rId" + (i + 2) + "\" Target=\"worksheets/sheet" + (i + 1) + ".xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet\"/>");
            }
            this$0.writer.append(XlsxValuesExtractor.WORKBOOK_RELS_FOOTER);
            return Unit.INSTANCE;
        }

        private static final Unit end$lambda$3(XlsxWorkbook this$0) {
            this$0.sharedStrings.write(this$0.writer);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit end$lambda$5(XlsxWorkbook this$0) {
            this$0.writer.append(XlsxValuesExtractor.WORKBOOK_HEADER);
            Iterable $this$forEachIndexed$iv = this$0.sheetNames;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void name;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int i = n;
                boolean bl = false;
                this$0.writer.append("<sheet name=\"" + (String)name + "\" r:id=\"rId" + (i + 2) + "\" sheetId=\"" + (i + 1) + "\"/>");
            }
            this$0.writer.append(XlsxValuesExtractor.WORKBOOK_FOOTER);
            return Unit.INSTANCE;
        }

        private static final Unit end$lambda$6(XlsxWorkbook this$0) {
            this$0.writer.append(XlsxValuesExtractor.CONTENT_TYPES_HEADER);
            int n = this$0.sheetNames.size();
            for (int i = 0; i < n; ++i) {
                this$0.writer.append("<Override ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\" PartName=\"/xl/worksheets/sheet" + (i + 1) + ".xml\"/>");
            }
            this$0.writer.append(XlsxValuesExtractor.CONTENT_TYPES_FOOTER);
            return Unit.INSTANCE;
        }
    }
}

