/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.datagrid.NestedTablesDataGridModel;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.nested.NestedTablesAware;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0005B\u0015\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u001a\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040!0 0\u001fH\u0016J\u001a\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040!0 0\u001fH\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001cH\u0016J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020$0\u001fH\u0016J\u0016\u0010)\u001a\u00020\u001c2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020$0\u001fH\u0016J\u0018\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u001aH\u0016J\"\u00101\u001a\u00020\u001c2\u0018\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040!0 0\u001fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00028\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00063"}, d2={"Lcom/intellij/database/datagrid/NestedTablesSortingModel;", "T", "Lcom/intellij/database/datagrid/GridSortingModel;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "Lcom/intellij/database/datagrid/nested/NestedTablesAware;", "getModel", "Lkotlin/Function0;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "sortingModelStack", "Lcom/intellij/database/datagrid/nested/NestedTablesAware$NonEmptyStack;", "activeSortingModel", "getActiveSortingModel", "()Lcom/intellij/database/datagrid/GridSortingModel;", "enterNestedTable", "coordinate", "Lcom/intellij/database/datagrid/NestedTablesDataGridModel$NestedTableCellCoordinate;", "nestedTable", "Lcom/intellij/database/datagrid/NestedTable;", "(Lcom/intellij/database/datagrid/NestedTablesDataGridModel$NestedTableCellCoordinate;Lcom/intellij/database/datagrid/NestedTable;)Lcom/intellij/database/datagrid/GridSortingModel;", "exitNestedTable", "steps", "", "(I)Lcom/intellij/database/datagrid/GridSortingModel;", "isSortingEnabled", "", "setSortingEnabled", "", "enabled", "getOrdering", "", "Lcom/intellij/database/datagrid/RowSortOrder;", "Lcom/intellij/database/datagrid/ModelIndex;", "getAppliedOrdering", "getAppliedSortingText", "", "apply", "getDocument", "Lcom/intellij/openapi/editor/Document;", "getHistory", "setHistory", "history", "addListener", "l", "Lcom/intellij/database/datagrid/GridSortingModel$Listener;", "disposable", "Lcom/intellij/openapi/Disposable;", "supportsAdditiveSorting", "setOrdering", "ordering", "intellij.grid.core.impl"})
public final class NestedTablesSortingModel<T extends GridSortingModel<GridRow, GridColumn>>
implements GridSortingModel<GridRow, GridColumn>,
NestedTablesAware<T> {
    @NotNull
    private final Function0<T> getModel;
    @NotNull
    private final NestedTablesAware.NonEmptyStack<T> sortingModelStack;

    public NestedTablesSortingModel(@NotNull Function0<? extends T> getModel) {
        Intrinsics.checkNotNullParameter(getModel, (String)"getModel");
        this.getModel = getModel;
        this.sortingModelStack = new NestedTablesAware.NonEmptyStack<Object>(this.getModel.invoke());
    }

    private final T getActiveSortingModel() {
        return (T)((GridSortingModel)this.sortingModelStack.last());
    }

    @Override
    @NotNull
    public T enterNestedTable(@NotNull NestedTablesDataGridModel.NestedTableCellCoordinate coordinate, @NotNull NestedTable nestedTable) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        Intrinsics.checkNotNullParameter((Object)nestedTable, (String)"nestedTable");
        this.sortingModelStack.push(this.getModel.invoke());
        return (T)((GridSortingModel)this.sortingModelStack.last());
    }

    @Override
    @NotNull
    public T exitNestedTable(int steps) {
        return (T)((GridSortingModel)this.sortingModelStack.pop(steps));
    }

    @Override
    public boolean isSortingEnabled() {
        return this.getActiveSortingModel().isSortingEnabled();
    }

    @Override
    public void setSortingEnabled(boolean enabled) {
        this.getActiveSortingModel().setSortingEnabled(enabled);
    }

    @Override
    @NotNull
    public List<RowSortOrder<ModelIndex<GridColumn>>> getOrdering() {
        List<RowSortOrder<ModelIndex<GridColumn>>> list = this.getActiveSortingModel().getOrdering();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getOrdering(...)");
        return list;
    }

    @Override
    @NotNull
    public List<RowSortOrder<ModelIndex<GridColumn>>> getAppliedOrdering() {
        List<RowSortOrder<ModelIndex<GridColumn>>> list = this.getActiveSortingModel().getAppliedOrdering();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAppliedOrdering(...)");
        return list;
    }

    @Override
    @NotNull
    public String getAppliedSortingText() {
        String string = this.getActiveSortingModel().getAppliedSortingText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAppliedSortingText(...)");
        return string;
    }

    @Override
    public void apply() {
        this.getActiveSortingModel().apply();
    }

    @Override
    @Nullable
    public Document getDocument() {
        return this.getActiveSortingModel().getDocument();
    }

    @Override
    @NotNull
    public List<String> getHistory() {
        List<String> list = this.getActiveSortingModel().getHistory();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHistory(...)");
        return list;
    }

    @Override
    public void setHistory(@NotNull List<String> history) {
        Intrinsics.checkNotNullParameter(history, (String)"history");
        this.getActiveSortingModel().setHistory(history);
    }

    @Override
    public void addListener(@NotNull GridSortingModel.Listener l, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.getActiveSortingModel().addListener(l, disposable);
    }

    @Override
    public boolean supportsAdditiveSorting() {
        return this.getActiveSortingModel().supportsAdditiveSorting();
    }

    @Override
    public void setOrdering(@NotNull List<RowSortOrder<ModelIndex<GridColumn>>> ordering) {
        Intrinsics.checkNotNullParameter(ordering, (String)"ordering");
        this.getActiveSortingModel().setOrdering(ordering);
    }
}

