/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.symspell.implementation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.languagetool.rules.spelling.symspell.implementation.ChunkArray;

public class SuggestionStage {
    public Map<Integer, Entry> deletes;
    public ChunkArray<Node> nodes;

    public SuggestionStage(int initialCapacity) {
        this.deletes = new HashMap<Integer, Entry>(initialCapacity);
        this.nodes = new ChunkArray(initialCapacity * 2);
    }

    public int deleteCount() {
        return this.deletes.size();
    }

    public int nodeCount() {
        return this.nodes.count;
    }

    public void clear() {
        this.deletes.clear();
        this.nodes.clear();
    }

    void add(int deleteHash, String suggestion) {
        Entry entry2 = this.deletes.getOrDefault(deleteHash, new Entry(0, -1));
        int next = entry2.first;
        ++entry2.count;
        entry2.first = this.nodes.count;
        this.deletes.put(deleteHash, entry2);
        this.nodes.add(new Node(suggestion, next));
    }

    void commitTo(Map<Integer, String[]> permanentDeletes) {
        this.deletes.forEach((key2, value) -> {
            int i;
            String[] suggestions;
            if (permanentDeletes.containsKey(key2)) {
                suggestions = (String[])permanentDeletes.get(key2);
                i = suggestions.length;
                String[] newSuggestion = Arrays.copyOf(suggestions, i + value.count);
                permanentDeletes.put((Integer)key2, newSuggestion);
                suggestions = newSuggestion;
            } else {
                i = 0;
                suggestions = new String[value.count];
                permanentDeletes.put((Integer)key2, suggestions);
            }
            int next = value.first;
            while (next >= 0) {
                Node node = this.nodes.getValues(next);
                suggestions[i] = node.suggestion;
                next = node.next;
                ++i;
            }
        });
    }

    public class Entry {
        public int count;
        public int first;

        Entry(int count, int first) {
            this.count = count;
            this.first = first;
        }
    }

    public class Node {
        public String suggestion;
        public int next;

        public Node(String suggestion, int next) {
            this.suggestion = suggestion;
            this.next = next;
        }
    }
}

