/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;

public final class Boundaries {
    private Boundaries() {
    }

    @CompilerDirectives.TruffleBoundary
    public static String javaToString(Object value2) {
        return value2.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringValueOf(Object o) {
        return String.valueOf(o);
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringFormat(String format, Object ... params) {
        return String.format(format, params);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean characterIsDigit(char ch) {
        return Character.isDigit(ch);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean characterIsUpperCase(char ch) {
        return Character.isUpperCase(ch);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equals(Object a, Object b) {
        return a.equals(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> Set<Map.Entry<K, V>> mapEntrySet(Map<K, V> map2) {
        return map2.entrySet();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static <K, V> Map.Entry<K, V> mapEntry(K key, V value2) {
        return Map.entry(key, value2);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapPut(Map<K, V> map2, K key, V value2) {
        return map2.put(key, value2);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapPutIfAbsent(Map<K, V> map2, K key, V value2) {
        return map2.putIfAbsent(key, value2);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> boolean mapContainsKey(Map<K, V> map2, K key) {
        return map2.containsKey(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapGet(Map<K, V> map2, K key) {
        return map2.get(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapRemove(Map<K, V> map2, K key) {
        return map2.remove(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> T listGet(List<T> list2, int index) {
        return list2.get(index);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void listSet(List<T> list2, int index, T value2) {
        list2.set(index, value2);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> int listSize(List<T> list2) {
        return list2.size();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> int listIndexOf(List<T> list2, T element) {
        return list2.indexOf(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void listAdd(List<T> list2, T element) {
        list2.add(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void listAddAll(List<T> list2, List<T> addList) {
        list2.addAll(addList);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean listContains(List<T> list2, T element) {
        return list2.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean listContainsUnchecked(List<?> list2, Object element) {
        return list2.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> Object[] listToArray(List<T> list2) {
        return list2.toArray();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean iteratorHasNext(Iterator<T> it) {
        return it.hasNext();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> T iteratorNext(Iterator<T> it) {
        return it.next();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> Iterator<T> iterator(Iterable<T> iterable) {
        return iterable.iterator();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> EconomicSet<T> economicSetCreate() {
        return EconomicSet.create();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean economicSetAdd(EconomicSet<T> economicSet, T element) {
        return economicSet.add(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean economicSetContains(EconomicSet<T> economicSet, T element) {
        return economicSet.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> EconomicMap<K, V> economicMapCreate() {
        return EconomicMap.create();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V economicMapPut(EconomicMap<K, V> map2, K key, V value2) {
        return map2.put(key, value2);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> boolean economicMapContainsKey(EconomicMap<K, V> map2, K key) {
        return map2.containsKey(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V economicMapGet(EconomicMap<K, V> map2, K key) {
        return map2.get(key);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static byte[] byteBufferArray(ByteBuffer buffer) {
        return buffer.array();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void byteBufferPutSlice(ByteBuffer dst, int dstPos, ByteBuffer src, int srcPos, int srcLimit) {
        dst.put(dstPos, src, srcPos, srcLimit - srcPos);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static ByteBuffer byteBufferSlice(ByteBuffer buf, int pos, int limit) {
        return buf.slice(pos, limit - pos);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void byteBufferGet(ByteBuffer src, int srcPos, byte[] dst, int dstPos, int length2) {
        src.get(srcPos, dst, dstPos, length2);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void byteBufferPutArray(ByteBuffer dst, int dstPos, byte[] src, int srcPos, int srcLength) {
        dst.put(dstPos, src, srcPos, srcLength);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean setContains(Set<?> set2, Object element) {
        return set2.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger bigIntegerValueOf(long l) {
        return BigInteger.valueOf(l);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigDecimal bigDecimalValueOf(long l) {
        return BigDecimal.valueOf(l);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger bigIntegerMultiply(BigInteger a, BigInteger b) {
        return a.multiply(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void queueAdd(Queue<? super T> queue, T request) {
        queue.add(request);
    }
}

