/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.WithStatementToObjectNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import java.util.Set;

public abstract class WithStatementToObjectNode
extends JSUnaryNode {
    protected WithStatementToObjectNode(JavaScriptNode operand) {
        super(operand);
    }

    public static JavaScriptNode create(JavaScriptNode child) {
        return WithStatementToObjectNodeGen.create(child);
    }

    @Specialization
    protected Object doDefault(Object value2, @Cached JSToObjectNode toObjectNode) {
        Object result2;
        assert (this.getLanguage().getJSContext().isOptionNashornCompatibilityMode());
        try {
            result2 = toObjectNode.execute(value2);
        }
        catch (JSException ex) {
            throw this.createTypeErrorNotObjectCoercible(value2);
        }
        if (this.getRealm().getEnv().isHostObject(value2)) {
            throw Errors.createTypeError("Cannot apply \"with\" to non script object. Consider using \"with(Object.bindProperties({}, nonScriptObject))\".", (Node)this);
        }
        return result2;
    }

    @CompilerDirectives.TruffleBoundary
    private JSException createTypeErrorNotObjectCoercible(Object value2) {
        return Errors.createTypeError("Cannot apply \"with\" to " + String.valueOf(JSRuntime.safeToString(value2)), (Node)this);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return WithStatementToObjectNode.create(WithStatementToObjectNode.cloneUninitialized(this.getOperand(), materializedTags));
    }
}

