/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.host.GuestToHostCodeCacheBase;
import com.oracle.truffle.host.GuestToHostRootNode;
import com.oracle.truffle.host.HostInteropReflect;
import com.oracle.truffle.host.HostLanguage;
import com.oracle.truffle.host.HostMethodDesc;
import com.oracle.truffle.host.HostObject;
import java.lang.invoke.MethodHandle;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.NoSuchElementException;

final class GuestToHostCodeCache
extends GuestToHostCodeCacheBase {
    final HostLanguage language;
    final CallTarget methodHandleHostInvoke = new GuestToHostInvokeHandle().getCallTarget();
    final CallTarget reflectionHostInvoke = new GuestToHostInvokeReflect().getCallTarget();
    final CallTarget execute = new GuestToHostRootNode(this.api.getProxyExecutableClass(), "execute"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return GuestToHostCodeCache.this.api.callProxyExecutableExecute(proxy, (Object[])arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }
    }.getCallTarget();
    final CallTarget asPointer = new GuestToHostRootNode(this.api.getProxyNativeObjectClass(), "asPointer"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return GuestToHostCodeCache.this.api.callProxyNativeObjectAsPointer(proxy);
        }
    }.getCallTarget();
    final CallTarget instantiate = new GuestToHostRootNode(this.api.getProxyInstantiableClass(), "newInstance"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return GuestToHostCodeCache.this.api.callProxyInstantiableNewInstance(proxy, (Object[])arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }
    }.getCallTarget();
    final CallTarget arrayGet = new GuestToHostRootNode(this.api.getProxyArrayClass(), "get"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws InvalidArrayIndexException, UnsupportedMessageException {
            long index = (Long)arguments[2];
            try {
                return this.boundaryGet(proxy, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw InvalidArrayIndexException.create(index);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private Object boundaryGet(Object proxy, long index) {
            return GuestToHostCodeCache.this.api.callProxyArrayGet(proxy, index);
        }
    }.getCallTarget();
    final CallTarget arraySet = new GuestToHostRootNode(this.api.getProxyArrayClass(), "set"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws InvalidArrayIndexException, UnsupportedMessageException {
            long index = (Long)arguments[2];
            try {
                this.boundarySet(proxy, index, arguments[3]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw InvalidArrayIndexException.create(index);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private void boundarySet(Object proxy, long index, Object value2) {
            GuestToHostCodeCache.this.api.callProxyArraySet(proxy, index, value2);
        }
    }.getCallTarget();
    final CallTarget arrayRemove = new GuestToHostRootNode(this.api.getProxyArrayClass(), "remove"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws InvalidArrayIndexException, UnsupportedMessageException {
            long index = (Long)arguments[2];
            try {
                return this.boundaryRemove(proxy, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw InvalidArrayIndexException.create(index);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean boundaryRemove(Object proxy, long index) {
            return GuestToHostCodeCache.this.api.callProxyArrayRemove(proxy, index);
        }
    }.getCallTarget();
    final CallTarget arraySize = new GuestToHostRootNode(this.api.getProxyArrayClass(), "getSize"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return GuestToHostCodeCache.this.api.callProxyArraySize(proxy);
        }
    }.getCallTarget();
    final CallTarget memberKeys = new GuestToHostRootNode(this.api.getProxyObjectClass(), "getMemberKeys"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return GuestToHostCodeCache.this.api.callProxyObjectMemberKeys(proxy);
        }
    }.getCallTarget();
    final CallTarget getMember = new GuestToHostRootNode(this.api.getProxyObjectClass(), "getMember"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return this.boundaryGetMember(proxy, (String)arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private Object boundaryGetMember(Object proxy, String argument) {
            return GuestToHostCodeCache.this.api.callProxyObjectGetMember(proxy, argument);
        }
    }.getCallTarget();
    final CallTarget putMember = new GuestToHostRootNode(this.api.getProxyObjectClass(), "putMember"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                this.boundaryPutMember(proxy, (String)arguments[2], arguments[3]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private void boundaryPutMember(Object proxy, String member, Object value2) {
            GuestToHostCodeCache.this.api.callProxyObjectPutMember(proxy, member, value2);
        }
    }.getCallTarget();
    final CallTarget removeMember = new GuestToHostRootNode(this.api.getProxyObjectClass(), "removeMember"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return this.removeBoundary(proxy, (String)arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean removeBoundary(Object proxy, String member) {
            return GuestToHostCodeCache.this.api.callProxyObjectRemoveMember(proxy, member);
        }
    }.getCallTarget();
    final CallTarget hasMember = new GuestToHostRootNode(this.api.getProxyObjectClass(), "hasMember"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return GuestToHostCodeCache.this.api.callProxyObjectHasMember(proxy, (String)arguments[2]);
        }
    }.getCallTarget();
    final CallTarget asTimezone = new GuestToHostRootNode(this.api.getProxyTimeZoneClass(), "asTimeZone"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            ZoneId zone = GuestToHostCodeCache.this.api.callProxyTimeZoneAsTimeZone(proxy);
            if (zone == null) {
                throw CompilerDirectives.shouldNotReachHere("The returned zone must not be null.");
            }
            return zone;
        }
    }.getCallTarget();
    final CallTarget asDate = new GuestToHostRootNode(this.api.getProxyDateClass(), "asDate"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            LocalDate date = GuestToHostCodeCache.this.api.callProxyDateAsDate(proxy);
            if (date == null) {
                throw new AssertionError((Object)"The returned date must not be null.");
            }
            return date;
        }
    }.getCallTarget();
    final CallTarget asTime = new GuestToHostRootNode(this.api.getProxyTimeClass(), "asTime"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            LocalTime time = GuestToHostCodeCache.this.api.callProxyTimeAsTime(proxy);
            if (time == null) {
                throw new AssertionError((Object)"The returned time must not be null.");
            }
            return time;
        }
    }.getCallTarget();
    final CallTarget asInstant = new GuestToHostRootNode(this.api.getProxyInstantClass(), "asInstant"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            Instant instant = GuestToHostCodeCache.this.api.callProxyInstantAsInstant(proxy);
            if (instant == null) {
                throw new AssertionError((Object)"The returned instant must not be null.");
            }
            return instant;
        }
    }.getCallTarget();
    final CallTarget asDuration = new GuestToHostRootNode(this.api.getProxyDurationClass(), "asDuration"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            Duration duration = GuestToHostCodeCache.this.api.callProxyDurationAsDuration(proxy);
            if (duration == null) {
                throw new AssertionError((Object)"The returned duration must not be null.");
            }
            return duration;
        }
    }.getCallTarget();
    final CallTarget getIterator = new GuestToHostRootNode(this.api.getProxyIterableClass(), "getIterator"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return GuestToHostCodeCache.this.api.callProxyIterableGetIterator(proxy);
        }
    }.getCallTarget();
    final CallTarget hasIteratorNextElement = new GuestToHostRootNode(this.api.getProxyIteratorClass(), "hasIteratorNextElement"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return GuestToHostCodeCache.this.api.callProxyIteratorHasNext(proxy);
        }
    }.getCallTarget();
    final CallTarget getIteratorNextElement = new GuestToHostRootNode(this.api.getProxyIteratorClass(), "getIteratorNextElement"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws StopIterationException, UnsupportedMessageException {
            try {
                return GuestToHostCodeCache.this.api.callProxyIteratorGetNext(proxy);
            }
            catch (NoSuchElementException e) {
                throw StopIterationException.create();
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }
    }.getCallTarget();
    final CallTarget hasHashEntry = new GuestToHostRootNode(this.api.getProxyHashMapClass(), "hasEntry"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws InteropException {
            return GuestToHostCodeCache.this.api.callProxyHashMapHasHashEntry(proxy, arguments[2]);
        }
    }.getCallTarget();
    final CallTarget getHashSize = new GuestToHostRootNode(this.api.getProxyHashMapClass(), "getSize"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws InteropException {
            return GuestToHostCodeCache.this.api.callProxyHashMapGetHashSize(proxy);
        }
    }.getCallTarget();
    final CallTarget getHashValue = new GuestToHostRootNode(this.api.getProxyHashMapClass(), "getValue"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws InteropException {
            try {
                return GuestToHostCodeCache.this.api.callProxyHashMapGetHashValue(proxy, arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }
    }.getCallTarget();
    final CallTarget putHashEntry = new GuestToHostRootNode(this.api.getProxyHashMapClass(), "putEntry"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws InteropException {
            try {
                GuestToHostCodeCache.this.api.callProxyHashMapPutHashEntry(proxy, arguments[2], arguments[3]);
                return null;
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }
    }.getCallTarget();
    final CallTarget removeHashEntry = new GuestToHostRootNode(this.api.getProxyHashMapClass(), "removeEntry"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws InteropException {
            try {
                return GuestToHostCodeCache.this.api.callProxyHashMapRemoveHashEntry(proxy, arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }
    }.getCallTarget();
    final CallTarget getHashEntriesIterator = new GuestToHostRootNode(this.api.getProxyHashMapClass(), "getEntriesIterator"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws InteropException {
            return GuestToHostCodeCache.this.api.callProxyHashMapGetEntriesIterator(proxy);
        }
    }.getCallTarget();

    GuestToHostCodeCache(HostLanguage language) {
        super(language.polyglot.getAPIAccess());
        this.language = language;
    }

    static class GuestToHostInvokeHandle
    extends GuestToHostRootNode {
        protected GuestToHostInvokeHandle() {
            super(HostObject.class, "doInvoke");
        }

        @Override
        protected Object executeImpl(Object receiver, Object[] callArguments) {
            Object ret;
            if (TruffleOptions.AOT) {
                throw CompilerDirectives.shouldNotReachHere("MHBase.invokeHandle can only be used in non AOT mode.");
            }
            MethodHandle methodHandle = (MethodHandle)callArguments[2];
            Object[] arguments = (Object[])callArguments[3];
            try {
                ret = HostMethodDesc.SingleMethod.MHBase.invokeHandle(methodHandle, receiver, arguments);
            }
            catch (Throwable e) {
                throw HostInteropReflect.rethrow(e);
            }
            return ret;
        }
    }

    static class GuestToHostInvokeReflect
    extends GuestToHostRootNode {
        protected GuestToHostInvokeReflect() {
            super(HostObject.class, "doInvoke");
        }

        @Override
        protected Object executeImpl(Object obj, Object[] callArguments) {
            Object ret;
            HostMethodDesc.SingleMethod.ReflectBase method = (HostMethodDesc.SingleMethod.ReflectBase)callArguments[2];
            Object[] arguments = (Object[])callArguments[3];
            try {
                ret = method.invoke(obj, arguments);
            }
            catch (Throwable e) {
                throw HostInteropReflect.rethrow(e);
            }
            return ret;
        }
    }
}

