/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.httpClient.actions.AddRequestTemplateProvider;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestFileUtils;
import com.intellij.httpClient.http.request.notification.HttpClientNotificationPanelV2Kt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.UIBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddHttpRequestAction
extends AnAction
implements DumbAware {
    public static final String DEFAULT_TEMPLATE = "gtrp";
    public static final String DEFAULT_GROUP = "HTTP Request";
    private static final Supplier<String> FIRST_POST_ACTION = RestClientBundle.messagePointer("http.request.add.request.action.post.text.body", new Object[0]);
    private static final Supplier<String> GRAPH_QL_ACTION = RestClientBundle.messagePointer("http.request.add.request.action.graphql.field", new Object[0]);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddHttpRequestAction.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = e.getPresentation();
        Project project = e.getProject();
        presentation2.setEnabledAndVisible(project != null && !project.isDefault() && e.getData(CommonDataKeys.EDITOR) != null);
        if (Boolean.TRUE.equals(e.getData(HttpClientNotificationPanelV2Kt.HTTP_CLIENT_IS_TOOLBAR_V2))) {
            presentation2.setIcon(AllIcons.General.Add);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddHttpRequestAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AddHttpRequestAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null || project.isDefault()) {
            return;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 != null) {
            ReadonlyStatusHandler.OperationStatus status;
            VirtualFile currentVFile;
            VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
            if (AddHttpRequestAction.isCurrentFileAppropriate(project, editor2, selectedFiles) && (currentVFile = FileDocumentManager.getInstance().getFile(editor2.getDocument())) != null && (status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(List.of(currentVFile))).hasReadonlyFiles()) {
                HintManager.getInstance().showErrorHint(editor2, status.getReadonlyFilesMessage());
                return;
            }
            AddHttpRequestAction.showRequestsPopup(project, editor2, e);
        }
    }

    static ActionGroup getNewRequestActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        final NewRequestActions actions = NewRequestActions.create();
        for (final String action : actions.actionsToShow()) {
            if (FIRST_POST_ACTION.get().equals(action) || GRAPH_QL_ACTION.get().equals(action)) {
                group.add((AnAction)new Separator());
            }
            group.add(new AnAction(action){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
                    Project project = e.getProject();
                    if (editor2 == null || project == null) {
                        return;
                    }
                    TemplateInfo templateInfo = actions.templateDescriptionMap().get(action);
                    AddHttpRequestAction.performHttpLiveTemplateAction(project, editor2, templateInfo.text(), templateInfo.group(), e);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/httpClient/actions/AddHttpRequestAction$1", "actionPerformed"));
                }
            });
        }
        return group;
    }

    private static void showRequestsPopup(final @NotNull Project project, final @NotNull Editor editor2, final @NotNull AnActionEvent event) {
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            AddHttpRequestAction.$$$reportNull$$$0(4);
        }
        if (event == null) {
            AddHttpRequestAction.$$$reportNull$$$0(5);
        }
        String title = RestClientBundle.message("action.HTTPClient.AddRequest.text", new Object[0]);
        final NewRequestActions actions = NewRequestActions.create();
        ListPopup requestsCollectionPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(title, actions.actionsToShow()){

            @Nullable
            public ListSeparator getSeparatorAbove(@NlsActions.ActionText String value2) {
                if (FIRST_POST_ACTION.get().equals(value2) || GRAPH_QL_ACTION.get().equals(value2)) {
                    return new ListSeparator();
                }
                return null;
            }

            public PopupStep<?> onChosen(String requestName, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    TemplateInfo templateInfo = actions.templateDescriptionMap().get(requestName);
                    AddHttpRequestAction.performHttpLiveTemplateAction(project, editor2, templateInfo.text(), templateInfo.group(), event);
                });
            }
        });
        HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)event.getDataContext().getData(HttpClientDataKeys.ADD_REQUEST_TOOLBAR_HYPERLINK_LABEL);
        if (hyperlinkLabel != null) {
            requestsCollectionPopup.showUnderneathOf((Component)hyperlinkLabel);
        } else if (Boolean.TRUE.equals(event.getData(HttpClientNotificationPanelV2Kt.HTTP_CLIENT_IS_TOOLBAR_V2)) && event.getInputEvent() != null) {
            requestsCollectionPopup.showUnderneathOf(event.getInputEvent().getComponent());
        } else {
            requestsCollectionPopup.showInBestPositionFor(editor2);
        }
    }

    public static void performHttpLiveTemplateAction(@NotNull Project project, @Nullable Editor editor2, @NotNull String liveTemplateName, @NotNull String templateGroup, @NotNull AnActionEvent event) {
        TemplateImpl httpRequestTemplate;
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(6);
        }
        if (liveTemplateName == null) {
            AddHttpRequestAction.$$$reportNull$$$0(7);
        }
        if (templateGroup == null) {
            AddHttpRequestAction.$$$reportNull$$$0(8);
        }
        if (event == null) {
            AddHttpRequestAction.$$$reportNull$$$0(9);
        }
        if ((httpRequestTemplate = TemplateSettings.getInstance().getTemplate(liveTemplateName, templateGroup)) == null) {
            AddHttpRequestAction.showErrorBalloon(event, RestClientBundle.message("http.request.add.request.action.failed.find.template", new Object[0]));
            return;
        }
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (!AddHttpRequestAction.isCurrentFileAppropriate(project, editor2, selectedFiles)) {
            AddHttpRequestAction.createScratchFileAndStartTemplate(project, event, (Template)httpRequestTemplate);
        } else {
            editor2.getSelectionModel().removeSelection();
            editor2.getCaretModel().moveToOffset(0);
            Document document = editor2.getDocument();
            WriteCommandAction.runWriteCommandAction((Project)project, (String)RestClientBundle.message("http.request.add.http.request.command", new Object[0]), null, () -> AddHttpRequestAction.lambda$performHttpLiveTemplateAction$0(document, project, editor2, (Template)httpRequestTemplate), (PsiFile[])new PsiFile[0]);
        }
    }

    private static boolean isCurrentFileAppropriate(@NotNull Project project, @Nullable Editor editor2, VirtualFile @NotNull [] selectedFiles) {
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(10);
        }
        if (selectedFiles == null) {
            AddHttpRequestAction.$$$reportNull$$$0(11);
        }
        return editor2 != null && selectedFiles.length != 0 && !HttpRequestFileUtils.isHttpRequestSystemFile(project, selectedFiles[0].getPath()) && FileTypeRegistry.getInstance().isFileOfType(selectedFiles[0], (FileType)HttpRequestFileType.INSTANCE);
    }

    private static void createScratchFileAndStartTemplate(@NotNull Project project, @NotNull AnActionEvent event, @NotNull Template template) {
        FileEditor[] fileEditors;
        VirtualFile file;
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(12);
        }
        if (event == null) {
            AddHttpRequestAction.$$$reportNull$$$0(13);
        }
        if (template == null) {
            AddHttpRequestAction.$$$reportNull$$$0(14);
        }
        String fileName = PathUtil.makeFileName((String)"rest-api", (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
        ScratchFileService fileService = ScratchFileService.getInstance();
        try {
            file = fileService.findFile((RootType)ScratchRootType.getInstance(), fileName, ScratchFileService.Option.create_new_always);
        }
        catch (IOException e) {
            AddHttpRequestAction.showErrorBalloon(event, UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}));
            return;
        }
        for (FileEditor curFileEditor : fileEditors = FileEditorManager.getInstance((Project)project).openFile(file, true)) {
            VirtualFile curFile;
            if (!(curFileEditor instanceof TextEditor) || (curFile = curFileEditor.getFile()) == null || !curFile.getPath().equals(file.getPath())) continue;
            TemplateManager.getInstance((Project)project).startTemplate(((TextEditor)curFileEditor).getEditor(), template);
            return;
        }
        Messages.showErrorDialog((Project)project, (String)RestClientBundle.message("http.request.add.request.action.error.adding.request.message", new Object[0]), (String)RestClientBundle.message("http.request.add.request.action.error.adding.request", new Object[0]));
    }

    public static void showErrorBalloon(@NotNull AnActionEvent event, @NotNull @NlsContexts.PopupContent String message) {
        if (event == null) {
            AddHttpRequestAction.$$$reportNull$$$0(15);
        }
        if (message == null) {
            AddHttpRequestAction.$$$reportNull$$$0(16);
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setFadeoutTime(2000L);
        Balloon errorBalloon = builder.createBalloon();
        HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)event.getDataContext().getData(HttpClientDataKeys.ADD_REQUEST_TOOLBAR_HYPERLINK_LABEL);
        if (hyperlinkLabel != null) {
            errorBalloon.showInCenterOf((JComponent)hyperlinkLabel);
        } else {
            errorBalloon.show(JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext()), Balloon.Position.below);
        }
    }

    private static /* synthetic */ void lambda$performHttpLiveTemplateAction$0(Document document, Project project, Editor editor2, Template httpRequestTemplate) {
        document.insertString(0, (CharSequence)"\n");
        TemplateManager.getInstance((Project)project).startTemplate(editor2, httpRequestTemplate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/actions/AddHttpRequestAction";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liveTemplateName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateGroup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFiles";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/actions/AddHttpRequestAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showRequestsPopup";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performHttpLiveTemplateAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCurrentFileAppropriate";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createScratchFileAndStartTemplate";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showErrorBalloon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private record NewRequestActions(@NotNull List<@NlsActions.ActionText String> actionsToShow, @NotNull Map<@NlsActions.ActionText String, TemplateInfo> templateDescriptionMap) {
        private final @NotNull List<@NlsActions.ActionText String> actionsToShow;
        private final @NotNull Map<@NlsActions.ActionText String, TemplateInfo> templateDescriptionMap;
        private static final ExtensionPointName<AddRequestTemplateProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.httpClient.addRequestTemplateProvider");
        private static final List<String> defaultLiveTemplatesNames = List.of("gtrp", "ptr", "ptrp", "mptr", "fptr", "gqlr", "wsr");

        private NewRequestActions(@NotNull List<@NlsActions.ActionText String> actionsToShow, @NotNull Map<@NlsActions.ActionText String, TemplateInfo> templateDescriptionMap) {
            if (actionsToShow == null) {
                NewRequestActions.$$$reportNull$$$0(0);
            }
            if (templateDescriptionMap == null) {
                NewRequestActions.$$$reportNull$$$0(1);
            }
        }

        static NewRequestActions create() {
            List providedDescriptors = EP_NAME.getExtensionList().stream().flatMap(provider -> provider.provideTemplates().stream()).toList();
            ArrayList<String> actionsToShow = new ArrayList<String>(NewRequestActions.getDefaultRequestDescriptions());
            List defaultTemplates = ContainerUtil.map(defaultLiveTemplatesNames, template -> new TemplateInfo((String)template, AddHttpRequestAction.DEFAULT_GROUP));
            Map templateDescriptionMap = ContainerUtil.newHashMap(actionsToShow, (List)defaultTemplates);
            for (AddRequestTemplateProvider.TemplateDescriptor descriptor : providedDescriptors) {
                actionsToShow.add(descriptor.getDescription());
                templateDescriptionMap.put(descriptor.getDescription(), new TemplateInfo(descriptor.getTemplate(), descriptor.getGroup()));
            }
            return new NewRequestActions(List.copyOf(actionsToShow), Map.copyOf(templateDescriptionMap));
        }

        private static @NotNull List<@NlsActions.ActionText String> getDefaultRequestDescriptions() {
            List<String> list2 = List.of(RestClientBundle.message("http.request.add.request.action.get", new Object[0]), RestClientBundle.message("http.request.add.request.action.post.text.body", new Object[0]), RestClientBundle.message("http.request.add.request.action.post.parameters.body", new Object[0]), RestClientBundle.message("http.request.add.request.action.form.text.field", new Object[0]), RestClientBundle.message("http.request.add.request.action.form.file.field", new Object[0]), RestClientBundle.message("http.request.add.request.action.graphql.field", new Object[0]), RestClientBundle.message("http.request.add.request.action.websocket.field", new Object[0]));
            if (list2 == null) {
                NewRequestActions.$$$reportNull$$$0(2);
            }
            return list2;
        }

        public @NotNull List<@NlsActions.ActionText String> actionsToShow() {
            List<String> list2 = this.actionsToShow;
            if (list2 == null) {
                NewRequestActions.$$$reportNull$$$0(3);
            }
            return list2;
        }

        public @NotNull Map<@NlsActions.ActionText String, TemplateInfo> templateDescriptionMap() {
            Map<String, TemplateInfo> map2 = this.templateDescriptionMap;
            if (map2 == null) {
                NewRequestActions.$$$reportNull$$$0(4);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionsToShow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateDescriptionMap";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/actions/AddHttpRequestAction$NewRequestActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/actions/AddHttpRequestAction$NewRequestActions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultRequestDescriptions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "actionsToShow";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "templateDescriptionMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private record TemplateInfo(@NotNull String text, @NotNull String group) {
        @NotNull
        private final String text;
        @NotNull
        private final String group;

        private TemplateInfo(@NotNull String text2, @NotNull String group) {
            if (text2 == null) {
                TemplateInfo.$$$reportNull$$$0(0);
            }
            if (group == null) {
                TemplateInfo.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String text() {
            String string = this.text;
            if (string == null) {
                TemplateInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String group() {
            String string = this.group;
            if (string == null) {
                TemplateInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/actions/AddHttpRequestAction$TemplateInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/actions/AddHttpRequestAction$TemplateInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

