/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nwjs;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfigurationBase;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfigurationEditor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.nwjs.NwjsProcessHandler;
import com.jetbrains.nwjs.NwjsProcessState;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.wip.WipVm;

final class NwjsRunConfiguration
extends DebuggableProcessRunConfigurationBase
implements RunProfileWithCompileBeforeLaunchOption {
    NwjsRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.checkExePath("NW.js interpreter");
    }

    @NotNull
    protected String getInputFileTitle() {
        return "NW.js app";
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new DebuggableProcessRunConfigurationEditor<NwjsRunConfiguration>(this.getProject()){

            @NotNull
            protected DebuggableProcessRunConfigurationEditor.DebuggableProgramParametersPanel createEditor() {
                DebuggableProcessRunConfigurationEditor.DebuggableProgramParametersPanel debuggableProgramParametersPanel = this.panel = new DebuggableProcessRunConfigurationEditor.DebuggableProgramParametersPanel(NwjsRunConfiguration.this.getProject(), this.createExePathDescriptor(), this.createInputPathDescriptor()){

                    protected void initComponents() {
                        super.initComponents();
                        this.inputPathLabel(JSDebuggerBundle.message((String)"nwjs.run.configuration.app", (Object[])new Object[0])).programParametersLabel(JSDebuggerBundle.message((String)"nwjs.run.configuration.arguments", (Object[])new Object[0])).exePathLabel(JSDebuggerBundle.message((String)"nwjs.run.configuration.interpreter", (Object[])new Object[0]));
                    }
                };
                if (debuggableProgramParametersPanel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return debuggableProgramParametersPanel;
            }

            protected FileChooserDescriptor createInputPathDescriptor() {
                return new FileChooserDescriptor(true, true, false, false, false, false){

                    public boolean isFileSelectable(@Nullable VirtualFile file) {
                        boolean selectable = super.isFileSelectable(file);
                        if (!selectable) {
                            return false;
                        }
                        if (file.isDirectory()) {
                            return file.findChild("package.json") != null;
                        }
                        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)".nw");
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration$1", "createEditor"));
            }
        };
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            NwjsRunConfiguration.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            NwjsRunConfiguration.$$$reportNull$$$0(1);
        }
        return new NwjsProcessState(this, environment);
    }

    @NotNull
    public String correctExePath(@NotNull String exePath) {
        if (exePath == null) {
            NwjsRunConfiguration.$$$reportNull$$$0(2);
        }
        if (SystemInfo.isMac) {
            if (exePath.endsWith("/node-webkit.app")) {
                String string = exePath + "/Contents/MacOS/node-webkit";
                if (string == null) {
                    NwjsRunConfiguration.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (exePath.endsWith("/nwjs.app")) {
                String string = exePath + "/Contents/MacOS/nwjs";
                if (string == null) {
                    NwjsRunConfiguration.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        String string = exePath;
        if (string == null) {
            NwjsRunConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (socketAddress == null) {
            NwjsRunConfiguration.$$$reportNull$$$0(6);
        }
        if (session == null) {
            NwjsRunConfiguration.$$$reportNull$$$0(7);
        }
        if (environment == null) {
            NwjsRunConfiguration.$$$reportNull$$$0(8);
        }
        assert (executionResult != null);
        NwjsProcessHandler processHandler = (NwjsProcessHandler)executionResult.getProcessHandler();
        WipRemoteVmConnection connection2 = processHandler.vmConnection;
        DebuggableFileFinderImpl fileFinder = new DebuggableFileFinderImpl(session.getProject(), connection2.getUrl()){

            protected FileUrlMapper @NotNull [] computeFileUrlMappers() {
                FileUrlMapper[] fileUrlMapperArray = new FileUrlMapper[]{new FileUrlMapper(){

                    @Nullable
                    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
                        if (url == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        String inputPath = NwjsRunConfiguration.this.getInputPath();
                        String expandedPath = PathMacroManager.getInstance((ComponentManager)project).expandPath(inputPath);
                        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(Objects.requireNonNull(expandedPath));
                        return VfsUtilCore.findRelativeFile((String)url.getPath(), (VirtualFile)root);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "url";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "project";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/nwjs/NwjsRunConfiguration$2$1";
                        objectArray[2] = "getFile";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }};
                if (fileUrlMapperArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return fileUrlMapperArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration$2", "computeFileUrlMappers"));
            }
        };
        BrowserChromeDebugProcess process = new BrowserChromeDebugProcess(session, (DebuggableFileFinder)fileFinder, (VmConnection<? extends WipVm>)connection2, executionResult);
        connection2.open(socketAddress, null);
        BrowserChromeDebugProcess browserChromeDebugProcess = process;
        if (browserChromeDebugProcess == null) {
            NwjsRunConfiguration.$$$reportNull$$$0(9);
        }
        return browserChromeDebugProcess;
    }

    @Nullable
    protected String computeDefaultExePath() {
        String appdata;
        Path exePath = null;
        if (SystemInfo.isUnix) {
            if (SystemInfo.isMac) {
                exePath = Path.of("/Applications/node-webkit.app/Contents/MacOS/node-webkit", new String[0]);
                if (!Files.exists(exePath, new LinkOption[0])) {
                    exePath = Path.of("/usr/local/lib/node_modules/nodewebkit/nodewebkit/node-webkit.app/Contents/MacOS/node-webkit", new String[0]);
                }
                if (!Files.exists(exePath, new LinkOption[0])) {
                    exePath = Path.of("/Applications/nwjs.app/Contents/MacOS/nwjs", new String[0]);
                }
            }
            if (!(exePath != null && Files.exists(exePath, new LinkOption[0]) || Files.exists(exePath = Path.of("/usr/local/bin/node-webkit", new String[0]), new LinkOption[0]))) {
                exePath = Path.of("/usr/local/bin/nwjs", new String[0]);
            }
        } else if (SystemInfo.isWindows && (appdata = System.getenv("APPDATA")) != null && !Files.exists(exePath = Path.of(appdata, "npm\\node_modules\\nodewebkit\\nodewebkit\\nw.exe"), new LinkOption[0])) {
            exePath = Path.of("npm\\node_modules\\nwjs\\nwjs\\nwjs.exe", new String[0]);
        }
        return exePath == null || !Files.exists(exePath, new LinkOption[0]) ? null : exePath.toString();
    }

    public boolean isBuildBeforeLaunchAddedByDefault() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nwjs/NwjsRunConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socketAddress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nwjs/NwjsRunConfiguration";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "correctExePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "correctExePath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 9 -> new IllegalStateException(string);
        };
    }
}

