/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.trust;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.jupyter.nbformat.DisplayDataContainer;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterDisplayDataOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="JupyterTrustHash", storages={@Storage(value="jupyterHashTrust.xml")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000bJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager$Trust;", "<init>", "()V", "trust", "hashed", "", "", "cachedTrust", "Ljava/util/WeakHashMap;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "", "getState", "loadState", "", "state", "saveTrustedNotebook", "notebook", "isNotebookTrusted", "calculateHash", "addHash", "hash", "Trust", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterHashTrustManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterHashTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n381#2,7:99\n1368#3:106\n1454#3,2:107\n1611#3,9:109\n1863#3:118\n1864#3:120\n1620#3:121\n1368#3:122\n1454#3,2:123\n1611#3,9:125\n1863#3:134\n1864#3:136\n1620#3:137\n1456#3,3:138\n1456#3,3:141\n1863#3,2:144\n1#4:119\n1#4:135\n*S KotlinDebug\n*F\n+ 1 JupyterHashTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager\n*L\n42#1:99,7\n51#1:106\n51#1:107,2\n56#1:109,9\n56#1:118\n56#1:120\n56#1:121\n57#1:122\n57#1:123,2\n59#1:125,9\n59#1:134\n59#1:136\n59#1:137\n57#1:138,3\n51#1:141,3\n68#1:144,2\n56#1:119\n59#1:135\n*E\n"})
public final class JupyterHashTrustManager
implements PersistentStateComponent<Trust> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Trust trust = new Trust(null, 1, null);
    @NotNull
    private final Set<String> hashed = new LinkedHashSet();
    @NotNull
    private final transient WeakHashMap<JupyterNotebook, Boolean> cachedTrust = new WeakHashMap();
    private static final int CACHE_MAX_SIZE = 65535;

    @NotNull
    public Trust getState() {
        return this.trust;
    }

    public void loadState(@NotNull Trust state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List newHashed = state.getHashed();
        if (newHashed.size() > 65535) {
            newHashed = CollectionsKt.drop((Iterable)newHashed, (int)16383);
        }
        this.trust.setHashed(newHashed);
        this.hashed.clear();
        this.hashed.addAll((Collection<String>)this.trust.getHashed());
    }

    public final void saveTrustedNotebook(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        String string = this.calculateHash(notebook);
        if (string == null) {
            return;
        }
        String hash = string;
        this.addHash(hash);
    }

    public final boolean isNotebookTrusted(@NotNull JupyterNotebook notebook) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Map $this$getOrPut$iv = this.cachedTrust;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(notebook);
        if (value$iv == null) {
            Boolean bl;
            boolean bl2 = false;
            String string = this.calculateHash(notebook);
            if (string == null) {
                bl = true;
            } else {
                String hash = string;
                bl = this.hashed.contains(hash);
            }
            Boolean answer$iv = bl;
            $this$getOrPut$iv.put(notebook, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    private final String calculateHash(JupyterNotebook notebook) {
        void $this$flatMapTo$iv$iv;
        List<JupyterCell> cells = notebook.computeCells();
        Iterable $this$flatMap$iv = cells;
        boolean $i$f$flatMap22 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            List list;
            Iterable $this$mapNotNull$iv;
            Object object;
            JupyterCell jupyterCell = (JupyterCell)element$iv$iv;
            boolean bl = false;
            JupyterOutputs outputs = jupyterCell.getOutputs();
            if (outputs == null) {
                CollectionsKt.emptyList();
            }
            if ((object = outputs) != null && (object = object.getOutputs()) != null) {
                void $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    JupyterDisplayDataOutput it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    JupyterOutput it = (JupyterOutput)element$iv$iv2;
                    boolean bl3 = false;
                    if ((it instanceof JupyterDisplayDataOutput ? (JupyterDisplayDataOutput)it : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.emptyList();
            }
            List displayOutputs = list;
            Iterable $this$flatMap$iv2 = displayOutputs;
            boolean $i$f$flatMap = false;
            $this$mapNotNull$iv = $this$flatMap$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv3 : $this$flatMapTo$iv$iv2) {
                void $this$mapNotNullTo$iv$iv;
                JupyterDisplayDataOutput dataOutput = (JupyterDisplayDataOutput)element$iv$iv3;
                boolean bl5 = false;
                DisplayDataContainer data = dataOutput.getData();
                Iterable $this$mapNotNull$iv2 = MimeType.Companion.getUNSAFE_OUTPUTS();
                boolean $i$f$mapNotNull = false;
                Iterable bl2 = $this$mapNotNull$iv2;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv4 = element$iv$iv$iv = iterator.next();
                    boolean bl6 = false;
                    MimeType it = (MimeType)((Object)element$iv$iv4);
                    boolean bl7 = false;
                    if (data.getAsString(it.getMimeType()) == null) continue;
                    boolean bl8 = false;
                    destination$iv$iv4.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv4;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List untrustedOutputs = (List)destination$iv$iv;
        if (untrustedOutputs.isEmpty()) {
            return null;
        }
        MessageDigest sha256 = DigestUtil.sha256();
        String string = PermanentInstallationID.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String $i$f$flatMap22 = string;
        byte[] byArray = $i$f$flatMap22.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        sha256.update(byArray);
        Iterable $this$forEach$iv = untrustedOutputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            byte[] byArray2 = it.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            sha256.update(byArray2);
        }
        return Base64.getEncoder().encodeToString(sha256.digest());
    }

    private final void addHash(String hash) {
        this.hashed.add(hash);
        Trust trust = this.trust;
        trust.setHashed(CollectionsKt.plus((Collection)trust.getHashed(), (Object)hash));
        this.cachedTrust.clear();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager$Companion;", "", "<init>", "()V", "CACHE_MAX_SIZE", "", "getIsTrusted", "", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "saveTrustedNotebook", "", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterHashTrustManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterHashTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,98:1\n40#2,3:99\n40#2,3:102\n*S KotlinDebug\n*F\n+ 1 JupyterHashTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager$Companion\n*L\n89#1:99,3\n93#1:102,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getIsTrusted(@NotNull JupyterNotebook notebook) {
            Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
            boolean $i$f$service = false;
            Class<JupyterHashTrustManager> serviceClass$iv = JupyterHashTrustManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return ((JupyterHashTrustManager)object).isNotebookTrusted(notebook);
        }

        public final void saveTrustedNotebook(@NotNull JupyterNotebook notebook) {
            Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
            boolean $i$f$service = false;
            Class<JupyterHashTrustManager> serviceClass$iv = JupyterHashTrustManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((JupyterHashTrustManager)object).saveTrustedNotebook(notebook);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R$\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager$Trust;", "", "hashed", "", "", "<init>", "(Ljava/util/List;)V", "getHashed", "()Ljava/util/List;", "setHashed", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.jupyter.core"})
    public static final class Trust {
        @XCollection
        @NotNull
        private List<String> hashed;

        public Trust(@NotNull List<String> hashed) {
            Intrinsics.checkNotNullParameter(hashed, (String)"hashed");
            this.hashed = hashed;
        }

        public /* synthetic */ Trust(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<String> getHashed() {
            return this.hashed;
        }

        public final void setHashed(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.hashed = list;
        }

        @NotNull
        public final List<String> component1() {
            return this.hashed;
        }

        @NotNull
        public final Trust copy(@NotNull List<String> hashed) {
            Intrinsics.checkNotNullParameter(hashed, (String)"hashed");
            return new Trust(hashed);
        }

        public static /* synthetic */ Trust copy$default(Trust trust, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = trust.hashed;
            }
            return trust.copy(list);
        }

        @NotNull
        public String toString() {
            return "Trust(hashed=" + this.hashed + ")";
        }

        public int hashCode() {
            return ((Object)this.hashed).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Trust)) {
                return false;
            }
            Trust trust = (Trust)other;
            return Intrinsics.areEqual(this.hashed, trust.hashed);
        }

        public Trust() {
            this(null, 1, null);
        }
    }
}

