/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionBase;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u000f*\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterOpenNotebookInBrowserAction;", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorActionBase;", "<init>", "()V", "createActionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "appendNotebookPath", "Ljava/net/URI;", "suffix", "", "isRemote", "", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "isItLocalFileConnectedToRemoteServer", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "Companion", "intellij.jupyter.core"})
public final class JupyterOpenNotebookInBrowserAction
extends JupyterEditorActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    @NotNull
    protected JupyterActonUpdater createActionUpdater() {
        return super.createActionUpdater().derive((Function1<? super JupyterActonUpdater.Builder, Unit>)((Function1)arg_0 -> JupyterOpenNotebookInBrowserAction.createActionUpdater$lambda$2(this, arg_0)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = JupyterAnActionEventExtensionsKt.getEditor(e);
        if (object == null || (object = JupyterEditorExtensionsKt.getNotebookFileOrNull(object)) == null) {
            return;
        }
        Object jupyterFile = object;
        JupyterNotebookSession session2 = JupyterRuntimeService.Companion.getInstance(project2).getNotebookSession((BackedNotebookVirtualFile)jupyterFile);
        if (session2 == null) {
            LOG.warn("Can't open a notebook since no session is running");
            return;
        }
        URI uri = this.appendNotebookPath(session2.getJupyterServer().getConnectionParameters().getHttpParams().toURI(), session2.getPathFromRoot());
        BrowserUtil.open((String)uri.toASCIIString());
    }

    private final URI appendNotebookPath(URI $this$appendNotebookPath, String suffix) {
        URIBuilder uRIBuilder = new URIBuilder($this$appendNotebookPath);
        String string = $this$appendNotebookPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        char[] cArray = new char[]{'/'};
        URI uRI = uRIBuilder.setPath(StringsKt.trimEnd((String)string, (char[])cArray) + "/notebooks/" + suffix).build();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
        return uRI;
    }

    private final boolean isRemote(BackedNotebookVirtualFile $this$isRemote) {
        return !$this$isRemote.getOriginFile().isInLocalFileSystem();
    }

    private final boolean isItLocalFileConnectedToRemoteServer(JupyterNotebookSession $this$isItLocalFileConnectedToRemoteServer) {
        return StringsKt.startsWith$default((String)$this$isItLocalFileConnectedToRemoteServer.getPathFromRoot(), (String)"localFileConnectedToRemoteServer", (boolean)false, (int)2, null);
    }

    private static final boolean createActionUpdater$lambda$2$lambda$0(JupyterOpenNotebookInBrowserAction this$0, JupyterEditorAction action, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        Object object = JupyterAnActionEventExtensionsKt.getEditor(event);
        if (object == null || (object = JupyterEditorExtensionsKt.getNotebookFileOrNull(object)) == null) {
            return false;
        }
        Object jupyterFile = object;
        if (!event.getPresentation().isVisible()) {
            return false;
        }
        JupyterNotebookSession notebookSession = JupyterRuntimeService.Companion.getInstance(project2).getNotebookSession((BackedNotebookVirtualFile)jupyterFile);
        return notebookSession != null && !this$0.isItLocalFileConnectedToRemoteServer(notebookSession);
    }

    private static final Unit createActionUpdater$lambda$2$lambda$1(JupyterEditorAction action, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getPresentation().isEnabled() ? JupyterBundle.message("action.JupyterOpenNotebookInBrowserAction.text", new Object[0]) : JupyterBundle.message("action.JupyterOpenNotebookInBrowserAction.remote.not.started", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit createActionUpdater$lambda$2(JupyterOpenNotebookInBrowserAction this$0, JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledAndVisibleProvider((Function2<? super JupyterEditorAction, ? super AnActionEvent, Boolean>)((Function2)(arg_0, arg_1) -> JupyterOpenNotebookInBrowserAction.createActionUpdater$lambda$2$lambda$0(this$0, arg_0, arg_1)));
        $this$derive.addVisualCustomizer((Function2<? super JupyterEditorAction, ? super AnActionEvent, Unit>)((Function2)JupyterOpenNotebookInBrowserAction::createActionUpdater$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterOpenNotebookInBrowserAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

