/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.row;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J$\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J6\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\"\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014JX\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2 \u0010\u001e\u001a\u001c\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/RowBasedTableAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "considerSeparatorRow", "", "<init>", "(Z)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "performAction", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "rowElement", "Lcom/intellij/psi/PsiElement;", "findTableAndRow", "Lkotlin/Pair;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "findRowOrSeparator", "findRow", "rowGetter", "Lkotlin/Function3;", "obtainParentTable", "element", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nRowBasedTableAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RowBasedTableAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/row/RowBasedTableAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public abstract class RowBasedTableAction
extends AnAction {
    private final boolean considerSeparatorRow;

    public RowBasedTableAction(boolean considerSeparatorRow) {
        this.considerSeparatorRow = considerSeparatorRow;
    }

    public /* synthetic */ RowBasedTableAction(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        if (caret == null) {
            return;
        }
        int offset = caret.getOffset();
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Pair<MarkdownTable, PsiElement> tableAndRow = this.findTableAndRow(event, file, document2, offset);
        if (tableAndRow == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        MarkdownTable table = (MarkdownTable)tableAndRow.component1();
        PsiElement row = (PsiElement)tableAndRow.component2();
        this.performAction(editor3, table, row);
    }

    public void update(@NotNull AnActionEvent event) {
        Integer offset;
        PsiFile file;
        Editor editor2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Project project = (Project)event.getData(CommonDataKeys.PROJECT);
                editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
                file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
                Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
                Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
                if (project == null || editor2 == null || file == null || offset == null) break block5;
                Language language = file.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                if (MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) break block6;
            }
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Pair<MarkdownTable, PsiElement> tableAndRow = this.findTableAndRow(event, file, document2, offset);
        event.getPresentation().setEnabledAndVisible(tableAndRow != null);
        if (tableAndRow != null) {
            MarkdownTable table = (MarkdownTable)tableAndRow.component1();
            PsiElement row = (PsiElement)tableAndRow.component2();
            this.update(event, table, row);
        } else {
            this.update(event, null, null);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected abstract void performAction(@NotNull Editor var1, @NotNull MarkdownTable var2, @NotNull PsiElement var3);

    protected void update(@NotNull AnActionEvent event, @Nullable MarkdownTable table, @Nullable PsiElement rowElement) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    private final Pair<MarkdownTable, PsiElement> findTableAndRow(AnActionEvent event, PsiFile file, Document document, int offset) {
        return this.considerSeparatorRow ? this.findTableAndRow(event, file, document, offset, (Function3<? super PsiFile, ? super Document, ? super Integer, ? extends PsiElement>)((Function3)new Function3<PsiFile, Document, Integer, PsiElement>((Object)this){

            public final PsiElement invoke(PsiFile p0, Document p1, int p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((RowBasedTableAction)((Object)this.receiver)).findRowOrSeparator(p0, p1, p2);
            }
        })) : this.findTableAndRow(event, file, document, offset, (Function3<? super PsiFile, ? super Document, ? super Integer, ? extends PsiElement>)((Function3)new Function3<PsiFile, Document, Integer, PsiElement>((Object)this){

            public final PsiElement invoke(PsiFile p0, Document p1, int p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((RowBasedTableAction)((Object)this.receiver)).findRow(p0, p1, p2);
            }
        }));
    }

    @Nullable
    protected PsiElement findRowOrSeparator(@NotNull PsiFile file, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return TableUtils.findRowOrSeparator(file, offset);
    }

    @Nullable
    protected PsiElement findRow(@NotNull PsiFile file, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return (PsiElement)TableUtils.findRow(file, offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pair<MarkdownTable, PsiElement> findTableAndRow(AnActionEvent event, PsiFile file, Document document, int offset, Function3<? super PsiFile, ? super Document, ? super Integer, ? extends PsiElement> rowGetter) {
        Object object;
        PsiElement row;
        PsiElement psiElement;
        MarkdownTable table;
        PsiElement elementFromEvent;
        WeakReference weakReference = (WeakReference)event.getData(TableActionKeys.INSTANCE.getELEMENT());
        Object object2 = elementFromEvent = weakReference != null ? (PsiElement)weakReference.get() : null;
        if (elementFromEvent != null && (table = this.obtainParentTable(elementFromEvent)) != null) {
            return TuplesKt.to((Object)table, (Object)elementFromEvent);
        }
        PsiElement psiElement2 = (PsiElement)rowGetter.invoke((Object)file, (Object)document, (Object)offset);
        if (psiElement2 == null) return null;
        PsiElement psiElement3 = psiElement = psiElement2;
        boolean bl = false;
        if (!psiElement3.isValid()) return null;
        PsiElement psiElement5 = psiElement;
        psiElement5 = row = psiElement5;
        Object object3 = psiElement5;
        if (psiElement5 == null) return null;
        PsiElement psiElement6 = object3;
        boolean bl2 = false;
        MarkdownTable markdownTable = this.obtainParentTable(psiElement6);
        object3 = markdownTable;
        if (markdownTable == null) return null;
        Object object4 = object = object3;
        boolean bl3 = false;
        if (!object4.isValid()) return null;
        Object object5 = object;
        Object table2 = object5;
        Object object6 = table2;
        if (object6 == null) return null;
        Pair pair = TuplesKt.to(object6, (Object)row);
        return pair;
    }

    private final MarkdownTable obtainParentTable(PsiElement element2) {
        PsiElement psiElement = element2;
        return psiElement instanceof MarkdownTableRow ? ((MarkdownTableRow)element2).getParentTable() : (psiElement instanceof MarkdownTableSeparatorRow ? ((MarkdownTableSeparatorRow)element2).getParentTable() : null);
    }

    public RowBasedTableAction() {
        this(false, 1, null);
    }
}

