/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public final class PyCythonExtensionWarning {
    private static final Logger LOG = Logger.getInstance(PyCythonExtensionWarning.class);
    private static final String CYTHON_WARNING_GROUP_ID = "CythonWarning";
    public static final String SETUP_CYTHON_PATH = "pydev/setup_cython.py";

    public static void showCythonExtensionWarning(@NotNull Project project) {
        if (project == null) {
            PyCythonExtensionWarning.$$$reportNull$$$0(0);
        }
        if (PyCythonExtensionWarning.shouldSuppressNotification(project)) {
            return;
        }
        Notification notification2 = new Notification(CYTHON_WARNING_GROUP_ID, PyBundle.message("compile.cython.extensions.notification", new Object[0]), PyBundle.message("debugger.cython.extension.speeds.up.python.debugging", new Object[0]), NotificationType.INFORMATION);
        notification2.setSuggestionType(true);
        notification2.addAction(PyCythonExtensionWarning.createInstallAction(notification2, project));
        notification2.addAction(PyCythonExtensionWarning.createDocsAction());
        notification2.notify(project);
    }

    private static AnAction createInstallAction(final @NotNull Notification notification2, final @NotNull Project project) {
        if (notification2 == null) {
            PyCythonExtensionWarning.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PyCythonExtensionWarning.$$$reportNull$$$0(2);
        }
        return new DumbAwareAction(PyBundle.message("compile.cython.extensions.install", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyCythonExtensionWarning.compileCythonExtension(project);
                notification2.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/PyCythonExtensionWarning$1", "actionPerformed"));
            }
        };
    }

    private static AnAction createDocsAction() {
        return new DumbAwareAction(PyBundle.message("compile.cython.extensions.help", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                HelpManager.getInstance().invokeHelp("Cython_Speedups");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/PyCythonExtensionWarning$2", "actionPerformed"));
            }
        };
    }

    private static boolean shouldSuppressNotification(@NotNull Project project) {
        if (project == null) {
            PyCythonExtensionWarning.$$$reportNull$$$0(3);
        }
        if (ProjectUtil.isNotificationSilentMode((Project)project)) {
            return true;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings selectedConfiguration = runManager.getSelectedConfiguration();
        if (selectedConfiguration == null) {
            return true;
        }
        RunConfiguration configuration = selectedConfiguration.getConfiguration();
        if (!(configuration instanceof AbstractPythonRunConfiguration)) {
            return true;
        }
        AbstractPythonRunConfiguration runConfiguration = (AbstractPythonRunConfiguration)configuration;
        return PythonSdkUtil.isRemote(runConfiguration.getSdk());
    }

    private static void showErrorDialog(Project project, @NlsContexts.DialogMessage String message) {
        Messages.showMessageDialog((Project)project, (String)message, (String)PyBundle.message("compile.cython.extensions.error", new Object[0]), null);
    }

    private static void compileCythonExtension(final @NotNull Project project) {
        if (project == null) {
            PyCythonExtensionWarning.$$$reportNull$$$0(4);
        }
        try {
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings selectedConfiguration = runManager.getSelectedConfiguration();
            if (selectedConfiguration == null) {
                throw new ExecutionException(PyBundle.message("debugger.cython.python.run.configuration.should.be.selected", new Object[0]));
            }
            RunConfiguration configuration = selectedConfiguration.getConfiguration();
            if (!(configuration instanceof AbstractPythonRunConfiguration)) {
                throw new ExecutionException(PyBundle.message("debugger.cython.python.run.configuration.should.be.selected", new Object[0]));
            }
            AbstractPythonRunConfiguration runConfiguration = (AbstractPythonRunConfiguration)configuration;
            String interpreterPath = runConfiguration.getInterpreterPath();
            String cythonPathString = PythonHelpersLocator.findPathStringInHelpers(SETUP_CYTHON_PATH);
            String cythonExtensionsDir = PyDebugRunner.CYTHON_EXTENSIONS_DIR;
            String[] cythonArgs = new String[]{"build_ext", "--build-lib", cythonExtensionsDir, "--build-temp", String.format("%s%sbuild", cythonExtensionsDir, File.separator)};
            ArrayList<String> cmdline = new ArrayList<String>();
            cmdline.add(interpreterPath);
            cmdline.add(cythonPathString);
            cmdline.addAll(Arrays.asList(cythonArgs));
            LOG.info("Compile Cython Extensions " + StringUtil.join(cmdline, (String)" "));
            HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
            PythonEnvUtil.addToPythonPath(environment, cythonExtensionsDir);
            PythonEnvUtil.setPythonUnbuffered(environment);
            PythonEnvUtil.setPythonDontWriteBytecode(environment);
            if (interpreterPath != null) {
                PythonEnvUtil.resetHomePathChanges(interpreterPath, environment);
            }
            final GeneralCommandLine commandLine = new GeneralCommandLine(cmdline).withEnvironment(environment);
            boolean canCreate = FileUtil.ensureCanCreateFile((File)new File(cythonExtensionsDir));
            boolean useSudo = !canCreate && !SystemInfo.isWindows;
            final Process process = useSudo ? ExecUtil.sudo((GeneralCommandLine)commandLine, (String)PyBundle.message("debugger.cython.please.enter.your.password.to.compile.cython.extensions", new Object[0])) : commandLine.createProcess();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, PyBundle.message("compile.cython.extensions.title", new Object[0])){

                public void run(final @NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    CapturingProcessHandler handler = new CapturingProcessHandler(process, commandLine.getCharset(), commandLine.getCommandLineString());
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (outputType == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.STDERR) {
                                for (String line : StringUtil.splitByLines((String)event.getText())) {
                                    if (!1.isSignificantOutput(line)) continue;
                                    indicator.setText2(line.trim());
                                }
                            }
                        }

                        private static boolean isSignificantOutput(String line) {
                            return line.trim().length() > 3;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "outputType";
                                    break;
                                }
                            }
                            objectArray[1] = "com/jetbrains/python/debugger/PyCythonExtensionWarning$3$1";
                            objectArray[2] = "onTextAvailable";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    ProcessOutput result2 = handler.runProcessWithProgressIndicator(indicator);
                    int exitCode = result2.getExitCode();
                    if (exitCode != 0) {
                        String message = StringUtil.isEmptyOrSpaces((String)result2.getStdout()) && StringUtil.isEmptyOrSpaces((String)result2.getStderr()) ? PyBundle.message("debugger.cython.extension.permission.denied", new Object[0]) : PyBundle.message("debugger.cython.extension.non.zero.exit.code", exitCode, result2.getStderr());
                        UIUtil.invokeLaterIfNeeded(() -> PyCythonExtensionWarning.showClearErrorMessage(message, project));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/debugger/PyCythonExtensionWarning$3", "run"));
                }
            });
        }
        catch (ExecutionException | IOException e) {
            PyCythonExtensionWarning.showClearErrorMessage(e.getMessage(), project);
        }
    }

    private static void showClearErrorMessage(@NlsContexts.DialogMessage String errMessage, Project project) {
        String suggestion = "";
        if (errMessage.contains(PyBundle.message("debugger.cython.extension.python.h", new Object[0]))) {
            suggestion = PyBundle.message("debugger.cython.extension.python.h.not.found", PyCythonExtensionWarning.getInstallPythonCommand(project));
        } else if (errMessage.contains(PyBundle.message("debugger.cython.extension.gcc", new Object[0]))) {
            suggestion = PyBundle.message("debugger.cython.extension.gcc.failed", new Object[0]);
        } else if (errMessage.contains(PyBundle.message("debugger.cython.extension.gcc.not.found", new Object[0]))) {
            suggestion = PyBundle.message("debugger.cython.extension.gcc.not.found.suggestion", new Object[0]);
        }
        PyCythonExtensionWarning.showErrorDialog(project, errMessage + suggestion);
    }

    private static String getInstallPythonCommand(Project project) {
        String versionString;
        Sdk pythonSdk;
        RunConfiguration runConfiguration;
        String version2 = "";
        int pythonStringLength = "Python ".length();
        RunnerAndConfigurationSettings selectedConfiguration = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (selectedConfiguration != null && (runConfiguration = selectedConfiguration.getConfiguration()) instanceof PythonRunConfiguration && (pythonSdk = ((PythonRunConfiguration)runConfiguration).getSdk()) != null && (versionString = pythonSdk.getVersionString()) != null && versionString.length() > pythonStringLength) {
            version2 = versionString.substring(pythonStringLength, versionString.lastIndexOf(46));
        }
        return PyBundle.message("debugger.cython.extension.install.python.command", version2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyCythonExtensionWarning";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showCythonExtensionWarning";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createInstallAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSuppressNotification";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compileCythonExtension";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

