/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.plugin.impl.run;

import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.python.community.plugin.impl.run.PyPluginSdkFragment;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.EnvFileComponent;
import com.jetbrains.python.run.PyCommonFragmentsBuilder;
import com.jetbrains.python.run.configuration.PyInterpreterModeNotifier;
import com.jetbrains.python.run.configuration.PyPathMappingsEditorFragment;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u0004\u001a\u00020\u0005\"\f\b\u0000\u0010\u0006*\u0006\u0012\u0002\b\u00030\u00072\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002H\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010\u000b\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/python/community/plugin/impl/run/PyPluginCommonFragmentsBuilder;", "Lcom/jetbrains/python/run/PyCommonFragmentsBuilder;", "<init>", "()V", "createEnvironmentFragments", "", "T", "Lcom/jetbrains/python/run/AbstractPythonRunConfiguration;", "fragments", "", "Lcom/intellij/execution/ui/SettingsEditorFragment;", "config", "(Ljava/util/List;Lcom/jetbrains/python/run/AbstractPythonRunConfiguration;)V", "intellij.python.community.plugin.impl"})
final class PyPluginCommonFragmentsBuilder
extends PyCommonFragmentsBuilder {
    @Override
    public <T extends AbstractPythonRunConfiguration<?>> void createEnvironmentFragments(@NotNull List<SettingsEditorFragment<T, ?>> fragments, @NotNull T config) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        SettingsEditorFragment sdkFragment = new PyPluginSdkFragment();
        fragments.add(sdkFragment);
        Project project = ((AbstractRunConfiguration)config).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        fragments.add(this.createWorkingDirectoryFragment(project));
        fragments.add(this.createEnvParameters());
        fragments.add(EnvFileComponent.Companion.createEnvFilesFragment((Function0<? extends VirtualFile>)((Function0)() -> PyPluginCommonFragmentsBuilder.createEnvironmentFragments$lambda$0(config))));
        fragments.add(new PyPathMappingsEditorFragment((PyInterpreterModeNotifier)sdkFragment));
    }

    private static final VirtualFile createEnvironmentFragments$lambda$0(AbstractPythonRunConfiguration $config) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        String string = $config.getWorkingDirectorySafe();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWorkingDirectorySafe(...)");
        Path path2 = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return virtualFileManager.findFileByNioPath(path2);
    }
}

