/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

public final class DefaultVersionFilterContext
implements VersionFilter.VersionFilterContext {
    private final RepositorySystemSession session;
    private Dependency dependency;
    VersionRangeResult result;
    private List<Version> versions;

    public DefaultVersionFilterContext(RepositorySystemSession session) {
        this.session = session;
    }

    public void set(Dependency dependency, VersionRangeResult result2) {
        this.dependency = dependency;
        this.result = result2;
        this.versions = new ArrayList<Version>(result2.getVersions());
    }

    public List<Version> get() {
        return new ArrayList<Version>(this.versions);
    }

    @Override
    public RepositorySystemSession getSession() {
        return this.session;
    }

    @Override
    public Dependency getDependency() {
        return this.dependency;
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.result.getVersionConstraint();
    }

    @Override
    public int getCount() {
        return this.versions.size();
    }

    @Override
    public ArtifactRepository getRepository(Version version) {
        return this.result.getRepository(version);
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return Collections.unmodifiableList(this.result.getRequest().getRepositories());
    }

    @Override
    public Iterator<Version> iterator() {
        return this.versions.iterator();
    }

    public String toString() {
        return this.dependency + " " + this.result.getVersions();
    }
}

