/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.dml.ColumnRefs;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectUsingKeys;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/couchbase/generator/dml/CouchbaseSelectUsingKeysGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/script/generator/dml/SelectGenerationResult;", "Lcom/intellij/database/script/generator/dml/SelectUsingKeys;", "task", "dbms", "Lcom/intellij/database/Dbms;", "helper", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "<init>", "(Lcom/intellij/database/script/generator/dml/SelectUsingKeys;Lcom/intellij/database/Dbms;Lcom/intellij/database/dialects/base/BaseDmlHelper;)V", "generate", "intellij.database.dialects.couchbase"})
public final class CouchbaseSelectUsingKeysGenerator
extends DmlGenerator<SelectGenerationResult, SelectUsingKeys> {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final BaseDmlHelper helper;

    public CouchbaseSelectUsingKeysGenerator(@NotNull SelectUsingKeys task, @NotNull Dbms dbms, @NotNull BaseDmlHelper helper) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        super((DmlTask)task);
        this.dbms = dbms;
        this.helper = helper;
    }

    @Override
    @NotNull
    public SelectGenerationResult generate() {
        DdlBuilder builder = ((SelectUsingKeys)this.getTask()).getOutput();
        DasObject dasObject = ((SelectUsingKeys)this.getTask()).getTable();
        if (dasObject == null) {
            throw new IllegalArgumentException("table is not set");
        }
        DasObject table = dasObject;
        builder.keyword("SELECT").space();
        String string = ((SelectUsingKeys)this.getTask()).getAlias();
        if (string == null) {
            string = "t";
        }
        String alias = string;
        this.helper.generate(DmlTaskKt.queryColumns(new ColumnRefs(CollectionsKt.emptyList())).table(table).alias(alias).version(((SelectUsingKeys)this.getTask()).getVersion()).appendRowId(((SelectUsingKeys)this.getTask()).getAppendRowId()).build(builder));
        DmlUtilKt.space(builder, ((SelectUsingKeys)this.getTask()).getInsertNewLines());
        this.helper.appendFromTable(builder, table, alias, null);
        DmlUtilKt.space(builder, ((SelectUsingKeys)this.getTask()).getInsertNewLines());
        builder.keyword("USE").space().keyword("KEYS").space().symbol("[");
        GridColumn col = (GridColumn)((SelectUsingKeys)this.getTask()).getModel().getColumn(ModelIndex.forColumn((GridModel)((GridModel)((SelectUsingKeys)this.getTask()).getModel()), (int)0));
        if (col != null) {
            boolean isFirst = true;
            for (GridRow row : ((SelectUsingKeys)this.getTask()).getModel().getRows()) {
                String literal;
                String key2;
                Object object = col.getValue(row);
                if ((object instanceof String ? (String)object : null) == null) continue;
                key2 = key2;
                Intrinsics.checkNotNullExpressionValue((Object)DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate(key2, this.dbms), (String)"decorate(...)");
                if (isFirst) {
                    isFirst = false;
                    v2 = Unit.INSTANCE;
                } else {
                    DdlBuilder ddlBuilder = builder.symbol(",").space();
                    v2 = ddlBuilder;
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
                }
                builder.literal(literal);
            }
        }
        builder.symbol("]");
        return new SelectGenerationResult(builder, null, null, 6, null);
    }
}

