/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.util.text.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaLogRecordFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final long logCreation;
    private final boolean withDateTime;

    public IdeaLogRecordFormatter() {
        this(true);
    }

    public IdeaLogRecordFormatter(boolean withDateTime) {
        this(withDateTime, null);
    }

    public IdeaLogRecordFormatter(boolean withDateTime, @Nullable IdeaLogRecordFormatter copyFrom) {
        this.withDateTime = withDateTime;
        this.logCreation = copyFrom == null ? System.currentTimeMillis() : copyFrom.getStartedMillis();
    }

    protected long getStartedMillis() {
        return this.logCreation;
    }

    @Override
    public String format(LogRecord record) {
        long recordMillis = record.getMillis();
        long startedMillis = this.getStartedMillis();
        StringBuilder sb = new StringBuilder();
        if (this.withDateTime) {
            LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(recordMillis), ZoneId.systemDefault());
            sb.append(date.getYear());
            sb.append('-');
            IdeaLogRecordFormatter.appendWithPadding(sb, Integer.toString(date.getMonthValue()), 2, '0');
            sb.append('-');
            IdeaLogRecordFormatter.appendWithPadding(sb, Integer.toString(date.getDayOfMonth()), 2, '0');
            sb.append(' ');
            IdeaLogRecordFormatter.appendWithPadding(sb, Integer.toString(date.getHour()), 2, '0');
            sb.append(':');
            IdeaLogRecordFormatter.appendWithPadding(sb, Integer.toString(date.getMinute()), 2, '0');
            sb.append(':');
            IdeaLogRecordFormatter.appendWithPadding(sb, Integer.toString(date.getSecond()), 2, '0');
            sb.append(',');
            IdeaLogRecordFormatter.appendWithPadding(sb, Long.toString(recordMillis % 1000L), 3, '0');
            sb.append(' ');
        }
        sb.append('[');
        IdeaLogRecordFormatter.appendWithPadding(sb, startedMillis == 0L ? "-------" : String.valueOf(recordMillis - startedMillis), 7, ' ');
        sb.append("] ");
        IdeaLogRecordFormatter.appendWithPadding(sb, LogLevel.getPrettyLevelName(record.getLevel()), 6, ' ');
        sb.append(" - ").append(IdeaLogRecordFormatter.smartAbbreviate(record.getLoggerName())).append(" - ").append(this.formatMessage(record)).append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            IdeaLogRecordFormatter.appendThrowable(record.getThrown(), sb);
        }
        return sb.toString();
    }

    private static void appendWithPadding(StringBuilder sb, String s, int width, char padChar) {
        int padding = width - s.length();
        for (int i = 0; i < padding; ++i) {
            sb.append(padChar);
        }
        sb.append(s);
    }

    @ApiStatus.Internal
    public static String smartAbbreviate(String category) {
        int nextDot;
        if (category == null) {
            return null;
        }
        StringBuilder result2 = new StringBuilder();
        int pos = 0;
        if (category.startsWith("#")) {
            result2.append('#');
            ++pos;
        }
        if (!(category.startsWith("com.intellij", pos) || category.startsWith("com.jetbrains", pos) || category.startsWith("org.jetbrains", pos))) {
            return category;
        }
        while ((nextDot = category.indexOf(46, pos)) >= 0) {
            result2.append(category.charAt(pos)).append('.');
            pos = nextDot + 1;
        }
        result2.append(category.substring(pos));
        return result2.toString();
    }

    @NotNull
    public static String formatThrowable(@NotNull Throwable thrown) {
        if (thrown == null) {
            IdeaLogRecordFormatter.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        IdeaLogRecordFormatter.appendThrowable(thrown, sb);
        String string = sb.toString();
        if (string == null) {
            IdeaLogRecordFormatter.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void appendThrowable(Throwable thrown, StringBuilder sb) {
        StringWriter stringWriter = new StringWriter();
        thrown.printStackTrace(new PrintWriter(stringWriter));
        String[] lines = StringUtil.splitByLines(stringWriter.toString());
        int maxStackSize = 1024;
        int maxExtraSize = 256;
        if (lines.length > maxStackSize + maxExtraSize) {
            String[] res = new String[maxStackSize + maxExtraSize + 1];
            System.arraycopy(lines, 0, res, 0, maxStackSize);
            res[maxStackSize] = "\t...";
            System.arraycopy(lines, lines.length - maxExtraSize, res, maxStackSize + 1, maxExtraSize);
            for (int i = 0; i < res.length; ++i) {
                if (i > 0) {
                    sb.append(LINE_SEPARATOR);
                }
                sb.append(res[i]);
            }
        } else {
            sb.append(stringWriter.getBuffer());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrown";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/IdeaLogRecordFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/IdeaLogRecordFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatThrowable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatThrowable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

