/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.google.gson.JsonObject;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.javascript.formatter.JSCodeStyleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.prettierjs.codeStyle.PrettierCodeStyleInstaller;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrettierConfig {
    private static final String BRACKET_SPACING = "bracketSpacing";
    private static final String PRINT_WIDTH = "printWidth";
    private static final String SEMI = "semi";
    private static final String SINGLE_QUOTE = "singleQuote";
    private static final String TAB_WIDTH = "tabWidth";
    private static final String TRAILING_COMMA = "trailingComma";
    private static final String USE_TABS = "useTabs";
    private static final String END_OF_LINE = "endOfLine";
    private static final String JSX_BRACKET_SAME_LINE = "jsxBracketSameLine";
    private static final String VUE_INDENT_SCRIPT_AND_STYLE = "vueIndentScriptAndStyle";
    public static final PrettierConfig DEFAULT = new PrettierConfig(false, true, 80, true, false, 2, TrailingCommaOption.none, false, null, false);
    public final boolean jsxBracketSameLine;
    public final boolean bracketSpacing;
    public final int printWidth;
    public final boolean semi;
    public final boolean singleQuote;
    public final int tabWidth;
    public final TrailingCommaOption trailingComma;
    public final boolean useTabs;
    @Nullable
    public final LineSeparator lineSeparator;
    public final boolean vueIndentScriptAndStyle;

    public static PrettierConfig createFromMap(@Nullable Map<String, Object> map) {
        return DEFAULT.mergeWith(map);
    }

    public static PrettierConfig createFromJson(@Nullable JsonObject object) {
        return DEFAULT.mergeWith(object);
    }

    public PrettierConfig(boolean jsxBracketSameLine, boolean bracketSpacing, int printWidth, boolean semi, boolean singleQuote, int tabWidth, @NotNull TrailingCommaOption trailingComma, boolean useTabs, @Nullable LineSeparator lineSeparator, boolean vueIndentScriptAndStyle) {
        if (trailingComma == null) {
            PrettierConfig.$$$reportNull$$$0(0);
        }
        this.jsxBracketSameLine = jsxBracketSameLine;
        this.bracketSpacing = bracketSpacing;
        this.printWidth = printWidth;
        this.semi = semi;
        this.singleQuote = singleQuote;
        this.tabWidth = tabWidth;
        this.trailingComma = trailingComma;
        this.useTabs = useTabs;
        this.lineSeparator = lineSeparator;
        this.vueIndentScriptAndStyle = vueIndentScriptAndStyle;
    }

    public void install(@NotNull Project project) {
        if (project == null) {
            PrettierConfig.$$$reportNull$$$0(1);
        }
        JSCodeStyleUtil.updateProjectCodeStyle((Project)project, newSettings -> {
            newSettings.LINE_SEPARATOR = this.lineSeparator != null ? this.lineSeparator.getSeparatorString() : null;
            PrettierCodeStyleInstaller.EP_NAME.getExtensionList().forEach(installer -> installer.install(project, this, (CodeStyleSettings)newSettings));
        });
    }

    public boolean isInstalled(@NotNull Project project) {
        String lineSeparator;
        if (project == null) {
            PrettierConfig.$$$reportNull$$$0(2);
        }
        CodeStyleSettings settings = CodeStyle.getSettings((Project)project);
        String string = lineSeparator = this.lineSeparator != null ? this.lineSeparator.getSeparatorString() : null;
        if (!StringUtil.equals((CharSequence)settings.LINE_SEPARATOR, (CharSequence)lineSeparator)) {
            return false;
        }
        return ContainerUtil.and((Iterable)PrettierCodeStyleInstaller.EP_NAME.getExtensionList(), installer -> installer.isInstalled(project, this, settings));
    }

    public PrettierConfig mergeWith(@Nullable Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        return new PrettierConfig((Boolean)ObjectUtils.coalesce((Object)PrettierConfig.getBooleanValue(map, JSX_BRACKET_SAME_LINE), (Object)this.jsxBracketSameLine), (Boolean)ObjectUtils.coalesce((Object)PrettierConfig.getBooleanValue(map, BRACKET_SPACING), (Object)this.bracketSpacing), (Integer)ObjectUtils.coalesce((Object)PrettierConfig.getIntValue(map, PRINT_WIDTH), (Object)this.printWidth), (Boolean)ObjectUtils.coalesce((Object)PrettierConfig.getBooleanValue(map, SEMI), (Object)this.semi), (Boolean)ObjectUtils.coalesce((Object)PrettierConfig.getBooleanValue(map, SINGLE_QUOTE), (Object)this.singleQuote), (Integer)ObjectUtils.coalesce((Object)PrettierConfig.getIntValue(map, TAB_WIDTH), (Object)this.tabWidth), (TrailingCommaOption)((Object)ObjectUtils.coalesce((Object)((Object)PrettierConfig.parseTrailingCommaValue((String)ObjectUtils.tryCast((Object)map.get(TRAILING_COMMA), String.class))), (Object)((Object)this.trailingComma))), (Boolean)ObjectUtils.coalesce((Object)PrettierConfig.getBooleanValue(map, USE_TABS), (Object)this.useTabs), (LineSeparator)ObjectUtils.coalesce((Object)PrettierConfig.parseLineSeparator((String)ObjectUtils.tryCast((Object)map.get(END_OF_LINE), String.class)), (Object)this.lineSeparator), (Boolean)ObjectUtils.coalesce((Object)PrettierConfig.getBooleanValue(map, VUE_INDENT_SCRIPT_AND_STYLE), (Object)this.vueIndentScriptAndStyle));
    }

    public PrettierConfig mergeWith(@Nullable JsonObject object) {
        if (object == null || object.isEmpty()) {
            return this;
        }
        return new PrettierConfig(JsonUtil.getChildAsBoolean((JsonObject)object, (String)JSX_BRACKET_SAME_LINE, (boolean)this.jsxBracketSameLine), JsonUtil.getChildAsBoolean((JsonObject)object, (String)BRACKET_SPACING, (boolean)this.bracketSpacing), JsonUtil.getChildAsInteger((JsonObject)object, (String)PRINT_WIDTH, (int)this.printWidth), JsonUtil.getChildAsBoolean((JsonObject)object, (String)SEMI, (boolean)this.semi), JsonUtil.getChildAsBoolean((JsonObject)object, (String)SINGLE_QUOTE, (boolean)this.singleQuote), JsonUtil.getChildAsInteger((JsonObject)object, (String)TAB_WIDTH, (int)this.tabWidth), (TrailingCommaOption)((Object)ObjectUtils.coalesce((Object)((Object)PrettierConfig.parseTrailingCommaValue(JsonUtil.getChildAsString((JsonObject)object, (String)TRAILING_COMMA))), (Object)((Object)this.trailingComma))), JsonUtil.getChildAsBoolean((JsonObject)object, (String)USE_TABS, (boolean)this.useTabs), (LineSeparator)ObjectUtils.coalesce((Object)PrettierConfig.parseLineSeparator(JsonUtil.getChildAsString((JsonObject)object, (String)END_OF_LINE)), (Object)this.lineSeparator), JsonUtil.getChildAsBoolean((JsonObject)object, (String)VUE_INDENT_SCRIPT_AND_STYLE, (boolean)this.vueIndentScriptAndStyle));
    }

    public String toString() {
        return "Config{jsxBracketSameLine=" + this.jsxBracketSameLine + ", bracketSpacing=" + this.bracketSpacing + ", printWidth=" + this.printWidth + ", semi=" + this.semi + ", singleQuote=" + this.singleQuote + ", tabWidth=" + this.tabWidth + ", trailingComma=" + String.valueOf((Object)this.trailingComma) + ", useTabs=" + this.useTabs + ", lineSeparator=" + (this.lineSeparator != null ? this.lineSeparator.getSeparatorString() : null) + ", vueIndentScriptAndStyle=" + this.vueIndentScriptAndStyle + "}";
    }

    @Nullable
    private static LineSeparator parseLineSeparator(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return (LineSeparator)StringUtil.parseEnum((String)StringUtil.toUpperCase((String)string), null, LineSeparator.class);
    }

    private static Boolean getBooleanValue(@NotNull Map<String, Object> map, String key) {
        Boolean value;
        if (map == null) {
            PrettierConfig.$$$reportNull$$$0(3);
        }
        return (value = (Boolean)ObjectUtils.tryCast((Object)map.get(key), Boolean.class)) == null ? null : Boolean.valueOf(value);
    }

    private static Integer getIntValue(@NotNull Map<String, Object> map, String key) {
        Number value;
        if (map == null) {
            PrettierConfig.$$$reportNull$$$0(4);
        }
        return (value = (Number)ObjectUtils.tryCast((Object)map.get(key), Number.class)) == null ? null : Integer.valueOf(value.intValue());
    }

    @Nullable
    private static TrailingCommaOption parseTrailingCommaValue(@Nullable String string) {
        return string == null ? null : (TrailingCommaOption)StringUtil.parseEnum((String)string, null, TrailingCommaOption.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = TRAILING_COMMA;
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        objectArray2[1] = "com/intellij/prettierjs/PrettierConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInstalled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBooleanValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getIntValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum TrailingCommaOption {
        none,
        all,
        es5;

    }
}

