/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/docker/agent/util/Version;", "", "major", "", "minor", "bugfix", "<init>", "(III)V", "getMajor", "()I", "getMinor", "getBugfix", "compareTo", "version", "toString", "", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "Companion", "intellij.clouds.docker.agent"})
public final class Version {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int bugfix;

    public Version(int major, int minor, int bugfix) {
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getBugfix() {
        return this.bugfix;
    }

    public final int compareTo(@NotNull Version version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return this.compareTo(version2.major, version2.minor, version2.bugfix);
    }

    @NotNull
    public String toString() {
        return this.major + "." + this.minor + "." + this.bugfix;
    }

    public final int compareTo(int major, int minor, int bugfix) {
        int result2 = this.major - major;
        if (result2 != 0) {
            return result2;
        }
        result2 = this.minor - minor;
        return result2 != 0 ? result2 : this.bugfix - bugfix;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.bugfix;
    }

    @NotNull
    public final Version copy(int major, int minor, int bugfix) {
        return new Version(major, minor, bugfix);
    }

    public static /* synthetic */ Version copy$default(Version version2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = version2.major;
        }
        if ((n4 & 2) != 0) {
            n2 = version2.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = version2.bugfix;
        }
        return version2.copy(n, n2, n3);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.major);
        result2 = result2 * 31 + Integer.hashCode(this.minor);
        result2 = result2 * 31 + Integer.hashCode(this.bugfix);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version version2 = (Version)other;
        if (this.major != version2.major) {
            return false;
        }
        if (this.minor != version2.minor) {
            return false;
        }
        return this.bugfix == version2.bugfix;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/agent/util/Version$Companion;", "", "<init>", "()V", "from", "Lcom/intellij/docker/agent/util/Version;", "versionString", "", "parseNumber", "", "num", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Version.kt\ncom/intellij/docker/agent/util/Version$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,49:1\n739#2,9:50\n37#3:59\n36#3,3:60\n*S KotlinDebug\n*F\n+ 1 Version.kt\ncom/intellij/docker/agent/util/Version$Companion\n*L\n7#1:50,9\n7#1:59\n7#1:60,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Version from(@NotNull String versionString) {
            int minor;
            List list2;
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            CharSequence charSequence = versionString;
            Regex regex = new Regex("\\.");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] versionChunks = thisCollection$iv.toArray(new String[0]);
            if (versionChunks.length == 0) {
                return null;
            }
            int major = this.parseNumber(versionChunks[0]);
            if (major < 0) {
                return null;
            }
            int n2 = minor = versionChunks.length > 1 ? this.parseNumber(versionChunks[1]) : 0;
            if (minor < 0) {
                return new Version(major, 0, 0);
            }
            int patch = versionChunks.length > 2 ? this.parseNumber(versionChunks[2]) : 0;
            return patch < 0 ? new Version(major, minor, 0) : new Version(major, minor, patch);
        }

        private final int parseNumber(String num) {
            CharSequence charSequence = num;
            Regex regex = new Regex("(\\d+).*");
            String string = "$1";
            Integer n = StringsKt.toIntOrNull((String)regex.replaceFirst(charSequence, string));
            return n != null ? n : -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

