/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.packageJson.UpdateDependenciesActionListener;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.JsqtProcessOutputViewer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterCodeStyleImporter<TConfig> {
    protected static final Logger LOG = Logger.getInstance(JSLinterCodeStyleImporter.class);
    private final boolean myShowUiOnMissingTool;
    private final boolean myIsForInitialImport;

    public JSLinterCodeStyleImporter(boolean isForInitialImport) {
        this.myIsForInitialImport = isForInitialImport;
        this.myShowUiOnMissingTool = !isForInitialImport && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public void importConfigFileWhenToolInstalled(final @NotNull PsiFile configPsi) {
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean imported = this.importConfigFile(configPsi);
        if (imported) {
            return;
        }
        LOG.info(String.format("Postponing code style import from %s because required tool not installed", this.getToolName()));
        final PackageJsonDependenciesExternalUpdateManager updateManager = PackageJsonDependenciesExternalUpdateManager.getInstance(configPsi.getProject());
        UpdateDependenciesActionListener listener2 = new UpdateDependenciesActionListener(){

            @Override
            public void updateActionFinished(@Nullable VirtualFile packageJson) {
                updateManager.removeUpdateActionListener(this);
                LOG.info(String.format("Performing postponed code style import from %s", JSLinterCodeStyleImporter.this.getToolName()));
                ReadAction.run(() -> {
                    if (configPsi.isValid()) {
                        JSLinterCodeStyleImporter.this.importConfigFile(configPsi);
                    }
                });
            }
        };
        updateManager.addUpdateActionListener(listener2);
    }

    public boolean importConfigFile(@NotNull PsiFile configPsi) {
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TConfig parsedConfig = this.parseConfigFromFile(configPsi);
        if (this.isDirectlyImportable(configPsi, parsedConfig)) {
            this.performImport(configPsi, parsedConfig);
            return true;
        }
        return this.importWithStoredState(configPsi, true);
    }

    private boolean importWithStoredState(@NotNull PsiFile configPsi, boolean showConfigurable) {
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(2);
        }
        Project project = configPsi.getProject();
        VirtualFile configVFile = configPsi.getVirtualFile();
        JSNpmLinterState state = this.getStoredState(project);
        NodePackageRef storedPackage = state.getNodePackageRef();
        NodePackage nodePackage = AutodetectLinterPackage.resolve(storedPackage, project, configVFile, this.getNpmPackageName(), null);
        if (nodePackage != null) {
            return this.importWithResolvedPackage(configPsi, state, nodePackage, showConfigurable);
        }
        String message = JavaScriptBundle.message("javascript.linter.import.error.package.not.found", this.getNpmPackageName());
        if (this.myShowUiOnMissingTool) {
            if (showConfigurable) {
                if (!ShowSettingsUtil.getInstance().editConfigurable(project, this.createSettingsConfigurable(project))) {
                    return false;
                }
                nodePackage = AutodetectLinterPackage.resolve(storedPackage, project, configVFile, this.getNpmPackageName(), null);
                if (nodePackage != null) {
                    return this.importWithResolvedPackage(configPsi, state, nodePackage, false);
                }
            }
            this.logErrorInUi(project, message);
        } else {
            this.detailedLog(message);
        }
        return false;
    }

    private boolean importWithResolvedPackage(final @NotNull PsiFile configPsi, @NotNull JSNpmLinterState state, final @NotNull NodePackage nodePackage, boolean showConfigurable) {
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(3);
        }
        if (state == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(4);
        }
        if (nodePackage == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(5);
        }
        final Project project = configPsi.getProject();
        VirtualFile configVFile = configPsi.getVirtualFile();
        final NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(project).getInterpreter();
        JSLinterFileLevelAnnotation validation = this.validateInterpreterAndPackage(project, interpreter2, nodePackage, configVFile);
        if (validation != null) {
            if (this.myShowUiOnMissingTool) {
                List specificFixes = ContainerUtil.notNullize(validation.getFixes().getOtherFixes());
                if (!specificFixes.isEmpty()) {
                    this.logErrorInUi(project, validation.getMessage(), null, specificFixes);
                    return false;
                }
                if (showConfigurable) {
                    if (!ShowSettingsUtil.getInstance().editConfigurable(project, this.createSettingsConfigurable(project))) {
                        return false;
                    }
                    return this.importWithStoredState(configPsi, false);
                }
                this.logErrorInUi(project, validation.getMessage());
            } else {
                this.detailedLog("Validation: " + validation.getMessage());
            }
            return false;
        }
        if (nodePackage.getClass() == NodePackage.class) {
            Path binFile = nodePackage.findBinFilePath(nodePackage.getName());
            if (binFile == null) {
                this.logErrorInUiIfEnabled(project, JavaScriptBundle.message("javascript.linter.import.error.entry.point.not.found", nodePackage.getName()));
                return false;
            }
            if (!Files.isRegularFile(binFile, new LinkOption[0])) {
                this.logErrorInUiIfEnabled(project, JavaScriptBundle.message("javascript.linter.import.error.bin.file.not.found", binFile.toString(), nodePackage.getName()));
                return false;
            }
        }
        JSLinterCodeStyleImporter.ensureSaved(configPsi);
        assert (interpreter2 != null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaScriptBundle.message("javascript.linter.import.translate.config.progress.title", this.getToolName())){
            private TConfig myEffectiveConfig;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    this.myEffectiveConfig = JSLinterCodeStyleImporter.this.computeEffectiveConfig(configPsi, interpreter2, nodePackage);
                }
                catch (InvalidExitCodeException e) {
                    JSLinterCodeStyleImporter.this.logErrorInUi(project, e.getMessage(), e.processOutput, ContainerUtil.emptyList());
                }
                catch (ExecutionException e) {
                    JSLinterCodeStyleImporter.this.logErrorInUi(project, e.getMessage());
                }
            }

            public void onSuccess() {
                if (this.myEffectiveConfig != null) {
                    JSLinterCodeStyleImporter.this.performImport(configPsi, this.myEffectiveConfig);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter$2", "run"));
            }
        });
        return true;
    }

    @NotNull
    protected abstract Configurable createSettingsConfigurable(@NotNull Project var1);

    @NotNull
    protected abstract JSNpmLinterState getStoredState(Project var1);

    @NotNull
    protected abstract String getNpmPackageName();

    @NotNull
    @NlsContexts.NotificationContent
    protected abstract String getToolName();

    protected abstract boolean isDirectlyImportable(@NotNull PsiFile var1, @Nullable TConfig var2);

    @Nullable
    protected abstract TConfig parseConfigFromFile(@NotNull PsiFile var1);

    @Nullable
    protected abstract TConfig computeEffectiveConfig(@NotNull PsiFile var1, @NotNull NodeJsInterpreter var2, @NotNull NodePackage var3) throws ExecutionException;

    @NotNull
    protected abstract ImportResult importConfig(@NotNull PsiFile var1, @NotNull TConfig var2);

    private void performImport(@NotNull PsiFile configPsi, @Nullable TConfig config) {
        Project project;
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(6);
        }
        if ((project = configPsi.getProject()).isDisposed()) {
            return;
        }
        if (config == null) {
            String message = JavaScriptBundle.message("javascript.linter.import.translate.config.file.error", new Object[0]);
            this.logErrorInUi(project, message);
            this.detailedLog(message);
            this.detailedLog(configPsi.getText());
            return;
        }
        ImportResult result2 = this.importConfig(configPsi, config);
        if (result2.isAlreadyImported) {
            if (!this.myIsForInitialImport) {
                JSLinterUtil.reportCodeStyleSettingsAlreadyImported(project, this.getToolName());
            }
        } else {
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
            JSLinterUtil.reportCodeStyleSettingsImported(project, this.getToolName(), configPsi.getVirtualFile(), result2.importedRules, null);
        }
    }

    @Nullable
    protected static Path getBinJsFile(@NotNull NodePackage nodePackage) {
        if (nodePackage == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(7);
        }
        return nodePackage.findBinFilePath(nodePackage.getName(), null);
    }

    @NotNull
    protected String runCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull PsiFile configPsi, @NotNull NodeJsInterpreter interpreter2) throws ExecutionException {
        if (commandLine == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(8);
        }
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(9);
        }
        if (interpreter2 == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(10);
        }
        commandLine.withCharset(StandardCharsets.UTF_8);
        commandLine.withWorkDirectory((File)ReadAction.compute(() -> VfsUtilCore.virtualToIoFile((VirtualFile)configPsi.getContainingDirectory().getVirtualFile())));
        NodeCommandLineConfigurator.find(interpreter2).configure(commandLine, NodeCommandLineConfigurator.defaultOptions(configPsi.getProject()));
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        ProcessOutput processOutput = processHandler.runProcess((int)TimeUnit.SECONDS.toMillis(30L));
        if (processOutput.isTimeout()) {
            throw new ExecutionException(JavaScriptBundle.message("javascript.linter.import.error.timeout.processing.configuration.file", new Object[0]));
        }
        if (processOutput.getExitCode() != 0) {
            throw new InvalidExitCodeException(JavaScriptBundle.message("javascript.linter.import.error.generic", new Object[0]), processOutput);
        }
        String string = processOutput.getStdout();
        if (string == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    protected String runToolWithArguments(@NotNull PsiFile configPsi, @NotNull NodeJsInterpreter interpreter2, @NotNull List<String> parameters2) throws ExecutionException {
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(12);
        }
        if (interpreter2 == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(13);
        }
        if (parameters2 == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(14);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParameters(parameters2);
        String string = this.runCommandLine(commandLine, configPsi, interpreter2);
        if (string == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(15);
        }
        return string;
    }

    private JSLinterFileLevelAnnotation validateInterpreterAndPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable NodePackage nodePackage, @Nullable VirtualFile contextFile) {
        if (project == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(16);
        }
        return JSLinterUtil.validateInterpreterAndPackage(project, interpreter2, nodePackage, this.getNpmPackageName(), contextFile);
    }

    private static void ensureSaved(@NotNull PsiFile configPsi) {
        Document document;
        FileDocumentManager manager;
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(17);
        }
        if ((manager = FileDocumentManager.getInstance()).isFileModified(configPsi.getVirtualFile()) && (document = manager.getDocument(configPsi.getVirtualFile())) != null) {
            manager.saveDocument(document);
        }
    }

    private void logErrorInUiIfEnabled(Project project, @NotNull @InspectionMessage String message) {
        if (message == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(18);
        }
        if (this.myShowUiOnMissingTool) {
            this.logErrorInUi(project, message);
        }
        this.detailedLog(message);
    }

    private void logErrorInUi(@NotNull Project project, @NotNull @InspectionMessage String error) {
        if (project == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(19);
        }
        if (error == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(20);
        }
        this.logErrorInUi(project, error, null, ContainerUtil.emptyList());
    }

    protected void logErrorInUi(final @NotNull Project project, @NotNull @Nls String error, final @Nullable ProcessOutput output, @NotNull List<IntentionAction> fixes) {
        if (project == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(21);
        }
        if (error == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(22);
        }
        if (fixes == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(23);
        }
        Notification notification = JSLinterUtil.NOTIFICATION_GROUP.createNotification(this.getToolName() + ": " + error, NotificationType.ERROR);
        for (final IntentionAction fix : fixes) {
            notification.addAction((AnAction)new NotificationAction(fix.getText()){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    fix.invoke(project, null, null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter$3";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (output != null) {
            notification.addAction((AnAction)new NotificationAction(JavaScriptBundle.message("notification.content.show.details", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    JsqtProcessOutputViewer.show(project, JSLinterCodeStyleImporter.this.getToolName(), null, null, null, output);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter$4";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        notification.notify(project);
    }

    private void detailedLog(String message) {
        if (this.myIsForInitialImport) {
            LOG.info(this.getToolName() + ":" + message);
        } else {
            LOG.debug(this.getToolName() + ":" + message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPsi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommandLine";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "runToolWithArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importConfigFileWhenToolInstalled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "importConfigFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "importWithStoredState";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importWithResolvedPackage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performImport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBinJsFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runCommandLine";
                break;
            }
            case 11: 
            case 15: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runToolWithArguments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "validateInterpreterAndPackage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "ensureSaved";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "logErrorInUiIfEnabled";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "logErrorInUi";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 15 -> new IllegalStateException(string);
        };
    }

    protected static final class ImportResult {
        @NotNull
        public final Collection<String> importedRules;
        public final boolean isAlreadyImported;
        private static final ImportResult ALREADY_IMPORTED = new ImportResult(ContainerUtil.emptyList(), true);

        private ImportResult(@NotNull Collection<String> rules, boolean alreadyImported) {
            if (rules == null) {
                ImportResult.$$$reportNull$$$0(0);
            }
            this.importedRules = rules;
            this.isAlreadyImported = alreadyImported;
        }

        @NotNull
        public static ImportResult success(@NotNull Collection<String> importedRules) {
            if (importedRules == null) {
                ImportResult.$$$reportNull$$$0(1);
            }
            return new ImportResult(importedRules, false);
        }

        @NotNull
        public static ImportResult alreadyImported() {
            ImportResult importResult = ALREADY_IMPORTED;
            if (importResult == null) {
                ImportResult.$$$reportNull$$$0(2);
            }
            return importResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rules";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedRules";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter$ImportResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter$ImportResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "alreadyImported";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "success";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class InvalidExitCodeException
    extends ExecutionException {
        public final ProcessOutput processOutput;

        private InvalidExitCodeException(@NlsContexts.DialogMessage String s, ProcessOutput processOutput) {
            super(s);
            this.processOutput = processOutput;
        }
    }
}

