/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
final class JSLanguageLevelApplicableRootsCache {
    private final Project myProject;
    @Nullable
    private volatile Set<VirtualFile> applicableDirs;

    static JSLanguageLevelApplicableRootsCache getInstance(@NotNull Project project) {
        if (project == null) {
            JSLanguageLevelApplicableRootsCache.$$$reportNull$$$0(0);
        }
        return (JSLanguageLevelApplicableRootsCache)project.getService(JSLanguageLevelApplicableRootsCache.class);
    }

    JSLanguageLevelApplicableRootsCache(@NotNull Project project) {
        if (project == null) {
            JSLanguageLevelApplicableRootsCache.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!event.isCausedByWorkspaceModelChangesOnly()) {
                    JSLanguageLevelApplicableRootsCache.this.resetCachedDirs();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/dialects/JSLanguageLevelApplicableRootsCache$1", "rootsChanged"));
            }
        });
        connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(@NotNull VersionedStorageChange event) {
                List changes;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(changes = event.getChanges(LibraryEntity.class)).isEmpty()) {
                    JSLanguageLevelApplicableRootsCache.this.resetCachedDirs();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/dialects/JSLanguageLevelApplicableRootsCache$2", "changed"));
            }
        });
        connection.subscribe(JSLibraryManager.TOPIC, this::resetCachedDirs);
    }

    private void resetCachedDirs() {
        this.applicableDirs = null;
    }

    @NotNull
    Set<VirtualFile> getApplicableLibraryFiles() {
        Set<VirtualFile> result2 = this.applicableDirs;
        if (result2 == null) {
            this.applicableDirs = result2 = Set.copyOf(JSLanguageLevelApplicableRootsCache.getApplicableLibraryFiles(this.myProject));
        }
        Set<VirtualFile> set = result2;
        if (set == null) {
            JSLanguageLevelApplicableRootsCache.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private static List<VirtualFile> getApplicableLibraryFiles(@NotNull Project project) {
        JSLibraryMappings mappings;
        if (project == null) {
            JSLanguageLevelApplicableRootsCache.$$$reportNull$$$0(3);
        }
        if ((mappings = (JSLibraryMappings)((Object)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return null;
            }
            return JSLibraryMappings.getInstance(project);
        }))) == null) {
            List<VirtualFile> list = List.of();
            if (list == null) {
                JSLanguageLevelApplicableRootsCache.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (ScriptingLibraryModel model : mappings.getMappings().values()) {
            if (model instanceof ScriptingLibraryMappings.CompoundLibrary) {
                for (ScriptingLibraryModel libraryModel : ((ScriptingLibraryMappings.CompoundLibrary)model).getLibraries()) {
                    JSLanguageLevelApplicableRootsCache.addFilesFromModel(files, libraryModel);
                }
                continue;
            }
            JSLanguageLevelApplicableRootsCache.addFilesFromModel(files, model);
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            JSLanguageLevelApplicableRootsCache.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void addFilesFromModel(@NotNull List<VirtualFile> files, @NotNull ScriptingLibraryModel model) {
        if (files == null) {
            JSLanguageLevelApplicableRootsCache.$$$reportNull$$$0(6);
        }
        if (model == null) {
            JSLanguageLevelApplicableRootsCache.$$$reportNull$$$0(7);
        }
        Collection<Object> roots = Collections.emptyList();
        if (model instanceof ScriptingLibraryModelBackedBySyntheticLibrary) {
            SyntheticLibrary library = ((ScriptingLibraryModelBackedBySyntheticLibrary)model).getSyntheticLibrary();
            if (library != null) {
                roots = library.getSourceRoots();
            }
        } else {
            roots = model.getAllFiles();
        }
        for (VirtualFile virtualFile : roots) {
            if (!virtualFile.isDirectory()) continue;
            files.add(virtualFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/dialects/JSLanguageLevelApplicableRootsCache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/dialects/JSLanguageLevelApplicableRootsCache";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableLibraryFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFilesFromModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

