/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.HttpAdapter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpAdapterList<T extends HttpAdapter>
extends AbstractList<T>
implements DeploymentDescriptorParser.AdapterFactory<T> {
    private final List<T> adapters = new ArrayList<T>();
    private final Map<PortInfo, String> addressMap = new HashMap<PortInfo, String>();

    @Override
    public T createAdapter(String name, String urlPattern, WSEndpoint<?> endpoint) {
        T t = this.createHttpAdapter(name, urlPattern, endpoint);
        this.adapters.add(t);
        WSDLPort port = endpoint.getPort();
        if (port != null) {
            PortInfo portInfo = new PortInfo(port.getOwner().getName(), port.getName().getLocalPart());
            this.addressMap.put(portInfo, this.getValidPath(urlPattern));
        }
        return t;
    }

    protected abstract T createHttpAdapter(String var1, String var2, WSEndpoint<?> var3);

    private String getValidPath(@NotNull String urlPattern) {
        if (urlPattern.endsWith("/*")) {
            return urlPattern.substring(0, urlPattern.length() - 2);
        }
        return urlPattern;
    }

    public PortAddressResolver createPortAddressResolver(final String baseAddress) {
        return new PortAddressResolver(){

            public String getAddressFor(@NotNull QName serviceName, @NotNull String portName) {
                String urlPattern = (String)HttpAdapterList.this.addressMap.get(new PortInfo(serviceName, portName));
                return urlPattern == null ? null : baseAddress + urlPattern;
            }
        };
    }

    @Override
    public T get(int index) {
        return (T)((HttpAdapter)this.adapters.get(index));
    }

    @Override
    public int size() {
        return this.adapters.size();
    }

    private static class PortInfo {
        private final QName serviceName;
        private final String portName;

        PortInfo(@NotNull QName serviceName, @NotNull String portName) {
            this.serviceName = serviceName;
            this.portName = portName;
        }

        public boolean equals(Object portInfo) {
            if (portInfo instanceof PortInfo) {
                PortInfo that = (PortInfo)portInfo;
                return this.serviceName.equals(that.serviceName) && this.portName.equals(that.portName);
            }
            return false;
        }

        public int hashCode() {
            return this.serviceName.hashCode() + this.portName.hashCode();
        }
    }
}

