// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct CountAll16Marker {
    remainder_byte_len: usize,
}

impl CountAll16Marker {
    pub fn some_field_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn remainder_byte_range(&self) -> Range<usize> {
        let start = self.some_field_byte_range().end;
        start..start + self.remainder_byte_len
    }
}

impl<'a> FontRead<'a> for CountAll16<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u16>();
        let remainder_byte_len = cursor.remaining_bytes() / u16::RAW_BYTE_LEN * u16::RAW_BYTE_LEN;
        cursor.advance_by(remainder_byte_len);
        cursor.finish(CountAll16Marker { remainder_byte_len })
    }
}

pub type CountAll16<'a> = TableRef<'a, CountAll16Marker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> CountAll16<'a> {
    pub fn some_field(&self) -> u16 {
        let range = self.shape.some_field_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn remainder(&self) -> &'a [BigEndian<u16>] {
        let range = self.shape.remainder_byte_range();
        self.data.read_array(range).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for CountAll16<'a> {
    fn type_name(&self) -> &str {
        "CountAll16"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("some_field", self.some_field())),
            1usize => Some(Field::new("remainder", self.remainder())),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for CountAll16<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct CountAll32Marker {
    remainder_byte_len: usize,
}

impl CountAll32Marker {
    pub fn some_field_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn remainder_byte_range(&self) -> Range<usize> {
        let start = self.some_field_byte_range().end;
        start..start + self.remainder_byte_len
    }
}

impl<'a> FontRead<'a> for CountAll32<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u16>();
        let remainder_byte_len = cursor.remaining_bytes() / u32::RAW_BYTE_LEN * u32::RAW_BYTE_LEN;
        cursor.advance_by(remainder_byte_len);
        cursor.finish(CountAll32Marker { remainder_byte_len })
    }
}

pub type CountAll32<'a> = TableRef<'a, CountAll32Marker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> CountAll32<'a> {
    pub fn some_field(&self) -> u16 {
        let range = self.shape.some_field_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn remainder(&self) -> &'a [BigEndian<u32>] {
        let range = self.shape.remainder_byte_range();
        self.data.read_array(range).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for CountAll32<'a> {
    fn type_name(&self) -> &str {
        "CountAll32"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("some_field", self.some_field())),
            1usize => Some(Field::new("remainder", self.remainder())),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for CountAll32<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}
