// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Represents the output for <code>DescribeStream</code>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DescribeStreamOutput {
    /// <p>The current status of the stream, the stream Amazon Resource Name (ARN), an array of shard objects that comprise the stream, and whether there are more shards available.</p>
    pub stream_description: ::std::option::Option<crate::types::StreamDescription>,
    _request_id: Option<String>,
}
impl DescribeStreamOutput {
    /// <p>The current status of the stream, the stream Amazon Resource Name (ARN), an array of shard objects that comprise the stream, and whether there are more shards available.</p>
    pub fn stream_description(&self) -> ::std::option::Option<&crate::types::StreamDescription> {
        self.stream_description.as_ref()
    }
}
impl ::aws_types::request_id::RequestId for DescribeStreamOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl DescribeStreamOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStreamOutput`](crate::operation::describe_stream::DescribeStreamOutput).
    pub fn builder() -> crate::operation::describe_stream::builders::DescribeStreamOutputBuilder {
        crate::operation::describe_stream::builders::DescribeStreamOutputBuilder::default()
    }
}

/// A builder for [`DescribeStreamOutput`](crate::operation::describe_stream::DescribeStreamOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DescribeStreamOutputBuilder {
    pub(crate) stream_description: ::std::option::Option<crate::types::StreamDescription>,
    _request_id: Option<String>,
}
impl DescribeStreamOutputBuilder {
    /// <p>The current status of the stream, the stream Amazon Resource Name (ARN), an array of shard objects that comprise the stream, and whether there are more shards available.</p>
    /// This field is required.
    pub fn stream_description(mut self, input: crate::types::StreamDescription) -> Self {
        self.stream_description = ::std::option::Option::Some(input);
        self
    }
    /// <p>The current status of the stream, the stream Amazon Resource Name (ARN), an array of shard objects that comprise the stream, and whether there are more shards available.</p>
    pub fn set_stream_description(mut self, input: ::std::option::Option<crate::types::StreamDescription>) -> Self {
        self.stream_description = input;
        self
    }
    /// <p>The current status of the stream, the stream Amazon Resource Name (ARN), an array of shard objects that comprise the stream, and whether there are more shards available.</p>
    pub fn get_stream_description(&self) -> &::std::option::Option<crate::types::StreamDescription> {
        &self.stream_description
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`DescribeStreamOutput`](crate::operation::describe_stream::DescribeStreamOutput).
    pub fn build(self) -> crate::operation::describe_stream::DescribeStreamOutput {
        crate::operation::describe_stream::DescribeStreamOutput {
            stream_description: self.stream_description,
            _request_id: self._request_id,
        }
    }
}
