/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.packaging.AbstractJavaFxPackager;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationIcons;
import org.jetbrains.plugins.javaFX.packaging.JavaFxManifestAttribute;
import org.jetbrains.plugins.javaFX.packaging.JavaFxPackagerConstants;

public final class JavaFxAntGenerator {
    public static List<SimpleTag> createJarAndDeployTasks(AbstractJavaFxPackager packager, String artifactFileName, String artifactName, String tempDirPath, String tempDirDeployPath, String relativeToBaseDirPath) {
        String version;
        String artifactFileNameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)artifactFileName);
        ArrayList<SimpleTag> topLevelTagsCollector = new ArrayList<SimpleTag>();
        String preloaderJar = packager.getPreloaderJar();
        String preloaderClass = packager.getPreloaderClass();
        String preloaderFiles = null;
        String allButPreloader = null;
        if (!StringUtil.isEmptyOrSpaces((String)preloaderJar) && !StringUtil.isEmptyOrSpaces((String)preloaderClass)) {
            preloaderFiles = artifactFileNameWithoutExtension + "_preloader_files";
            topLevelTagsCollector.add(new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"id", (Object)preloaderFiles), Couple.of((Object)"requiredFor", (Object)"preloader"), Couple.of((Object)"dir", (Object)tempDirPath), Couple.of((Object)"includes", (Object)preloaderJar)}));
            allButPreloader = "all_but_preloader_" + artifactFileNameWithoutExtension;
            topLevelTagsCollector.add(new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"id", (Object)allButPreloader), Couple.of((Object)"dir", (Object)tempDirPath), Couple.of((Object)"excludes", (Object)preloaderJar), Couple.of((Object)"includes", (Object)"**/*.jar")}));
        }
        String allButSelf = "all_but_" + artifactFileNameWithoutExtension;
        SimpleTag allButSelfAndPreloader = new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"id", (Object)allButSelf), Couple.of((Object)"dir", (Object)tempDirPath), Couple.of((Object)"includes", (Object)"**/*.jar")});
        allButSelfAndPreloader.add(new SimpleTag("exclude", new Pair[]{Couple.of((Object)"name", (Object)artifactFileName)}));
        if (preloaderJar != null) {
            allButSelfAndPreloader.add(new SimpleTag("exclude", new Pair[]{Couple.of((Object)"name", (Object)preloaderJar)}));
        }
        topLevelTagsCollector.add(allButSelfAndPreloader);
        String all = "all_" + artifactFileNameWithoutExtension;
        SimpleTag allIncluded = new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"id", (Object)all), Couple.of((Object)"dir", (Object)tempDirPath), Couple.of((Object)"includes", (Object)"**/*.jar")});
        topLevelTagsCollector.add(allIncluded);
        String appId = artifactFileNameWithoutExtension + "_id";
        SimpleTag applicationTag = new SimpleTag("fx:application", new Pair[]{Couple.of((Object)"id", (Object)appId), Couple.of((Object)"name", (Object)artifactName), Couple.of((Object)"mainClass", (Object)packager.getAppClass())});
        if (preloaderFiles != null) {
            applicationTag.addAttribute((Pair)Couple.of((Object)"preloaderClass", (Object)preloaderClass));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(version = packager.getVersion()))) {
            applicationTag.addAttribute((Pair)Couple.of((Object)"version", (Object)version.trim().replaceAll("\\s", "-")));
        }
        JavaFxAntGenerator.appendValuesFromPropertiesFile(applicationTag, packager.getHtmlParamFile(), "fx:htmlParam", false);
        JavaFxAntGenerator.appendValuesFromPropertiesFile(applicationTag, packager.getParamFile(), "fx:param", true);
        topLevelTagsCollector.add(applicationTag);
        if (packager.convertCss2Bin()) {
            SimpleTag css2binTag = new SimpleTag("fx:csstobin", new Pair[]{Couple.of((Object)"outdir", (Object)tempDirPath)});
            css2binTag.add(new SimpleTag("fileset", new Pair[]{Couple.of((Object)"dir", (Object)tempDirPath), Couple.of((Object)"includes", (Object)"**/*.css")}));
            topLevelTagsCollector.add(css2binTag);
        }
        SimpleTag createJarTag = new SimpleTag("fx:jar", new Pair[]{Couple.of((Object)"destfile", (Object)(tempDirPath + "/" + artifactFileName))});
        JavaFxAntGenerator.addVerboseAttribute(createJarTag, packager);
        createJarTag.add(new SimpleTag("fx:application", new Pair[]{Couple.of((Object)"refid", (Object)appId)}));
        ArrayList<Couple> fileset2Jar = new ArrayList<Couple>();
        fileset2Jar.add(Couple.of((Object)"dir", (Object)tempDirPath));
        fileset2Jar.add(Couple.of((Object)"excludes", (Object)"**/*.jar"));
        createJarTag.add(new SimpleTag("fileset", fileset2Jar.toArray(new Pair[0])));
        createJarTag.add(JavaFxAntGenerator.createResourcesTag(preloaderFiles, false, allButPreloader, allButSelf, all));
        List<JavaFxManifestAttribute> manifestAttributes = JavaFxAntGenerator.getManifestAttributes(packager);
        if (!manifestAttributes.isEmpty()) {
            SimpleTag manifestTag = new SimpleTag("manifest", new Pair[0]);
            for (JavaFxManifestAttribute pair : manifestAttributes) {
                manifestTag.add(new SimpleTag("attribute", new Pair[]{Couple.of((Object)"name", (Object)pair.getName()), Couple.of((Object)"value", (Object)pair.getValue())}));
            }
            createJarTag.add(manifestTag);
        }
        topLevelTagsCollector.add(createJarTag);
        JavaFxPackagerConstants.NativeBundles bundle = packager.getNativeBundle();
        SimpleTag iconTag = JavaFxAntGenerator.appendApplicationIconPath(topLevelTagsCollector, bundle, packager.getIcons(), relativeToBaseDirPath);
        SimpleTag deployTag = new SimpleTag("fx:deploy", new Pair[]{Couple.of((Object)"width", (Object)packager.getWidth()), Couple.of((Object)"height", (Object)packager.getHeight()), Couple.of((Object)"updatemode", (Object)packager.getUpdateMode()), Couple.of((Object)"outdir", (Object)tempDirDeployPath), Couple.of((Object)"outfile", (Object)artifactFileNameWithoutExtension)});
        if (bundle != null && bundle != JavaFxPackagerConstants.NativeBundles.none) {
            deployTag.addAttribute((Pair)Couple.of((Object)"nativeBundles", (Object)bundle.name()));
        }
        if (!StringUtil.isEmpty((String)packager.getHtmlPlaceholderId())) {
            deployTag.addAttribute((Pair)Couple.of((Object)"placeholderId", (Object)packager.getHtmlPlaceholderId()));
        }
        JavaFxAntGenerator.addVerboseAttribute(deployTag, packager);
        if (packager.isEnabledSigning()) {
            deployTag.add(new SimpleTag("fx:permissions", new Pair[]{Couple.of((Object)"elevated", (Object)"true")}));
        }
        deployTag.add(new SimpleTag("fx:application", new Pair[]{Couple.of((Object)"refid", (Object)appId)}));
        ArrayList<Pair> infoPairs = new ArrayList<Pair>();
        JavaFxAntGenerator.appendIfNotEmpty(infoPairs, "title", packager.getTitle());
        JavaFxAntGenerator.appendIfNotEmpty(infoPairs, "vendor", packager.getVendor());
        JavaFxAntGenerator.appendIfNotEmpty(infoPairs, "description", packager.getDescription());
        if (!infoPairs.isEmpty() || iconTag != null) {
            SimpleTag infoTag = new SimpleTag("fx:info", infoPairs);
            deployTag.add(infoTag);
            if (iconTag != null) {
                infoTag.add(iconTag);
            }
        }
        deployTag.add(JavaFxAntGenerator.createResourcesTag(preloaderFiles, true, allButPreloader, allButSelf, all));
        SimpleTag templateTag = JavaFxAntGenerator.createTemplateTag(packager, tempDirDeployPath, relativeToBaseDirPath);
        if (templateTag != null) {
            deployTag.add(templateTag);
        }
        topLevelTagsCollector.add(deployTag);
        return topLevelTagsCollector;
    }

    private static void addVerboseAttribute(SimpleTag tag, @NotNull AbstractJavaFxPackager packager) {
        JavaFxPackagerConstants.MsgOutputLevel msgOutputLevel;
        if (packager == null) {
            JavaFxAntGenerator.$$$reportNull$$$0(0);
        }
        if ((msgOutputLevel = packager.getMsgOutputLevel()) != null && msgOutputLevel.isVerbose()) {
            tag.addAttribute((Pair)Couple.of((Object)"verbose", (Object)"true"));
        }
    }

    @NotNull
    private static List<JavaFxManifestAttribute> getManifestAttributes(@NotNull AbstractJavaFxPackager packager) {
        List<JavaFxManifestAttribute> customManifestAttributes;
        String vendor;
        String version;
        if (packager == null) {
            JavaFxAntGenerator.$$$reportNull$$$0(1);
        }
        ArrayList<JavaFxManifestAttribute> manifestAttributes = new ArrayList<JavaFxManifestAttribute>();
        String title = packager.getTitle();
        if (title != null) {
            manifestAttributes.add(new JavaFxManifestAttribute("Implementation-Title", title));
        }
        if ((version = packager.getVersion()) != null) {
            manifestAttributes.add(new JavaFxManifestAttribute("Implementation-Version", version));
        }
        if ((vendor = packager.getVendor()) != null) {
            manifestAttributes.add(new JavaFxManifestAttribute("Implementation-Vendor", vendor));
        }
        if ((customManifestAttributes = packager.getCustomManifestAttributes()) != null) {
            manifestAttributes.addAll(customManifestAttributes);
        }
        ArrayList<JavaFxManifestAttribute> arrayList = manifestAttributes;
        if (arrayList == null) {
            JavaFxAntGenerator.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static SimpleTag appendApplicationIconPath(List<SimpleTag> topLevelTagsCollector, JavaFxPackagerConstants.NativeBundles bundle, JavaFxApplicationIcons appIcons, String relativeToPath) {
        String iconPath;
        boolean haveAppIcon = false;
        if (appIcons == null || bundle == null || appIcons.isEmpty()) {
            return null;
        }
        if (bundle.isOnLinux() && !StringUtil.isEmpty((String)(iconPath = appIcons.getLinuxIcon(relativeToPath)))) {
            SimpleTag and = new SimpleTag("and", new Pair[0]);
            and.add(new SimpleTag("os", new Pair[]{Couple.of((Object)"family", (Object)"unix")}));
            SimpleTag not = new SimpleTag("not", new Pair[0]);
            not.add(new SimpleTag("os", new Pair[]{Couple.of((Object)"family", (Object)"mac")}));
            and.add(not);
            JavaFxAntGenerator.appendIconPropertyTag(topLevelTagsCollector, iconPath, relativeToPath != null, and);
            haveAppIcon = true;
        }
        if (bundle.isOnMac() && !StringUtil.isEmpty((String)(iconPath = appIcons.getMacIcon(relativeToPath)))) {
            JavaFxAntGenerator.appendIconPropertyTag(topLevelTagsCollector, iconPath, relativeToPath != null, new SimpleTag("os", new Pair[]{Couple.of((Object)"family", (Object)"mac")}));
            haveAppIcon = true;
        }
        if (bundle.isOnWindows() && !StringUtil.isEmpty((String)(iconPath = appIcons.getWindowsIcon(relativeToPath)))) {
            JavaFxAntGenerator.appendIconPropertyTag(topLevelTagsCollector, iconPath, relativeToPath != null, new SimpleTag("os", new Pair[]{Couple.of((Object)"family", (Object)"windows")}));
            haveAppIcon = true;
        }
        if (haveAppIcon) {
            return new SimpleTag("fx:icon", new Pair[]{Couple.of((Object)"href", (Object)"${app.icon.path}")});
        }
        return null;
    }

    private static void appendIconPropertyTag(List<SimpleTag> tagsCollector, String iconPath, boolean isRelativeIconPath, SimpleTag osFamily) {
        SimpleTag condition = new SimpleTag("condition", new Pair[]{Couple.of((Object)"property", (Object)"app.icon.path"), Couple.of((Object)"value", (Object)(isRelativeIconPath ? "${basedir}/" + iconPath : iconPath))});
        condition.add(osFamily);
        tagsCollector.add(condition);
    }

    private static SimpleTag createResourcesTag(String preloaderFiles, boolean includeSelf, String allButPreloader, String allButSelf, String all) {
        SimpleTag resourcesTag = new SimpleTag("fx:resources", new Pair[0]);
        if (preloaderFiles != null) {
            resourcesTag.add(new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"refid", (Object)preloaderFiles)}));
            resourcesTag.add(new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"refid", (Object)(includeSelf ? allButPreloader : allButSelf))}));
        } else {
            resourcesTag.add(new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"refid", (Object)(includeSelf ? all : allButSelf))}));
        }
        return resourcesTag;
    }

    private static SimpleTag createTemplateTag(AbstractJavaFxPackager packager, String deployOutDir, String relativeToBaseDirPath) {
        Object htmlTemplate = packager.getHtmlTemplateFile();
        if (!StringUtil.isEmpty((String)htmlTemplate)) {
            String shortName = new File((String)htmlTemplate).getName();
            if (!StringUtil.isEmpty((String)relativeToBaseDirPath)) {
                htmlTemplate = "${basedir}/" + FileUtil.getRelativePath((String)relativeToBaseDirPath, (String)htmlTemplate, (char)'/');
            }
            return new SimpleTag("fx:template", new Pair[]{Couple.of((Object)"file", (Object)htmlTemplate), Couple.of((Object)"tofile", (Object)(deployOutDir + "/" + shortName))});
        }
        return null;
    }

    private static void appendIfNotEmpty(List<Pair> pairs, String propertyName, String propValue) {
        if (!StringUtil.isEmptyOrSpaces((String)propValue)) {
            pairs.add((Pair)Couple.of((Object)propertyName, (Object)propValue));
        }
    }

    private static void appendValuesFromPropertiesFile(SimpleTag applicationTag, String paramFile, String paramTagName, boolean allowNoNamed) {
        if (!StringUtil.isEmptyOrSpaces((String)paramFile)) {
            Properties properties = new Properties();
            try (FileInputStream paramsInputStream = new FileInputStream(paramFile);){
                properties.load(paramsInputStream);
                for (Object o : properties.keySet()) {
                    final String propName = (String)o;
                    String propValue = properties.getProperty(propName);
                    if (!StringUtil.isEmptyOrSpaces((String)propValue)) {
                        applicationTag.add(new SimpleTag(paramTagName, new Pair[]{Couple.of((Object)"name", (Object)propName), Couple.of((Object)"value", (Object)propValue)}));
                        continue;
                    }
                    if (!allowNoNamed) continue;
                    applicationTag.add(new SimpleTag("fx:argument", propName){

                        @Override
                        public void generate(StringBuilder buf) {
                            buf.append("<").append(this.getName()).append(">").append(propName).append("</").append(this.getName()).append(">");
                        }
                    });
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/packaging/JavaFxAntGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/packaging/JavaFxAntGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getManifestAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addVerboseAttribute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getManifestAttributes";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SimpleTag {
        private final String myName;
        private final List<Pair> myPairs;
        private final List<SimpleTag> mySubTags = new ArrayList<SimpleTag>();
        private final String myValue;

        public SimpleTag(String name, Pair ... pairs) {
            this.myName = name;
            this.myPairs = new ArrayList<Pair>(Arrays.asList(pairs));
            this.myValue = null;
        }

        public SimpleTag(String name, Collection<? extends Pair> pairs) {
            this.myName = name;
            this.myPairs = new ArrayList<Pair>(pairs);
            this.myValue = null;
        }

        public SimpleTag(String name, String value) {
            this.myName = name;
            this.myPairs = new ArrayList<Pair>();
            this.myValue = value;
        }

        public void addAttribute(Pair attr) {
            this.myPairs.add(attr);
        }

        public void add(SimpleTag tag) {
            this.mySubTags.add(tag);
        }

        public String getName() {
            return this.myName;
        }

        public Pair[] getPairs() {
            return this.myPairs.toArray(new Pair[0]);
        }

        public String getValue() {
            return this.myValue;
        }

        public List<SimpleTag> getSubTags() {
            return this.mySubTags;
        }

        public void generate(StringBuilder buf) {
            buf.append("<").append(this.getName());
            for (Pair pair : this.getPairs()) {
                buf.append(" ").append(pair.first).append("=\"").append(pair.second).append("\"");
            }
            buf.append(">\n");
            for (SimpleTag tag : this.getSubTags()) {
                tag.generate(buf);
            }
            buf.append("</").append(this.getName()).append(">\n");
        }
    }
}

