/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.dom.util;

import org.jetbrains.relocated.apache.batik.constants.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XMLSupport
implements XMLConstants {
    private XMLSupport() {
    }

    public static String getXMLLang(Element elt) {
        Attr attr = elt.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (attr != null) {
            return attr.getNodeValue();
        }
        for (Node n = elt.getParentNode(); n != null; n = n.getParentNode()) {
            if (n.getNodeType() != 1 || (attr = ((Element)n).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang")) == null) continue;
            return attr.getNodeValue();
        }
        return "en";
    }

    public static String getXMLSpace(Element elt) {
        Attr attr = elt.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space");
        if (attr != null) {
            return attr.getNodeValue();
        }
        for (Node n = elt.getParentNode(); n != null; n = n.getParentNode()) {
            if (n.getNodeType() != 1 || (attr = ((Element)n).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space")) == null) continue;
            return attr.getNodeValue();
        }
        return "default";
    }

    public static String defaultXMLSpace(String data2) {
        int nChars = data2.length();
        StringBuffer result2 = new StringBuffer(nChars);
        boolean space = false;
        block4: for (int i = 0; i < nChars; ++i) {
            char c = data2.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    space = false;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    if (space) continue block4;
                    result2.append(' ');
                    space = true;
                    continue block4;
                }
                default: {
                    result2.append(c);
                    space = false;
                }
            }
        }
        return result2.toString().trim();
    }

    public static String preserveXMLSpace(String data2) {
        int nChars = data2.length();
        StringBuffer result2 = new StringBuffer(nChars);
        block3: for (int i = 0; i < data2.length(); ++i) {
            char c = data2.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    result2.append(' ');
                    continue block3;
                }
                default: {
                    result2.append(c);
                }
            }
        }
        return result2.toString();
    }
}

