/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.html;

import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.collaboration.ui.html.ImageLoader;
import com.intellij.collaboration.ui.html.ResizingHtmlImageViewKt;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J(\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J&\u0010\"\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010!2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0012\u0010(\u001a\u00020\u001d2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0016J\"\u0010*\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010%\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J3\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u00132\u0006\u0010%\u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020,01H\u0016\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020\u0007H\u0002J\b\u00104\u001a\u00020\u001dH\u0002J\u0014\u00105\u001a\u00020\u0013*\u0002062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u00105\u001a\u00020\u0013*\u0002072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/collaboration/ui/html/ResizingHtmlImageView;", "Ljavax/swing/text/View;", "element", "Ljavax/swing/text/Element;", "<init>", "(Ljavax/swing/text/Element;)V", "value", "Lcom/intellij/collaboration/ui/html/ImageLoader;", "_loader", "set_loader", "(Lcom/intellij/collaboration/ui/html/ImageLoader;)V", "loader", "getLoader", "()Lcom/intellij/collaboration/ui/html/ImageLoader;", "cachedContainer", "Ljava/awt/Container;", "lastPaintedRectangle", "Ljava/awt/Rectangle;", "getPreferredSpan", "", "axis", "", "getBreakWeight", "pos", "len", "breakView", "offset", "getAlignment", "paint", "", "g", "Ljava/awt/Graphics;", "allocation", "Ljava/awt/Shape;", "changedUpdate", "e", "Ljavax/swing/event/DocumentEvent;", "a", "f", "Ljavax/swing/text/ViewFactory;", "setParent", "parent", "modelToView", "b", "Ljavax/swing/text/Position$Bias;", "viewToModel", "x", "y", "bias", "", "(FFLjava/awt/Shape;[Ljavax/swing/text/Position$Bias;)I", "createImageLoader", "requestRepaint", "getSpan", "Ljava/awt/Dimension;", "Ljavax/swing/Icon;", "SizedImageView", "intellij.platform.collaborationTools"})
public final class ResizingHtmlImageView
extends View {
    @Nullable
    private ImageLoader _loader;
    @Nullable
    private Container cachedContainer;
    @Nullable
    private Rectangle lastPaintedRectangle;

    public ResizingHtmlImageView(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
    }

    private final void set_loader(ImageLoader value) {
        ImageLoader imageLoader = this._loader;
        if (imageLoader != null) {
            imageLoader.cancel();
        }
        this._loader = value;
    }

    private final ImageLoader getLoader() {
        ImageLoader imageLoader = this._loader;
        if (imageLoader == null) {
            ImageLoader imageLoader2;
            ResizingHtmlImageView $this$_get_loader__u24lambda_u241 = this;
            boolean bl = false;
            ImageLoader it = imageLoader2 = $this$_get_loader__u24lambda_u241.createImageLoader();
            boolean bl2 = false;
            $this$_get_loader__u24lambda_u241.set_loader(it);
            imageLoader = imageLoader2;
        }
        return imageLoader;
    }

    @Override
    public float getPreferredSpan(int axis) {
        float f;
        ImageLoader.State state = this.getLoader().getState();
        if (Intrinsics.areEqual((Object)state, (Object)ImageLoader.State.NotLoaded.INSTANCE)) {
            f = this.getSpan(ResizingHtmlImageViewKt.access$getNotLoadedIcon(), axis);
        } else if (state instanceof ImageLoader.State.Loading) {
            Dimension dimension = ((ImageLoader.State.Loading)state).getDimension();
            f = dimension != null ? this.getSpan(dimension, axis) : this.getSpan(ResizingHtmlImageViewKt.access$getLoadingIcon(), axis);
        } else if (state instanceof ImageLoader.State.Loaded) {
            f = this.getSpan(((ImageLoader.State.Loaded)state).getDimension(), axis);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return f;
    }

    @Override
    public int getBreakWeight(int axis, float pos, float len) {
        return axis == 0 && this.getLoader().getState() instanceof ImageLoader.State.Loaded ? 3000 : 0;
    }

    @Override
    @NotNull
    public View breakView(int axis, int offset, float pos, float len) {
        ImageLoader.State state = this.getLoader().getState();
        if (axis == 0 && state instanceof ImageLoader.State.Loaded) {
            this.preferenceChanged(null, false, true);
            float imageWidth = ((ImageLoader.State.Loaded)state).getDimension().width;
            float imageHeight = ((ImageLoader.State.Loaded)state).getDimension().height;
            Comparable comparable = ComparatorUtil.min((Comparable)Float.valueOf(len), (Comparable)Float.valueOf(imageWidth));
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"min(...)");
            float width = RangesKt.coerceAtLeast((float)((Number)((Object)comparable)).floatValue(), (float)1.0f);
            float scale = RangesKt.coerceAtMost((float)(width / imageWidth), (float)1.0f);
            float height = RangesKt.coerceAtLeast((float)(imageHeight * scale), (float)1.0f);
            return new SizedImageView(((ImageLoader.State.Loaded)state).getImage(), width, height);
        }
        return this;
    }

    @Override
    public float getAlignment(int axis) {
        return 0.0f;
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull Shape allocation) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
        Rectangle rect = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        ImageLoader currentLoader = this.getLoader();
        currentLoader.loadImage();
        ImageLoader.State state = currentLoader.getState();
        if (Intrinsics.areEqual((Object)state, (Object)ImageLoader.State.NotLoaded.INSTANCE)) {
            ResizingHtmlImageViewKt.access$getNotLoadedIcon().paintIcon(null, g, rect.x, rect.y);
        } else if (state instanceof ImageLoader.State.Loading) {
            ResizingHtmlImageViewKt.access$getLoadingIcon().paintIcon(null, g, rect.x, rect.y);
        } else if (state instanceof ImageLoader.State.Loaded) {
            StartupUiUtil.drawImage((Graphics)g, (Image)((ImageLoader.State.Loaded)state).getImage(), (Rectangle)rect, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void changedUpdate(@Nullable DocumentEvent e, @Nullable Shape a, @Nullable ViewFactory f) {
        super.changedUpdate(e, a, f);
        this.set_loader(null);
        this.preferenceChanged(null, true, true);
    }

    @Override
    public void setParent(@Nullable View parent) {
        super.setParent(parent);
        View view = parent;
        this.cachedContainer = view != null ? view.getContainer() : null;
    }

    @Override
    @NotNull
    public Shape modelToView(int pos, @NotNull Shape a, @Nullable Position.Bias b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        int n = this.getStartOffset();
        if (!(pos <= this.getEndOffset() ? n <= pos : false)) {
            throw new BadLocationException(this.getElement().toString(), pos);
        }
        int x = a.getBounds().x + (pos == this.getEndOffset() ? a.getBounds().width : 0);
        return new Rectangle(x, a.getBounds().y, 0, a.getBounds().height);
    }

    @Override
    public int viewToModel(float x, float y, @NotNull Shape a, @NotNull Position.Bias[] bias) {
        int n;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)bias, (String)"bias");
        int right = a.getBounds().x + a.getBounds().width;
        if (x >= (float)right) {
            Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Backward, (String)"Backward");
            n = this.getEndOffset();
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Forward, (String)"Forward");
            n = this.getStartOffset();
        }
        return n;
    }

    private final ImageLoader createImageLoader() {
        Object object = this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        String src = object instanceof String ? (String)object : null;
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type javax.swing.text.html.HTMLDocument");
        URL base = ((HTMLDocument)document).getBase();
        Object object2 = this.getDocument().getProperty(AsyncHtmlImageLoader.Companion.getKEY());
        AsyncHtmlImageLoader asyncLoader = object2 instanceof AsyncHtmlImageLoader ? (AsyncHtmlImageLoader)object2 : null;
        return new ImageLoader(base, src, asyncLoader, (Function2<? super ImageLoader.State, ? super ImageLoader.State, Unit>)((Function2)(arg_0, arg_1) -> ResizingHtmlImageView.createImageLoader$lambda$2(this, arg_0, arg_1)));
    }

    private final void requestRepaint() {
        block1: {
            Rectangle rect;
            block0: {
                rect = this.lastPaintedRectangle;
                if (rect != null) break block0;
                Container container = this.cachedContainer;
                if (container == null) break block1;
                container.repaint(100L);
                break block1;
            }
            Container container = this.cachedContainer;
            if (container == null) break block1;
            container.repaint(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private final float getSpan(Dimension $this$getSpan, int axis) {
        return axis == 0 ? $this$getSpan.width : $this$getSpan.height;
    }

    private final float getSpan(Icon $this$getSpan, int axis) {
        return axis == 0 ? $this$getSpan.getIconWidth() : $this$getSpan.getIconHeight();
    }

    private static final Unit createImageLoader$lambda$2(ResizingHtmlImageView this$0, ImageLoader.State old, ImageLoader.State state) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)state, (String)"new");
        if (!Intrinsics.areEqual((Object)old, (Object)state)) {
            this$0.preferenceChanged(null, true, true);
        }
        this$0.requestRepaint();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J3\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/collaboration/ui/html/ResizingHtmlImageView$SizedImageView;", "Ljavax/swing/text/View;", "image", "Ljava/awt/Image;", "width", "", "height", "<init>", "(Lcom/intellij/collaboration/ui/html/ResizingHtmlImageView;Ljava/awt/Image;FF)V", "getPreferredSpan", "axis", "", "paint", "", "g", "Ljava/awt/Graphics;", "allocation", "Ljava/awt/Shape;", "getAlignment", "getToolTipText", "", "x", "y", "modelToView", "pos", "a", "b", "Ljavax/swing/text/Position$Bias;", "viewToModel", "biasReturn", "", "(FFLjava/awt/Shape;[Ljavax/swing/text/Position$Bias;)I", "intellij.platform.collaborationTools"})
    private final class SizedImageView
    extends View {
        @NotNull
        private final Image image;
        private final float width;
        private final float height;

        public SizedImageView(Image image, float width, float height) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            super(ResizingHtmlImageView.this.getElement());
            this.image = image;
            this.width = width;
            this.height = height;
        }

        @Override
        public float getPreferredSpan(int axis) {
            return axis == 0 ? this.width : this.height;
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull Shape allocation) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
            Rectangle rect = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
            StartupUiUtil.drawImage((Graphics)g, (Image)this.image, (Rectangle)rect, null);
            ResizingHtmlImageView.this.lastPaintedRectangle = rect;
        }

        @Override
        public float getAlignment(int axis) {
            return ResizingHtmlImageView.this.getAlignment(axis);
        }

        @Override
        @Nullable
        public String getToolTipText(float x, float y, @Nullable Shape allocation) {
            return ResizingHtmlImageView.this.getToolTipText(x, y, allocation);
        }

        @Override
        @NotNull
        public Shape modelToView(int pos, @NotNull Shape a, @Nullable Position.Bias b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return ResizingHtmlImageView.this.modelToView(pos, a, b);
        }

        @Override
        public int viewToModel(float x, float y, @NotNull Shape a, @NotNull Position.Bias[] biasReturn) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)biasReturn, (String)"biasReturn");
            return ResizingHtmlImageView.this.viewToModel(x, y, a, biasReturn);
        }
    }
}

