/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.codeStyle.OptionTreeWithPreviewPanel;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.frontback.impl.JavaFrontbackBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.border.CustomLineBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocFormattingPanel
extends OptionTreeWithPreviewPanel {
    private JCheckBox myEnableCheckBox;
    private final JPanel myJavaDocPanel = new JPanel(new BorderLayout());

    public JavaDocFormattingPanel(CodeStyleSettings settings) {
        super(settings);
        this.init();
    }

    protected void init() {
        super.init();
        this.myEnableCheckBox = new JCheckBox(JavaFrontbackBundle.message("checkbox.enable.javadoc.formatting", new Object[0]));
        this.myEnableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaDocFormattingPanel.this.update();
            }
        });
        this.myPanel.setBorder((Border)new CustomLineBorder(OnePixelDivider.BACKGROUND, 1, 0, 0, 0));
        this.myJavaDocPanel.add("Center", this.myPanel);
        this.myJavaDocPanel.add((Component)this.myEnableCheckBox, "North");
    }

    public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
    }

    public JComponent getPanel() {
        return this.myJavaDocPanel;
    }

    private void update() {
        JavaDocFormattingPanel.setEnabled(this.getPanel(), this.myEnableCheckBox.isSelected());
        this.myEnableCheckBox.setEnabled(true);
    }

    protected void initTables() {
        this.initCustomOptions(JavaDocFormattingPanel.getAlignmentGroup());
        this.initCustomOptions(JavaDocFormattingPanel.getBlankLinesGroup());
        this.initCustomOptions(JavaDocFormattingPanel.getInvalidTagsGroup());
        this.initBooleanField("WRAP_COMMENTS", JavaFrontbackBundle.message("checkbox.wrap.at.right.margin", new Object[0]), JavaDocFormattingPanel.getOtherGroup());
        this.initCustomOptions(JavaDocFormattingPanel.getOtherGroup());
    }

    protected int getRightMargin() {
        return 47;
    }

    protected String getPreviewText() {
        return "package sample;\npublic class Sample {\n  /**\n   * This is a method description that is long enough to exceed right margin.\n   *\n   * Another paragraph of the description placed after blank line.\n   * <p/>\n   * Line with manual\n   * line feed.\n   * @param i short named parameter description\n   * @param longParameterName long named parameter description\n   * @param missingDescription\n   * @return return description.\n   * @throws XXXException description.\n   * @throws YException description.\n   * @throws ZException\n   *\n   * @invalidTag   */\n  public abstract String sampleMethod(int i, int longParameterName, int missingDescription) throws XXXException, YException, ZException;\n\n  /** One-line comment */\n  public abstract String sampleMethod2();\n\n  /**\n   * Simple method description\n   * @return\n   */\n  public abstract String sampleMethod3();\n";
    }

    private static void setEnabled(JComponent c, boolean enabled) {
        Component[] children;
        c.setEnabled(enabled);
        for (Component child : children = c.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            JavaDocFormattingPanel.setEnabled((JComponent)child, enabled);
        }
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            JavaDocFormattingPanel.$$$reportNull$$$0(0);
        }
        super.apply(settings);
        ((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING = this.myEnableCheckBox.isSelected();
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            JavaDocFormattingPanel.$$$reportNull$$$0(1);
        }
        super.resetImpl(settings);
        this.myEnableCheckBox.setSelected(((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING);
        this.update();
    }

    public boolean isModified(CodeStyleSettings settings) {
        return super.isModified(settings) || this.myEnableCheckBox.isSelected() != ((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING;
    }

    @NotNull
    protected final FileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            JavaDocFormattingPanel.$$$reportNull$$$0(2);
        }
        return javaFileType;
    }

    protected void customizeSettings() {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)JavaLanguage.INSTANCE);
        if (provider != null) {
            provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
        }
    }

    @NlsContexts.TabTitle
    @NotNull
    protected String getTabTitle() {
        String string = JavaFrontbackBundle.message("title.javadoc", new Object[0]);
        if (string == null) {
            JavaDocFormattingPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Language getDefaultLanguage() {
        return JavaLanguage.INSTANCE;
    }

    @NlsContexts.Label
    public static String getOtherGroup() {
        return JavaFrontbackBundle.message("group.javadoc.other", new Object[0]);
    }

    @NlsContexts.Label
    public static String getInvalidTagsGroup() {
        return JavaFrontbackBundle.message("group.javadoc.invalid.tags", new Object[0]);
    }

    @NlsContexts.Label
    public static String getBlankLinesGroup() {
        return JavaFrontbackBundle.message("group.javadoc.blank.lines", new Object[0]);
    }

    @NlsContexts.Label
    public static String getAlignmentGroup() {
        return JavaFrontbackBundle.message("group.javadoc.alignment", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/JavaDocFormattingPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/JavaDocFormattingPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

