/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.interceptors;

import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTracer
implements MessageInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageTracer.class);

    @Override
    public void sendRequest(Request request) {
        LOGGER.info("{} <== req {}", (Object)request.getDestinationContext(), (Object)request);
    }

    @Override
    public void sendResponse(Response response) {
        LOGGER.info("{} <== res {}", (Object)response.getDestinationContext(), (Object)response);
    }

    @Override
    public void sendEmptyMessage(EmptyMessage message) {
        LOGGER.info("{} <== emp {}", (Object)message.getDestinationContext(), (Object)message);
    }

    @Override
    public void receiveRequest(Request request) {
        LOGGER.info("{} ==> req {}", (Object)request.getSourceContext(), (Object)request);
    }

    @Override
    public void receiveResponse(Response response) {
        LOGGER.info("{} ==> res {}", (Object)response.getSourceContext(), (Object)response);
    }

    @Override
    public void receiveEmptyMessage(EmptyMessage message) {
        LOGGER.info("{} ==> emp {}", (Object)message.getSourceContext(), (Object)message);
    }
}

