/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanElaborator;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class Contains
extends CollatingFunctionFixed {
    @Override
    public boolean isSubstringMatchingFunction() {
        return true;
    }

    private static boolean contains(StringValue arg0, StringValue arg1, SubstringMatcher collator) {
        if (arg1 == null || arg1.isEmpty() || collator.isEqualToEmpty(arg1.getUnicodeStringValue())) {
            return true;
        }
        if (arg0 == null || arg0.isEmpty()) {
            return false;
        }
        return collator.contains(arg0.getUnicodeStringValue(), arg1.getUnicodeStringValue());
    }

    @Override
    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue s0 = (StringValue)arguments[0].head();
        StringValue s1 = (StringValue)arguments[1].head();
        return BooleanValue.get(Contains.contains(s0, s1, (SubstringMatcher)this.getStringCollator()));
    }

    @Override
    public Elaborator getElaborator() {
        return new ContainsFnElaborator();
    }

    public static class ContainsFnElaborator
    extends BooleanElaborator {
        @Override
        public BooleanEvaluator elaborateForBoolean() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            CollatingFunctionFixed fn = (CollatingFunctionFixed)fnc.getTargetFunction();
            SubstringMatcher collation = (SubstringMatcher)fn.getStringCollator();
            assert (collation != null);
            String name = fnc.getFunctionName().getLocalPart();
            if (collation == CodepointCollator.getInstance()) {
                StringEvaluator arg0Eval = fnc.getArg(0).makeElaborator().elaborateForString(true);
                StringEvaluator arg1Eval = fnc.getArg(1).makeElaborator().elaborateForString(true);
                switch (name) {
                    case "contains": {
                        return context -> arg0Eval.eval(context).contains(arg1Eval.eval(context));
                    }
                    case "starts-with": {
                        return context -> arg0Eval.eval(context).startsWith(arg1Eval.eval(context));
                    }
                    case "ends-with": {
                        return context -> arg0Eval.eval(context).endsWith(arg1Eval.eval(context));
                    }
                }
                throw new UnsupportedOperationException();
            }
            UnicodeStringEvaluator arg0Eval = fnc.getArg(0).makeElaborator().elaborateForUnicodeString(true);
            UnicodeStringEvaluator arg1Eval = fnc.getArg(1).makeElaborator().elaborateForUnicodeString(true);
            switch (name) {
                case "contains": {
                    return context -> {
                        UnicodeString s0 = arg0Eval.eval(context);
                        UnicodeString s1 = arg1Eval.eval(context);
                        return collation.contains(s0, s1);
                    };
                }
                case "starts-with": {
                    return context -> {
                        UnicodeString s0 = arg0Eval.eval(context);
                        UnicodeString s1 = arg1Eval.eval(context);
                        return collation.startsWith(s0, s1);
                    };
                }
                case "ends-with": {
                    return context -> {
                        UnicodeString s0 = arg0Eval.eval(context);
                        UnicodeString s1 = arg1Eval.eval(context);
                        return collation.endsWith(s0, s1);
                    };
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

