/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class AnnotationLocationCheck
extends AbstractCheck {
    public static final String MSG_KEY_ANNOTATION_LOCATION_ALONE = "annotation.location.alone";
    public static final String MSG_KEY_ANNOTATION_LOCATION = "annotation.location";
    private static final int[] SINGLELINE_ANNOTATION_PARENTS = new int[]{156, 21, 35};
    private boolean allowSamelineSingleParameterlessAnnotation = true;
    private boolean allowSamelineParameterizedAnnotation;
    private boolean allowSamelineMultipleAnnotations;

    public final void setAllowSamelineSingleParameterlessAnnotation(boolean allow) {
        this.allowSamelineSingleParameterlessAnnotation = allow;
    }

    public final void setAllowSamelineParameterizedAnnotation(boolean allow) {
        this.allowSamelineParameterizedAnnotation = allow;
    }

    public final void setAllowSamelineMultipleAnnotations(boolean allow) {
        this.allowSamelineMultipleAnnotations = allow;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 154, 9, 8, 10};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 9, 8, 10, 21, 157, 23, 81, 19, 164, 136, 59, 161};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST modifiersNode = ast.findFirstToken(5);
        if (modifiersNode != null) {
            this.checkAnnotations(modifiersNode, AnnotationLocationCheck.getExpectedAnnotationIndentation(modifiersNode));
        }
    }

    private static int getExpectedAnnotationIndentation(DetailAST modifierNode) {
        return modifierNode.getParent().getColumnNo();
    }

    private void checkAnnotations(DetailAST modifierNode, int correctIndentation) {
        for (DetailAST annotation = modifierNode.getFirstChild(); annotation != null && annotation.getType() == 159; annotation = annotation.getNextSibling()) {
            boolean hasParameters = AnnotationLocationCheck.isParameterized(annotation);
            if (!this.isCorrectLocation(annotation, hasParameters)) {
                this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_LOCATION_ALONE, AnnotationLocationCheck.getAnnotationName(annotation));
                continue;
            }
            if (annotation.getColumnNo() == correctIndentation || AnnotationLocationCheck.hasNodeBefore(annotation)) continue;
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_LOCATION, AnnotationLocationCheck.getAnnotationName(annotation), annotation.getColumnNo(), correctIndentation);
        }
    }

    private static boolean isParameterized(DetailAST annotation) {
        return annotation.findFirstToken(28) != null;
    }

    private static String getAnnotationName(DetailAST annotation) {
        DetailAST identNode = annotation.findFirstToken(58);
        if (identNode == null) {
            identNode = annotation.findFirstToken(59).findFirstToken(58);
        }
        return identNode.getText();
    }

    private boolean isCorrectLocation(DetailAST annotation, boolean hasParams) {
        boolean allowingCondition = hasParams ? this.allowSamelineParameterizedAnnotation : this.allowSamelineSingleParameterlessAnnotation;
        return this.allowSamelineMultipleAnnotations || allowingCondition && !AnnotationLocationCheck.hasNodeBefore(annotation) || !allowingCondition && (!AnnotationLocationCheck.hasNodeBeside(annotation) || AnnotationLocationCheck.isAllowedPosition(annotation, SINGLELINE_ANNOTATION_PARENTS));
    }

    private static boolean hasNodeBefore(DetailAST annotation) {
        int annotationLineNo = annotation.getLineNo();
        DetailAST previousNode = annotation.getPreviousSibling();
        return previousNode != null && annotationLineNo == previousNode.getLineNo();
    }

    private static boolean hasNodeBeside(DetailAST annotation) {
        return AnnotationLocationCheck.hasNodeBefore(annotation) || AnnotationLocationCheck.hasNodeAfter(annotation);
    }

    private static boolean hasNodeAfter(DetailAST annotation) {
        int annotationLineNo = annotation.getLineNo();
        DetailAST nextNode = annotation.getNextSibling();
        if (nextNode == null) {
            nextNode = annotation.getParent().getNextSibling();
        }
        return annotationLineNo == nextNode.getLineNo();
    }

    private static boolean isAllowedPosition(DetailAST annotation, int ... allowedPositions) {
        boolean allowed = false;
        for (int position : allowedPositions) {
            if (!AnnotationLocationCheck.isInSpecificCodeBlock(annotation, position)) continue;
            allowed = true;
            break;
        }
        return allowed;
    }

    private static boolean isInSpecificCodeBlock(DetailAST node, int blockType) {
        boolean returnValue = false;
        for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (type != blockType) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }
}

