// Copyright 2024 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This proto verifies that we keep the name mangling algorithm (which is
// position dependent) intact in the protoc_gen_go generator. The field names
// and the getter names have to be kept intact over time, both in the OPEN and
// in the HYBRID API. How fields are "mangled" is described in a comment per
// field.

// The order of "evaluation" of fields is important. Fields are evaluated in
// order of appearance, except the oneof union names, that are evaluated after
// their first member. For each field, check if there is a previous field name
// or getter name that clashes with this field or it's getter. In case there is
// a clash, add an _ to the field name and repeat. In the case of oneof's, the
// union will be renamed if it clashes with it's first member, but not if it
// clashes with it's second.

// This scheme is here for backwards compatibility.
// The type of clashes that can be are the following:
// 1 - My field name clashes with their getter name
// 2 - My getter name clashes with their field name

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: cmd/protoc-gen-go/testdata/nameclash/test_name_clash_opaque3.proto

package test_name_clash_opaque3

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/gofeaturespb"
	reflect "reflect"
	unsafe "unsafe"
)

type M0 struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_I1 int32                  `protobuf:"varint,1,opt,name=i1,proto3"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *M0) Reset() {
	*x = M0{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M0) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M0) ProtoMessage() {}

func (x *M0) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M0) GetI1() int32 {
	if x != nil {
		return x.xxx_hidden_I1
	}
	return 0
}

func (x *M0) SetI1(v int32) {
	x.xxx_hidden_I1 = v
}

type M0_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	I1 int32
}

func (b0 M0_builder) Build() *M0 {
	m0 := &M0{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_I1 = b.I1
	return m0
}

type M1 struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo       *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_GetFoo_   *M0                    `protobuf:"bytes,2,opt,name=get_foo,json=getFoo,proto3"`
	xxx_hidden_GetGetFoo *M0                    `protobuf:"bytes,3,opt,name=get_get_foo,json=getGetFoo,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *M1) Reset() {
	*x = M1{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M1) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M1) ProtoMessage() {}

func (x *M1) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M1) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M1) GetGetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_GetFoo_
	}
	return nil
}

func (x *M1) GetGetGetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_GetGetFoo
	}
	return nil
}

func (x *M1) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M1) SetGetFoo(v *M0) {
	x.xxx_hidden_GetFoo_ = v
}

func (x *M1) SetGetGetFoo(v *M0) {
	x.xxx_hidden_GetGetFoo = v
}

func (x *M1) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M1) HasGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetFoo_ != nil
}

func (x *M1) HasGetGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetGetFoo != nil
}

func (x *M1) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M1) ClearGetFoo() {
	x.xxx_hidden_GetFoo_ = nil
}

func (x *M1) ClearGetGetFoo() {
	x.xxx_hidden_GetGetFoo = nil
}

type M1_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Old Scheme:
	// initial name in Go     | Clashes with field | type | final name
	// Foo                    | -                  | -    | Foo
	// GetFoo                 | foo                | 1    | GetFoo_
	// GetGetFoo              | -                  | -    | GetGetFoo
	// New Scheme:
	// initial name in Go     | Clashes with field | type | Getter name
	// Foo                    | get_foo            | G    | Get_Foo
	// GetFoo                 | get_get_foo        | G    | Get_GetFoo
	// GetGetFoo              | -                  | -    | GetGetGetFoo
	Foo       *M0
	GetFoo    *M0
	GetGetFoo *M0
}

func (b0 M1_builder) Build() *M1 {
	m0 := &M1{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	x.xxx_hidden_GetFoo_ = b.GetFoo
	x.xxx_hidden_GetGetFoo = b.GetGetFoo
	return m0
}

type M2 struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_GetGetFoo *M0                    `protobuf:"bytes,3,opt,name=get_get_foo,json=getGetFoo,proto3"`
	xxx_hidden_GetFoo_   *M0                    `protobuf:"bytes,2,opt,name=get_foo,json=getFoo,proto3"`
	xxx_hidden_Foo       *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *M2) Reset() {
	*x = M2{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M2) ProtoMessage() {}

func (x *M2) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M2) GetGetGetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_GetGetFoo
	}
	return nil
}

func (x *M2) GetGetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_GetFoo_
	}
	return nil
}

func (x *M2) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M2) SetGetGetFoo(v *M0) {
	x.xxx_hidden_GetGetFoo = v
}

func (x *M2) SetGetFoo(v *M0) {
	x.xxx_hidden_GetFoo_ = v
}

func (x *M2) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M2) HasGetGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetGetFoo != nil
}

func (x *M2) HasGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetFoo_ != nil
}

func (x *M2) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M2) ClearGetGetFoo() {
	x.xxx_hidden_GetGetFoo = nil
}

func (x *M2) ClearGetFoo() {
	x.xxx_hidden_GetFoo_ = nil
}

func (x *M2) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

type M2_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Old Scheme:
	// initial name in Go     | Clashes with field | type | final name
	// GetGetFoo              | -                  | -    | GetGetFoo
	// GetFoo                 | get_get_foo        | 2    | GetFoo_
	// Foo                    | -                  | -    | Foo
	// New Scheme:
	// initial name in Go     | Clashes with field | type | Getter name
	// Foo                    | get_foo            | G    | Get_Foo
	// GetFoo                 | get_get_foo        | G    | Get_GetFoo
	// GetGetFoo              | -                  | -    | GetGetGetFoo
	GetGetFoo *M0
	GetFoo    *M0
	Foo       *M0
}

func (b0 M2_builder) Build() *M2 {
	m0 := &M2{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_GetGetFoo = b.GetGetFoo
	x.xxx_hidden_GetFoo_ = b.GetFoo
	x.xxx_hidden_Foo = b.Foo
	return m0
}

type M3 struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_GetFoo     *M0                    `protobuf:"bytes,2,opt,name=get_foo,json=getFoo,proto3"`
	xxx_hidden_GetGetFoo_ *M0                    `protobuf:"bytes,3,opt,name=get_get_foo,json=getGetFoo,proto3"`
	xxx_hidden_Foo_       *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *M3) Reset() {
	*x = M3{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M3) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M3) ProtoMessage() {}

func (x *M3) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M3) GetGetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_GetFoo
	}
	return nil
}

func (x *M3) GetGetGetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_GetGetFoo_
	}
	return nil
}

func (x *M3) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo_
	}
	return nil
}

func (x *M3) SetGetFoo(v *M0) {
	x.xxx_hidden_GetFoo = v
}

func (x *M3) SetGetGetFoo(v *M0) {
	x.xxx_hidden_GetGetFoo_ = v
}

func (x *M3) SetFoo(v *M0) {
	x.xxx_hidden_Foo_ = v
}

func (x *M3) HasGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetFoo != nil
}

func (x *M3) HasGetGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetGetFoo_ != nil
}

func (x *M3) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo_ != nil
}

func (x *M3) ClearGetFoo() {
	x.xxx_hidden_GetFoo = nil
}

func (x *M3) ClearGetGetFoo() {
	x.xxx_hidden_GetGetFoo_ = nil
}

func (x *M3) ClearFoo() {
	x.xxx_hidden_Foo_ = nil
}

type M3_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Old Scheme:
	// initial name in Go     | Clashes with field | type | final name
	// GetFoo                 | -                  | -    | GetFoo
	// GetGetFoo              | get_foo            | 1    | GetGetFoo_
	// Foo                    | get_foo            | 2    | Foo_
	// New Scheme:
	// initial name in Go     | Clashes with field | type | Getter name
	// Foo                    | get_foo            | G    | Get_Foo
	// GetFoo                 | get_get_foo        | G    | Get_GetFoo
	// GetGetFoo              | -                  | -    | GetGetGetFoo
	GetFoo    *M0
	GetGetFoo *M0
	Foo       *M0
}

func (b0 M3_builder) Build() *M3 {
	m0 := &M3{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_GetFoo = b.GetFoo
	x.xxx_hidden_GetGetFoo_ = b.GetGetFoo
	x.xxx_hidden_Foo_ = b.Foo
	return m0
}

type M4 struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_GetFoo     *M0                    `protobuf:"bytes,2,opt,name=get_foo,json=getFoo,proto3"`
	xxx_hidden_GetGetFoo_ isM4_GetGetFoo_        `protobuf_oneof:"get_get_foo"`
	xxx_hidden_Foo_       *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *M4) Reset() {
	*x = M4{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M4) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M4) ProtoMessage() {}

func (x *M4) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M4) GetGetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_GetFoo
	}
	return nil
}

func (x *M4) GetGetGetGetFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_GetGetFoo_.(*m4_GetGetGetFoo); ok {
			return x.GetGetGetFoo
		}
	}
	return 0
}

func (x *M4) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo_
	}
	return nil
}

func (x *M4) SetGetFoo(v *M0) {
	x.xxx_hidden_GetFoo = v
}

func (x *M4) SetGetGetGetFoo(v int32) {
	x.xxx_hidden_GetGetFoo_ = &m4_GetGetGetFoo{v}
}

func (x *M4) SetFoo(v *M0) {
	x.xxx_hidden_Foo_ = v
}

func (x *M4) HasGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetFoo != nil
}

func (x *M4) HasGetGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetGetFoo_ != nil
}

func (x *M4) HasGetGetGetFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_GetGetFoo_.(*m4_GetGetGetFoo)
	return ok
}

func (x *M4) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo_ != nil
}

func (x *M4) ClearGetFoo() {
	x.xxx_hidden_GetFoo = nil
}

func (x *M4) ClearGetGetFoo() {
	x.xxx_hidden_GetGetFoo_ = nil
}

func (x *M4) ClearGetGetGetFoo() {
	if _, ok := x.xxx_hidden_GetGetFoo_.(*m4_GetGetGetFoo); ok {
		x.xxx_hidden_GetGetFoo_ = nil
	}
}

func (x *M4) ClearFoo() {
	x.xxx_hidden_Foo_ = nil
}

const M4_GetGetFoo__not_set_case case_M4_GetGetFoo_ = 0
const M4_GetGetGetFoo_case case_M4_GetGetFoo_ = 3

func (x *M4) WhichGetGetFoo() case_M4_GetGetFoo_ {
	if x == nil {
		return M4_GetGetFoo__not_set_case
	}
	switch x.xxx_hidden_GetGetFoo_.(type) {
	case *m4_GetGetGetFoo:
		return M4_GetGetGetFoo_case
	default:
		return M4_GetGetFoo__not_set_case
	}
}

type M4_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Old Scheme:
	// initial name in Go     | Clashes with field | type | final name
	// GetFoo                 | -                  | -    | GetFoo
	// GetGetFoo              | get_foo            | 1    | GetGetFoo_
	//
	//	GetGetGetFoo          | -                  | -    | GetGetGetFoo
	//	                      |                    |      |
	//
	// Foo                    | get_foo            | 2    | Foo_
	// New Scheme:
	// initial name in Go     | Clashes with field | type | Getter name
	// Foo                    | get_foo            | G    | Get_Foo
	// GetFoo                 | get_get_foo        | G    | Get_GetFoo
	// GetGetGetFoo           | -                  | -    | GetGetGetGetFoo
	GetFoo *M0
	// Fields of oneof xxx_hidden_GetGetFoo_:
	GetGetGetFoo *int32
	// -- end of xxx_hidden_GetGetFoo_
	Foo *M0
}

func (b0 M4_builder) Build() *M4 {
	m0 := &M4{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_GetFoo = b.GetFoo
	if b.GetGetGetFoo != nil {
		x.xxx_hidden_GetGetFoo_ = &m4_GetGetGetFoo{*b.GetGetGetFoo}
	}
	x.xxx_hidden_Foo_ = b.Foo
	return m0
}

type case_M4_GetGetFoo_ protoreflect.FieldNumber

func (x case_M4_GetGetFoo_) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[4].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM4_GetGetFoo_ interface {
	isM4_GetGetFoo_()
}

type m4_GetGetGetFoo struct {
	GetGetGetFoo int32 `protobuf:"varint,3,opt,name=get_get_get_foo,json=getGetGetFoo,proto3,oneof"`
}

func (*m4_GetGetGetFoo) isM4_GetGetFoo_() {}

type M5 struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_GetFoo       *M0                    `protobuf:"bytes,2,opt,name=get_foo,json=getFoo,proto3"`
	xxx_hidden_GetGetGetFoo isM5_GetGetGetFoo      `protobuf_oneof:"get_get_get_foo"`
	xxx_hidden_Foo_         *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *M5) Reset() {
	*x = M5{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M5) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M5) ProtoMessage() {}

func (x *M5) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M5) GetGetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_GetFoo
	}
	return nil
}

func (x *M5) GetGetGetFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_GetGetGetFoo.(*m5_GetGetFoo_); ok {
			return x.GetGetFoo_
		}
	}
	return 0
}

func (x *M5) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo_
	}
	return nil
}

func (x *M5) SetGetFoo(v *M0) {
	x.xxx_hidden_GetFoo = v
}

func (x *M5) SetGetGetFoo(v int32) {
	x.xxx_hidden_GetGetGetFoo = &m5_GetGetFoo_{v}
}

func (x *M5) SetFoo(v *M0) {
	x.xxx_hidden_Foo_ = v
}

func (x *M5) HasGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetFoo != nil
}

func (x *M5) HasGetGetGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetGetGetFoo != nil
}

func (x *M5) HasGetGetFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_GetGetGetFoo.(*m5_GetGetFoo_)
	return ok
}

func (x *M5) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo_ != nil
}

func (x *M5) ClearGetFoo() {
	x.xxx_hidden_GetFoo = nil
}

func (x *M5) ClearGetGetGetFoo() {
	x.xxx_hidden_GetGetGetFoo = nil
}

func (x *M5) ClearGetGetFoo() {
	if _, ok := x.xxx_hidden_GetGetGetFoo.(*m5_GetGetFoo_); ok {
		x.xxx_hidden_GetGetGetFoo = nil
	}
}

func (x *M5) ClearFoo() {
	x.xxx_hidden_Foo_ = nil
}

const M5_GetGetGetFoo_not_set_case case_M5_GetGetGetFoo = 0
const M5_GetGetFoo__case case_M5_GetGetGetFoo = 3

func (x *M5) WhichGetGetGetFoo() case_M5_GetGetGetFoo {
	if x == nil {
		return M5_GetGetGetFoo_not_set_case
	}
	switch x.xxx_hidden_GetGetGetFoo.(type) {
	case *m5_GetGetFoo_:
		return M5_GetGetFoo__case
	default:
		return M5_GetGetGetFoo_not_set_case
	}
}

type M5_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Old Scheme:
	// Note evaluation order - get_get_foo before get_get_get_foo
	// initial name in Go     | Clashes with field | type | final name
	// GetFoo                 | -                  | -    | GetFoo
	// GetGetGetFoo           | -                  | -    | GetGetGetFoo
	//
	//	GetGetFoo             | get_foo            | 1    | GetGetFoo_
	//	                      |                    |      |
	//
	// Foo                    | get_foo            | 2    | Foo_
	// New Scheme:
	// initial name in Go     | Clashes with field | type | Getter name
	// Foo                    | get_foo            | G    | Get_Foo
	// GetFoo                 | get_get_foo        | G    | Get_GetFoo
	// GetGetFoo              | get_get_get_foo    | G    | Get_GetGetFoo
	GetFoo *M0
	// Fields of oneof xxx_hidden_GetGetGetFoo:
	GetGetFoo *int32
	// -- end of xxx_hidden_GetGetGetFoo
	Foo *M0
}

func (b0 M5_builder) Build() *M5 {
	m0 := &M5{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_GetFoo = b.GetFoo
	if b.GetGetFoo != nil {
		x.xxx_hidden_GetGetGetFoo = &m5_GetGetFoo_{*b.GetGetFoo}
	}
	x.xxx_hidden_Foo_ = b.Foo
	return m0
}

type case_M5_GetGetGetFoo protoreflect.FieldNumber

func (x case_M5_GetGetGetFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[5].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM5_GetGetGetFoo interface {
	isM5_GetGetGetFoo()
}

type m5_GetGetFoo_ struct {
	GetGetFoo_ int32 `protobuf:"varint,3,opt,name=get_get_foo,json=getGetFoo,proto3,oneof"`
}

func (*m5_GetGetFoo_) isM5_GetGetGetFoo() {}

type M6 struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_GetGetFoo isM6_GetGetFoo         `protobuf_oneof:"get_get_foo"`
	xxx_hidden_GetFoo_   *M0                    `protobuf:"bytes,2,opt,name=get_foo,json=getFoo,proto3"`
	xxx_hidden_Foo       *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *M6) Reset() {
	*x = M6{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M6) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M6) ProtoMessage() {}

func (x *M6) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M6) GetGetGetGetFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_GetGetFoo.(*m6_GetGetGetFoo); ok {
			return x.GetGetGetFoo
		}
	}
	return 0
}

func (x *M6) GetGetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_GetFoo_
	}
	return nil
}

func (x *M6) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M6) SetGetGetGetFoo(v int32) {
	x.xxx_hidden_GetGetFoo = &m6_GetGetGetFoo{v}
}

func (x *M6) SetGetFoo(v *M0) {
	x.xxx_hidden_GetFoo_ = v
}

func (x *M6) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M6) HasGetGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetGetFoo != nil
}

func (x *M6) HasGetGetGetFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_GetGetFoo.(*m6_GetGetGetFoo)
	return ok
}

func (x *M6) HasGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetFoo_ != nil
}

func (x *M6) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M6) ClearGetGetFoo() {
	x.xxx_hidden_GetGetFoo = nil
}

func (x *M6) ClearGetGetGetFoo() {
	if _, ok := x.xxx_hidden_GetGetFoo.(*m6_GetGetGetFoo); ok {
		x.xxx_hidden_GetGetFoo = nil
	}
}

func (x *M6) ClearGetFoo() {
	x.xxx_hidden_GetFoo_ = nil
}

func (x *M6) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

const M6_GetGetFoo_not_set_case case_M6_GetGetFoo = 0
const M6_GetGetGetFoo_case case_M6_GetGetFoo = 3

func (x *M6) WhichGetGetFoo() case_M6_GetGetFoo {
	if x == nil {
		return M6_GetGetFoo_not_set_case
	}
	switch x.xxx_hidden_GetGetFoo.(type) {
	case *m6_GetGetGetFoo:
		return M6_GetGetGetFoo_case
	default:
		return M6_GetGetFoo_not_set_case
	}
}

type M6_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Note evaluation order - get_get_get_foo before get_get_foo
	// initial name in Go     | Clashes with field | type | final name
	// GetGetFoo              | -                  | -    | GetGetFoo
	//  GetGetGetFoo          | -                  | -    | GetGetGetFoo
	//                        |                    |      |
	// GetFoo                 | get_get_foo        | 2    | GetFoo_
	// Foo                    | -                  | -    | Foo
	// New Scheme:
	// initial name in Go     | Clashes with field | type | Getter name
	// Foo                    | get_foo            | G    | Get_Foo
	// GetFoo                 | get_get_foo        | G    | Get_GetFoo
	// GetGetGetFoo           | -                  | -    | GetGetGetGetFoo

	// Fields of oneof xxx_hidden_GetGetFoo:
	GetGetGetFoo *int32
	// -- end of xxx_hidden_GetGetFoo
	GetFoo *M0
	Foo    *M0
}

func (b0 M6_builder) Build() *M6 {
	m0 := &M6{}
	b, x := &b0, m0
	_, _ = b, x
	if b.GetGetGetFoo != nil {
		x.xxx_hidden_GetGetFoo = &m6_GetGetGetFoo{*b.GetGetGetFoo}
	}
	x.xxx_hidden_GetFoo_ = b.GetFoo
	x.xxx_hidden_Foo = b.Foo
	return m0
}

type case_M6_GetGetFoo protoreflect.FieldNumber

func (x case_M6_GetGetFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[6].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM6_GetGetFoo interface {
	isM6_GetGetFoo()
}

type m6_GetGetGetFoo struct {
	GetGetGetFoo int32 `protobuf:"varint,3,opt,name=get_get_get_foo,json=getGetGetFoo,proto3,oneof"`
}

func (*m6_GetGetGetFoo) isM6_GetGetFoo() {}

type M7 struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_GetGetFoo isM7_GetGetFoo         `protobuf_oneof:"get_get_foo"`
	xxx_hidden_Foo       *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *M7) Reset() {
	*x = M7{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M7) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M7) ProtoMessage() {}

func (x *M7) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M7) GetBar() bool {
	if x != nil {
		if x, ok := x.xxx_hidden_GetGetFoo.(*m7_Bar); ok {
			return x.Bar
		}
	}
	return false
}

func (x *M7) GetGetFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_GetGetFoo.(*m7_GetFoo_); ok {
			return x.GetFoo_
		}
	}
	return 0
}

func (x *M7) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M7) SetBar(v bool) {
	x.xxx_hidden_GetGetFoo = &m7_Bar{v}
}

func (x *M7) SetGetFoo(v int32) {
	x.xxx_hidden_GetGetFoo = &m7_GetFoo_{v}
}

func (x *M7) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M7) HasGetGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetGetFoo != nil
}

func (x *M7) HasBar() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_GetGetFoo.(*m7_Bar)
	return ok
}

func (x *M7) HasGetFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_GetGetFoo.(*m7_GetFoo_)
	return ok
}

func (x *M7) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M7) ClearGetGetFoo() {
	x.xxx_hidden_GetGetFoo = nil
}

func (x *M7) ClearBar() {
	if _, ok := x.xxx_hidden_GetGetFoo.(*m7_Bar); ok {
		x.xxx_hidden_GetGetFoo = nil
	}
}

func (x *M7) ClearGetFoo() {
	if _, ok := x.xxx_hidden_GetGetFoo.(*m7_GetFoo_); ok {
		x.xxx_hidden_GetGetFoo = nil
	}
}

func (x *M7) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

const M7_GetGetFoo_not_set_case case_M7_GetGetFoo = 0
const M7_Bar_case case_M7_GetGetFoo = 4
const M7_GetFoo__case case_M7_GetGetFoo = 3

func (x *M7) WhichGetGetFoo() case_M7_GetGetFoo {
	if x == nil {
		return M7_GetGetFoo_not_set_case
	}
	switch x.xxx_hidden_GetGetFoo.(type) {
	case *m7_Bar:
		return M7_Bar_case
	case *m7_GetFoo_:
		return M7_GetFoo__case
	default:
		return M7_GetGetFoo_not_set_case
	}
}

type M7_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Note evaluation order - bar before get_get_foo, then get_get_get_foo
	// initial name in Go     | Clashes with field | type | final name
	// GetGetFoo              | -                  | -    | GetGetFoo
	//  Bar                   | -                  | -    | Bar
	//  GetFoo                | foo                | 1    | GetFoo_
	//                        |                    |      |
	// Foo                    | -                  | -    | Foo
	// New Scheme:
	// initial name in Go     | Clashes with field | type | Getter name
	// Foo                    | get_foo            | G    | Get_Foo
	// GetFoo                 | get_get_foo        | G    | Get_GetFoo
	// Bar                    | -                  | -    | GetBar

	// Fields of oneof xxx_hidden_GetGetFoo:
	Bar    *bool
	GetFoo *int32
	// -- end of xxx_hidden_GetGetFoo
	Foo *M0
}

func (b0 M7_builder) Build() *M7 {
	m0 := &M7{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Bar != nil {
		x.xxx_hidden_GetGetFoo = &m7_Bar{*b.Bar}
	}
	if b.GetFoo != nil {
		x.xxx_hidden_GetGetFoo = &m7_GetFoo_{*b.GetFoo}
	}
	x.xxx_hidden_Foo = b.Foo
	return m0
}

type case_M7_GetGetFoo protoreflect.FieldNumber

func (x case_M7_GetGetFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[7].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM7_GetGetFoo interface {
	isM7_GetGetFoo()
}

type m7_Bar struct {
	Bar bool `protobuf:"varint,4,opt,name=bar,proto3,oneof"`
}

type m7_GetFoo_ struct {
	GetFoo_ int32 `protobuf:"varint,3,opt,name=get_foo,json=getFoo,proto3,oneof"`
}

func (*m7_Bar) isM7_GetGetFoo() {}

func (*m7_GetFoo_) isM7_GetGetFoo() {}

type M8 struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_GetGetGetFoo_ isM8_GetGetGetFoo_     `protobuf_oneof:"get_get_get_foo"`
	xxx_hidden_GetFoo_       *M0                    `protobuf:"bytes,2,opt,name=get_foo,json=getFoo,proto3"`
	xxx_hidden_Foo           *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *M8) Reset() {
	*x = M8{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M8) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M8) ProtoMessage() {}

func (x *M8) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M8) GetGetGetFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_GetGetGetFoo_.(*m8_GetGetFoo); ok {
			return x.GetGetFoo
		}
	}
	return 0
}

func (x *M8) GetGetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_GetFoo_
	}
	return nil
}

func (x *M8) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M8) SetGetGetFoo(v int32) {
	x.xxx_hidden_GetGetGetFoo_ = &m8_GetGetFoo{v}
}

func (x *M8) SetGetFoo(v *M0) {
	x.xxx_hidden_GetFoo_ = v
}

func (x *M8) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M8) HasGetGetGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetGetGetFoo_ != nil
}

func (x *M8) HasGetGetFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_GetGetGetFoo_.(*m8_GetGetFoo)
	return ok
}

func (x *M8) HasGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetFoo_ != nil
}

func (x *M8) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M8) ClearGetGetGetFoo() {
	x.xxx_hidden_GetGetGetFoo_ = nil
}

func (x *M8) ClearGetGetFoo() {
	if _, ok := x.xxx_hidden_GetGetGetFoo_.(*m8_GetGetFoo); ok {
		x.xxx_hidden_GetGetGetFoo_ = nil
	}
}

func (x *M8) ClearGetFoo() {
	x.xxx_hidden_GetFoo_ = nil
}

func (x *M8) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

const M8_GetGetGetFoo__not_set_case case_M8_GetGetGetFoo_ = 0
const M8_GetGetFoo_case case_M8_GetGetGetFoo_ = 3

func (x *M8) WhichGetGetGetFoo() case_M8_GetGetGetFoo_ {
	if x == nil {
		return M8_GetGetGetFoo__not_set_case
	}
	switch x.xxx_hidden_GetGetGetFoo_.(type) {
	case *m8_GetGetFoo:
		return M8_GetGetFoo_case
	default:
		return M8_GetGetGetFoo__not_set_case
	}
}

type M8_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Note evaluation order - get_get_foo before get_get_get_foo
	// initial name in Go     | Clashes with field | type | final name
	// GetGetGetFoo           | get_get_foo        | 1    | GetGetGetFoo_
	//  GetGetFoo             | -                  | -    | GetGetFoo
	//                        |                    |      |
	// GetFoo                 | get_get_foo        | 2    | GetFoo_
	// Foo                    | -                  | -    | Foo
	// New Scheme:
	// initial name in Go     | Clashes with field | type | Getter name
	// Foo                    | get_foo            | G    | Get_Foo
	// GetFoo                 | get_get_foo        | G    | Get_GetFoo
	// GetGetFoo              | get_get_get_foo    | G    | Get_GetGetFoo

	// Fields of oneof xxx_hidden_GetGetGetFoo_:
	GetGetFoo *int32
	// -- end of xxx_hidden_GetGetGetFoo_
	GetFoo *M0
	Foo    *M0
}

func (b0 M8_builder) Build() *M8 {
	m0 := &M8{}
	b, x := &b0, m0
	_, _ = b, x
	if b.GetGetFoo != nil {
		x.xxx_hidden_GetGetGetFoo_ = &m8_GetGetFoo{*b.GetGetFoo}
	}
	x.xxx_hidden_GetFoo_ = b.GetFoo
	x.xxx_hidden_Foo = b.Foo
	return m0
}

type case_M8_GetGetGetFoo_ protoreflect.FieldNumber

func (x case_M8_GetGetGetFoo_) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[8].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM8_GetGetGetFoo_ interface {
	isM8_GetGetGetFoo_()
}

type m8_GetGetFoo struct {
	GetGetFoo int32 `protobuf:"varint,3,opt,name=get_get_foo,json=getGetFoo,proto3,oneof"`
}

func (*m8_GetGetFoo) isM8_GetGetGetFoo_() {}

type M9 struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_GetGetGetFoo_ isM9_GetGetGetFoo_     `protobuf_oneof:"get_get_get_foo"`
	xxx_hidden_Foo           *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *M9) Reset() {
	*x = M9{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M9) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M9) ProtoMessage() {}

func (x *M9) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M9) GetGetGetFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_GetGetGetFoo_.(*m9_GetGetFoo); ok {
			return x.GetGetFoo
		}
	}
	return 0
}

func (x *M9) GetGetFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_GetGetGetFoo_.(*m9_GetFoo_); ok {
			return x.GetFoo_
		}
	}
	return 0
}

func (x *M9) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M9) SetGetGetFoo(v int32) {
	x.xxx_hidden_GetGetGetFoo_ = &m9_GetGetFoo{v}
}

func (x *M9) SetGetFoo(v int32) {
	x.xxx_hidden_GetGetGetFoo_ = &m9_GetFoo_{v}
}

func (x *M9) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M9) HasGetGetGetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_GetGetGetFoo_ != nil
}

func (x *M9) HasGetGetFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_GetGetGetFoo_.(*m9_GetGetFoo)
	return ok
}

func (x *M9) HasGetFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_GetGetGetFoo_.(*m9_GetFoo_)
	return ok
}

func (x *M9) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M9) ClearGetGetGetFoo() {
	x.xxx_hidden_GetGetGetFoo_ = nil
}

func (x *M9) ClearGetGetFoo() {
	if _, ok := x.xxx_hidden_GetGetGetFoo_.(*m9_GetGetFoo); ok {
		x.xxx_hidden_GetGetGetFoo_ = nil
	}
}

func (x *M9) ClearGetFoo() {
	if _, ok := x.xxx_hidden_GetGetGetFoo_.(*m9_GetFoo_); ok {
		x.xxx_hidden_GetGetGetFoo_ = nil
	}
}

func (x *M9) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

const M9_GetGetGetFoo__not_set_case case_M9_GetGetGetFoo_ = 0
const M9_GetGetFoo_case case_M9_GetGetGetFoo_ = 3
const M9_GetFoo__case case_M9_GetGetGetFoo_ = 2

func (x *M9) WhichGetGetGetFoo() case_M9_GetGetGetFoo_ {
	if x == nil {
		return M9_GetGetGetFoo__not_set_case
	}
	switch x.xxx_hidden_GetGetGetFoo_.(type) {
	case *m9_GetGetFoo:
		return M9_GetGetFoo_case
	case *m9_GetFoo_:
		return M9_GetFoo__case
	default:
		return M9_GetGetGetFoo__not_set_case
	}
}

type M9_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Note evaluation order - get_get_foo before get_get_get_foo, then get_foo
	// initial name in Go     | Clashes with field | type | final name
	// GetGetGetFoo           | get_get_foo        | 1    | GetGetGetFoo_
	//  GetGetFoo             | -                  | -    | GetGetFoo
	//  GetFoo                | get_get_foo        | 2    | GetFoo_
	//                        |                    |      |
	// Foo                    | -                  | -    | Foo
	// New Scheme:
	// initial name in Go     | Clashes with field | type | Getter name
	// Foo                    | get_foo            | G    | Get_Foo
	// GetFoo                 | get_get_foo        | G    | Get_GetFoo
	// GetGetFoo              | get_get_get_foo    | G    | Get_GetGetFoo

	// Fields of oneof xxx_hidden_GetGetGetFoo_:
	GetGetFoo *int32
	GetFoo    *int32
	// -- end of xxx_hidden_GetGetGetFoo_
	Foo *M0
}

func (b0 M9_builder) Build() *M9 {
	m0 := &M9{}
	b, x := &b0, m0
	_, _ = b, x
	if b.GetGetFoo != nil {
		x.xxx_hidden_GetGetGetFoo_ = &m9_GetGetFoo{*b.GetGetFoo}
	}
	if b.GetFoo != nil {
		x.xxx_hidden_GetGetGetFoo_ = &m9_GetFoo_{*b.GetFoo}
	}
	x.xxx_hidden_Foo = b.Foo
	return m0
}

type case_M9_GetGetGetFoo_ protoreflect.FieldNumber

func (x case_M9_GetGetGetFoo_) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[9].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM9_GetGetGetFoo_ interface {
	isM9_GetGetGetFoo_()
}

type m9_GetGetFoo struct {
	GetGetFoo int32 `protobuf:"varint,3,opt,name=get_get_foo,json=getGetFoo,proto3,oneof"`
}

type m9_GetFoo_ struct {
	GetFoo_ int32 `protobuf:"varint,2,opt,name=get_foo,json=getFoo,proto3,oneof"`
}

func (*m9_GetGetFoo) isM9_GetGetGetFoo_() {}

func (*m9_GetFoo_) isM9_GetGetGetFoo_() {}

type M10 struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo    *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_SetFoo *M0                    `protobuf:"bytes,2,opt,name=set_foo,json=setFoo,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *M10) Reset() {
	*x = M10{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M10) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M10) ProtoMessage() {}

func (x *M10) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M10) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M10) GetSetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_SetFoo
	}
	return nil
}

func (x *M10) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M10) SetSetFoo(v *M0) {
	x.xxx_hidden_SetFoo = v
}

func (x *M10) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M10) HasSetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_SetFoo != nil
}

func (x *M10) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M10) ClearSetFoo() {
	x.xxx_hidden_SetFoo = nil
}

type M10_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Set Clashes - no concerns with get-mangling as legacy open struct
	// does not have setters except for weak fields:
	// initial name in Go     | Clashes with field | Setter name
	// Foo                    | set_foo            | Set_Foo
	// SetFoo                 | -                  | SetSetFoo
	Foo    *M0
	SetFoo *M0
}

func (b0 M10_builder) Build() *M10 {
	m0 := &M10{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	x.xxx_hidden_SetFoo = b.SetFoo
	return m0
}

type M11 struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo    *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_SetFoo isM11_SetFoo           `protobuf_oneof:"set_foo"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *M11) Reset() {
	*x = M11{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M11) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M11) ProtoMessage() {}

func (x *M11) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M11) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M11) GetSetSetFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_SetFoo.(*m11_SetSetFoo); ok {
			return x.SetSetFoo
		}
	}
	return 0
}

func (x *M11) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M11) SetSetSetFoo(v int32) {
	x.xxx_hidden_SetFoo = &m11_SetSetFoo{v}
}

func (x *M11) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M11) HasSetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_SetFoo != nil
}

func (x *M11) HasSetSetFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_SetFoo.(*m11_SetSetFoo)
	return ok
}

func (x *M11) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M11) ClearSetFoo() {
	x.xxx_hidden_SetFoo = nil
}

func (x *M11) ClearSetSetFoo() {
	if _, ok := x.xxx_hidden_SetFoo.(*m11_SetSetFoo); ok {
		x.xxx_hidden_SetFoo = nil
	}
}

const M11_SetFoo_not_set_case case_M11_SetFoo = 0
const M11_SetSetFoo_case case_M11_SetFoo = 2

func (x *M11) WhichSetFoo() case_M11_SetFoo {
	if x == nil {
		return M11_SetFoo_not_set_case
	}
	switch x.xxx_hidden_SetFoo.(type) {
	case *m11_SetSetFoo:
		return M11_SetSetFoo_case
	default:
		return M11_SetFoo_not_set_case
	}
}

type M11_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Set Clashes - no concerns with get-mangling as legacy open struct
	// does not have setters except for weak fields:
	// initial name in Go     | Clashes with field | Setter name
	// Foo                    | set_foo            | Set_Foo
	// SetSetFoo              | -                  | SetSetSetFoo
	Foo *M0
	// Fields of oneof xxx_hidden_SetFoo:
	SetSetFoo *int32
	// -- end of xxx_hidden_SetFoo
}

func (b0 M11_builder) Build() *M11 {
	m0 := &M11{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	if b.SetSetFoo != nil {
		x.xxx_hidden_SetFoo = &m11_SetSetFoo{*b.SetSetFoo}
	}
	return m0
}

type case_M11_SetFoo protoreflect.FieldNumber

func (x case_M11_SetFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[11].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM11_SetFoo interface {
	isM11_SetFoo()
}

type m11_SetSetFoo struct {
	SetSetFoo int32 `protobuf:"varint,2,opt,name=set_set_foo,json=setSetFoo,proto3,oneof"`
}

func (*m11_SetSetFoo) isM11_SetFoo() {}

type M12 struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo       *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_SetSetFoo isM12_SetSetFoo        `protobuf_oneof:"set_set_foo"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *M12) Reset() {
	*x = M12{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M12) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M12) ProtoMessage() {}

func (x *M12) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M12) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M12) GetSetFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_SetSetFoo.(*m12_SetFoo); ok {
			return x.SetFoo
		}
	}
	return 0
}

func (x *M12) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M12) SetSetFoo(v int32) {
	x.xxx_hidden_SetSetFoo = &m12_SetFoo{v}
}

func (x *M12) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M12) HasSetSetFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_SetSetFoo != nil
}

func (x *M12) HasSetFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_SetSetFoo.(*m12_SetFoo)
	return ok
}

func (x *M12) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M12) ClearSetSetFoo() {
	x.xxx_hidden_SetSetFoo = nil
}

func (x *M12) ClearSetFoo() {
	if _, ok := x.xxx_hidden_SetSetFoo.(*m12_SetFoo); ok {
		x.xxx_hidden_SetSetFoo = nil
	}
}

const M12_SetSetFoo_not_set_case case_M12_SetSetFoo = 0
const M12_SetFoo_case case_M12_SetSetFoo = 2

func (x *M12) WhichSetSetFoo() case_M12_SetSetFoo {
	if x == nil {
		return M12_SetSetFoo_not_set_case
	}
	switch x.xxx_hidden_SetSetFoo.(type) {
	case *m12_SetFoo:
		return M12_SetFoo_case
	default:
		return M12_SetSetFoo_not_set_case
	}
}

type M12_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Set Clashes - no concerns with get-mangling as legacy open struct
	// does not have setters except for weak fields:
	// initial name in Go     | Clashes with field | Setter name
	// Foo                    | set_foo            | Set_Foo
	// SetFoo                 | set_set_foo        | Set_SetFoo
	Foo *M0
	// Fields of oneof xxx_hidden_SetSetFoo:
	SetFoo *int32
	// -- end of xxx_hidden_SetSetFoo
}

func (b0 M12_builder) Build() *M12 {
	m0 := &M12{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	if b.SetFoo != nil {
		x.xxx_hidden_SetSetFoo = &m12_SetFoo{*b.SetFoo}
	}
	return m0
}

type case_M12_SetSetFoo protoreflect.FieldNumber

func (x case_M12_SetSetFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[12].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM12_SetSetFoo interface {
	isM12_SetSetFoo()
}

type m12_SetFoo struct {
	SetFoo int32 `protobuf:"varint,2,opt,name=set_foo,json=setFoo,proto3,oneof"`
}

func (*m12_SetFoo) isM12_SetSetFoo() {}

type M13 struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo    *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_HasFoo *M0                    `protobuf:"bytes,2,opt,name=has_foo,json=hasFoo,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *M13) Reset() {
	*x = M13{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M13) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M13) ProtoMessage() {}

func (x *M13) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M13) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M13) GetHasFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_HasFoo
	}
	return nil
}

func (x *M13) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M13) SetHasFoo(v *M0) {
	x.xxx_hidden_HasFoo = v
}

func (x *M13) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M13) HasHasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_HasFoo != nil
}

func (x *M13) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M13) ClearHasFoo() {
	x.xxx_hidden_HasFoo = nil
}

type M13_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Has Clashes - no concerns with get-mangling as legacy open struct
	// does not have hassers except for weak fields:
	// initial name in Go     | Clashes with field | Hasser name
	// Foo                    | has_foo            | Has_Foo
	// HasFoo                 | -                  | HasHasFoo
	Foo    *M0
	HasFoo *M0
}

func (b0 M13_builder) Build() *M13 {
	m0 := &M13{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	x.xxx_hidden_HasFoo = b.HasFoo
	return m0
}

type M14 struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo    *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_HasFoo isM14_HasFoo           `protobuf_oneof:"has_foo"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *M14) Reset() {
	*x = M14{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M14) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M14) ProtoMessage() {}

func (x *M14) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M14) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M14) GetHasHasFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_HasFoo.(*m14_HasHasFoo); ok {
			return x.HasHasFoo
		}
	}
	return 0
}

func (x *M14) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M14) SetHasHasFoo(v int32) {
	x.xxx_hidden_HasFoo = &m14_HasHasFoo{v}
}

func (x *M14) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M14) HasHasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_HasFoo != nil
}

func (x *M14) HasHasHasFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_HasFoo.(*m14_HasHasFoo)
	return ok
}

func (x *M14) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M14) ClearHasFoo() {
	x.xxx_hidden_HasFoo = nil
}

func (x *M14) ClearHasHasFoo() {
	if _, ok := x.xxx_hidden_HasFoo.(*m14_HasHasFoo); ok {
		x.xxx_hidden_HasFoo = nil
	}
}

const M14_HasFoo_not_set_case case_M14_HasFoo = 0
const M14_HasHasFoo_case case_M14_HasFoo = 2

func (x *M14) WhichHasFoo() case_M14_HasFoo {
	if x == nil {
		return M14_HasFoo_not_set_case
	}
	switch x.xxx_hidden_HasFoo.(type) {
	case *m14_HasHasFoo:
		return M14_HasHasFoo_case
	default:
		return M14_HasFoo_not_set_case
	}
}

type M14_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Has Clashes - no concerns with get-mangling as legacy open struct
	// does not have hassers except for weak fields:
	// initial name in Go     | Clashes with field | Hasser name
	// Foo                    | has_foo            | Has_Foo
	// HasFoo                 | has_has_foo        | Has_HasFoo
	// HasHasFoo              | -                  | HasHasHasFoo
	Foo *M0
	// Fields of oneof xxx_hidden_HasFoo:
	HasHasFoo *int32
	// -- end of xxx_hidden_HasFoo
}

func (b0 M14_builder) Build() *M14 {
	m0 := &M14{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	if b.HasHasFoo != nil {
		x.xxx_hidden_HasFoo = &m14_HasHasFoo{*b.HasHasFoo}
	}
	return m0
}

type case_M14_HasFoo protoreflect.FieldNumber

func (x case_M14_HasFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[14].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM14_HasFoo interface {
	isM14_HasFoo()
}

type m14_HasHasFoo struct {
	HasHasFoo int32 `protobuf:"varint,2,opt,name=has_has_foo,json=hasHasFoo,proto3,oneof"`
}

func (*m14_HasHasFoo) isM14_HasFoo() {}

type M15 struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo       *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_HasHasFoo isM15_HasHasFoo        `protobuf_oneof:"has_has_foo"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *M15) Reset() {
	*x = M15{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M15) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M15) ProtoMessage() {}

func (x *M15) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M15) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M15) GetHasFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_HasHasFoo.(*m15_HasFoo); ok {
			return x.HasFoo
		}
	}
	return 0
}

func (x *M15) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M15) SetHasFoo(v int32) {
	x.xxx_hidden_HasHasFoo = &m15_HasFoo{v}
}

func (x *M15) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M15) HasHasHasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_HasHasFoo != nil
}

func (x *M15) HasHasFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_HasHasFoo.(*m15_HasFoo)
	return ok
}

func (x *M15) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M15) ClearHasHasFoo() {
	x.xxx_hidden_HasHasFoo = nil
}

func (x *M15) ClearHasFoo() {
	if _, ok := x.xxx_hidden_HasHasFoo.(*m15_HasFoo); ok {
		x.xxx_hidden_HasHasFoo = nil
	}
}

const M15_HasHasFoo_not_set_case case_M15_HasHasFoo = 0
const M15_HasFoo_case case_M15_HasHasFoo = 2

func (x *M15) WhichHasHasFoo() case_M15_HasHasFoo {
	if x == nil {
		return M15_HasHasFoo_not_set_case
	}
	switch x.xxx_hidden_HasHasFoo.(type) {
	case *m15_HasFoo:
		return M15_HasFoo_case
	default:
		return M15_HasHasFoo_not_set_case
	}
}

type M15_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Has Clashes - no concerns with get-mangling as legacy open struct
	// does not have hassers except for weak fields:
	// initial name in Go     | Clashes with field | Hasser name
	// Foo                    | has_foo            | Has_Foo
	// HasFoo                 | has_has_foo        | Has_HasFoo
	// HasHasFoo              | -                  | HasHasHasFoo
	Foo *M0
	// Fields of oneof xxx_hidden_HasHasFoo:
	HasFoo *int32
	// -- end of xxx_hidden_HasHasFoo
}

func (b0 M15_builder) Build() *M15 {
	m0 := &M15{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	if b.HasFoo != nil {
		x.xxx_hidden_HasHasFoo = &m15_HasFoo{*b.HasFoo}
	}
	return m0
}

type case_M15_HasHasFoo protoreflect.FieldNumber

func (x case_M15_HasHasFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[15].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM15_HasHasFoo interface {
	isM15_HasHasFoo()
}

type m15_HasFoo struct {
	HasFoo int32 `protobuf:"varint,2,opt,name=has_foo,json=hasFoo,proto3,oneof"`
}

func (*m15_HasFoo) isM15_HasHasFoo() {}

type M16 struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo      *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_ClearFoo *M0                    `protobuf:"bytes,2,opt,name=clear_foo,json=clearFoo,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *M16) Reset() {
	*x = M16{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M16) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M16) ProtoMessage() {}

func (x *M16) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M16) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M16) GetClearFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_ClearFoo
	}
	return nil
}

func (x *M16) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M16) SetClearFoo(v *M0) {
	x.xxx_hidden_ClearFoo = v
}

func (x *M16) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M16) HasClearFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ClearFoo != nil
}

func (x *M16) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M16) ClearClearFoo() {
	x.xxx_hidden_ClearFoo = nil
}

type M16_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Clear Clashes - no concerns with get-mangling as legacy open
	// struct does not have clearers except for weak fields:
	// initial name in Go     | Clashes with field | Clearer name
	// Foo                    | clear_foo            | Clear_Foo
	// ClearFoo               | -                  | ClearClearFoo
	Foo      *M0
	ClearFoo *M0
}

func (b0 M16_builder) Build() *M16 {
	m0 := &M16{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	x.xxx_hidden_ClearFoo = b.ClearFoo
	return m0
}

type M17 struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo      *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_ClearFoo isM17_ClearFoo         `protobuf_oneof:"clear_foo"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *M17) Reset() {
	*x = M17{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M17) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M17) ProtoMessage() {}

func (x *M17) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M17) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M17) GetClearClearFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_ClearFoo.(*m17_ClearClearFoo); ok {
			return x.ClearClearFoo
		}
	}
	return 0
}

func (x *M17) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M17) SetClearClearFoo(v int32) {
	x.xxx_hidden_ClearFoo = &m17_ClearClearFoo{v}
}

func (x *M17) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M17) HasClearFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ClearFoo != nil
}

func (x *M17) HasClearClearFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_ClearFoo.(*m17_ClearClearFoo)
	return ok
}

func (x *M17) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M17) ClearClearFoo() {
	x.xxx_hidden_ClearFoo = nil
}

func (x *M17) ClearClearClearFoo() {
	if _, ok := x.xxx_hidden_ClearFoo.(*m17_ClearClearFoo); ok {
		x.xxx_hidden_ClearFoo = nil
	}
}

const M17_ClearFoo_not_set_case case_M17_ClearFoo = 0
const M17_ClearClearFoo_case case_M17_ClearFoo = 2

func (x *M17) WhichClearFoo() case_M17_ClearFoo {
	if x == nil {
		return M17_ClearFoo_not_set_case
	}
	switch x.xxx_hidden_ClearFoo.(type) {
	case *m17_ClearClearFoo:
		return M17_ClearClearFoo_case
	default:
		return M17_ClearFoo_not_set_case
	}
}

type M17_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Clear Clashes - no concerns with get-mangling as legacy open
	// struct does not have clearers except for weak fields:
	// initial name in Go     | Clashes with field | Clearer name
	// Foo                    | clear_foo          | Clear_Foo
	// ClearFoo               | clear_clear_foo    | Clear_ClearFoo
	// ClearClearFoo          | -                  | ClearClearClearFoo
	Foo *M0
	// Fields of oneof xxx_hidden_ClearFoo:
	ClearClearFoo *int32
	// -- end of xxx_hidden_ClearFoo
}

func (b0 M17_builder) Build() *M17 {
	m0 := &M17{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	if b.ClearClearFoo != nil {
		x.xxx_hidden_ClearFoo = &m17_ClearClearFoo{*b.ClearClearFoo}
	}
	return m0
}

type case_M17_ClearFoo protoreflect.FieldNumber

func (x case_M17_ClearFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[17].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM17_ClearFoo interface {
	isM17_ClearFoo()
}

type m17_ClearClearFoo struct {
	ClearClearFoo int32 `protobuf:"varint,2,opt,name=clear_clear_foo,json=clearClearFoo,proto3,oneof"`
}

func (*m17_ClearClearFoo) isM17_ClearFoo() {}

type M18 struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo           *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_ClearClearFoo isM18_ClearClearFoo    `protobuf_oneof:"clear_clear_foo"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *M18) Reset() {
	*x = M18{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M18) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M18) ProtoMessage() {}

func (x *M18) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M18) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M18) GetClearFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_ClearClearFoo.(*m18_ClearFoo); ok {
			return x.ClearFoo
		}
	}
	return 0
}

func (x *M18) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M18) SetClearFoo(v int32) {
	x.xxx_hidden_ClearClearFoo = &m18_ClearFoo{v}
}

func (x *M18) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M18) HasClearClearFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ClearClearFoo != nil
}

func (x *M18) HasClearFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_ClearClearFoo.(*m18_ClearFoo)
	return ok
}

func (x *M18) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M18) ClearClearClearFoo() {
	x.xxx_hidden_ClearClearFoo = nil
}

func (x *M18) ClearClearFoo() {
	if _, ok := x.xxx_hidden_ClearClearFoo.(*m18_ClearFoo); ok {
		x.xxx_hidden_ClearClearFoo = nil
	}
}

const M18_ClearClearFoo_not_set_case case_M18_ClearClearFoo = 0
const M18_ClearFoo_case case_M18_ClearClearFoo = 2

func (x *M18) WhichClearClearFoo() case_M18_ClearClearFoo {
	if x == nil {
		return M18_ClearClearFoo_not_set_case
	}
	switch x.xxx_hidden_ClearClearFoo.(type) {
	case *m18_ClearFoo:
		return M18_ClearFoo_case
	default:
		return M18_ClearClearFoo_not_set_case
	}
}

type M18_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Clear Clashes - no concerns with get-mangling as legacy open
	// struct does not have clearers except for weak fields:
	// initial name in Go     | Clashes with field | Clearer name
	// Foo                    | clear_foo          | Clear_Foo
	// ClearFoo               | clear_clear_foo    | Clear_ClearFoo
	// ClearClearFoo          | -                  | ClearClearClearFoo
	Foo *M0
	// Fields of oneof xxx_hidden_ClearClearFoo:
	ClearFoo *int32
	// -- end of xxx_hidden_ClearClearFoo
}

func (b0 M18_builder) Build() *M18 {
	m0 := &M18{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	if b.ClearFoo != nil {
		x.xxx_hidden_ClearClearFoo = &m18_ClearFoo{*b.ClearFoo}
	}
	return m0
}

type case_M18_ClearClearFoo protoreflect.FieldNumber

func (x case_M18_ClearClearFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[18].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM18_ClearClearFoo interface {
	isM18_ClearClearFoo()
}

type m18_ClearFoo struct {
	ClearFoo int32 `protobuf:"varint,2,opt,name=clear_foo,json=clearFoo,proto3,oneof"`
}

func (*m18_ClearFoo) isM18_ClearClearFoo() {}

type M19 struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo           *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_WhichWhichFoo isM19_WhichWhichFoo    `protobuf_oneof:"which_which_foo"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *M19) Reset() {
	*x = M19{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M19) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M19) ProtoMessage() {}

func (x *M19) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M19) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M19) GetWhichFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_WhichWhichFoo.(*m19_WhichFoo); ok {
			return x.WhichFoo
		}
	}
	return 0
}

func (x *M19) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M19) SetWhichFoo(v int32) {
	x.xxx_hidden_WhichWhichFoo = &m19_WhichFoo{v}
}

func (x *M19) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M19) HasWhichWhichFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_WhichWhichFoo != nil
}

func (x *M19) HasWhichFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_WhichWhichFoo.(*m19_WhichFoo)
	return ok
}

func (x *M19) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M19) ClearWhichWhichFoo() {
	x.xxx_hidden_WhichWhichFoo = nil
}

func (x *M19) ClearWhichFoo() {
	if _, ok := x.xxx_hidden_WhichWhichFoo.(*m19_WhichFoo); ok {
		x.xxx_hidden_WhichWhichFoo = nil
	}
}

const M19_WhichWhichFoo_not_set_case case_M19_WhichWhichFoo = 0
const M19_WhichFoo_case case_M19_WhichWhichFoo = 2

func (x *M19) WhichWhichWhichFoo() case_M19_WhichWhichFoo {
	if x == nil {
		return M19_WhichWhichFoo_not_set_case
	}
	switch x.xxx_hidden_WhichWhichFoo.(type) {
	case *m19_WhichFoo:
		return M19_WhichFoo_case
	default:
		return M19_WhichWhichFoo_not_set_case
	}
}

type M19_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Which Clashes - no concerns with get-mangling as legacy open
	// struct does not have whichers except for weak fields:
	// initial name in Go     | Clashes with field | Whicher name
	// Foo                    | -                  | -
	// WhichFoo               | -                  | -
	// WhichWhichFoo          | -                  | WhichWhichWhichFoo
	Foo *M0
	// Fields of oneof xxx_hidden_WhichWhichFoo:
	WhichFoo *int32
	// -- end of xxx_hidden_WhichWhichFoo
}

func (b0 M19_builder) Build() *M19 {
	m0 := &M19{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	if b.WhichFoo != nil {
		x.xxx_hidden_WhichWhichFoo = &m19_WhichFoo{*b.WhichFoo}
	}
	return m0
}

type case_M19_WhichWhichFoo protoreflect.FieldNumber

func (x case_M19_WhichWhichFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[19].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM19_WhichWhichFoo interface {
	isM19_WhichWhichFoo()
}

type m19_WhichFoo struct {
	WhichFoo int32 `protobuf:"varint,2,opt,name=which_foo,json=whichFoo,proto3,oneof"`
}

func (*m19_WhichFoo) isM19_WhichWhichFoo() {}

type M20 struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Foo      *M0                    `protobuf:"bytes,1,opt,name=foo,proto3"`
	xxx_hidden_WhichFoo isM20_WhichFoo         `protobuf_oneof:"which_foo"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *M20) Reset() {
	*x = M20{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M20) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M20) ProtoMessage() {}

func (x *M20) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M20) GetFoo() *M0 {
	if x != nil {
		return x.xxx_hidden_Foo
	}
	return nil
}

func (x *M20) GetWhichWhichFoo() int32 {
	if x != nil {
		if x, ok := x.xxx_hidden_WhichFoo.(*m20_WhichWhichFoo); ok {
			return x.WhichWhichFoo
		}
	}
	return 0
}

func (x *M20) SetFoo(v *M0) {
	x.xxx_hidden_Foo = v
}

func (x *M20) SetWhichWhichFoo(v int32) {
	x.xxx_hidden_WhichFoo = &m20_WhichWhichFoo{v}
}

func (x *M20) HasFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Foo != nil
}

func (x *M20) HasWhichFoo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_WhichFoo != nil
}

func (x *M20) HasWhichWhichFoo() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_WhichFoo.(*m20_WhichWhichFoo)
	return ok
}

func (x *M20) ClearFoo() {
	x.xxx_hidden_Foo = nil
}

func (x *M20) ClearWhichFoo() {
	x.xxx_hidden_WhichFoo = nil
}

func (x *M20) ClearWhichWhichFoo() {
	if _, ok := x.xxx_hidden_WhichFoo.(*m20_WhichWhichFoo); ok {
		x.xxx_hidden_WhichFoo = nil
	}
}

const M20_WhichFoo_not_set_case case_M20_WhichFoo = 0
const M20_WhichWhichFoo_case case_M20_WhichFoo = 2

func (x *M20) WhichWhichFoo() case_M20_WhichFoo {
	if x == nil {
		return M20_WhichFoo_not_set_case
	}
	switch x.xxx_hidden_WhichFoo.(type) {
	case *m20_WhichWhichFoo:
		return M20_WhichWhichFoo_case
	default:
		return M20_WhichFoo_not_set_case
	}
}

type M20_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Which Clashes - no concerns with get-mangling as legacy open
	// struct does not have whichers except for weak fields:
	// initial name in Go     | Clashes with field | Whicher name
	// Foo                    | -                  | -
	// WhichFoo               | which_which_foo    | Which_WhichFoo
	// WhichWhichFoo          | -                  | -
	Foo *M0
	// Fields of oneof xxx_hidden_WhichFoo:
	WhichWhichFoo *int32
	// -- end of xxx_hidden_WhichFoo
}

func (b0 M20_builder) Build() *M20 {
	m0 := &M20{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Foo = b.Foo
	if b.WhichWhichFoo != nil {
		x.xxx_hidden_WhichFoo = &m20_WhichWhichFoo{*b.WhichWhichFoo}
	}
	return m0
}

type case_M20_WhichFoo protoreflect.FieldNumber

func (x case_M20_WhichFoo) String() string {
	md := file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[20].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isM20_WhichFoo interface {
	isM20_WhichFoo()
}

type m20_WhichWhichFoo struct {
	WhichWhichFoo int32 `protobuf:"varint,2,opt,name=which_which_foo,json=whichWhichFoo,proto3,oneof"`
}

func (*m20_WhichWhichFoo) isM20_WhichFoo() {}

type M21 struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_XFoo      string                 `protobuf:"bytes,1,opt,name=_foo,json=Foo,proto3"`
	xxx_hidden_XFoo_     string                 `protobuf:"bytes,2,opt,name=X_foo,json=XFoo,proto3"`
	xxx_hidden_GetXFoo__ string                 `protobuf:"bytes,3,opt,name=get_x_foo,json=getXFoo,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *M21) Reset() {
	*x = M21{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M21) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M21) ProtoMessage() {}

func (x *M21) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *M21) GetXFoo_1() string {
	if x != nil {
		return x.xxx_hidden_XFoo
	}
	return ""
}

func (x *M21) GetXFoo_2() string {
	if x != nil {
		return x.xxx_hidden_XFoo_
	}
	return ""
}

func (x *M21) GetGetXFoo() string {
	if x != nil {
		return x.xxx_hidden_GetXFoo__
	}
	return ""
}

func (x *M21) SetXFoo_1(v string) {
	x.xxx_hidden_XFoo = v
}

func (x *M21) SetXFoo_2(v string) {
	x.xxx_hidden_XFoo_ = v
}

func (x *M21) SetGetXFoo(v string) {
	x.xxx_hidden_GetXFoo__ = v
}

type M21_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	XFoo_1  string
	XFoo_2  string
	GetXFoo string
}

func (b0 M21_builder) Build() *M21 {
	m0 := &M21{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_XFoo = b.XFoo_1
	x.xxx_hidden_XFoo_ = b.XFoo_2
	x.xxx_hidden_GetXFoo__ = b.GetXFoo
	return m0
}

var File_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto protoreflect.FileDescriptor

const file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_rawDesc = "" +
	"\n" +
	"Bcmd/protoc-gen-go/testdata/nameclash/test_name_clash_opaque3.proto\x12'net.proto2.go.testdata.nameclashopaque3\x1a!google/protobuf/go_features.proto\"\x14\n" +
	"\x02M0\x12\x0e\n" +
	"\x02i1\x18\x01 \x01(\x05R\x02i1\"\xd6\x01\n" +
	"\x02M1\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12D\n" +
	"\aget_foo\x18\x02 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x06getFoo\x12K\n" +
	"\vget_get_foo\x18\x03 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\tgetGetFoo\"\xd6\x01\n" +
	"\x02M2\x12K\n" +
	"\vget_get_foo\x18\x03 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\tgetGetFoo\x12D\n" +
	"\aget_foo\x18\x02 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x06getFoo\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\"\xd6\x01\n" +
	"\x02M3\x12D\n" +
	"\aget_foo\x18\x02 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x06getFoo\x12K\n" +
	"\vget_get_foo\x18\x03 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\tgetGetFoo\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\"\xc1\x01\n" +
	"\x02M4\x12D\n" +
	"\aget_foo\x18\x02 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x06getFoo\x12'\n" +
	"\x0fget_get_get_foo\x18\x03 \x01(\x05H\x00R\fgetGetGetFoo\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03fooB\r\n" +
	"\vget_get_foo\"\xbe\x01\n" +
	"\x02M5\x12D\n" +
	"\aget_foo\x18\x02 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x06getFoo\x12 \n" +
	"\vget_get_foo\x18\x03 \x01(\x05H\x00R\tgetGetFoo\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03fooB\x11\n" +
	"\x0fget_get_get_foo\"\xc1\x01\n" +
	"\x02M6\x12'\n" +
	"\x0fget_get_get_foo\x18\x03 \x01(\x05H\x00R\fgetGetGetFoo\x12D\n" +
	"\aget_foo\x18\x02 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x06getFoo\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03fooB\r\n" +
	"\vget_get_foo\"\x81\x01\n" +
	"\x02M7\x12\x12\n" +
	"\x03bar\x18\x04 \x01(\bH\x00R\x03bar\x12\x19\n" +
	"\aget_foo\x18\x03 \x01(\x05H\x00R\x06getFoo\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03fooB\r\n" +
	"\vget_get_foo\"\xbe\x01\n" +
	"\x02M8\x12 \n" +
	"\vget_get_foo\x18\x03 \x01(\x05H\x00R\tgetGetFoo\x12D\n" +
	"\aget_foo\x18\x02 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x06getFoo\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03fooB\x11\n" +
	"\x0fget_get_get_foo\"\x93\x01\n" +
	"\x02M9\x12 \n" +
	"\vget_get_foo\x18\x03 \x01(\x05H\x00R\tgetGetFoo\x12\x19\n" +
	"\aget_foo\x18\x02 \x01(\x05H\x00R\x06getFoo\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03fooB\x11\n" +
	"\x0fget_get_get_foo\"\x8a\x01\n" +
	"\x03M10\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12D\n" +
	"\aset_foo\x18\x02 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x06setFoo\"q\n" +
	"\x03M11\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12 \n" +
	"\vset_set_foo\x18\x02 \x01(\x05H\x00R\tsetSetFooB\t\n" +
	"\aset_foo\"n\n" +
	"\x03M12\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12\x19\n" +
	"\aset_foo\x18\x02 \x01(\x05H\x00R\x06setFooB\r\n" +
	"\vset_set_foo\"\x8a\x01\n" +
	"\x03M13\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12D\n" +
	"\ahas_foo\x18\x02 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x06hasFoo\"q\n" +
	"\x03M14\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12 \n" +
	"\vhas_has_foo\x18\x02 \x01(\x05H\x00R\thasHasFooB\t\n" +
	"\ahas_foo\"n\n" +
	"\x03M15\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12\x19\n" +
	"\ahas_foo\x18\x02 \x01(\x05H\x00R\x06hasFooB\r\n" +
	"\vhas_has_foo\"\x8e\x01\n" +
	"\x03M16\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12H\n" +
	"\tclear_foo\x18\x02 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\bclearFoo\"{\n" +
	"\x03M17\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12(\n" +
	"\x0fclear_clear_foo\x18\x02 \x01(\x05H\x00R\rclearClearFooB\v\n" +
	"\tclear_foo\"v\n" +
	"\x03M18\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12\x1d\n" +
	"\tclear_foo\x18\x02 \x01(\x05H\x00R\bclearFooB\x11\n" +
	"\x0fclear_clear_foo\"v\n" +
	"\x03M19\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12\x1d\n" +
	"\twhich_foo\x18\x02 \x01(\x05H\x00R\bwhichFooB\x11\n" +
	"\x0fwhich_which_foo\"{\n" +
	"\x03M20\x12=\n" +
	"\x03foo\x18\x01 \x01(\v2+.net.proto2.go.testdata.nameclashopaque3.M0R\x03foo\x12(\n" +
	"\x0fwhich_which_foo\x18\x02 \x01(\x05H\x00R\rwhichWhichFooB\v\n" +
	"\twhich_foo\"I\n" +
	"\x03M21\x12\x11\n" +
	"\x04_foo\x18\x01 \x01(\tR\x03Foo\x12\x13\n" +
	"\x05X_foo\x18\x02 \x01(\tR\x04XFoo\x12\x1a\n" +
	"\tget_x_foo\x18\x03 \x01(\tR\agetXFooBYZWgoogle.golang.org/protobuf/cmd/protoc-gen-go/testdata/nameclash/test_name_clash_opaque3b\x06proto3"

var file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_goTypes = []any{
	(*M0)(nil),  // 0: net.proto2.go.testdata.nameclashopaque3.M0
	(*M1)(nil),  // 1: net.proto2.go.testdata.nameclashopaque3.M1
	(*M2)(nil),  // 2: net.proto2.go.testdata.nameclashopaque3.M2
	(*M3)(nil),  // 3: net.proto2.go.testdata.nameclashopaque3.M3
	(*M4)(nil),  // 4: net.proto2.go.testdata.nameclashopaque3.M4
	(*M5)(nil),  // 5: net.proto2.go.testdata.nameclashopaque3.M5
	(*M6)(nil),  // 6: net.proto2.go.testdata.nameclashopaque3.M6
	(*M7)(nil),  // 7: net.proto2.go.testdata.nameclashopaque3.M7
	(*M8)(nil),  // 8: net.proto2.go.testdata.nameclashopaque3.M8
	(*M9)(nil),  // 9: net.proto2.go.testdata.nameclashopaque3.M9
	(*M10)(nil), // 10: net.proto2.go.testdata.nameclashopaque3.M10
	(*M11)(nil), // 11: net.proto2.go.testdata.nameclashopaque3.M11
	(*M12)(nil), // 12: net.proto2.go.testdata.nameclashopaque3.M12
	(*M13)(nil), // 13: net.proto2.go.testdata.nameclashopaque3.M13
	(*M14)(nil), // 14: net.proto2.go.testdata.nameclashopaque3.M14
	(*M15)(nil), // 15: net.proto2.go.testdata.nameclashopaque3.M15
	(*M16)(nil), // 16: net.proto2.go.testdata.nameclashopaque3.M16
	(*M17)(nil), // 17: net.proto2.go.testdata.nameclashopaque3.M17
	(*M18)(nil), // 18: net.proto2.go.testdata.nameclashopaque3.M18
	(*M19)(nil), // 19: net.proto2.go.testdata.nameclashopaque3.M19
	(*M20)(nil), // 20: net.proto2.go.testdata.nameclashopaque3.M20
	(*M21)(nil), // 21: net.proto2.go.testdata.nameclashopaque3.M21
}
var file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_depIdxs = []int32{
	0,  // 0: net.proto2.go.testdata.nameclashopaque3.M1.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 1: net.proto2.go.testdata.nameclashopaque3.M1.get_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 2: net.proto2.go.testdata.nameclashopaque3.M1.get_get_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 3: net.proto2.go.testdata.nameclashopaque3.M2.get_get_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 4: net.proto2.go.testdata.nameclashopaque3.M2.get_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 5: net.proto2.go.testdata.nameclashopaque3.M2.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 6: net.proto2.go.testdata.nameclashopaque3.M3.get_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 7: net.proto2.go.testdata.nameclashopaque3.M3.get_get_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 8: net.proto2.go.testdata.nameclashopaque3.M3.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 9: net.proto2.go.testdata.nameclashopaque3.M4.get_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 10: net.proto2.go.testdata.nameclashopaque3.M4.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 11: net.proto2.go.testdata.nameclashopaque3.M5.get_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 12: net.proto2.go.testdata.nameclashopaque3.M5.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 13: net.proto2.go.testdata.nameclashopaque3.M6.get_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 14: net.proto2.go.testdata.nameclashopaque3.M6.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 15: net.proto2.go.testdata.nameclashopaque3.M7.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 16: net.proto2.go.testdata.nameclashopaque3.M8.get_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 17: net.proto2.go.testdata.nameclashopaque3.M8.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 18: net.proto2.go.testdata.nameclashopaque3.M9.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 19: net.proto2.go.testdata.nameclashopaque3.M10.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 20: net.proto2.go.testdata.nameclashopaque3.M10.set_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 21: net.proto2.go.testdata.nameclashopaque3.M11.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 22: net.proto2.go.testdata.nameclashopaque3.M12.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 23: net.proto2.go.testdata.nameclashopaque3.M13.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 24: net.proto2.go.testdata.nameclashopaque3.M13.has_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 25: net.proto2.go.testdata.nameclashopaque3.M14.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 26: net.proto2.go.testdata.nameclashopaque3.M15.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 27: net.proto2.go.testdata.nameclashopaque3.M16.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 28: net.proto2.go.testdata.nameclashopaque3.M16.clear_foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 29: net.proto2.go.testdata.nameclashopaque3.M17.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 30: net.proto2.go.testdata.nameclashopaque3.M18.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 31: net.proto2.go.testdata.nameclashopaque3.M19.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	0,  // 32: net.proto2.go.testdata.nameclashopaque3.M20.foo:type_name -> net.proto2.go.testdata.nameclashopaque3.M0
	33, // [33:33] is the sub-list for method output_type
	33, // [33:33] is the sub-list for method input_type
	33, // [33:33] is the sub-list for extension type_name
	33, // [33:33] is the sub-list for extension extendee
	0,  // [0:33] is the sub-list for field type_name
}

func init() { file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_init() }
func file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_init() {
	if File_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto != nil {
		return
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[4].OneofWrappers = []any{
		(*m4_GetGetGetFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[5].OneofWrappers = []any{
		(*m5_GetGetFoo_)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[6].OneofWrappers = []any{
		(*m6_GetGetGetFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[7].OneofWrappers = []any{
		(*m7_Bar)(nil),
		(*m7_GetFoo_)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[8].OneofWrappers = []any{
		(*m8_GetGetFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[9].OneofWrappers = []any{
		(*m9_GetGetFoo)(nil),
		(*m9_GetFoo_)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[11].OneofWrappers = []any{
		(*m11_SetSetFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[12].OneofWrappers = []any{
		(*m12_SetFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[14].OneofWrappers = []any{
		(*m14_HasHasFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[15].OneofWrappers = []any{
		(*m15_HasFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[17].OneofWrappers = []any{
		(*m17_ClearClearFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[18].OneofWrappers = []any{
		(*m18_ClearFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[19].OneofWrappers = []any{
		(*m19_WhichFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes[20].OneofWrappers = []any{
		(*m20_WhichWhichFoo)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_rawDesc), len(file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_goTypes,
		DependencyIndexes: file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_depIdxs,
		MessageInfos:      file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_msgTypes,
	}.Build()
	File_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto = out.File
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_goTypes = nil
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_opaque3_proto_depIdxs = nil
}
