//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipagecontrolprogressdelegate?language=objc)
    pub unsafe trait UIPageControlProgressDelegate: NSObjectProtocol {
        /// Returns the initial progress (between 0...1) for the specified page. By default, `currentProgress` is set to 0 when the page changes.
        #[optional]
        #[unsafe(method(pageControlProgress:initialProgressForPage:))]
        #[unsafe(method_family = none)]
        unsafe fn pageControlProgress_initialProgressForPage(
            &self,
            progress: &UIPageControlProgress,
            page: NSInteger,
        ) -> c_float;

        /// Called when the page control progress visibility has changed, which could occur when the page control is being interacted
        /// with. The page control progress becomes hidden when the user begins to interact with the page control (when it begins
        /// continuous interaction), and is visible again when the user stops interacting with the control. Observe the page control progress
        /// visibility to pause or resume the paging content.
        ///
        /// Example:
        ///
        /// ```text
        ///  - (void)pageControlProgressVisibilityDidChange:(UIPageControlProgress *)progress {
        ///      BOOL isProgressVisible = progress.isProgressVisible;
        ///      if (isProgressVisible) {
        ///          [self _resumeContentFromInteractionChanges];
        ///      } else {
        ///          [self _pauseContentFromInteractionChanges];
        ///      }
        ///  }
        /// ```
        #[optional]
        #[unsafe(method(pageControlProgressVisibilityDidChange:))]
        #[unsafe(method_family = none)]
        unsafe fn pageControlProgressVisibilityDidChange(&self, progress: &UIPageControlProgress);
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipagecontrolprogress?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPageControlProgress;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPageControlProgress {}
);

impl UIPageControlProgress {
    extern_methods!(
        /// An object that defines the delegate of the page control progress.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UIPageControlProgressDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn UIPageControlProgressDelegate>>,
        );

        /// The current progress value of the active page control indicator, between 0 and 1.
        /// Values outside of [0...1] will be clamped.
        #[unsafe(method(currentProgress))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentProgress(&self) -> c_float;

        /// Setter for [`currentProgress`][Self::currentProgress].
        #[unsafe(method(setCurrentProgress:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCurrentProgress(&self, current_progress: c_float);

        /// Returns `YES` if the progress indicator is visible. The progress indicator is hidden when
        /// the user is actively interacting with the `UIPageControl`.
        #[unsafe(method(isProgressVisible))]
        #[unsafe(method_family = none)]
        pub unsafe fn isProgressVisible(&self) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl UIPageControlProgress {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipagecontroltimerprogressdelegate?language=objc)
    pub unsafe trait UIPageControlTimerProgressDelegate:
        UIPageControlProgressDelegate
    {
        /// Called when the progress has changed from the time interval progress.
        #[optional]
        #[unsafe(method(pageControlTimerProgressDidChange:))]
        #[unsafe(method_family = none)]
        unsafe fn pageControlTimerProgressDidChange(&self, progress: &UIPageControlTimerProgress);

        /// Determines if the time interval progress should advance to the next page upon progress completion of
        /// the current page's duration. Default is YES.
        #[optional]
        #[unsafe(method(pageControlTimerProgress:shouldAdvanceToPage:))]
        #[unsafe(method_family = none)]
        unsafe fn pageControlTimerProgress_shouldAdvanceToPage(
            &self,
            progress: &UIPageControlTimerProgress,
            page: NSInteger,
        ) -> bool;
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipagecontroltimerprogress?language=objc)
    #[unsafe(super(UIPageControlProgress, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPageControlTimerProgress;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPageControlTimerProgress {}
);

impl UIPageControlTimerProgress {
    extern_methods!(
        /// Creates a time interval progress with a specified preferred duration.
        #[unsafe(method(initWithPreferredDuration:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithPreferredDuration(
            this: Allocated<Self>,
            preferred_duration: NSTimeInterval,
        ) -> Retained<Self>;

        /// An object that defines the delegate of the page control progress.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UIPageControlTimerProgressDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn UIPageControlTimerProgressDelegate>>,
        );

        /// Determines if the page control should loop back to page 0 after the last page. Default is NO.
        #[unsafe(method(resetsToInitialPageAfterEnd))]
        #[unsafe(method_family = none)]
        pub unsafe fn resetsToInitialPageAfterEnd(&self) -> bool;

        /// Setter for [`resetsToInitialPageAfterEnd`][Self::resetsToInitialPageAfterEnd].
        #[unsafe(method(setResetsToInitialPageAfterEnd:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setResetsToInitialPageAfterEnd(&self, resets_to_initial_page_after_end: bool);

        /// Returns YES if the timer is currently active.
        #[unsafe(method(isRunning))]
        #[unsafe(method_family = none)]
        pub unsafe fn isRunning(&self) -> bool;

        /// Resume the timer if it is not currently active.
        #[unsafe(method(resumeTimer))]
        #[unsafe(method_family = none)]
        pub unsafe fn resumeTimer(&self);

        /// Pause the timer if it is active.
        #[unsafe(method(pauseTimer))]
        #[unsafe(method_family = none)]
        pub unsafe fn pauseTimer(&self);

        /// The preferred duration for the time interval progress, used when there is no custom page duration set for the current page.
        /// The preferred duration must be greater than 0.0
        #[unsafe(method(preferredDuration))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredDuration(&self) -> NSTimeInterval;

        /// Setter for [`preferredDuration`][Self::preferredDuration].
        #[unsafe(method(setPreferredDuration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferredDuration(&self, preferred_duration: NSTimeInterval);

        /// Sets a custom duration for the specified page. Set 0.0 to remove the custom duration for the specified page.
        #[unsafe(method(setDuration:forPage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDuration_forPage(&self, duration: NSTimeInterval, page: NSInteger);

        /// Returns the duration for the specified page, and `preferredDuration` when there is no custom duration set
        /// for the specified page.
        #[unsafe(method(durationForPage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn durationForPage(&self, page: NSInteger) -> NSTimeInterval;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
