# Copyright (c) Jupyter Development Team.
# Distributed under the terms of the Modified BSD License.

# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))
import os.path as osp
import shutil
import sys

HERE = osp.abspath(osp.dirname(__file__))
sys.path.insert(0, osp.join(HERE, "..", ".."))

from jupyterlab_server import LabServerApp, _version  # noqa: E402

# -- Project information -----------------------------------------------------

project = "JupyterLab Server"
copyright = "2021, Project Jupyter"
author = "Project Jupyter"

# The short X.Y version.
version = "%i.%i" % _version.version_info[:2]
# The full version, including alpha/beta/rc tags.
release = _version.__version__

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "myst_parser",
    "autodoc_traits",
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinxcontrib.openapi",
    "sphinx.ext.napoleon",
    "sphinx.ext.mathjax",
    "sphinx_copybutton",
]

try:
    import enchant  # noqa: F401

    extensions += ["sphinxcontrib.spelling"]
except ImportError:
    pass


myst_enable_extensions = ["html_image"]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
#
html_theme = "pydata_sphinx_theme"

# Add an Edit this Page button
html_theme_options = {
    "use_edit_page_button": True,
    "navigation_with_keys": False,
}

# Output for github to be used in links
html_context = {
    "github_user": "jupyterlab",  # Username
    "github_repo": "jupyterlab_server",  # Repo name
    "github_version": "master",  # Version
    "doc_path": "/docs/source/",  # Path in the checkout to the docs root
}

# This option generates errors when methods do not have docstrings,
# so disable
numpydoc_show_class_members = False

config_header = """\
.. _api-full-config:


Config file and command line options
====================================

The JupyterLab Server can be run with a variety of command line arguments.
A list of available options can be found below in the :ref:`options section
<options>`.

Defaults for these options can also be set by creating a file named
``jupyter_jupyterlab_server_config.py`` in your Jupyter folder. The Jupyter
folder is in your home directory, ``~/.jupyter``.

To create a ``jupyter_jupyterlab_server_config.py`` file, with all the defaults
commented out, you can use the following command line::

  $ python -m jupyterlab_server --generate-config


.. _options:

Options
-------

This list of options can be generated by running the following and hitting
enter::

  $ python -m jupyterlab_server --help-all

"""


def setup(app):  # noqa: ARG001
    dest = osp.join(HERE, "changelog.md")
    shutil.copy(osp.join(HERE, "..", "..", "CHANGELOG.md"), dest)
    destination = osp.join(HERE, "api/app-config.rst")
    with open(destination, "w") as f:
        f.write(config_header)
        f.write(LabServerApp().document_config_options())
