# BTstack Port for the Microchip PIC32 Harmony Platform

Status: All examples working, polling UART driver. Tested on Bluetooth Audio Development Kit only. Created with Harmony v1.07, does not compile with new v2.x versions.

## Hardware

The PIC32 Bluetooth Audio Development Kit comes with the CSR8811-based
BTM805 Bluetooth module. In the port, the UART on the DAC daughter board
was used for the debug output. Please remove the DAC board and connect a
3.3V USB-2-UART converter to GND and TX to get the debug output.

## Software

Microchip MPLAB X IDE and the MPLAB XC32 compiler needs to be installed.

## Setup

- Place BTstack tree into harmony/framework folder. 
- Run port/pic32-harmony/create_examples.py to create examples in harmony/apps/btstack folder.

## Usage

The examples can be opened and compiled in Microchip MPLAB X IDE or from the command line using the Makefile generated by it.

### Modifications to the GATT Database

After changing the GATT definition in $example.gatt, please run ./update_gatt_db.h to regenerate example.h in the $example folder.

### Compiler Warnings:

The project is set to use -Os optimization which will cause warnings if you
only have the Free version. It will still compile a working example. 

