/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import React, { type ReactNode } from 'react';
import { jsx } from '@emotion/react';
import type { BasePrimitiveProps } from './types';
export type BleedProps = {
    /**
     * Elements to be rendered inside the Flex.
     */
    children: ReactNode;
    /**
     * Bleed along both axes.
     */
    all?: Space;
    /**
     * Bleed along the inline axis.
     */
    inline?: Space;
    /**
     * Bleed along the block axis.
     */
    block?: Space;
} & BasePrimitiveProps;
type Space = 'space.025' | 'space.050' | 'space.100' | 'space.150' | 'space.200';
/**
 * __Bleed__
 *
 * `Bleed` is a primitive layout component that controls negative whitespace.
 *
 * - [Examples](https://atlassian.design/components/primitives/bleed/examples)
 * - [Code](https://atlassian.design/components/primitives/bleed/code)
 */
declare const Bleed: React.MemoExoticComponent<({ children, testId, inline, block, all, xcss }: BleedProps) => jsx.JSX.Element>;
export default Bleed;
