import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
import { _DJB2, _makeTypedGet } from '@statsig/client-core';
var LOCAL_OVERRIDE_REASON = 'LocalOverride:Recognized';
export var LOCAL_STORAGE_KEY = 'STATSIG_OVERRIDES';
var LEGACY_LOCAL_STORAGE_KEY = 'STATSIG_JS_LITE_LOCAL_OVERRIDES';
var makeEmptyStore = function makeEmptyStore() {
  return {
    gates: {},
    configs: {},
    layers: {}
  };
};
var djb2MapKey = function djb2MapKey(hash, kind) {
  return kind + ':' + hash;
};

/**
 * Custom implementation of `@statsig/js-local-overrides` package with support for local storage
 * so we can keep the existing behavior where overrides are cached locally. Also designed for
 * compatibility with the old override system (eg. no `experiments` field, `configs` is used
 * instead).
 *
 * [Reference](https://github.com/statsig-io/js-client-monorepo/blob/main/packages/js-local-overrides/src/LocalOverrideAdapter.ts)
 */
export var PersistentOverrideAdapter = /*#__PURE__*/function () {
  function PersistentOverrideAdapter(localStorageKey) {
    _classCallCheck(this, PersistentOverrideAdapter);
    this._overrides = makeEmptyStore();
    this._djb2Map = new Map();
    this._localStorageKey = localStorageKey;
  }
  return _createClass(PersistentOverrideAdapter, [{
    key: "parseStoredOverrides",
    value: function parseStoredOverrides(localStorageKey) {
      try {
        var json = window.localStorage.getItem(localStorageKey);
        if (!json) {
          return makeEmptyStore();
        }
        return JSON.parse(json);
      } catch (_unused) {
        return makeEmptyStore();
      }
    }
  }, {
    key: "mergeOverrides",
    value: function mergeOverrides() {
      var merged = makeEmptyStore();
      for (var _len = arguments.length, allOverrides = new Array(_len), _key = 0; _key < _len; _key++) {
        allOverrides[_key] = arguments[_key];
      }
      for (var _i = 0, _allOverrides = allOverrides; _i < _allOverrides.length; _i++) {
        var overrides = _allOverrides[_i];
        for (var _i2 = 0, _Object$entries = Object.entries((_overrides$gates = overrides.gates) !== null && _overrides$gates !== void 0 ? _overrides$gates : {}); _i2 < _Object$entries.length; _i2++) {
          var _overrides$gates;
          var _Object$entries$_i = _slicedToArray(_Object$entries[_i2], 2),
            name = _Object$entries$_i[0],
            value = _Object$entries$_i[1];
          merged.gates[name] = value;
        }
        for (var _i3 = 0, _Object$entries2 = Object.entries((_overrides$configs = overrides.configs) !== null && _overrides$configs !== void 0 ? _overrides$configs : {}); _i3 < _Object$entries2.length; _i3++) {
          var _overrides$configs;
          var _Object$entries2$_i = _slicedToArray(_Object$entries2[_i3], 2),
            _name = _Object$entries2$_i[0],
            _value = _Object$entries2$_i[1];
          merged.configs[_name] = _value;
        }
        for (var _i4 = 0, _Object$entries3 = Object.entries((_overrides$layers = overrides.layers) !== null && _overrides$layers !== void 0 ? _overrides$layers : {}); _i4 < _Object$entries3.length; _i4++) {
          var _overrides$layers;
          var _Object$entries3$_i = _slicedToArray(_Object$entries3[_i4], 2),
            _name2 = _Object$entries3$_i[0],
            _value2 = _Object$entries3$_i[1];
          merged.layers[_name2] = _value2;
        }
      }
      return merged;
    }
  }, {
    key: "initFromStoredOverrides",
    value: function initFromStoredOverrides() {
      var storedOverrides = this.mergeOverrides(this._overrides, this.parseStoredOverrides(LEGACY_LOCAL_STORAGE_KEY), this.parseStoredOverrides(this._localStorageKey));

      // Clear data from legacy local storage key now we've read from it.
      // This prevents things being stuck in there that are always read but never written to.
      try {
        window.localStorage.removeItem(LEGACY_LOCAL_STORAGE_KEY);
      } catch (_unused2) {
        // ignored - window is not defined in non-browser environments, and we don't save things there
        // (things like SSR, etc)
      }

      // In version 4.24.0 we introduced hashes in this override adapter, but had a bug which would cause
      // multiple hashes to continue being created. This code here removes these hashes since we've moved
      // to using a more reliable and easier to maintain map in `_djb2Map`.
      for (var _i5 = 0, _Object$values = Object.values(storedOverrides); _i5 < _Object$values.length; _i5++) {
        var container = _Object$values[_i5];
        var allKeys = new Set(Object.keys(container));
        var _iterator = _createForOfIteratorHelper(allKeys),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var name = _step.value;
            var hash = _DJB2(name);
            if (allKeys.has(hash)) {
              delete container[hash];
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
      this.applyOverrides(storedOverrides);
    }
  }, {
    key: "saveOverrides",
    value: function saveOverrides() {
      try {
        window.localStorage.setItem(this._localStorageKey, JSON.stringify(this._overrides));
      } catch (_unused3) {
        // ignored - window is not defined in non-browser environments, and we don't save things there
        // (things like SSR, etc)
      }
    }
  }, {
    key: "getOverrides",
    value: function getOverrides() {
      return this.mergeOverrides(this._overrides);
    }
  }, {
    key: "applyOverrides",
    value: function applyOverrides(overrides) {
      var newOverrides = _objectSpread(_objectSpread({}, makeEmptyStore()), overrides);
      this._djb2Map.clear();
      for (var _i6 = 0, _Object$entries4 = Object.entries(newOverrides); _i6 < _Object$entries4.length; _i6++) {
        var _Object$entries4$_i = _slicedToArray(_Object$entries4[_i6], 2),
          containerName = _Object$entries4$_i[0],
          container = _Object$entries4$_i[1];
        for (var _i7 = 0, _Object$entries5 = Object.entries(container); _i7 < _Object$entries5.length; _i7++) {
          var _Object$entries5$_i = _slicedToArray(_Object$entries5[_i7], 2),
            name = _Object$entries5$_i[0],
            value = _Object$entries5$_i[1];
          this._djb2Map.set(djb2MapKey(_DJB2(name), containerName), value);
        }
      }
      this._overrides = newOverrides;
    }
  }, {
    key: "setOverrides",
    value: function setOverrides(overrides) {
      this.applyOverrides(overrides);
      this.saveOverrides();
    }
  }, {
    key: "overrideGate",
    value: function overrideGate(name, value) {
      this._overrides.gates[name] = value;
      this._djb2Map.set(djb2MapKey(_DJB2(name), 'gates'), value);
      this.saveOverrides();
    }
  }, {
    key: "removeGateOverride",
    value: function removeGateOverride(name) {
      delete this._overrides.gates[name];
      this._djb2Map.delete(djb2MapKey(_DJB2(name), 'gates'));
      this.saveOverrides();
    }
  }, {
    key: "getGateOverride",
    value: function getGateOverride(current, _user) {
      var _this$_overrides$gate;
      var overridden = (_this$_overrides$gate = this._overrides.gates[current.name]) !== null && _this$_overrides$gate !== void 0 ? _this$_overrides$gate : this._djb2Map.get(djb2MapKey(current.name, 'gates'));
      if (overridden == null) {
        return null;
      }
      return _objectSpread(_objectSpread({}, current), {}, {
        value: overridden,
        details: _objectSpread(_objectSpread({}, current.details), {}, {
          reason: LOCAL_OVERRIDE_REASON
        })
      });
    }
  }, {
    key: "overrideDynamicConfig",
    value: function overrideDynamicConfig(name, value) {
      this._overrides.configs[name] = value;
      this._djb2Map.set(djb2MapKey(_DJB2(name), 'configs'), value);
      this.saveOverrides();
    }
  }, {
    key: "removeDynamicConfigOverride",
    value: function removeDynamicConfigOverride(name) {
      delete this._overrides.configs[name];
      this._djb2Map.delete(djb2MapKey(_DJB2(name), 'configs'));
      this.saveOverrides();
    }
  }, {
    key: "getDynamicConfigOverride",
    value: function getDynamicConfigOverride(current, _user) {
      return this._getConfigOverride(current, this._overrides.configs);
    }
  }, {
    key: "overrideExperiment",
    value: function overrideExperiment(name, value) {
      this._overrides.configs[name] = value;
      this._djb2Map.set(djb2MapKey(_DJB2(name), 'configs'), value);
      this.saveOverrides();
    }
  }, {
    key: "removeExperimentOverride",
    value: function removeExperimentOverride(name) {
      delete this._overrides.configs[name];
      this._djb2Map.delete(djb2MapKey(_DJB2(name), 'configs'));
      this.saveOverrides();
    }
  }, {
    key: "getExperimentOverride",
    value: function getExperimentOverride(current, _user) {
      return this._getConfigOverride(current, this._overrides.configs);
    }
  }, {
    key: "overrideLayer",
    value: function overrideLayer(name, value) {
      this._overrides.layers[name] = value;
      this._djb2Map.set(djb2MapKey(_DJB2(name), 'layers'), value);
      this.saveOverrides();
    }
  }, {
    key: "removeLayerOverride",
    value: function removeLayerOverride(name) {
      delete this._overrides.layers[name];
      this._djb2Map.delete(djb2MapKey(_DJB2(name), 'layers'));
      this.saveOverrides();
    }
  }, {
    key: "removeAllOverrides",
    value: function removeAllOverrides() {
      this._overrides = makeEmptyStore();
      try {
        window.localStorage.removeItem(this._localStorageKey);
      } catch (_unused4) {
        // ignored - window is not defined in non-browser environments, and we don't save things there
        // (things like SSR, etc)
      }
    }
  }, {
    key: "getLayerOverride",
    value: function getLayerOverride(current, _user) {
      var _this$_overrides$laye;
      var overridden = (_this$_overrides$laye = this._overrides.layers[current.name]) !== null && _this$_overrides$laye !== void 0 ? _this$_overrides$laye : this._djb2Map.get(djb2MapKey(current.name, 'layers'));
      if (overridden == null) {
        return null;
      }
      return _objectSpread(_objectSpread({}, current), {}, {
        __value: overridden,
        get: _makeTypedGet(current.name, overridden),
        details: _objectSpread(_objectSpread({}, current.details), {}, {
          reason: LOCAL_OVERRIDE_REASON
        })
      });
    }
  }, {
    key: "_getConfigOverride",
    value: function _getConfigOverride(current, lookup) {
      var _lookup$current$name;
      var overridden = (_lookup$current$name = lookup[current.name]) !== null && _lookup$current$name !== void 0 ? _lookup$current$name : this._djb2Map.get(djb2MapKey(current.name, 'configs'));
      if (overridden == null) {
        return null;
      }
      return _objectSpread(_objectSpread({}, current), {}, {
        value: overridden,
        get: _makeTypedGet(current.name, overridden),
        details: _objectSpread(_objectSpread({}, current.details), {}, {
          reason: LOCAL_OVERRIDE_REASON
        })
      });
    }
  }]);
}();