/*
 * Decompiled with CFR 0.152.
 */
package com.google.thirdparty.publicsuffix;

import com.google.thirdparty.publicsuffix.PublicSuffixType;
import io.bazel.kotlin.builder.guava.annotations.GwtCompatible;
import io.bazel.kotlin.builder.guava.annotations.VisibleForTesting;
import io.bazel.kotlin.builder.guava.base.Joiner;
import io.bazel.kotlin.builder.guava.collect.ImmutableMap;
import io.bazel.kotlin.builder.guava.collect.Queues;
import java.util.Deque;

@GwtCompatible
final class TrieParser {
    private static final Joiner DIRECT_JOINER = Joiner.on("");

    TrieParser() {
    }

    static ImmutableMap<String, PublicSuffixType> parseTrie(CharSequence ... encodedChunks) {
        String encoded = DIRECT_JOINER.join(encodedChunks);
        return TrieParser.parseFullString(encoded);
    }

    @VisibleForTesting
    static ImmutableMap<String, PublicSuffixType> parseFullString(String encoded) {
        ImmutableMap.Builder<String, PublicSuffixType> builder = ImmutableMap.builder();
        int encodedLen = encoded.length();
        for (int idx = 0; idx < encodedLen; idx += TrieParser.doParseTrieToBuilder(Queues.newArrayDeque(), encoded, idx, builder)) {
        }
        return builder.buildOrThrow();
    }

    private static int doParseTrieToBuilder(Deque<CharSequence> stack, CharSequence encoded, int start2, ImmutableMap.Builder<String, PublicSuffixType> builder) {
        String domain;
        int idx;
        int encodedLen = encoded.length();
        char c = '\u0000';
        for (idx = start2; idx < encodedLen && (c = encoded.charAt(idx)) != '&' && c != '?' && c != '!' && c != ':' && c != ','; ++idx) {
        }
        stack.push(TrieParser.reverse(encoded.subSequence(start2, idx)));
        if ((c == '!' || c == '?' || c == ':' || c == ',') && (domain = DIRECT_JOINER.join(stack)).length() > 0) {
            builder.put(domain, PublicSuffixType.fromCode(c));
        }
        ++idx;
        if (c != '?' && c != ',') {
            while (idx < encodedLen) {
                if (encoded.charAt(idx += TrieParser.doParseTrieToBuilder(stack, encoded, idx, builder)) != '?' && encoded.charAt(idx) != ',') continue;
                ++idx;
                break;
            }
        }
        stack.pop();
        return idx - start2;
    }

    private static CharSequence reverse(CharSequence s2) {
        return new StringBuilder(s2).reverse();
    }
}

