// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateAssets = "AssociateAssets"

// AssociateAssetsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAssets for more information on using the AssociateAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateAssetsRequest method.
//    req, resp := client.AssociateAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets
func (c *IoTSiteWise) AssociateAssetsRequest(input *AssociateAssetsInput) (req *request.Request, output *AssociateAssetsOutput) {
	op := &request.Operation{
		Name:       opAssociateAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/assets/{assetId}/associate",
	}

	if input == nil {
		input = &AssociateAssetsInput{}
	}

	output = &AssociateAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssociateAssets API operation for AWS IoT SiteWise.
//
// Associates a child asset with the given parent asset through a hierarchy
// defined in the parent asset's model. For more information, see Associating
// assets (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation AssociateAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets
func (c *IoTSiteWise) AssociateAssets(input *AssociateAssetsInput) (*AssociateAssetsOutput, error) {
	req, out := c.AssociateAssetsRequest(input)
	return out, req.Send()
}

// AssociateAssetsWithContext is the same as AssociateAssets with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) AssociateAssetsWithContext(ctx aws.Context, input *AssociateAssetsInput, opts ...request.Option) (*AssociateAssetsOutput, error) {
	req, out := c.AssociateAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTimeSeriesToAssetProperty = "AssociateTimeSeriesToAssetProperty"

// AssociateTimeSeriesToAssetPropertyRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTimeSeriesToAssetProperty operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTimeSeriesToAssetProperty for more information on using the AssociateTimeSeriesToAssetProperty
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateTimeSeriesToAssetPropertyRequest method.
//    req, resp := client.AssociateTimeSeriesToAssetPropertyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateTimeSeriesToAssetProperty
func (c *IoTSiteWise) AssociateTimeSeriesToAssetPropertyRequest(input *AssociateTimeSeriesToAssetPropertyInput) (req *request.Request, output *AssociateTimeSeriesToAssetPropertyOutput) {
	op := &request.Operation{
		Name:       opAssociateTimeSeriesToAssetProperty,
		HTTPMethod: "POST",
		HTTPPath:   "/timeseries/associate/",
	}

	if input == nil {
		input = &AssociateTimeSeriesToAssetPropertyInput{}
	}

	output = &AssociateTimeSeriesToAssetPropertyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssociateTimeSeriesToAssetProperty API operation for AWS IoT SiteWise.
//
// Associates a time series (data stream) with an asset property.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation AssociateTimeSeriesToAssetProperty for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateTimeSeriesToAssetProperty
func (c *IoTSiteWise) AssociateTimeSeriesToAssetProperty(input *AssociateTimeSeriesToAssetPropertyInput) (*AssociateTimeSeriesToAssetPropertyOutput, error) {
	req, out := c.AssociateTimeSeriesToAssetPropertyRequest(input)
	return out, req.Send()
}

// AssociateTimeSeriesToAssetPropertyWithContext is the same as AssociateTimeSeriesToAssetProperty with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTimeSeriesToAssetProperty for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) AssociateTimeSeriesToAssetPropertyWithContext(ctx aws.Context, input *AssociateTimeSeriesToAssetPropertyInput, opts ...request.Option) (*AssociateTimeSeriesToAssetPropertyOutput, error) {
	req, out := c.AssociateTimeSeriesToAssetPropertyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchAssociateProjectAssets = "BatchAssociateProjectAssets"

// BatchAssociateProjectAssetsRequest generates a "aws/request.Request" representing the
// client's request for the BatchAssociateProjectAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchAssociateProjectAssets for more information on using the BatchAssociateProjectAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchAssociateProjectAssetsRequest method.
//    req, resp := client.BatchAssociateProjectAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets
func (c *IoTSiteWise) BatchAssociateProjectAssetsRequest(input *BatchAssociateProjectAssetsInput) (req *request.Request, output *BatchAssociateProjectAssetsOutput) {
	op := &request.Operation{
		Name:       opBatchAssociateProjectAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{projectId}/assets/associate",
	}

	if input == nil {
		input = &BatchAssociateProjectAssetsInput{}
	}

	output = &BatchAssociateProjectAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchAssociateProjectAssets API operation for AWS IoT SiteWise.
//
// Associates a group (batch) of assets with an IoT SiteWise Monitor project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation BatchAssociateProjectAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets
func (c *IoTSiteWise) BatchAssociateProjectAssets(input *BatchAssociateProjectAssetsInput) (*BatchAssociateProjectAssetsOutput, error) {
	req, out := c.BatchAssociateProjectAssetsRequest(input)
	return out, req.Send()
}

// BatchAssociateProjectAssetsWithContext is the same as BatchAssociateProjectAssets with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAssociateProjectAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchAssociateProjectAssetsWithContext(ctx aws.Context, input *BatchAssociateProjectAssetsInput, opts ...request.Option) (*BatchAssociateProjectAssetsOutput, error) {
	req, out := c.BatchAssociateProjectAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisassociateProjectAssets = "BatchDisassociateProjectAssets"

// BatchDisassociateProjectAssetsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisassociateProjectAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisassociateProjectAssets for more information on using the BatchDisassociateProjectAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDisassociateProjectAssetsRequest method.
//    req, resp := client.BatchDisassociateProjectAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets
func (c *IoTSiteWise) BatchDisassociateProjectAssetsRequest(input *BatchDisassociateProjectAssetsInput) (req *request.Request, output *BatchDisassociateProjectAssetsOutput) {
	op := &request.Operation{
		Name:       opBatchDisassociateProjectAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{projectId}/assets/disassociate",
	}

	if input == nil {
		input = &BatchDisassociateProjectAssetsInput{}
	}

	output = &BatchDisassociateProjectAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchDisassociateProjectAssets API operation for AWS IoT SiteWise.
//
// Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation BatchDisassociateProjectAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets
func (c *IoTSiteWise) BatchDisassociateProjectAssets(input *BatchDisassociateProjectAssetsInput) (*BatchDisassociateProjectAssetsOutput, error) {
	req, out := c.BatchDisassociateProjectAssetsRequest(input)
	return out, req.Send()
}

// BatchDisassociateProjectAssetsWithContext is the same as BatchDisassociateProjectAssets with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisassociateProjectAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchDisassociateProjectAssetsWithContext(ctx aws.Context, input *BatchDisassociateProjectAssetsInput, opts ...request.Option) (*BatchDisassociateProjectAssetsOutput, error) {
	req, out := c.BatchDisassociateProjectAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetAssetPropertyAggregates = "BatchGetAssetPropertyAggregates"

// BatchGetAssetPropertyAggregatesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetAssetPropertyAggregates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetAssetPropertyAggregates for more information on using the BatchGetAssetPropertyAggregates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetAssetPropertyAggregatesRequest method.
//    req, resp := client.BatchGetAssetPropertyAggregatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates
func (c *IoTSiteWise) BatchGetAssetPropertyAggregatesRequest(input *BatchGetAssetPropertyAggregatesInput) (req *request.Request, output *BatchGetAssetPropertyAggregatesOutput) {
	op := &request.Operation{
		Name:       opBatchGetAssetPropertyAggregates,
		HTTPMethod: "POST",
		HTTPPath:   "/properties/batch/aggregates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &BatchGetAssetPropertyAggregatesInput{}
	}

	output = &BatchGetAssetPropertyAggregatesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchGetAssetPropertyAggregates API operation for AWS IoT SiteWise.
//
// Gets aggregated values (for example, average, minimum, and maximum) for one
// or more asset properties. For more information, see Querying aggregates (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation BatchGetAssetPropertyAggregates for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates
func (c *IoTSiteWise) BatchGetAssetPropertyAggregates(input *BatchGetAssetPropertyAggregatesInput) (*BatchGetAssetPropertyAggregatesOutput, error) {
	req, out := c.BatchGetAssetPropertyAggregatesRequest(input)
	return out, req.Send()
}

// BatchGetAssetPropertyAggregatesWithContext is the same as BatchGetAssetPropertyAggregates with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetAssetPropertyAggregates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchGetAssetPropertyAggregatesWithContext(ctx aws.Context, input *BatchGetAssetPropertyAggregatesInput, opts ...request.Option) (*BatchGetAssetPropertyAggregatesOutput, error) {
	req, out := c.BatchGetAssetPropertyAggregatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// BatchGetAssetPropertyAggregatesPages iterates over the pages of a BatchGetAssetPropertyAggregates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See BatchGetAssetPropertyAggregates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a BatchGetAssetPropertyAggregates operation.
//    pageNum := 0
//    err := client.BatchGetAssetPropertyAggregatesPages(params,
//        func(page *iotsitewise.BatchGetAssetPropertyAggregatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) BatchGetAssetPropertyAggregatesPages(input *BatchGetAssetPropertyAggregatesInput, fn func(*BatchGetAssetPropertyAggregatesOutput, bool) bool) error {
	return c.BatchGetAssetPropertyAggregatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// BatchGetAssetPropertyAggregatesPagesWithContext same as BatchGetAssetPropertyAggregatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchGetAssetPropertyAggregatesPagesWithContext(ctx aws.Context, input *BatchGetAssetPropertyAggregatesInput, fn func(*BatchGetAssetPropertyAggregatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *BatchGetAssetPropertyAggregatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.BatchGetAssetPropertyAggregatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*BatchGetAssetPropertyAggregatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opBatchGetAssetPropertyValue = "BatchGetAssetPropertyValue"

// BatchGetAssetPropertyValueRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetAssetPropertyValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetAssetPropertyValue for more information on using the BatchGetAssetPropertyValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetAssetPropertyValueRequest method.
//    req, resp := client.BatchGetAssetPropertyValueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue
func (c *IoTSiteWise) BatchGetAssetPropertyValueRequest(input *BatchGetAssetPropertyValueInput) (req *request.Request, output *BatchGetAssetPropertyValueOutput) {
	op := &request.Operation{
		Name:       opBatchGetAssetPropertyValue,
		HTTPMethod: "POST",
		HTTPPath:   "/properties/batch/latest",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &BatchGetAssetPropertyValueInput{}
	}

	output = &BatchGetAssetPropertyValueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchGetAssetPropertyValue API operation for AWS IoT SiteWise.
//
// Gets the current value for one or more asset properties. For more information,
// see Querying current values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation BatchGetAssetPropertyValue for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue
func (c *IoTSiteWise) BatchGetAssetPropertyValue(input *BatchGetAssetPropertyValueInput) (*BatchGetAssetPropertyValueOutput, error) {
	req, out := c.BatchGetAssetPropertyValueRequest(input)
	return out, req.Send()
}

// BatchGetAssetPropertyValueWithContext is the same as BatchGetAssetPropertyValue with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetAssetPropertyValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchGetAssetPropertyValueWithContext(ctx aws.Context, input *BatchGetAssetPropertyValueInput, opts ...request.Option) (*BatchGetAssetPropertyValueOutput, error) {
	req, out := c.BatchGetAssetPropertyValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// BatchGetAssetPropertyValuePages iterates over the pages of a BatchGetAssetPropertyValue operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See BatchGetAssetPropertyValue method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a BatchGetAssetPropertyValue operation.
//    pageNum := 0
//    err := client.BatchGetAssetPropertyValuePages(params,
//        func(page *iotsitewise.BatchGetAssetPropertyValueOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) BatchGetAssetPropertyValuePages(input *BatchGetAssetPropertyValueInput, fn func(*BatchGetAssetPropertyValueOutput, bool) bool) error {
	return c.BatchGetAssetPropertyValuePagesWithContext(aws.BackgroundContext(), input, fn)
}

// BatchGetAssetPropertyValuePagesWithContext same as BatchGetAssetPropertyValuePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchGetAssetPropertyValuePagesWithContext(ctx aws.Context, input *BatchGetAssetPropertyValueInput, fn func(*BatchGetAssetPropertyValueOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *BatchGetAssetPropertyValueInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.BatchGetAssetPropertyValueRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*BatchGetAssetPropertyValueOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opBatchGetAssetPropertyValueHistory = "BatchGetAssetPropertyValueHistory"

// BatchGetAssetPropertyValueHistoryRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetAssetPropertyValueHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetAssetPropertyValueHistory for more information on using the BatchGetAssetPropertyValueHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetAssetPropertyValueHistoryRequest method.
//    req, resp := client.BatchGetAssetPropertyValueHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory
func (c *IoTSiteWise) BatchGetAssetPropertyValueHistoryRequest(input *BatchGetAssetPropertyValueHistoryInput) (req *request.Request, output *BatchGetAssetPropertyValueHistoryOutput) {
	op := &request.Operation{
		Name:       opBatchGetAssetPropertyValueHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/properties/batch/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &BatchGetAssetPropertyValueHistoryInput{}
	}

	output = &BatchGetAssetPropertyValueHistoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchGetAssetPropertyValueHistory API operation for AWS IoT SiteWise.
//
// Gets the historical values for one or more asset properties. For more information,
// see Querying historical values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation BatchGetAssetPropertyValueHistory for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory
func (c *IoTSiteWise) BatchGetAssetPropertyValueHistory(input *BatchGetAssetPropertyValueHistoryInput) (*BatchGetAssetPropertyValueHistoryOutput, error) {
	req, out := c.BatchGetAssetPropertyValueHistoryRequest(input)
	return out, req.Send()
}

// BatchGetAssetPropertyValueHistoryWithContext is the same as BatchGetAssetPropertyValueHistory with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetAssetPropertyValueHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchGetAssetPropertyValueHistoryWithContext(ctx aws.Context, input *BatchGetAssetPropertyValueHistoryInput, opts ...request.Option) (*BatchGetAssetPropertyValueHistoryOutput, error) {
	req, out := c.BatchGetAssetPropertyValueHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// BatchGetAssetPropertyValueHistoryPages iterates over the pages of a BatchGetAssetPropertyValueHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See BatchGetAssetPropertyValueHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a BatchGetAssetPropertyValueHistory operation.
//    pageNum := 0
//    err := client.BatchGetAssetPropertyValueHistoryPages(params,
//        func(page *iotsitewise.BatchGetAssetPropertyValueHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) BatchGetAssetPropertyValueHistoryPages(input *BatchGetAssetPropertyValueHistoryInput, fn func(*BatchGetAssetPropertyValueHistoryOutput, bool) bool) error {
	return c.BatchGetAssetPropertyValueHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// BatchGetAssetPropertyValueHistoryPagesWithContext same as BatchGetAssetPropertyValueHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchGetAssetPropertyValueHistoryPagesWithContext(ctx aws.Context, input *BatchGetAssetPropertyValueHistoryInput, fn func(*BatchGetAssetPropertyValueHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *BatchGetAssetPropertyValueHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.BatchGetAssetPropertyValueHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*BatchGetAssetPropertyValueHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opBatchPutAssetPropertyValue = "BatchPutAssetPropertyValue"

// BatchPutAssetPropertyValueRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutAssetPropertyValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutAssetPropertyValue for more information on using the BatchPutAssetPropertyValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchPutAssetPropertyValueRequest method.
//    req, resp := client.BatchPutAssetPropertyValueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue
func (c *IoTSiteWise) BatchPutAssetPropertyValueRequest(input *BatchPutAssetPropertyValueInput) (req *request.Request, output *BatchPutAssetPropertyValueOutput) {
	op := &request.Operation{
		Name:       opBatchPutAssetPropertyValue,
		HTTPMethod: "POST",
		HTTPPath:   "/properties",
	}

	if input == nil {
		input = &BatchPutAssetPropertyValueInput{}
	}

	output = &BatchPutAssetPropertyValueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchPutAssetPropertyValue API operation for AWS IoT SiteWise.
//
// Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value
// (TQV) data point. For more information, see Ingesting data using the API
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html)
// in the IoT SiteWise User Guide.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
// With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have
// a timestamp of no more than 7 days in the past and no more than 10 minutes
// in the future. IoT SiteWise rejects timestamps outside of the inclusive range
// of [-7 days, +10 minutes] and returns a TimestampOutOfRangeException error.
//
// For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps
// unless the newer TQV has a different quality. For example, if you store a
// TQV {T1, GOOD, V1}, then storing {T1, GOOD, V2} replaces the existing TQV.
//
// IoT SiteWise authorizes access to each BatchPutAssetPropertyValue entry individually.
// For more information, see BatchPutAssetPropertyValue authorization (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation BatchPutAssetPropertyValue for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue
func (c *IoTSiteWise) BatchPutAssetPropertyValue(input *BatchPutAssetPropertyValueInput) (*BatchPutAssetPropertyValueOutput, error) {
	req, out := c.BatchPutAssetPropertyValueRequest(input)
	return out, req.Send()
}

// BatchPutAssetPropertyValueWithContext is the same as BatchPutAssetPropertyValue with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutAssetPropertyValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchPutAssetPropertyValueWithContext(ctx aws.Context, input *BatchPutAssetPropertyValueInput, opts ...request.Option) (*BatchPutAssetPropertyValueOutput, error) {
	req, out := c.BatchPutAssetPropertyValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessPolicy = "CreateAccessPolicy"

// CreateAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessPolicy for more information on using the CreateAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccessPolicyRequest method.
//    req, resp := client.CreateAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy
func (c *IoTSiteWise) CreateAccessPolicyRequest(input *CreateAccessPolicyInput) (req *request.Request, output *CreateAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateAccessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/access-policies",
	}

	if input == nil {
		input = &CreateAccessPolicyInput{}
	}

	output = &CreateAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAccessPolicy API operation for AWS IoT SiteWise.
//
// Creates an access policy that grants the specified identity (Amazon Web Services
// SSO user, Amazon Web Services SSO group, or IAM user) access to the specified
// IoT SiteWise Monitor portal or project resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy
func (c *IoTSiteWise) CreateAccessPolicy(input *CreateAccessPolicyInput) (*CreateAccessPolicyOutput, error) {
	req, out := c.CreateAccessPolicyRequest(input)
	return out, req.Send()
}

// CreateAccessPolicyWithContext is the same as CreateAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateAccessPolicyWithContext(ctx aws.Context, input *CreateAccessPolicyInput, opts ...request.Option) (*CreateAccessPolicyOutput, error) {
	req, out := c.CreateAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAsset = "CreateAsset"

// CreateAssetRequest generates a "aws/request.Request" representing the
// client's request for the CreateAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAsset for more information on using the CreateAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssetRequest method.
//    req, resp := client.CreateAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset
func (c *IoTSiteWise) CreateAssetRequest(input *CreateAssetInput) (req *request.Request, output *CreateAssetOutput) {
	op := &request.Operation{
		Name:       opCreateAsset,
		HTTPMethod: "POST",
		HTTPPath:   "/assets",
	}

	if input == nil {
		input = &CreateAssetInput{}
	}

	output = &CreateAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAsset API operation for AWS IoT SiteWise.
//
// Creates an asset from an existing asset model. For more information, see
// Creating assets (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateAsset for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset
func (c *IoTSiteWise) CreateAsset(input *CreateAssetInput) (*CreateAssetOutput, error) {
	req, out := c.CreateAssetRequest(input)
	return out, req.Send()
}

// CreateAssetWithContext is the same as CreateAsset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateAssetWithContext(ctx aws.Context, input *CreateAssetInput, opts ...request.Option) (*CreateAssetOutput, error) {
	req, out := c.CreateAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssetModel = "CreateAssetModel"

// CreateAssetModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssetModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssetModel for more information on using the CreateAssetModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssetModelRequest method.
//    req, resp := client.CreateAssetModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel
func (c *IoTSiteWise) CreateAssetModelRequest(input *CreateAssetModelInput) (req *request.Request, output *CreateAssetModelOutput) {
	op := &request.Operation{
		Name:       opCreateAssetModel,
		HTTPMethod: "POST",
		HTTPPath:   "/asset-models",
	}

	if input == nil {
		input = &CreateAssetModelInput{}
	}

	output = &CreateAssetModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAssetModel API operation for AWS IoT SiteWise.
//
// Creates an asset model from specified property and hierarchy definitions.
// You create assets from asset models. With asset models, you can easily create
// assets of the same type that have standardized definitions. Each asset created
// from a model inherits the asset model's property and hierarchy definitions.
// For more information, see Defining asset models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateAssetModel for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel
func (c *IoTSiteWise) CreateAssetModel(input *CreateAssetModelInput) (*CreateAssetModelOutput, error) {
	req, out := c.CreateAssetModelRequest(input)
	return out, req.Send()
}

// CreateAssetModelWithContext is the same as CreateAssetModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssetModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateAssetModelWithContext(ctx aws.Context, input *CreateAssetModelInput, opts ...request.Option) (*CreateAssetModelOutput, error) {
	req, out := c.CreateAssetModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDashboard = "CreateDashboard"

// CreateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the CreateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDashboard for more information on using the CreateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDashboardRequest method.
//    req, resp := client.CreateDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard
func (c *IoTSiteWise) CreateDashboardRequest(input *CreateDashboardInput) (req *request.Request, output *CreateDashboardOutput) {
	op := &request.Operation{
		Name:       opCreateDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/dashboards",
	}

	if input == nil {
		input = &CreateDashboardInput{}
	}

	output = &CreateDashboardOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateDashboard API operation for AWS IoT SiteWise.
//
// Creates a dashboard in an IoT SiteWise Monitor project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateDashboard for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard
func (c *IoTSiteWise) CreateDashboard(input *CreateDashboardInput) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	return out, req.Send()
}

// CreateDashboardWithContext is the same as CreateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateDashboardWithContext(ctx aws.Context, input *CreateDashboardInput, opts ...request.Option) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGateway = "CreateGateway"

// CreateGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGateway for more information on using the CreateGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGatewayRequest method.
//    req, resp := client.CreateGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway
func (c *IoTSiteWise) CreateGatewayRequest(input *CreateGatewayInput) (req *request.Request, output *CreateGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/20200301/gateways",
	}

	if input == nil {
		input = &CreateGatewayInput{}
	}

	output = &CreateGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateGateway API operation for AWS IoT SiteWise.
//
// Creates a gateway, which is a virtual or edge device that delivers industrial
// data streams from local servers to IoT SiteWise. For more information, see
// Ingesting data using a gateway (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway
func (c *IoTSiteWise) CreateGateway(input *CreateGatewayInput) (*CreateGatewayOutput, error) {
	req, out := c.CreateGatewayRequest(input)
	return out, req.Send()
}

// CreateGatewayWithContext is the same as CreateGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateGatewayWithContext(ctx aws.Context, input *CreateGatewayInput, opts ...request.Option) (*CreateGatewayOutput, error) {
	req, out := c.CreateGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePortal = "CreatePortal"

// CreatePortalRequest generates a "aws/request.Request" representing the
// client's request for the CreatePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePortal for more information on using the CreatePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePortalRequest method.
//    req, resp := client.CreatePortalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal
func (c *IoTSiteWise) CreatePortalRequest(input *CreatePortalInput) (req *request.Request, output *CreatePortalOutput) {
	op := &request.Operation{
		Name:       opCreatePortal,
		HTTPMethod: "POST",
		HTTPPath:   "/portals",
	}

	if input == nil {
		input = &CreatePortalInput{}
	}

	output = &CreatePortalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreatePortal API operation for AWS IoT SiteWise.
//
// Creates a portal, which can contain projects and dashboards. IoT SiteWise
// Monitor uses Amazon Web Services SSO or IAM to authenticate portal users
// and manage user permissions.
//
// Before you can sign in to a new portal, you must add at least one identity
// to that portal. For more information, see Adding or removing portal administrators
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreatePortal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal
func (c *IoTSiteWise) CreatePortal(input *CreatePortalInput) (*CreatePortalOutput, error) {
	req, out := c.CreatePortalRequest(input)
	return out, req.Send()
}

// CreatePortalWithContext is the same as CreatePortal with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreatePortalWithContext(ctx aws.Context, input *CreatePortalInput, opts ...request.Option) (*CreatePortalOutput, error) {
	req, out := c.CreatePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject
func (c *IoTSiteWise) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/projects",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateProject API operation for AWS IoT SiteWise.
//
// Creates a project in the specified portal.
//
// Make sure that the project name and description don't contain confidential
// information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject
func (c *IoTSiteWise) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPolicy = "DeleteAccessPolicy"

// DeleteAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPolicy for more information on using the DeleteAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccessPolicyRequest method.
//    req, resp := client.DeleteAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy
func (c *IoTSiteWise) DeleteAccessPolicyRequest(input *DeleteAccessPolicyInput) (req *request.Request, output *DeleteAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/access-policies/{accessPolicyId}",
	}

	if input == nil {
		input = &DeleteAccessPolicyInput{}
	}

	output = &DeleteAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAccessPolicy API operation for AWS IoT SiteWise.
//
// Deletes an access policy that grants the specified identity access to the
// specified IoT SiteWise Monitor resource. You can use this operation to revoke
// access to an IoT SiteWise Monitor resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy
func (c *IoTSiteWise) DeleteAccessPolicy(input *DeleteAccessPolicyInput) (*DeleteAccessPolicyOutput, error) {
	req, out := c.DeleteAccessPolicyRequest(input)
	return out, req.Send()
}

// DeleteAccessPolicyWithContext is the same as DeleteAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteAccessPolicyWithContext(ctx aws.Context, input *DeleteAccessPolicyInput, opts ...request.Option) (*DeleteAccessPolicyOutput, error) {
	req, out := c.DeleteAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAsset = "DeleteAsset"

// DeleteAssetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAsset for more information on using the DeleteAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssetRequest method.
//    req, resp := client.DeleteAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset
func (c *IoTSiteWise) DeleteAssetRequest(input *DeleteAssetInput) (req *request.Request, output *DeleteAssetOutput) {
	op := &request.Operation{
		Name:       opDeleteAsset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/assets/{assetId}",
	}

	if input == nil {
		input = &DeleteAssetInput{}
	}

	output = &DeleteAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAsset API operation for AWS IoT SiteWise.
//
// Deletes an asset. This action can't be undone. For more information, see
// Deleting assets and models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html)
// in the IoT SiteWise User Guide.
//
// You can't delete an asset that's associated to another asset. For more information,
// see DisassociateAssets (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteAsset for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset
func (c *IoTSiteWise) DeleteAsset(input *DeleteAssetInput) (*DeleteAssetOutput, error) {
	req, out := c.DeleteAssetRequest(input)
	return out, req.Send()
}

// DeleteAssetWithContext is the same as DeleteAsset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteAssetWithContext(ctx aws.Context, input *DeleteAssetInput, opts ...request.Option) (*DeleteAssetOutput, error) {
	req, out := c.DeleteAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssetModel = "DeleteAssetModel"

// DeleteAssetModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssetModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssetModel for more information on using the DeleteAssetModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssetModelRequest method.
//    req, resp := client.DeleteAssetModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel
func (c *IoTSiteWise) DeleteAssetModelRequest(input *DeleteAssetModelInput) (req *request.Request, output *DeleteAssetModelOutput) {
	op := &request.Operation{
		Name:       opDeleteAssetModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/asset-models/{assetModelId}",
	}

	if input == nil {
		input = &DeleteAssetModelInput{}
	}

	output = &DeleteAssetModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAssetModel API operation for AWS IoT SiteWise.
//
// Deletes an asset model. This action can't be undone. You must delete all
// assets created from an asset model before you can delete the model. Also,
// you can't delete an asset model if a parent asset model exists that contains
// a property formula expression that depends on the asset model that you want
// to delete. For more information, see Deleting assets and models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteAssetModel for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel
func (c *IoTSiteWise) DeleteAssetModel(input *DeleteAssetModelInput) (*DeleteAssetModelOutput, error) {
	req, out := c.DeleteAssetModelRequest(input)
	return out, req.Send()
}

// DeleteAssetModelWithContext is the same as DeleteAssetModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssetModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteAssetModelWithContext(ctx aws.Context, input *DeleteAssetModelInput, opts ...request.Option) (*DeleteAssetModelOutput, error) {
	req, out := c.DeleteAssetModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDashboard = "DeleteDashboard"

// DeleteDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDashboard for more information on using the DeleteDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDashboardRequest method.
//    req, resp := client.DeleteDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard
func (c *IoTSiteWise) DeleteDashboardRequest(input *DeleteDashboardInput) (req *request.Request, output *DeleteDashboardOutput) {
	op := &request.Operation{
		Name:       opDeleteDashboard,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dashboards/{dashboardId}",
	}

	if input == nil {
		input = &DeleteDashboardInput{}
	}

	output = &DeleteDashboardOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteDashboard API operation for AWS IoT SiteWise.
//
// Deletes a dashboard from IoT SiteWise Monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteDashboard for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard
func (c *IoTSiteWise) DeleteDashboard(input *DeleteDashboardInput) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	return out, req.Send()
}

// DeleteDashboardWithContext is the same as DeleteDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteDashboardWithContext(ctx aws.Context, input *DeleteDashboardInput, opts ...request.Option) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGateway = "DeleteGateway"

// DeleteGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGateway for more information on using the DeleteGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGatewayRequest method.
//    req, resp := client.DeleteGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway
func (c *IoTSiteWise) DeleteGatewayRequest(input *DeleteGatewayInput) (req *request.Request, output *DeleteGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteGateway,
		HTTPMethod: "DELETE",
		HTTPPath:   "/20200301/gateways/{gatewayId}",
	}

	if input == nil {
		input = &DeleteGatewayInput{}
	}

	output = &DeleteGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteGateway API operation for AWS IoT SiteWise.
//
// Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the
// gateway's files remain in your gateway's file system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway
func (c *IoTSiteWise) DeleteGateway(input *DeleteGatewayInput) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	return out, req.Send()
}

// DeleteGatewayWithContext is the same as DeleteGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteGatewayWithContext(ctx aws.Context, input *DeleteGatewayInput, opts ...request.Option) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePortal = "DeletePortal"

// DeletePortalRequest generates a "aws/request.Request" representing the
// client's request for the DeletePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePortal for more information on using the DeletePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePortalRequest method.
//    req, resp := client.DeletePortalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal
func (c *IoTSiteWise) DeletePortalRequest(input *DeletePortalInput) (req *request.Request, output *DeletePortalOutput) {
	op := &request.Operation{
		Name:       opDeletePortal,
		HTTPMethod: "DELETE",
		HTTPPath:   "/portals/{portalId}",
	}

	if input == nil {
		input = &DeletePortalInput{}
	}

	output = &DeletePortalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeletePortal API operation for AWS IoT SiteWise.
//
// Deletes a portal from IoT SiteWise Monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeletePortal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal
func (c *IoTSiteWise) DeletePortal(input *DeletePortalInput) (*DeletePortalOutput, error) {
	req, out := c.DeletePortalRequest(input)
	return out, req.Send()
}

// DeletePortalWithContext is the same as DeletePortal with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeletePortalWithContext(ctx aws.Context, input *DeletePortalInput, opts ...request.Option) (*DeletePortalOutput, error) {
	req, out := c.DeletePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject
func (c *IoTSiteWise) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{projectId}",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteProject API operation for AWS IoT SiteWise.
//
// Deletes a project from IoT SiteWise Monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject
func (c *IoTSiteWise) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTimeSeries = "DeleteTimeSeries"

// DeleteTimeSeriesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTimeSeries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTimeSeries for more information on using the DeleteTimeSeries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTimeSeriesRequest method.
//    req, resp := client.DeleteTimeSeriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteTimeSeries
func (c *IoTSiteWise) DeleteTimeSeriesRequest(input *DeleteTimeSeriesInput) (req *request.Request, output *DeleteTimeSeriesOutput) {
	op := &request.Operation{
		Name:       opDeleteTimeSeries,
		HTTPMethod: "POST",
		HTTPPath:   "/timeseries/delete/",
	}

	if input == nil {
		input = &DeleteTimeSeriesInput{}
	}

	output = &DeleteTimeSeriesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteTimeSeries API operation for AWS IoT SiteWise.
//
// Deletes a time series (data stream). If you delete a time series that's associated
// with an asset property, the asset property still exists, but the time series
// will no longer be associated with this asset property.
//
// To identify a time series, do one of the following:
//
//    * If the time series isn't associated with an asset property, specify
//    the alias of the time series.
//
//    * If the time series is associated with an asset property, specify one
//    of the following: The alias of the time series. The assetId and propertyId
//    that identifies the asset property.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteTimeSeries for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteTimeSeries
func (c *IoTSiteWise) DeleteTimeSeries(input *DeleteTimeSeriesInput) (*DeleteTimeSeriesOutput, error) {
	req, out := c.DeleteTimeSeriesRequest(input)
	return out, req.Send()
}

// DeleteTimeSeriesWithContext is the same as DeleteTimeSeries with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTimeSeries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteTimeSeriesWithContext(ctx aws.Context, input *DeleteTimeSeriesInput, opts ...request.Option) (*DeleteTimeSeriesOutput, error) {
	req, out := c.DeleteTimeSeriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccessPolicy = "DescribeAccessPolicy"

// DescribeAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccessPolicy for more information on using the DescribeAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccessPolicyRequest method.
//    req, resp := client.DescribeAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy
func (c *IoTSiteWise) DescribeAccessPolicyRequest(input *DescribeAccessPolicyInput) (req *request.Request, output *DescribeAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeAccessPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/access-policies/{accessPolicyId}",
	}

	if input == nil {
		input = &DescribeAccessPolicyInput{}
	}

	output = &DescribeAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAccessPolicy API operation for AWS IoT SiteWise.
//
// Describes an access policy, which specifies an identity's access to an IoT
// SiteWise Monitor portal or project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy
func (c *IoTSiteWise) DescribeAccessPolicy(input *DescribeAccessPolicyInput) (*DescribeAccessPolicyOutput, error) {
	req, out := c.DescribeAccessPolicyRequest(input)
	return out, req.Send()
}

// DescribeAccessPolicyWithContext is the same as DescribeAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeAccessPolicyWithContext(ctx aws.Context, input *DescribeAccessPolicyInput, opts ...request.Option) (*DescribeAccessPolicyOutput, error) {
	req, out := c.DescribeAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAsset = "DescribeAsset"

// DescribeAssetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAsset for more information on using the DescribeAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssetRequest method.
//    req, resp := client.DescribeAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset
func (c *IoTSiteWise) DescribeAssetRequest(input *DescribeAssetInput) (req *request.Request, output *DescribeAssetOutput) {
	op := &request.Operation{
		Name:       opDescribeAsset,
		HTTPMethod: "GET",
		HTTPPath:   "/assets/{assetId}",
	}

	if input == nil {
		input = &DescribeAssetInput{}
	}

	output = &DescribeAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAsset API operation for AWS IoT SiteWise.
//
// Retrieves information about an asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeAsset for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset
func (c *IoTSiteWise) DescribeAsset(input *DescribeAssetInput) (*DescribeAssetOutput, error) {
	req, out := c.DescribeAssetRequest(input)
	return out, req.Send()
}

// DescribeAssetWithContext is the same as DescribeAsset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeAssetWithContext(ctx aws.Context, input *DescribeAssetInput, opts ...request.Option) (*DescribeAssetOutput, error) {
	req, out := c.DescribeAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssetModel = "DescribeAssetModel"

// DescribeAssetModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssetModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssetModel for more information on using the DescribeAssetModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssetModelRequest method.
//    req, resp := client.DescribeAssetModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel
func (c *IoTSiteWise) DescribeAssetModelRequest(input *DescribeAssetModelInput) (req *request.Request, output *DescribeAssetModelOutput) {
	op := &request.Operation{
		Name:       opDescribeAssetModel,
		HTTPMethod: "GET",
		HTTPPath:   "/asset-models/{assetModelId}",
	}

	if input == nil {
		input = &DescribeAssetModelInput{}
	}

	output = &DescribeAssetModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAssetModel API operation for AWS IoT SiteWise.
//
// Retrieves information about an asset model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeAssetModel for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel
func (c *IoTSiteWise) DescribeAssetModel(input *DescribeAssetModelInput) (*DescribeAssetModelOutput, error) {
	req, out := c.DescribeAssetModelRequest(input)
	return out, req.Send()
}

// DescribeAssetModelWithContext is the same as DescribeAssetModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssetModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeAssetModelWithContext(ctx aws.Context, input *DescribeAssetModelInput, opts ...request.Option) (*DescribeAssetModelOutput, error) {
	req, out := c.DescribeAssetModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssetProperty = "DescribeAssetProperty"

// DescribeAssetPropertyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssetProperty operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssetProperty for more information on using the DescribeAssetProperty
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssetPropertyRequest method.
//    req, resp := client.DescribeAssetPropertyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty
func (c *IoTSiteWise) DescribeAssetPropertyRequest(input *DescribeAssetPropertyInput) (req *request.Request, output *DescribeAssetPropertyOutput) {
	op := &request.Operation{
		Name:       opDescribeAssetProperty,
		HTTPMethod: "GET",
		HTTPPath:   "/assets/{assetId}/properties/{propertyId}",
	}

	if input == nil {
		input = &DescribeAssetPropertyInput{}
	}

	output = &DescribeAssetPropertyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAssetProperty API operation for AWS IoT SiteWise.
//
// Retrieves information about an asset property.
//
// When you call this operation for an attribute property, this response includes
// the default attribute value that you define in the asset model. If you update
// the default value in the model, this operation's response includes the new
// default value.
//
// This operation doesn't return the value of the asset property. To get the
// value of an asset property, use GetAssetPropertyValue (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeAssetProperty for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty
func (c *IoTSiteWise) DescribeAssetProperty(input *DescribeAssetPropertyInput) (*DescribeAssetPropertyOutput, error) {
	req, out := c.DescribeAssetPropertyRequest(input)
	return out, req.Send()
}

// DescribeAssetPropertyWithContext is the same as DescribeAssetProperty with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssetProperty for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeAssetPropertyWithContext(ctx aws.Context, input *DescribeAssetPropertyInput, opts ...request.Option) (*DescribeAssetPropertyOutput, error) {
	req, out := c.DescribeAssetPropertyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboard = "DescribeDashboard"

// DescribeDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboard for more information on using the DescribeDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDashboardRequest method.
//    req, resp := client.DescribeDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard
func (c *IoTSiteWise) DescribeDashboardRequest(input *DescribeDashboardInput) (req *request.Request, output *DescribeDashboardOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboard,
		HTTPMethod: "GET",
		HTTPPath:   "/dashboards/{dashboardId}",
	}

	if input == nil {
		input = &DescribeDashboardInput{}
	}

	output = &DescribeDashboardOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeDashboard API operation for AWS IoT SiteWise.
//
// Retrieves information about a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeDashboard for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard
func (c *IoTSiteWise) DescribeDashboard(input *DescribeDashboardInput) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	return out, req.Send()
}

// DescribeDashboardWithContext is the same as DescribeDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeDashboardWithContext(ctx aws.Context, input *DescribeDashboardInput, opts ...request.Option) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDefaultEncryptionConfiguration = "DescribeDefaultEncryptionConfiguration"

// DescribeDefaultEncryptionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDefaultEncryptionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDefaultEncryptionConfiguration for more information on using the DescribeDefaultEncryptionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDefaultEncryptionConfigurationRequest method.
//    req, resp := client.DescribeDefaultEncryptionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDefaultEncryptionConfiguration
func (c *IoTSiteWise) DescribeDefaultEncryptionConfigurationRequest(input *DescribeDefaultEncryptionConfigurationInput) (req *request.Request, output *DescribeDefaultEncryptionConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeDefaultEncryptionConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/configuration/account/encryption",
	}

	if input == nil {
		input = &DescribeDefaultEncryptionConfigurationInput{}
	}

	output = &DescribeDefaultEncryptionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeDefaultEncryptionConfiguration API operation for AWS IoT SiteWise.
//
// Retrieves information about the default encryption configuration for the
// Amazon Web Services account in the default or specified Region. For more
// information, see Key management (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeDefaultEncryptionConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDefaultEncryptionConfiguration
func (c *IoTSiteWise) DescribeDefaultEncryptionConfiguration(input *DescribeDefaultEncryptionConfigurationInput) (*DescribeDefaultEncryptionConfigurationOutput, error) {
	req, out := c.DescribeDefaultEncryptionConfigurationRequest(input)
	return out, req.Send()
}

// DescribeDefaultEncryptionConfigurationWithContext is the same as DescribeDefaultEncryptionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDefaultEncryptionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeDefaultEncryptionConfigurationWithContext(ctx aws.Context, input *DescribeDefaultEncryptionConfigurationInput, opts ...request.Option) (*DescribeDefaultEncryptionConfigurationOutput, error) {
	req, out := c.DescribeDefaultEncryptionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGateway = "DescribeGateway"

// DescribeGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGateway for more information on using the DescribeGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGatewayRequest method.
//    req, resp := client.DescribeGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway
func (c *IoTSiteWise) DescribeGatewayRequest(input *DescribeGatewayInput) (req *request.Request, output *DescribeGatewayOutput) {
	op := &request.Operation{
		Name:       opDescribeGateway,
		HTTPMethod: "GET",
		HTTPPath:   "/20200301/gateways/{gatewayId}",
	}

	if input == nil {
		input = &DescribeGatewayInput{}
	}

	output = &DescribeGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeGateway API operation for AWS IoT SiteWise.
//
// Retrieves information about a gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway
func (c *IoTSiteWise) DescribeGateway(input *DescribeGatewayInput) (*DescribeGatewayOutput, error) {
	req, out := c.DescribeGatewayRequest(input)
	return out, req.Send()
}

// DescribeGatewayWithContext is the same as DescribeGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeGatewayWithContext(ctx aws.Context, input *DescribeGatewayInput, opts ...request.Option) (*DescribeGatewayOutput, error) {
	req, out := c.DescribeGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGatewayCapabilityConfiguration = "DescribeGatewayCapabilityConfiguration"

// DescribeGatewayCapabilityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGatewayCapabilityConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGatewayCapabilityConfiguration for more information on using the DescribeGatewayCapabilityConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGatewayCapabilityConfigurationRequest method.
//    req, resp := client.DescribeGatewayCapabilityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration
func (c *IoTSiteWise) DescribeGatewayCapabilityConfigurationRequest(input *DescribeGatewayCapabilityConfigurationInput) (req *request.Request, output *DescribeGatewayCapabilityConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeGatewayCapabilityConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/20200301/gateways/{gatewayId}/capability/{capabilityNamespace}",
	}

	if input == nil {
		input = &DescribeGatewayCapabilityConfigurationInput{}
	}

	output = &DescribeGatewayCapabilityConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeGatewayCapabilityConfiguration API operation for AWS IoT SiteWise.
//
// Retrieves information about a gateway capability configuration. Each gateway
// capability defines data sources for a gateway. A capability configuration
// can contain multiple data source configurations. If you define OPC-UA sources
// for a gateway in the IoT SiteWise console, all of your OPC-UA sources are
// stored in one capability configuration. To list all capability configurations
// for a gateway, use DescribeGateway (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeGatewayCapabilityConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration
func (c *IoTSiteWise) DescribeGatewayCapabilityConfiguration(input *DescribeGatewayCapabilityConfigurationInput) (*DescribeGatewayCapabilityConfigurationOutput, error) {
	req, out := c.DescribeGatewayCapabilityConfigurationRequest(input)
	return out, req.Send()
}

// DescribeGatewayCapabilityConfigurationWithContext is the same as DescribeGatewayCapabilityConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGatewayCapabilityConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeGatewayCapabilityConfigurationWithContext(ctx aws.Context, input *DescribeGatewayCapabilityConfigurationInput, opts ...request.Option) (*DescribeGatewayCapabilityConfigurationOutput, error) {
	req, out := c.DescribeGatewayCapabilityConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoggingOptions = "DescribeLoggingOptions"

// DescribeLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoggingOptions for more information on using the DescribeLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoggingOptionsRequest method.
//    req, resp := client.DescribeLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions
func (c *IoTSiteWise) DescribeLoggingOptionsRequest(input *DescribeLoggingOptionsInput) (req *request.Request, output *DescribeLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeLoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/logging",
	}

	if input == nil {
		input = &DescribeLoggingOptionsInput{}
	}

	output = &DescribeLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeLoggingOptions API operation for AWS IoT SiteWise.
//
// Retrieves the current IoT SiteWise logging options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeLoggingOptions for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions
func (c *IoTSiteWise) DescribeLoggingOptions(input *DescribeLoggingOptionsInput) (*DescribeLoggingOptionsOutput, error) {
	req, out := c.DescribeLoggingOptionsRequest(input)
	return out, req.Send()
}

// DescribeLoggingOptionsWithContext is the same as DescribeLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeLoggingOptionsWithContext(ctx aws.Context, input *DescribeLoggingOptionsInput, opts ...request.Option) (*DescribeLoggingOptionsOutput, error) {
	req, out := c.DescribeLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePortal = "DescribePortal"

// DescribePortalRequest generates a "aws/request.Request" representing the
// client's request for the DescribePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePortal for more information on using the DescribePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePortalRequest method.
//    req, resp := client.DescribePortalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal
func (c *IoTSiteWise) DescribePortalRequest(input *DescribePortalInput) (req *request.Request, output *DescribePortalOutput) {
	op := &request.Operation{
		Name:       opDescribePortal,
		HTTPMethod: "GET",
		HTTPPath:   "/portals/{portalId}",
	}

	if input == nil {
		input = &DescribePortalInput{}
	}

	output = &DescribePortalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribePortal API operation for AWS IoT SiteWise.
//
// Retrieves information about a portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribePortal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal
func (c *IoTSiteWise) DescribePortal(input *DescribePortalInput) (*DescribePortalOutput, error) {
	req, out := c.DescribePortalRequest(input)
	return out, req.Send()
}

// DescribePortalWithContext is the same as DescribePortal with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribePortalWithContext(ctx aws.Context, input *DescribePortalInput, opts ...request.Option) (*DescribePortalOutput, error) {
	req, out := c.DescribePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProject for more information on using the DescribeProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProjectRequest method.
//    req, resp := client.DescribeProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject
func (c *IoTSiteWise) DescribeProjectRequest(input *DescribeProjectInput) (req *request.Request, output *DescribeProjectOutput) {
	op := &request.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectId}",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	output = &DescribeProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeProject API operation for AWS IoT SiteWise.
//
// Retrieves information about a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeProject for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject
func (c *IoTSiteWise) DescribeProject(input *DescribeProjectInput) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	return out, req.Send()
}

// DescribeProjectWithContext is the same as DescribeProject with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeProjectWithContext(ctx aws.Context, input *DescribeProjectInput, opts ...request.Option) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStorageConfiguration = "DescribeStorageConfiguration"

// DescribeStorageConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStorageConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStorageConfiguration for more information on using the DescribeStorageConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStorageConfigurationRequest method.
//    req, resp := client.DescribeStorageConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeStorageConfiguration
func (c *IoTSiteWise) DescribeStorageConfigurationRequest(input *DescribeStorageConfigurationInput) (req *request.Request, output *DescribeStorageConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeStorageConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/configuration/account/storage",
	}

	if input == nil {
		input = &DescribeStorageConfigurationInput{}
	}

	output = &DescribeStorageConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeStorageConfiguration API operation for AWS IoT SiteWise.
//
// Retrieves information about the storage configuration for IoT SiteWise.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeStorageConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeStorageConfiguration
func (c *IoTSiteWise) DescribeStorageConfiguration(input *DescribeStorageConfigurationInput) (*DescribeStorageConfigurationOutput, error) {
	req, out := c.DescribeStorageConfigurationRequest(input)
	return out, req.Send()
}

// DescribeStorageConfigurationWithContext is the same as DescribeStorageConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStorageConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeStorageConfigurationWithContext(ctx aws.Context, input *DescribeStorageConfigurationInput, opts ...request.Option) (*DescribeStorageConfigurationOutput, error) {
	req, out := c.DescribeStorageConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTimeSeries = "DescribeTimeSeries"

// DescribeTimeSeriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTimeSeries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTimeSeries for more information on using the DescribeTimeSeries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTimeSeriesRequest method.
//    req, resp := client.DescribeTimeSeriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeTimeSeries
func (c *IoTSiteWise) DescribeTimeSeriesRequest(input *DescribeTimeSeriesInput) (req *request.Request, output *DescribeTimeSeriesOutput) {
	op := &request.Operation{
		Name:       opDescribeTimeSeries,
		HTTPMethod: "GET",
		HTTPPath:   "/timeseries/describe/",
	}

	if input == nil {
		input = &DescribeTimeSeriesInput{}
	}

	output = &DescribeTimeSeriesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeTimeSeries API operation for AWS IoT SiteWise.
//
// Retrieves information about a time series (data stream).
//
// To identify a time series, do one of the following:
//
//    * If the time series isn't associated with an asset property, specify
//    the alias of the time series.
//
//    * If the time series is associated with an asset property, specify one
//    of the following: The alias of the time series. The assetId and propertyId
//    that identifies the asset property.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeTimeSeries for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeTimeSeries
func (c *IoTSiteWise) DescribeTimeSeries(input *DescribeTimeSeriesInput) (*DescribeTimeSeriesOutput, error) {
	req, out := c.DescribeTimeSeriesRequest(input)
	return out, req.Send()
}

// DescribeTimeSeriesWithContext is the same as DescribeTimeSeries with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTimeSeries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeTimeSeriesWithContext(ctx aws.Context, input *DescribeTimeSeriesInput, opts ...request.Option) (*DescribeTimeSeriesOutput, error) {
	req, out := c.DescribeTimeSeriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAssets = "DisassociateAssets"

// DisassociateAssetsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAssets for more information on using the DisassociateAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateAssetsRequest method.
//    req, resp := client.DisassociateAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets
func (c *IoTSiteWise) DisassociateAssetsRequest(input *DisassociateAssetsInput) (req *request.Request, output *DisassociateAssetsOutput) {
	op := &request.Operation{
		Name:       opDisassociateAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/assets/{assetId}/disassociate",
	}

	if input == nil {
		input = &DisassociateAssetsInput{}
	}

	output = &DisassociateAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DisassociateAssets API operation for AWS IoT SiteWise.
//
// Disassociates a child asset from the given parent asset through a hierarchy
// defined in the parent asset's model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DisassociateAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets
func (c *IoTSiteWise) DisassociateAssets(input *DisassociateAssetsInput) (*DisassociateAssetsOutput, error) {
	req, out := c.DisassociateAssetsRequest(input)
	return out, req.Send()
}

// DisassociateAssetsWithContext is the same as DisassociateAssets with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DisassociateAssetsWithContext(ctx aws.Context, input *DisassociateAssetsInput, opts ...request.Option) (*DisassociateAssetsOutput, error) {
	req, out := c.DisassociateAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateTimeSeriesFromAssetProperty = "DisassociateTimeSeriesFromAssetProperty"

// DisassociateTimeSeriesFromAssetPropertyRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateTimeSeriesFromAssetProperty operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateTimeSeriesFromAssetProperty for more information on using the DisassociateTimeSeriesFromAssetProperty
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateTimeSeriesFromAssetPropertyRequest method.
//    req, resp := client.DisassociateTimeSeriesFromAssetPropertyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateTimeSeriesFromAssetProperty
func (c *IoTSiteWise) DisassociateTimeSeriesFromAssetPropertyRequest(input *DisassociateTimeSeriesFromAssetPropertyInput) (req *request.Request, output *DisassociateTimeSeriesFromAssetPropertyOutput) {
	op := &request.Operation{
		Name:       opDisassociateTimeSeriesFromAssetProperty,
		HTTPMethod: "POST",
		HTTPPath:   "/timeseries/disassociate/",
	}

	if input == nil {
		input = &DisassociateTimeSeriesFromAssetPropertyInput{}
	}

	output = &DisassociateTimeSeriesFromAssetPropertyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DisassociateTimeSeriesFromAssetProperty API operation for AWS IoT SiteWise.
//
// Disassociates a time series (data stream) from an asset property.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DisassociateTimeSeriesFromAssetProperty for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateTimeSeriesFromAssetProperty
func (c *IoTSiteWise) DisassociateTimeSeriesFromAssetProperty(input *DisassociateTimeSeriesFromAssetPropertyInput) (*DisassociateTimeSeriesFromAssetPropertyOutput, error) {
	req, out := c.DisassociateTimeSeriesFromAssetPropertyRequest(input)
	return out, req.Send()
}

// DisassociateTimeSeriesFromAssetPropertyWithContext is the same as DisassociateTimeSeriesFromAssetProperty with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateTimeSeriesFromAssetProperty for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DisassociateTimeSeriesFromAssetPropertyWithContext(ctx aws.Context, input *DisassociateTimeSeriesFromAssetPropertyInput, opts ...request.Option) (*DisassociateTimeSeriesFromAssetPropertyOutput, error) {
	req, out := c.DisassociateTimeSeriesFromAssetPropertyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssetPropertyAggregates = "GetAssetPropertyAggregates"

// GetAssetPropertyAggregatesRequest generates a "aws/request.Request" representing the
// client's request for the GetAssetPropertyAggregates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssetPropertyAggregates for more information on using the GetAssetPropertyAggregates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssetPropertyAggregatesRequest method.
//    req, resp := client.GetAssetPropertyAggregatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates
func (c *IoTSiteWise) GetAssetPropertyAggregatesRequest(input *GetAssetPropertyAggregatesInput) (req *request.Request, output *GetAssetPropertyAggregatesOutput) {
	op := &request.Operation{
		Name:       opGetAssetPropertyAggregates,
		HTTPMethod: "GET",
		HTTPPath:   "/properties/aggregates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAssetPropertyAggregatesInput{}
	}

	output = &GetAssetPropertyAggregatesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAssetPropertyAggregates API operation for AWS IoT SiteWise.
//
// Gets aggregated values for an asset property. For more information, see Querying
// aggregates (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates)
// in the IoT SiteWise User Guide.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation GetAssetPropertyAggregates for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates
func (c *IoTSiteWise) GetAssetPropertyAggregates(input *GetAssetPropertyAggregatesInput) (*GetAssetPropertyAggregatesOutput, error) {
	req, out := c.GetAssetPropertyAggregatesRequest(input)
	return out, req.Send()
}

// GetAssetPropertyAggregatesWithContext is the same as GetAssetPropertyAggregates with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssetPropertyAggregates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetAssetPropertyAggregatesWithContext(ctx aws.Context, input *GetAssetPropertyAggregatesInput, opts ...request.Option) (*GetAssetPropertyAggregatesOutput, error) {
	req, out := c.GetAssetPropertyAggregatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetAssetPropertyAggregatesPages iterates over the pages of a GetAssetPropertyAggregates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAssetPropertyAggregates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetAssetPropertyAggregates operation.
//    pageNum := 0
//    err := client.GetAssetPropertyAggregatesPages(params,
//        func(page *iotsitewise.GetAssetPropertyAggregatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) GetAssetPropertyAggregatesPages(input *GetAssetPropertyAggregatesInput, fn func(*GetAssetPropertyAggregatesOutput, bool) bool) error {
	return c.GetAssetPropertyAggregatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetAssetPropertyAggregatesPagesWithContext same as GetAssetPropertyAggregatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetAssetPropertyAggregatesPagesWithContext(ctx aws.Context, input *GetAssetPropertyAggregatesInput, fn func(*GetAssetPropertyAggregatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetAssetPropertyAggregatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAssetPropertyAggregatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetAssetPropertyAggregatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetAssetPropertyValue = "GetAssetPropertyValue"

// GetAssetPropertyValueRequest generates a "aws/request.Request" representing the
// client's request for the GetAssetPropertyValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssetPropertyValue for more information on using the GetAssetPropertyValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssetPropertyValueRequest method.
//    req, resp := client.GetAssetPropertyValueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue
func (c *IoTSiteWise) GetAssetPropertyValueRequest(input *GetAssetPropertyValueInput) (req *request.Request, output *GetAssetPropertyValueOutput) {
	op := &request.Operation{
		Name:       opGetAssetPropertyValue,
		HTTPMethod: "GET",
		HTTPPath:   "/properties/latest",
	}

	if input == nil {
		input = &GetAssetPropertyValueInput{}
	}

	output = &GetAssetPropertyValueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAssetPropertyValue API operation for AWS IoT SiteWise.
//
// Gets an asset property's current value. For more information, see Querying
// current values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values)
// in the IoT SiteWise User Guide.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation GetAssetPropertyValue for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue
func (c *IoTSiteWise) GetAssetPropertyValue(input *GetAssetPropertyValueInput) (*GetAssetPropertyValueOutput, error) {
	req, out := c.GetAssetPropertyValueRequest(input)
	return out, req.Send()
}

// GetAssetPropertyValueWithContext is the same as GetAssetPropertyValue with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssetPropertyValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetAssetPropertyValueWithContext(ctx aws.Context, input *GetAssetPropertyValueInput, opts ...request.Option) (*GetAssetPropertyValueOutput, error) {
	req, out := c.GetAssetPropertyValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssetPropertyValueHistory = "GetAssetPropertyValueHistory"

// GetAssetPropertyValueHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetAssetPropertyValueHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssetPropertyValueHistory for more information on using the GetAssetPropertyValueHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssetPropertyValueHistoryRequest method.
//    req, resp := client.GetAssetPropertyValueHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory
func (c *IoTSiteWise) GetAssetPropertyValueHistoryRequest(input *GetAssetPropertyValueHistoryInput) (req *request.Request, output *GetAssetPropertyValueHistoryOutput) {
	op := &request.Operation{
		Name:       opGetAssetPropertyValueHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/properties/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAssetPropertyValueHistoryInput{}
	}

	output = &GetAssetPropertyValueHistoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAssetPropertyValueHistory API operation for AWS IoT SiteWise.
//
// Gets the history of an asset property's values. For more information, see
// Querying historical values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values)
// in the IoT SiteWise User Guide.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation GetAssetPropertyValueHistory for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory
func (c *IoTSiteWise) GetAssetPropertyValueHistory(input *GetAssetPropertyValueHistoryInput) (*GetAssetPropertyValueHistoryOutput, error) {
	req, out := c.GetAssetPropertyValueHistoryRequest(input)
	return out, req.Send()
}

// GetAssetPropertyValueHistoryWithContext is the same as GetAssetPropertyValueHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssetPropertyValueHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetAssetPropertyValueHistoryWithContext(ctx aws.Context, input *GetAssetPropertyValueHistoryInput, opts ...request.Option) (*GetAssetPropertyValueHistoryOutput, error) {
	req, out := c.GetAssetPropertyValueHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetAssetPropertyValueHistoryPages iterates over the pages of a GetAssetPropertyValueHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAssetPropertyValueHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetAssetPropertyValueHistory operation.
//    pageNum := 0
//    err := client.GetAssetPropertyValueHistoryPages(params,
//        func(page *iotsitewise.GetAssetPropertyValueHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) GetAssetPropertyValueHistoryPages(input *GetAssetPropertyValueHistoryInput, fn func(*GetAssetPropertyValueHistoryOutput, bool) bool) error {
	return c.GetAssetPropertyValueHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetAssetPropertyValueHistoryPagesWithContext same as GetAssetPropertyValueHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetAssetPropertyValueHistoryPagesWithContext(ctx aws.Context, input *GetAssetPropertyValueHistoryInput, fn func(*GetAssetPropertyValueHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetAssetPropertyValueHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAssetPropertyValueHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetAssetPropertyValueHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetInterpolatedAssetPropertyValues = "GetInterpolatedAssetPropertyValues"

// GetInterpolatedAssetPropertyValuesRequest generates a "aws/request.Request" representing the
// client's request for the GetInterpolatedAssetPropertyValues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInterpolatedAssetPropertyValues for more information on using the GetInterpolatedAssetPropertyValues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInterpolatedAssetPropertyValuesRequest method.
//    req, resp := client.GetInterpolatedAssetPropertyValuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues
func (c *IoTSiteWise) GetInterpolatedAssetPropertyValuesRequest(input *GetInterpolatedAssetPropertyValuesInput) (req *request.Request, output *GetInterpolatedAssetPropertyValuesOutput) {
	op := &request.Operation{
		Name:       opGetInterpolatedAssetPropertyValues,
		HTTPMethod: "GET",
		HTTPPath:   "/properties/interpolated",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetInterpolatedAssetPropertyValuesInput{}
	}

	output = &GetInterpolatedAssetPropertyValuesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetInterpolatedAssetPropertyValues API operation for AWS IoT SiteWise.
//
// Get interpolated values for an asset property for a specified time interval,
// during a period of time. If your time series is missing data points during
// the specified time interval, you can use interpolation to estimate the missing
// data.
//
// For example, you can use this operation to return the interpolated temperature
// values for a wind turbine every 24 hours over a duration of 7 days.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation GetInterpolatedAssetPropertyValues for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues
func (c *IoTSiteWise) GetInterpolatedAssetPropertyValues(input *GetInterpolatedAssetPropertyValuesInput) (*GetInterpolatedAssetPropertyValuesOutput, error) {
	req, out := c.GetInterpolatedAssetPropertyValuesRequest(input)
	return out, req.Send()
}

// GetInterpolatedAssetPropertyValuesWithContext is the same as GetInterpolatedAssetPropertyValues with the addition of
// the ability to pass a context and additional request options.
//
// See GetInterpolatedAssetPropertyValues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetInterpolatedAssetPropertyValuesWithContext(ctx aws.Context, input *GetInterpolatedAssetPropertyValuesInput, opts ...request.Option) (*GetInterpolatedAssetPropertyValuesOutput, error) {
	req, out := c.GetInterpolatedAssetPropertyValuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetInterpolatedAssetPropertyValuesPages iterates over the pages of a GetInterpolatedAssetPropertyValues operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetInterpolatedAssetPropertyValues method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetInterpolatedAssetPropertyValues operation.
//    pageNum := 0
//    err := client.GetInterpolatedAssetPropertyValuesPages(params,
//        func(page *iotsitewise.GetInterpolatedAssetPropertyValuesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) GetInterpolatedAssetPropertyValuesPages(input *GetInterpolatedAssetPropertyValuesInput, fn func(*GetInterpolatedAssetPropertyValuesOutput, bool) bool) error {
	return c.GetInterpolatedAssetPropertyValuesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetInterpolatedAssetPropertyValuesPagesWithContext same as GetInterpolatedAssetPropertyValuesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetInterpolatedAssetPropertyValuesPagesWithContext(ctx aws.Context, input *GetInterpolatedAssetPropertyValuesInput, fn func(*GetInterpolatedAssetPropertyValuesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetInterpolatedAssetPropertyValuesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetInterpolatedAssetPropertyValuesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetInterpolatedAssetPropertyValuesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccessPolicies = "ListAccessPolicies"

// ListAccessPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessPolicies for more information on using the ListAccessPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccessPoliciesRequest method.
//    req, resp := client.ListAccessPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies
func (c *IoTSiteWise) ListAccessPoliciesRequest(input *ListAccessPoliciesInput) (req *request.Request, output *ListAccessPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAccessPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/access-policies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPoliciesInput{}
	}

	output = &ListAccessPoliciesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAccessPolicies API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of access policies for an identity (an Amazon
// Web Services SSO user, an Amazon Web Services SSO group, or an IAM user)
// or an IoT SiteWise Monitor resource (a portal or project).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListAccessPolicies for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies
func (c *IoTSiteWise) ListAccessPolicies(input *ListAccessPoliciesInput) (*ListAccessPoliciesOutput, error) {
	req, out := c.ListAccessPoliciesRequest(input)
	return out, req.Send()
}

// ListAccessPoliciesWithContext is the same as ListAccessPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAccessPoliciesWithContext(ctx aws.Context, input *ListAccessPoliciesInput, opts ...request.Option) (*ListAccessPoliciesOutput, error) {
	req, out := c.ListAccessPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessPoliciesPages iterates over the pages of a ListAccessPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccessPolicies operation.
//    pageNum := 0
//    err := client.ListAccessPoliciesPages(params,
//        func(page *iotsitewise.ListAccessPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListAccessPoliciesPages(input *ListAccessPoliciesInput, fn func(*ListAccessPoliciesOutput, bool) bool) error {
	return c.ListAccessPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessPoliciesPagesWithContext same as ListAccessPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAccessPoliciesPagesWithContext(ctx aws.Context, input *ListAccessPoliciesInput, fn func(*ListAccessPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssetModels = "ListAssetModels"

// ListAssetModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssetModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssetModels for more information on using the ListAssetModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssetModelsRequest method.
//    req, resp := client.ListAssetModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels
func (c *IoTSiteWise) ListAssetModelsRequest(input *ListAssetModelsInput) (req *request.Request, output *ListAssetModelsOutput) {
	op := &request.Operation{
		Name:       opListAssetModels,
		HTTPMethod: "GET",
		HTTPPath:   "/asset-models",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetModelsInput{}
	}

	output = &ListAssetModelsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAssetModels API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of summaries of all asset models.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListAssetModels for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels
func (c *IoTSiteWise) ListAssetModels(input *ListAssetModelsInput) (*ListAssetModelsOutput, error) {
	req, out := c.ListAssetModelsRequest(input)
	return out, req.Send()
}

// ListAssetModelsWithContext is the same as ListAssetModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssetModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssetModelsWithContext(ctx aws.Context, input *ListAssetModelsInput, opts ...request.Option) (*ListAssetModelsOutput, error) {
	req, out := c.ListAssetModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetModelsPages iterates over the pages of a ListAssetModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssetModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssetModels operation.
//    pageNum := 0
//    err := client.ListAssetModelsPages(params,
//        func(page *iotsitewise.ListAssetModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListAssetModelsPages(input *ListAssetModelsInput, fn func(*ListAssetModelsOutput, bool) bool) error {
	return c.ListAssetModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetModelsPagesWithContext same as ListAssetModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssetModelsPagesWithContext(ctx aws.Context, input *ListAssetModelsInput, fn func(*ListAssetModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssetRelationships = "ListAssetRelationships"

// ListAssetRelationshipsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssetRelationships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssetRelationships for more information on using the ListAssetRelationships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssetRelationshipsRequest method.
//    req, resp := client.ListAssetRelationshipsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships
func (c *IoTSiteWise) ListAssetRelationshipsRequest(input *ListAssetRelationshipsInput) (req *request.Request, output *ListAssetRelationshipsOutput) {
	op := &request.Operation{
		Name:       opListAssetRelationships,
		HTTPMethod: "GET",
		HTTPPath:   "/assets/{assetId}/assetRelationships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetRelationshipsInput{}
	}

	output = &ListAssetRelationshipsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAssetRelationships API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of asset relationships for an asset. You can use
// this operation to identify an asset's root asset and all associated assets
// between that asset and its root.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListAssetRelationships for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships
func (c *IoTSiteWise) ListAssetRelationships(input *ListAssetRelationshipsInput) (*ListAssetRelationshipsOutput, error) {
	req, out := c.ListAssetRelationshipsRequest(input)
	return out, req.Send()
}

// ListAssetRelationshipsWithContext is the same as ListAssetRelationships with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssetRelationships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssetRelationshipsWithContext(ctx aws.Context, input *ListAssetRelationshipsInput, opts ...request.Option) (*ListAssetRelationshipsOutput, error) {
	req, out := c.ListAssetRelationshipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetRelationshipsPages iterates over the pages of a ListAssetRelationships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssetRelationships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssetRelationships operation.
//    pageNum := 0
//    err := client.ListAssetRelationshipsPages(params,
//        func(page *iotsitewise.ListAssetRelationshipsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListAssetRelationshipsPages(input *ListAssetRelationshipsInput, fn func(*ListAssetRelationshipsOutput, bool) bool) error {
	return c.ListAssetRelationshipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetRelationshipsPagesWithContext same as ListAssetRelationshipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssetRelationshipsPagesWithContext(ctx aws.Context, input *ListAssetRelationshipsInput, fn func(*ListAssetRelationshipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetRelationshipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetRelationshipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetRelationshipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssets = "ListAssets"

// ListAssetsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssets for more information on using the ListAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssetsRequest method.
//    req, resp := client.ListAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets
func (c *IoTSiteWise) ListAssetsRequest(input *ListAssetsInput) (req *request.Request, output *ListAssetsOutput) {
	op := &request.Operation{
		Name:       opListAssets,
		HTTPMethod: "GET",
		HTTPPath:   "/assets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetsInput{}
	}

	output = &ListAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAssets API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of asset summaries.
//
// You can use this operation to do the following:
//
//    * List assets based on a specific asset model.
//
//    * List top-level assets.
//
// You can't use this operation to list all assets. To retrieve summaries for
// all of your assets, use ListAssetModels (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html)
// to get all of your asset model IDs. Then, use ListAssets to get all assets
// for each asset model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets
func (c *IoTSiteWise) ListAssets(input *ListAssetsInput) (*ListAssetsOutput, error) {
	req, out := c.ListAssetsRequest(input)
	return out, req.Send()
}

// ListAssetsWithContext is the same as ListAssets with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssetsWithContext(ctx aws.Context, input *ListAssetsInput, opts ...request.Option) (*ListAssetsOutput, error) {
	req, out := c.ListAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetsPages iterates over the pages of a ListAssets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssets operation.
//    pageNum := 0
//    err := client.ListAssetsPages(params,
//        func(page *iotsitewise.ListAssetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListAssetsPages(input *ListAssetsInput, fn func(*ListAssetsOutput, bool) bool) error {
	return c.ListAssetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetsPagesWithContext same as ListAssetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssetsPagesWithContext(ctx aws.Context, input *ListAssetsInput, fn func(*ListAssetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssociatedAssets = "ListAssociatedAssets"

// ListAssociatedAssetsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociatedAssets for more information on using the ListAssociatedAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociatedAssetsRequest method.
//    req, resp := client.ListAssociatedAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets
func (c *IoTSiteWise) ListAssociatedAssetsRequest(input *ListAssociatedAssetsInput) (req *request.Request, output *ListAssociatedAssetsOutput) {
	op := &request.Operation{
		Name:       opListAssociatedAssets,
		HTTPMethod: "GET",
		HTTPPath:   "/assets/{assetId}/hierarchies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociatedAssetsInput{}
	}

	output = &ListAssociatedAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAssociatedAssets API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of associated assets.
//
// You can use this operation to do the following:
//
//    * List child assets associated to a parent asset by a hierarchy that you
//    specify.
//
//    * List an asset's parent asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListAssociatedAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets
func (c *IoTSiteWise) ListAssociatedAssets(input *ListAssociatedAssetsInput) (*ListAssociatedAssetsOutput, error) {
	req, out := c.ListAssociatedAssetsRequest(input)
	return out, req.Send()
}

// ListAssociatedAssetsWithContext is the same as ListAssociatedAssets with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociatedAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssociatedAssetsWithContext(ctx aws.Context, input *ListAssociatedAssetsInput, opts ...request.Option) (*ListAssociatedAssetsOutput, error) {
	req, out := c.ListAssociatedAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssociatedAssetsPages iterates over the pages of a ListAssociatedAssets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociatedAssets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssociatedAssets operation.
//    pageNum := 0
//    err := client.ListAssociatedAssetsPages(params,
//        func(page *iotsitewise.ListAssociatedAssetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListAssociatedAssetsPages(input *ListAssociatedAssetsInput, fn func(*ListAssociatedAssetsOutput, bool) bool) error {
	return c.ListAssociatedAssetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssociatedAssetsPagesWithContext same as ListAssociatedAssetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssociatedAssetsPagesWithContext(ctx aws.Context, input *ListAssociatedAssetsInput, fn func(*ListAssociatedAssetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssociatedAssetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssociatedAssetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssociatedAssetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDashboards = "ListDashboards"

// ListDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboards for more information on using the ListDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDashboardsRequest method.
//    req, resp := client.ListDashboardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards
func (c *IoTSiteWise) ListDashboardsRequest(input *ListDashboardsInput) (req *request.Request, output *ListDashboardsOutput) {
	op := &request.Operation{
		Name:       opListDashboards,
		HTTPMethod: "GET",
		HTTPPath:   "/dashboards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardsInput{}
	}

	output = &ListDashboardsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListDashboards API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListDashboards for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards
func (c *IoTSiteWise) ListDashboards(input *ListDashboardsInput) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	return out, req.Send()
}

// ListDashboardsWithContext is the same as ListDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListDashboardsWithContext(ctx aws.Context, input *ListDashboardsInput, opts ...request.Option) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardsPages iterates over the pages of a ListDashboards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDashboards operation.
//    pageNum := 0
//    err := client.ListDashboardsPages(params,
//        func(page *iotsitewise.ListDashboardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListDashboardsPages(input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool) error {
	return c.ListDashboardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardsPagesWithContext same as ListDashboardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListDashboardsPagesWithContext(ctx aws.Context, input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGateways = "ListGateways"

// ListGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the ListGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGateways for more information on using the ListGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGatewaysRequest method.
//    req, resp := client.ListGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways
func (c *IoTSiteWise) ListGatewaysRequest(input *ListGatewaysInput) (req *request.Request, output *ListGatewaysOutput) {
	op := &request.Operation{
		Name:       opListGateways,
		HTTPMethod: "GET",
		HTTPPath:   "/20200301/gateways",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewaysInput{}
	}

	output = &ListGatewaysOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListGateways API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListGateways for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways
func (c *IoTSiteWise) ListGateways(input *ListGatewaysInput) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	return out, req.Send()
}

// ListGatewaysWithContext is the same as ListGateways with the addition of
// the ability to pass a context and additional request options.
//
// See ListGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListGatewaysWithContext(ctx aws.Context, input *ListGatewaysInput, opts ...request.Option) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGatewaysPages iterates over the pages of a ListGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGateways operation.
//    pageNum := 0
//    err := client.ListGatewaysPages(params,
//        func(page *iotsitewise.ListGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListGatewaysPages(input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool) error {
	return c.ListGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGatewaysPagesWithContext same as ListGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListGatewaysPagesWithContext(ctx aws.Context, input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPortals = "ListPortals"

// ListPortalsRequest generates a "aws/request.Request" representing the
// client's request for the ListPortals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPortals for more information on using the ListPortals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPortalsRequest method.
//    req, resp := client.ListPortalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals
func (c *IoTSiteWise) ListPortalsRequest(input *ListPortalsInput) (req *request.Request, output *ListPortalsOutput) {
	op := &request.Operation{
		Name:       opListPortals,
		HTTPMethod: "GET",
		HTTPPath:   "/portals",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPortalsInput{}
	}

	output = &ListPortalsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListPortals API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of IoT SiteWise Monitor portals.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListPortals for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals
func (c *IoTSiteWise) ListPortals(input *ListPortalsInput) (*ListPortalsOutput, error) {
	req, out := c.ListPortalsRequest(input)
	return out, req.Send()
}

// ListPortalsWithContext is the same as ListPortals with the addition of
// the ability to pass a context and additional request options.
//
// See ListPortals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListPortalsWithContext(ctx aws.Context, input *ListPortalsInput, opts ...request.Option) (*ListPortalsOutput, error) {
	req, out := c.ListPortalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPortalsPages iterates over the pages of a ListPortals operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPortals method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPortals operation.
//    pageNum := 0
//    err := client.ListPortalsPages(params,
//        func(page *iotsitewise.ListPortalsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListPortalsPages(input *ListPortalsInput, fn func(*ListPortalsOutput, bool) bool) error {
	return c.ListPortalsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPortalsPagesWithContext same as ListPortalsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListPortalsPagesWithContext(ctx aws.Context, input *ListPortalsInput, fn func(*ListPortalsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPortalsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPortalsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPortalsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjectAssets = "ListProjectAssets"

// ListProjectAssetsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjectAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjectAssets for more information on using the ListProjectAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectAssetsRequest method.
//    req, resp := client.ListProjectAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets
func (c *IoTSiteWise) ListProjectAssetsRequest(input *ListProjectAssetsInput) (req *request.Request, output *ListProjectAssetsOutput) {
	op := &request.Operation{
		Name:       opListProjectAssets,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectId}/assets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectAssetsInput{}
	}

	output = &ListProjectAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListProjectAssets API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of assets associated with an IoT SiteWise Monitor
// project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListProjectAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets
func (c *IoTSiteWise) ListProjectAssets(input *ListProjectAssetsInput) (*ListProjectAssetsOutput, error) {
	req, out := c.ListProjectAssetsRequest(input)
	return out, req.Send()
}

// ListProjectAssetsWithContext is the same as ListProjectAssets with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjectAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListProjectAssetsWithContext(ctx aws.Context, input *ListProjectAssetsInput, opts ...request.Option) (*ListProjectAssetsOutput, error) {
	req, out := c.ListProjectAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectAssetsPages iterates over the pages of a ListProjectAssets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjectAssets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProjectAssets operation.
//    pageNum := 0
//    err := client.ListProjectAssetsPages(params,
//        func(page *iotsitewise.ListProjectAssetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListProjectAssetsPages(input *ListProjectAssetsInput, fn func(*ListProjectAssetsOutput, bool) bool) error {
	return c.ListProjectAssetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectAssetsPagesWithContext same as ListProjectAssetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListProjectAssetsPagesWithContext(ctx aws.Context, input *ListProjectAssetsInput, fn func(*ListProjectAssetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectAssetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectAssetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectAssetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects
func (c *IoTSiteWise) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "GET",
		HTTPPath:   "/projects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListProjects API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListProjects for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects
func (c *IoTSiteWise) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProjects operation.
//    pageNum := 0
//    err := client.ListProjectsPages(params,
//        func(page *iotsitewise.ListProjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListProjectsPages(input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool) error {
	return c.ListProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectsPagesWithContext same as ListProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListProjectsPagesWithContext(ctx aws.Context, input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource
func (c *IoTSiteWise) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTagsForResource API operation for AWS IoT SiteWise.
//
// Retrieves the list of tags for an IoT SiteWise resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * UnauthorizedException
//   You are not authorized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource
func (c *IoTSiteWise) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTimeSeries = "ListTimeSeries"

// ListTimeSeriesRequest generates a "aws/request.Request" representing the
// client's request for the ListTimeSeries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTimeSeries for more information on using the ListTimeSeries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTimeSeriesRequest method.
//    req, resp := client.ListTimeSeriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries
func (c *IoTSiteWise) ListTimeSeriesRequest(input *ListTimeSeriesInput) (req *request.Request, output *ListTimeSeriesOutput) {
	op := &request.Operation{
		Name:       opListTimeSeries,
		HTTPMethod: "GET",
		HTTPPath:   "/timeseries/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTimeSeriesInput{}
	}

	output = &ListTimeSeriesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTimeSeries API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of time series (data streams).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListTimeSeries for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries
func (c *IoTSiteWise) ListTimeSeries(input *ListTimeSeriesInput) (*ListTimeSeriesOutput, error) {
	req, out := c.ListTimeSeriesRequest(input)
	return out, req.Send()
}

// ListTimeSeriesWithContext is the same as ListTimeSeries with the addition of
// the ability to pass a context and additional request options.
//
// See ListTimeSeries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListTimeSeriesWithContext(ctx aws.Context, input *ListTimeSeriesInput, opts ...request.Option) (*ListTimeSeriesOutput, error) {
	req, out := c.ListTimeSeriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTimeSeriesPages iterates over the pages of a ListTimeSeries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTimeSeries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTimeSeries operation.
//    pageNum := 0
//    err := client.ListTimeSeriesPages(params,
//        func(page *iotsitewise.ListTimeSeriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListTimeSeriesPages(input *ListTimeSeriesInput, fn func(*ListTimeSeriesOutput, bool) bool) error {
	return c.ListTimeSeriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTimeSeriesPagesWithContext same as ListTimeSeriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListTimeSeriesPagesWithContext(ctx aws.Context, input *ListTimeSeriesInput, fn func(*ListTimeSeriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTimeSeriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTimeSeriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTimeSeriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutDefaultEncryptionConfiguration = "PutDefaultEncryptionConfiguration"

// PutDefaultEncryptionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutDefaultEncryptionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDefaultEncryptionConfiguration for more information on using the PutDefaultEncryptionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDefaultEncryptionConfigurationRequest method.
//    req, resp := client.PutDefaultEncryptionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutDefaultEncryptionConfiguration
func (c *IoTSiteWise) PutDefaultEncryptionConfigurationRequest(input *PutDefaultEncryptionConfigurationInput) (req *request.Request, output *PutDefaultEncryptionConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutDefaultEncryptionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/configuration/account/encryption",
	}

	if input == nil {
		input = &PutDefaultEncryptionConfigurationInput{}
	}

	output = &PutDefaultEncryptionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutDefaultEncryptionConfiguration API operation for AWS IoT SiteWise.
//
// Sets the default encryption configuration for the Amazon Web Services account.
// For more information, see Key management (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation PutDefaultEncryptionConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutDefaultEncryptionConfiguration
func (c *IoTSiteWise) PutDefaultEncryptionConfiguration(input *PutDefaultEncryptionConfigurationInput) (*PutDefaultEncryptionConfigurationOutput, error) {
	req, out := c.PutDefaultEncryptionConfigurationRequest(input)
	return out, req.Send()
}

// PutDefaultEncryptionConfigurationWithContext is the same as PutDefaultEncryptionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutDefaultEncryptionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) PutDefaultEncryptionConfigurationWithContext(ctx aws.Context, input *PutDefaultEncryptionConfigurationInput, opts ...request.Option) (*PutDefaultEncryptionConfigurationOutput, error) {
	req, out := c.PutDefaultEncryptionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLoggingOptions = "PutLoggingOptions"

// PutLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLoggingOptions for more information on using the PutLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLoggingOptionsRequest method.
//    req, resp := client.PutLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions
func (c *IoTSiteWise) PutLoggingOptionsRequest(input *PutLoggingOptionsInput) (req *request.Request, output *PutLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opPutLoggingOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/logging",
	}

	if input == nil {
		input = &PutLoggingOptionsInput{}
	}

	output = &PutLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutLoggingOptions API operation for AWS IoT SiteWise.
//
// Sets logging options for IoT SiteWise.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation PutLoggingOptions for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions
func (c *IoTSiteWise) PutLoggingOptions(input *PutLoggingOptionsInput) (*PutLoggingOptionsOutput, error) {
	req, out := c.PutLoggingOptionsRequest(input)
	return out, req.Send()
}

// PutLoggingOptionsWithContext is the same as PutLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) PutLoggingOptionsWithContext(ctx aws.Context, input *PutLoggingOptionsInput, opts ...request.Option) (*PutLoggingOptionsOutput, error) {
	req, out := c.PutLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutStorageConfiguration = "PutStorageConfiguration"

// PutStorageConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutStorageConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutStorageConfiguration for more information on using the PutStorageConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutStorageConfigurationRequest method.
//    req, resp := client.PutStorageConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutStorageConfiguration
func (c *IoTSiteWise) PutStorageConfigurationRequest(input *PutStorageConfigurationInput) (req *request.Request, output *PutStorageConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutStorageConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/configuration/account/storage",
	}

	if input == nil {
		input = &PutStorageConfigurationInput{}
	}

	output = &PutStorageConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutStorageConfiguration API operation for AWS IoT SiteWise.
//
// Configures storage settings for IoT SiteWise.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation PutStorageConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutStorageConfiguration
func (c *IoTSiteWise) PutStorageConfiguration(input *PutStorageConfigurationInput) (*PutStorageConfigurationOutput, error) {
	req, out := c.PutStorageConfigurationRequest(input)
	return out, req.Send()
}

// PutStorageConfigurationWithContext is the same as PutStorageConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutStorageConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) PutStorageConfigurationWithContext(ctx aws.Context, input *PutStorageConfigurationInput, opts ...request.Option) (*PutStorageConfigurationOutput, error) {
	req, out := c.PutStorageConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource
func (c *IoTSiteWise) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// TagResource API operation for AWS IoT SiteWise.
//
// Adds tags to an IoT SiteWise resource. If a tag already exists for the resource,
// this operation updates the tag's value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * UnauthorizedException
//   You are not authorized.
//
//   * TooManyTagsException
//   You've reached the limit for the number of tags allowed for a resource. For
//   more information, see Tag naming limits and requirements (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions)
//   in the Amazon Web Services General Reference.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource
func (c *IoTSiteWise) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource
func (c *IoTSiteWise) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UntagResource API operation for AWS IoT SiteWise.
//
// Removes a tag from an IoT SiteWise resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * UnauthorizedException
//   You are not authorized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource
func (c *IoTSiteWise) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccessPolicy = "UpdateAccessPolicy"

// UpdateAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccessPolicy for more information on using the UpdateAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccessPolicyRequest method.
//    req, resp := client.UpdateAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy
func (c *IoTSiteWise) UpdateAccessPolicyRequest(input *UpdateAccessPolicyInput) (req *request.Request, output *UpdateAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateAccessPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/access-policies/{accessPolicyId}",
	}

	if input == nil {
		input = &UpdateAccessPolicyInput{}
	}

	output = &UpdateAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAccessPolicy API operation for AWS IoT SiteWise.
//
// Updates an existing access policy that specifies an identity's access to
// an IoT SiteWise Monitor portal or project resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy
func (c *IoTSiteWise) UpdateAccessPolicy(input *UpdateAccessPolicyInput) (*UpdateAccessPolicyOutput, error) {
	req, out := c.UpdateAccessPolicyRequest(input)
	return out, req.Send()
}

// UpdateAccessPolicyWithContext is the same as UpdateAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateAccessPolicyWithContext(ctx aws.Context, input *UpdateAccessPolicyInput, opts ...request.Option) (*UpdateAccessPolicyOutput, error) {
	req, out := c.UpdateAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAsset = "UpdateAsset"

// UpdateAssetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAsset for more information on using the UpdateAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssetRequest method.
//    req, resp := client.UpdateAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset
func (c *IoTSiteWise) UpdateAssetRequest(input *UpdateAssetInput) (req *request.Request, output *UpdateAssetOutput) {
	op := &request.Operation{
		Name:       opUpdateAsset,
		HTTPMethod: "PUT",
		HTTPPath:   "/assets/{assetId}",
	}

	if input == nil {
		input = &UpdateAssetInput{}
	}

	output = &UpdateAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAsset API operation for AWS IoT SiteWise.
//
// Updates an asset's name. For more information, see Updating assets and models
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html)
// in the IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateAsset for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset
func (c *IoTSiteWise) UpdateAsset(input *UpdateAssetInput) (*UpdateAssetOutput, error) {
	req, out := c.UpdateAssetRequest(input)
	return out, req.Send()
}

// UpdateAssetWithContext is the same as UpdateAsset with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateAssetWithContext(ctx aws.Context, input *UpdateAssetInput, opts ...request.Option) (*UpdateAssetOutput, error) {
	req, out := c.UpdateAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssetModel = "UpdateAssetModel"

// UpdateAssetModelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssetModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssetModel for more information on using the UpdateAssetModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssetModelRequest method.
//    req, resp := client.UpdateAssetModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel
func (c *IoTSiteWise) UpdateAssetModelRequest(input *UpdateAssetModelInput) (req *request.Request, output *UpdateAssetModelOutput) {
	op := &request.Operation{
		Name:       opUpdateAssetModel,
		HTTPMethod: "PUT",
		HTTPPath:   "/asset-models/{assetModelId}",
	}

	if input == nil {
		input = &UpdateAssetModelInput{}
	}

	output = &UpdateAssetModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAssetModel API operation for AWS IoT SiteWise.
//
// Updates an asset model and all of the assets that were created from the model.
// Each asset created from the model inherits the updated asset model's property
// and hierarchy definitions. For more information, see Updating assets and
// models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html)
// in the IoT SiteWise User Guide.
//
// This operation overwrites the existing model with the provided model. To
// avoid deleting your asset model's properties or hierarchies, you must include
// their IDs and definitions in the updated asset model payload. For more information,
// see DescribeAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html).
//
// If you remove a property from an asset model, IoT SiteWise deletes all previous
// data for that property. If you remove a hierarchy definition from an asset
// model, IoT SiteWise disassociates every asset associated with that hierarchy.
// You can't change the type or data type of an existing property.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateAssetModel for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel
func (c *IoTSiteWise) UpdateAssetModel(input *UpdateAssetModelInput) (*UpdateAssetModelOutput, error) {
	req, out := c.UpdateAssetModelRequest(input)
	return out, req.Send()
}

// UpdateAssetModelWithContext is the same as UpdateAssetModel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssetModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateAssetModelWithContext(ctx aws.Context, input *UpdateAssetModelInput, opts ...request.Option) (*UpdateAssetModelOutput, error) {
	req, out := c.UpdateAssetModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssetProperty = "UpdateAssetProperty"

// UpdateAssetPropertyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssetProperty operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssetProperty for more information on using the UpdateAssetProperty
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssetPropertyRequest method.
//    req, resp := client.UpdateAssetPropertyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty
func (c *IoTSiteWise) UpdateAssetPropertyRequest(input *UpdateAssetPropertyInput) (req *request.Request, output *UpdateAssetPropertyOutput) {
	op := &request.Operation{
		Name:       opUpdateAssetProperty,
		HTTPMethod: "PUT",
		HTTPPath:   "/assets/{assetId}/properties/{propertyId}",
	}

	if input == nil {
		input = &UpdateAssetPropertyInput{}
	}

	output = &UpdateAssetPropertyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAssetProperty API operation for AWS IoT SiteWise.
//
// Updates an asset property's alias and notification state.
//
// This operation overwrites the property's existing alias and notification
// state. To keep your existing property's alias or notification state, you
// must include the existing values in the UpdateAssetProperty request. For
// more information, see DescribeAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateAssetProperty for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty
func (c *IoTSiteWise) UpdateAssetProperty(input *UpdateAssetPropertyInput) (*UpdateAssetPropertyOutput, error) {
	req, out := c.UpdateAssetPropertyRequest(input)
	return out, req.Send()
}

// UpdateAssetPropertyWithContext is the same as UpdateAssetProperty with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssetProperty for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateAssetPropertyWithContext(ctx aws.Context, input *UpdateAssetPropertyInput, opts ...request.Option) (*UpdateAssetPropertyOutput, error) {
	req, out := c.UpdateAssetPropertyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboard = "UpdateDashboard"

// UpdateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboard for more information on using the UpdateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDashboardRequest method.
//    req, resp := client.UpdateDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard
func (c *IoTSiteWise) UpdateDashboardRequest(input *UpdateDashboardInput) (req *request.Request, output *UpdateDashboardOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboard,
		HTTPMethod: "PUT",
		HTTPPath:   "/dashboards/{dashboardId}",
	}

	if input == nil {
		input = &UpdateDashboardInput{}
	}

	output = &UpdateDashboardOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateDashboard API operation for AWS IoT SiteWise.
//
// Updates an IoT SiteWise Monitor dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateDashboard for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard
func (c *IoTSiteWise) UpdateDashboard(input *UpdateDashboardInput) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	return out, req.Send()
}

// UpdateDashboardWithContext is the same as UpdateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateDashboardWithContext(ctx aws.Context, input *UpdateDashboardInput, opts ...request.Option) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGateway = "UpdateGateway"

// UpdateGatewayRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGateway for more information on using the UpdateGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGatewayRequest method.
//    req, resp := client.UpdateGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway
func (c *IoTSiteWise) UpdateGatewayRequest(input *UpdateGatewayInput) (req *request.Request, output *UpdateGatewayOutput) {
	op := &request.Operation{
		Name:       opUpdateGateway,
		HTTPMethod: "PUT",
		HTTPPath:   "/20200301/gateways/{gatewayId}",
	}

	if input == nil {
		input = &UpdateGatewayInput{}
	}

	output = &UpdateGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateGateway API operation for AWS IoT SiteWise.
//
// Updates a gateway's name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway
func (c *IoTSiteWise) UpdateGateway(input *UpdateGatewayInput) (*UpdateGatewayOutput, error) {
	req, out := c.UpdateGatewayRequest(input)
	return out, req.Send()
}

// UpdateGatewayWithContext is the same as UpdateGateway with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateGatewayWithContext(ctx aws.Context, input *UpdateGatewayInput, opts ...request.Option) (*UpdateGatewayOutput, error) {
	req, out := c.UpdateGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGatewayCapabilityConfiguration = "UpdateGatewayCapabilityConfiguration"

// UpdateGatewayCapabilityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewayCapabilityConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGatewayCapabilityConfiguration for more information on using the UpdateGatewayCapabilityConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGatewayCapabilityConfigurationRequest method.
//    req, resp := client.UpdateGatewayCapabilityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration
func (c *IoTSiteWise) UpdateGatewayCapabilityConfigurationRequest(input *UpdateGatewayCapabilityConfigurationInput) (req *request.Request, output *UpdateGatewayCapabilityConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewayCapabilityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/20200301/gateways/{gatewayId}/capability",
	}

	if input == nil {
		input = &UpdateGatewayCapabilityConfigurationInput{}
	}

	output = &UpdateGatewayCapabilityConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateGatewayCapabilityConfiguration API operation for AWS IoT SiteWise.
//
// Updates a gateway capability configuration or defines a new capability configuration.
// Each gateway capability defines data sources for a gateway. A capability
// configuration can contain multiple data source configurations. If you define
// OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA
// sources are stored in one capability configuration. To list all capability
// configurations for a gateway, use DescribeGateway (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateGatewayCapabilityConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration
func (c *IoTSiteWise) UpdateGatewayCapabilityConfiguration(input *UpdateGatewayCapabilityConfigurationInput) (*UpdateGatewayCapabilityConfigurationOutput, error) {
	req, out := c.UpdateGatewayCapabilityConfigurationRequest(input)
	return out, req.Send()
}

// UpdateGatewayCapabilityConfigurationWithContext is the same as UpdateGatewayCapabilityConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGatewayCapabilityConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateGatewayCapabilityConfigurationWithContext(ctx aws.Context, input *UpdateGatewayCapabilityConfigurationInput, opts ...request.Option) (*UpdateGatewayCapabilityConfigurationOutput, error) {
	req, out := c.UpdateGatewayCapabilityConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePortal = "UpdatePortal"

// UpdatePortalRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePortal for more information on using the UpdatePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePortalRequest method.
//    req, resp := client.UpdatePortalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal
func (c *IoTSiteWise) UpdatePortalRequest(input *UpdatePortalInput) (req *request.Request, output *UpdatePortalOutput) {
	op := &request.Operation{
		Name:       opUpdatePortal,
		HTTPMethod: "PUT",
		HTTPPath:   "/portals/{portalId}",
	}

	if input == nil {
		input = &UpdatePortalInput{}
	}

	output = &UpdatePortalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdatePortal API operation for AWS IoT SiteWise.
//
// Updates an IoT SiteWise Monitor portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdatePortal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal
func (c *IoTSiteWise) UpdatePortal(input *UpdatePortalInput) (*UpdatePortalOutput, error) {
	req, out := c.UpdatePortalRequest(input)
	return out, req.Send()
}

// UpdatePortalWithContext is the same as UpdatePortal with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdatePortalWithContext(ctx aws.Context, input *UpdatePortalInput, opts ...request.Option) (*UpdatePortalOutput, error) {
	req, out := c.UpdatePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProjectRequest method.
//    req, resp := client.UpdateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject
func (c *IoTSiteWise) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{projectId}",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateProject API operation for AWS IoT SiteWise.
//
// Updates an IoT SiteWise Monitor project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateProject for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of IoT SiteWise assets that can be created per second, the allowed
//   number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject
func (c *IoTSiteWise) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains an access policy that defines an identity's access to an IoT SiteWise
// Monitor resource.
type AccessPolicySummary struct {
	_ struct{} `type:"structure"`

	// The date the access policy was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The ID of the access policy.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO
	// group, or an IAM user).
	//
	// Identity is a required field
	Identity *Identity `locationName:"identity" type:"structure" required:"true"`

	// The date the access policy was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The permissions for the access policy. Note that a project ADMINISTRATOR
	// is also known as a project owner.
	//
	// Permission is a required field
	Permission *string `locationName:"permission" type:"string" required:"true" enum:"Permission"`

	// The IoT SiteWise Monitor resource (a portal or project).
	//
	// Resource is a required field
	Resource *Resource `locationName:"resource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPolicySummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *AccessPolicySummary) SetCreationDate(v time.Time) *AccessPolicySummary {
	s.CreationDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *AccessPolicySummary) SetId(v string) *AccessPolicySummary {
	s.Id = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *AccessPolicySummary) SetIdentity(v *Identity) *AccessPolicySummary {
	s.Identity = v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *AccessPolicySummary) SetLastUpdateDate(v time.Time) *AccessPolicySummary {
	s.LastUpdateDate = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *AccessPolicySummary) SetPermission(v string) *AccessPolicySummary {
	s.Permission = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *AccessPolicySummary) SetResource(v *Resource) *AccessPolicySummary {
	s.Resource = v
	return s
}

// Contains aggregated asset property values (for example, average, minimum,
// and maximum).
type AggregatedValue struct {
	_ struct{} `type:"structure"`

	// The quality of the aggregated data.
	Quality *string `locationName:"quality" type:"string" enum:"Quality"`

	// The date the aggregating computations occurred, in Unix epoch time.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" required:"true"`

	// The value of the aggregates.
	//
	// Value is a required field
	Value *Aggregates `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedValue) GoString() string {
	return s.String()
}

// SetQuality sets the Quality field's value.
func (s *AggregatedValue) SetQuality(v string) *AggregatedValue {
	s.Quality = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *AggregatedValue) SetTimestamp(v time.Time) *AggregatedValue {
	s.Timestamp = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AggregatedValue) SetValue(v *Aggregates) *AggregatedValue {
	s.Value = v
	return s
}

// Contains the (pre-calculated) aggregate values for an asset property.
type Aggregates struct {
	_ struct{} `type:"structure"`

	// The average (mean) value of the time series over a time interval window.
	Average *float64 `locationName:"average" type:"double"`

	// The count of data points in the time series over a time interval window.
	Count *float64 `locationName:"count" type:"double"`

	// The maximum value of the time series over a time interval window.
	Maximum *float64 `locationName:"maximum" type:"double"`

	// The minimum value of the time series over a time interval window.
	Minimum *float64 `locationName:"minimum" type:"double"`

	// The standard deviation of the time series over a time interval window.
	StandardDeviation *float64 `locationName:"standardDeviation" type:"double"`

	// The sum of the time series over a time interval window.
	Sum *float64 `locationName:"sum" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Aggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Aggregates) GoString() string {
	return s.String()
}

// SetAverage sets the Average field's value.
func (s *Aggregates) SetAverage(v float64) *Aggregates {
	s.Average = &v
	return s
}

// SetCount sets the Count field's value.
func (s *Aggregates) SetCount(v float64) *Aggregates {
	s.Count = &v
	return s
}

// SetMaximum sets the Maximum field's value.
func (s *Aggregates) SetMaximum(v float64) *Aggregates {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *Aggregates) SetMinimum(v float64) *Aggregates {
	s.Minimum = &v
	return s
}

// SetStandardDeviation sets the StandardDeviation field's value.
func (s *Aggregates) SetStandardDeviation(v float64) *Aggregates {
	s.StandardDeviation = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *Aggregates) SetSum(v float64) *Aggregates {
	s.Sum = &v
	return s
}

// Contains the configuration information of an alarm created in an IoT SiteWise
// Monitor portal. You can use the alarm to monitor an asset property and get
// notified when the asset property value is outside a specified range. For
// more information, see Monitoring with alarms (https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html)
// in the IoT SiteWise Application Guide.
type Alarms struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the IAM role that allows the alarm to perform actions and access Amazon
	// Web Services resources and services, such as IoT Events.
	//
	// AlarmRoleArn is a required field
	AlarmRoleArn *string `locationName:"alarmRoleArn" min:"1" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Lambda function that manages alarm notifications. For more information,
	// see Managing alarm notifications (https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html)
	// in the IoT Events Developer Guide.
	NotificationLambdaArn *string `locationName:"notificationLambdaArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alarms) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alarms) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Alarms) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Alarms"}
	if s.AlarmRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmRoleArn"))
	}
	if s.AlarmRoleArn != nil && len(*s.AlarmRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmRoleArn", 1))
	}
	if s.NotificationLambdaArn != nil && len(*s.NotificationLambdaArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NotificationLambdaArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmRoleArn sets the AlarmRoleArn field's value.
func (s *Alarms) SetAlarmRoleArn(v string) *Alarms {
	s.AlarmRoleArn = &v
	return s
}

// SetNotificationLambdaArn sets the NotificationLambdaArn field's value.
func (s *Alarms) SetNotificationLambdaArn(v string) *Alarms {
	s.NotificationLambdaArn = &v
	return s
}

// Contains information about a composite model in an asset. This object contains
// the asset's properties that you define in the composite model.
type AssetCompositeModel struct {
	_ struct{} `type:"structure"`

	// The description of the composite model.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the composite model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The asset properties that this composite model defines.
	//
	// Properties is a required field
	Properties []*AssetProperty `locationName:"properties" type:"list" required:"true"`

	// The type of the composite model. For alarm composite models, this type is
	// AWS/ALARM.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetCompositeModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetCompositeModel) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *AssetCompositeModel) SetDescription(v string) *AssetCompositeModel {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetCompositeModel) SetName(v string) *AssetCompositeModel {
	s.Name = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *AssetCompositeModel) SetProperties(v []*AssetProperty) *AssetCompositeModel {
	s.Properties = v
	return s
}

// SetType sets the Type field's value.
func (s *AssetCompositeModel) SetType(v string) *AssetCompositeModel {
	s.Type = &v
	return s
}

// Contains error details for the requested associate project asset action.
type AssetErrorDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"AssetErrorCode"`

	// The error message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetErrorDetails) GoString() string {
	return s.String()
}

// SetAssetId sets the AssetId field's value.
func (s *AssetErrorDetails) SetAssetId(v string) *AssetErrorDetails {
	s.AssetId = &v
	return s
}

// SetCode sets the Code field's value.
func (s *AssetErrorDetails) SetCode(v string) *AssetErrorDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AssetErrorDetails) SetMessage(v string) *AssetErrorDetails {
	s.Message = &v
	return s
}

// Describes an asset hierarchy that contains a hierarchy's name and ID.
type AssetHierarchy struct {
	_ struct{} `type:"structure"`

	// The ID of the hierarchy. This ID is a hierarchyId.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The hierarchy name provided in the CreateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)
	// API operation.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetHierarchy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetHierarchy) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *AssetHierarchy) SetId(v string) *AssetHierarchy {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetHierarchy) SetName(v string) *AssetHierarchy {
	s.Name = &v
	return s
}

// Contains information about a parent asset and a child asset that are related
// through an asset hierarchy.
type AssetHierarchyInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the child asset in this asset relationship.
	ChildAssetId *string `locationName:"childAssetId" min:"36" type:"string"`

	// The ID of the parent asset in this asset relationship.
	ParentAssetId *string `locationName:"parentAssetId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetHierarchyInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetHierarchyInfo) GoString() string {
	return s.String()
}

// SetChildAssetId sets the ChildAssetId field's value.
func (s *AssetHierarchyInfo) SetChildAssetId(v string) *AssetHierarchyInfo {
	s.ChildAssetId = &v
	return s
}

// SetParentAssetId sets the ParentAssetId field's value.
func (s *AssetHierarchyInfo) SetParentAssetId(v string) *AssetHierarchyInfo {
	s.ParentAssetId = &v
	return s
}

// Contains information about a composite model in an asset model. This object
// contains the asset property definitions that you define in the composite
// model.
type AssetModelCompositeModel struct {
	_ struct{} `type:"structure"`

	// The description of the composite model.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the composite model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The asset property definitions for this composite model.
	Properties []*AssetModelProperty `locationName:"properties" type:"list"`

	// The type of the composite model. For alarm composite models, this type is
	// AWS/ALARM.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelCompositeModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelCompositeModel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelCompositeModel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetModelCompositeModel"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}
	if s.Properties != nil {
		for i, v := range s.Properties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Properties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *AssetModelCompositeModel) SetDescription(v string) *AssetModelCompositeModel {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelCompositeModel) SetName(v string) *AssetModelCompositeModel {
	s.Name = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *AssetModelCompositeModel) SetProperties(v []*AssetModelProperty) *AssetModelCompositeModel {
	s.Properties = v
	return s
}

// SetType sets the Type field's value.
func (s *AssetModelCompositeModel) SetType(v string) *AssetModelCompositeModel {
	s.Type = &v
	return s
}

// Contains a composite model definition in an asset model. This composite model
// definition is applied to all assets created from the asset model.
type AssetModelCompositeModelDefinition struct {
	_ struct{} `type:"structure"`

	// The description of the composite model.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the composite model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The asset property definitions for this composite model.
	Properties []*AssetModelPropertyDefinition `locationName:"properties" type:"list"`

	// The type of the composite model. For alarm composite models, this type is
	// AWS/ALARM.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelCompositeModelDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelCompositeModelDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelCompositeModelDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetModelCompositeModelDefinition"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}
	if s.Properties != nil {
		for i, v := range s.Properties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Properties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *AssetModelCompositeModelDefinition) SetDescription(v string) *AssetModelCompositeModelDefinition {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelCompositeModelDefinition) SetName(v string) *AssetModelCompositeModelDefinition {
	s.Name = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *AssetModelCompositeModelDefinition) SetProperties(v []*AssetModelPropertyDefinition) *AssetModelCompositeModelDefinition {
	s.Properties = v
	return s
}

// SetType sets the Type field's value.
func (s *AssetModelCompositeModelDefinition) SetType(v string) *AssetModelCompositeModelDefinition {
	s.Type = &v
	return s
}

// Describes an asset hierarchy that contains a hierarchy's name, ID, and child
// asset model ID that specifies the type of asset that can be in this hierarchy.
type AssetModelHierarchy struct {
	_ struct{} `type:"structure"`

	// The ID of the asset model. All assets in this hierarchy must be instances
	// of the childAssetModelId asset model.
	//
	// ChildAssetModelId is a required field
	ChildAssetModelId *string `locationName:"childAssetModelId" min:"36" type:"string" required:"true"`

	// The ID of the asset model hierarchy. This ID is a hierarchyId.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name of the asset model hierarchy that you specify by using the CreateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)
	// API operation.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelHierarchy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelHierarchy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelHierarchy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetModelHierarchy"}
	if s.ChildAssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildAssetModelId"))
	}
	if s.ChildAssetModelId != nil && len(*s.ChildAssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ChildAssetModelId", 36))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildAssetModelId sets the ChildAssetModelId field's value.
func (s *AssetModelHierarchy) SetChildAssetModelId(v string) *AssetModelHierarchy {
	s.ChildAssetModelId = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetModelHierarchy) SetId(v string) *AssetModelHierarchy {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelHierarchy) SetName(v string) *AssetModelHierarchy {
	s.Name = &v
	return s
}

// Contains an asset model hierarchy used in asset model creation. An asset
// model hierarchy determines the kind (or type) of asset that can belong to
// a hierarchy.
type AssetModelHierarchyDefinition struct {
	_ struct{} `type:"structure"`

	// The ID of an asset model for this hierarchy.
	//
	// ChildAssetModelId is a required field
	ChildAssetModelId *string `locationName:"childAssetModelId" min:"36" type:"string" required:"true"`

	// The name of the asset model hierarchy definition (as specified in the CreateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)
	// API operation).
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelHierarchyDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelHierarchyDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelHierarchyDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetModelHierarchyDefinition"}
	if s.ChildAssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildAssetModelId"))
	}
	if s.ChildAssetModelId != nil && len(*s.ChildAssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ChildAssetModelId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildAssetModelId sets the ChildAssetModelId field's value.
func (s *AssetModelHierarchyDefinition) SetChildAssetModelId(v string) *AssetModelHierarchyDefinition {
	s.ChildAssetModelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelHierarchyDefinition) SetName(v string) *AssetModelHierarchyDefinition {
	s.Name = &v
	return s
}

// Contains information about an asset model property.
type AssetModelProperty struct {
	_ struct{} `type:"structure"`

	// The data type of the asset model property.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"PropertyDataType"`

	// The data type of the structure for this property. This parameter exists on
	// properties that have the STRUCT data type.
	DataTypeSpec *string `locationName:"dataTypeSpec" min:"1" type:"string"`

	// The ID of the asset model property.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name of the asset model property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The property type (see PropertyType).
	//
	// Type is a required field
	Type *PropertyType `locationName:"type" type:"structure" required:"true"`

	// The unit of the asset model property, such as Newtons or RPM.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetModelProperty"}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.DataTypeSpec != nil && len(*s.DataTypeSpec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataTypeSpec", 1))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Unit != nil && len(*s.Unit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Unit", 1))
	}
	if s.Type != nil {
		if err := s.Type.Validate(); err != nil {
			invalidParams.AddNested("Type", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataType sets the DataType field's value.
func (s *AssetModelProperty) SetDataType(v string) *AssetModelProperty {
	s.DataType = &v
	return s
}

// SetDataTypeSpec sets the DataTypeSpec field's value.
func (s *AssetModelProperty) SetDataTypeSpec(v string) *AssetModelProperty {
	s.DataTypeSpec = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetModelProperty) SetId(v string) *AssetModelProperty {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelProperty) SetName(v string) *AssetModelProperty {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AssetModelProperty) SetType(v *PropertyType) *AssetModelProperty {
	s.Type = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *AssetModelProperty) SetUnit(v string) *AssetModelProperty {
	s.Unit = &v
	return s
}

// Contains an asset model property definition. This property definition is
// applied to all assets created from the asset model.
type AssetModelPropertyDefinition struct {
	_ struct{} `type:"structure"`

	// The data type of the property definition.
	//
	// If you specify STRUCT, you must also specify dataTypeSpec to identify the
	// type of the structure for this property.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"PropertyDataType"`

	// The data type of the structure for this property. This parameter is required
	// on properties that have the STRUCT data type.
	//
	// The options for this parameter depend on the type of the composite model
	// in which you define this property. Use AWS/ALARM_STATE for alarm state in
	// alarm composite models.
	DataTypeSpec *string `locationName:"dataTypeSpec" min:"1" type:"string"`

	// The name of the property definition.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The property definition type (see PropertyType). You can only specify one
	// type in a property definition.
	//
	// Type is a required field
	Type *PropertyType `locationName:"type" type:"structure" required:"true"`

	// The unit of the property definition, such as Newtons or RPM.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelPropertyDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelPropertyDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelPropertyDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetModelPropertyDefinition"}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.DataTypeSpec != nil && len(*s.DataTypeSpec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataTypeSpec", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Unit != nil && len(*s.Unit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Unit", 1))
	}
	if s.Type != nil {
		if err := s.Type.Validate(); err != nil {
			invalidParams.AddNested("Type", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataType sets the DataType field's value.
func (s *AssetModelPropertyDefinition) SetDataType(v string) *AssetModelPropertyDefinition {
	s.DataType = &v
	return s
}

// SetDataTypeSpec sets the DataTypeSpec field's value.
func (s *AssetModelPropertyDefinition) SetDataTypeSpec(v string) *AssetModelPropertyDefinition {
	s.DataTypeSpec = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelPropertyDefinition) SetName(v string) *AssetModelPropertyDefinition {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AssetModelPropertyDefinition) SetType(v *PropertyType) *AssetModelPropertyDefinition {
	s.Type = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *AssetModelPropertyDefinition) SetUnit(v string) *AssetModelPropertyDefinition {
	s.Unit = &v
	return s
}

// Contains current status information for an asset model. For more information,
// see Asset and model states (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html)
// in the IoT SiteWise User Guide.
type AssetModelStatus struct {
	_ struct{} `type:"structure"`

	// Contains associated error information, if any.
	Error *ErrorDetails `locationName:"error" type:"structure"`

	// The current state of the asset model.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"AssetModelState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelStatus) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *AssetModelStatus) SetError(v *ErrorDetails) *AssetModelStatus {
	s.Error = v
	return s
}

// SetState sets the State field's value.
func (s *AssetModelStatus) SetState(v string) *AssetModelStatus {
	s.State = &v
	return s
}

// Contains a summary of an asset model.
type AssetModelSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset model, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The date the asset model was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The asset model description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The ID of the asset model (used with IoT SiteWise APIs).
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the asset model was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current status of the asset model.
	//
	// Status is a required field
	Status *AssetModelStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetModelSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetModelSummary) SetArn(v string) *AssetModelSummary {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AssetModelSummary) SetCreationDate(v time.Time) *AssetModelSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssetModelSummary) SetDescription(v string) *AssetModelSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetModelSummary) SetId(v string) *AssetModelSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *AssetModelSummary) SetLastUpdateDate(v time.Time) *AssetModelSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelSummary) SetName(v string) *AssetModelSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssetModelSummary) SetStatus(v *AssetModelStatus) *AssetModelSummary {
	s.Status = v
	return s
}

// Contains asset property information.
type AssetProperty struct {
	_ struct{} `type:"structure"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The data type of the asset property.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"PropertyDataType"`

	// The data type of the structure for this property. This parameter exists on
	// properties that have the STRUCT data type.
	DataTypeSpec *string `locationName:"dataTypeSpec" min:"1" type:"string"`

	// The ID of the asset property.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The asset property's notification topic and state. For more information,
	// see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
	Notification *PropertyNotification `locationName:"notification" type:"structure"`

	// The unit (such as Newtons or RPM) of the asset property.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetProperty) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *AssetProperty) SetAlias(v string) *AssetProperty {
	s.Alias = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *AssetProperty) SetDataType(v string) *AssetProperty {
	s.DataType = &v
	return s
}

// SetDataTypeSpec sets the DataTypeSpec field's value.
func (s *AssetProperty) SetDataTypeSpec(v string) *AssetProperty {
	s.DataTypeSpec = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetProperty) SetId(v string) *AssetProperty {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetProperty) SetName(v string) *AssetProperty {
	s.Name = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *AssetProperty) SetNotification(v *PropertyNotification) *AssetProperty {
	s.Notification = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *AssetProperty) SetUnit(v string) *AssetProperty {
	s.Unit = &v
	return s
}

// Contains asset property value information.
type AssetPropertyValue struct {
	_ struct{} `type:"structure"`

	// The quality of the asset property value.
	Quality *string `locationName:"quality" type:"string" enum:"Quality"`

	// The timestamp of the asset property value.
	//
	// Timestamp is a required field
	Timestamp *TimeInNanos `locationName:"timestamp" type:"structure" required:"true"`

	// The value of the asset property (see Variant).
	//
	// Value is a required field
	Value *Variant `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetPropertyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetPropertyValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetPropertyValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetPropertyValue"}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Timestamp != nil {
		if err := s.Timestamp.Validate(); err != nil {
			invalidParams.AddNested("Timestamp", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuality sets the Quality field's value.
func (s *AssetPropertyValue) SetQuality(v string) *AssetPropertyValue {
	s.Quality = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *AssetPropertyValue) SetTimestamp(v *TimeInNanos) *AssetPropertyValue {
	s.Timestamp = v
	return s
}

// SetValue sets the Value field's value.
func (s *AssetPropertyValue) SetValue(v *Variant) *AssetPropertyValue {
	s.Value = v
	return s
}

// Contains information about assets that are related to one another.
type AssetRelationshipSummary struct {
	_ struct{} `type:"structure"`

	// The assets that are related through an asset hierarchy.
	//
	// This object is present if the relationshipType is HIERARCHY.
	HierarchyInfo *AssetHierarchyInfo `locationName:"hierarchyInfo" type:"structure"`

	// The relationship type of the assets in this relationship. This value is one
	// of the following:
	//
	//    * HIERARCHY – The assets are related through an asset hierarchy. If
	//    you specify this relationship type, this asset relationship includes the
	//    hierarchyInfo object.
	//
	// RelationshipType is a required field
	RelationshipType *string `locationName:"relationshipType" type:"string" required:"true" enum:"AssetRelationshipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetRelationshipSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetRelationshipSummary) GoString() string {
	return s.String()
}

// SetHierarchyInfo sets the HierarchyInfo field's value.
func (s *AssetRelationshipSummary) SetHierarchyInfo(v *AssetHierarchyInfo) *AssetRelationshipSummary {
	s.HierarchyInfo = v
	return s
}

// SetRelationshipType sets the RelationshipType field's value.
func (s *AssetRelationshipSummary) SetRelationshipType(v string) *AssetRelationshipSummary {
	s.RelationshipType = &v
	return s
}

// Contains information about the current status of an asset. For more information,
// see Asset and model states (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html)
// in the IoT SiteWise User Guide.
type AssetStatus struct {
	_ struct{} `type:"structure"`

	// Contains associated error information, if any.
	Error *ErrorDetails `locationName:"error" type:"structure"`

	// The current status of the asset.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"AssetState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetStatus) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *AssetStatus) SetError(v *ErrorDetails) *AssetStatus {
	s.Error = v
	return s
}

// SetState sets the State field's value.
func (s *AssetStatus) SetState(v string) *AssetStatus {
	s.State = &v
	return s
}

// Contains a summary of an asset.
type AssetSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The ID of the asset model used to create this asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The date the asset was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// Hierarchies is a required field
	Hierarchies []*AssetHierarchy `locationName:"hierarchies" type:"list" required:"true"`

	// The ID of the asset.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the asset was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current status of the asset.
	//
	// Status is a required field
	Status *AssetStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetSummary) SetArn(v string) *AssetSummary {
	s.Arn = &v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *AssetSummary) SetAssetModelId(v string) *AssetSummary {
	s.AssetModelId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AssetSummary) SetCreationDate(v time.Time) *AssetSummary {
	s.CreationDate = &v
	return s
}

// SetHierarchies sets the Hierarchies field's value.
func (s *AssetSummary) SetHierarchies(v []*AssetHierarchy) *AssetSummary {
	s.Hierarchies = v
	return s
}

// SetId sets the Id field's value.
func (s *AssetSummary) SetId(v string) *AssetSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *AssetSummary) SetLastUpdateDate(v time.Time) *AssetSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetSummary) SetName(v string) *AssetSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssetSummary) SetStatus(v *AssetStatus) *AssetSummary {
	s.Status = v
	return s
}

type AssociateAssetsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the parent asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// The ID of the child asset to be associated.
	//
	// ChildAssetId is a required field
	ChildAssetId *string `locationName:"childAssetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of a hierarchy in the parent asset's model. Hierarchies allow different
	// groupings of assets to be formed that all come from the same asset model.
	// For more information, see Asset hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the IoT SiteWise User Guide.
	//
	// HierarchyId is a required field
	HierarchyId *string `locationName:"hierarchyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAssetsInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ChildAssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildAssetId"))
	}
	if s.ChildAssetId != nil && len(*s.ChildAssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ChildAssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.HierarchyId == nil {
		invalidParams.Add(request.NewErrParamRequired("HierarchyId"))
	}
	if s.HierarchyId != nil && len(*s.HierarchyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *AssociateAssetsInput) SetAssetId(v string) *AssociateAssetsInput {
	s.AssetId = &v
	return s
}

// SetChildAssetId sets the ChildAssetId field's value.
func (s *AssociateAssetsInput) SetChildAssetId(v string) *AssociateAssetsInput {
	s.ChildAssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateAssetsInput) SetClientToken(v string) *AssociateAssetsInput {
	s.ClientToken = &v
	return s
}

// SetHierarchyId sets the HierarchyId field's value.
func (s *AssociateAssetsInput) SetHierarchyId(v string) *AssociateAssetsInput {
	s.HierarchyId = &v
	return s
}

type AssociateAssetsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAssetsOutput) GoString() string {
	return s.String()
}

type AssociateTimeSeriesToAssetPropertyInput struct {
	_ struct{} `type:"structure"`

	// The alias that identifies the time series.
	//
	// Alias is a required field
	Alias *string `location:"querystring" locationName:"alias" min:"1" type:"string" required:"true"`

	// The ID of the asset in which the asset property was created.
	//
	// AssetId is a required field
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the asset property.
	//
	// PropertyId is a required field
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTimeSeriesToAssetPropertyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTimeSeriesToAssetPropertyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTimeSeriesToAssetPropertyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateTimeSeriesToAssetPropertyInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PropertyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyId"))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *AssociateTimeSeriesToAssetPropertyInput) SetAlias(v string) *AssociateTimeSeriesToAssetPropertyInput {
	s.Alias = &v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *AssociateTimeSeriesToAssetPropertyInput) SetAssetId(v string) *AssociateTimeSeriesToAssetPropertyInput {
	s.AssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateTimeSeriesToAssetPropertyInput) SetClientToken(v string) *AssociateTimeSeriesToAssetPropertyInput {
	s.ClientToken = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *AssociateTimeSeriesToAssetPropertyInput) SetPropertyId(v string) *AssociateTimeSeriesToAssetPropertyInput {
	s.PropertyId = &v
	return s
}

type AssociateTimeSeriesToAssetPropertyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTimeSeriesToAssetPropertyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTimeSeriesToAssetPropertyOutput) GoString() string {
	return s.String()
}

// Contains a summary of an associated asset.
type AssociatedAssetsSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The ID of the asset model used to create the asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The date the asset was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// Hierarchies is a required field
	Hierarchies []*AssetHierarchy `locationName:"hierarchies" type:"list" required:"true"`

	// The ID of the asset.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the asset was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current status of the asset.
	//
	// Status is a required field
	Status *AssetStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedAssetsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedAssetsSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssociatedAssetsSummary) SetArn(v string) *AssociatedAssetsSummary {
	s.Arn = &v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *AssociatedAssetsSummary) SetAssetModelId(v string) *AssociatedAssetsSummary {
	s.AssetModelId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AssociatedAssetsSummary) SetCreationDate(v time.Time) *AssociatedAssetsSummary {
	s.CreationDate = &v
	return s
}

// SetHierarchies sets the Hierarchies field's value.
func (s *AssociatedAssetsSummary) SetHierarchies(v []*AssetHierarchy) *AssociatedAssetsSummary {
	s.Hierarchies = v
	return s
}

// SetId sets the Id field's value.
func (s *AssociatedAssetsSummary) SetId(v string) *AssociatedAssetsSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *AssociatedAssetsSummary) SetLastUpdateDate(v time.Time) *AssociatedAssetsSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociatedAssetsSummary) SetName(v string) *AssociatedAssetsSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociatedAssetsSummary) SetStatus(v *AssetStatus) *AssociatedAssetsSummary {
	s.Status = v
	return s
}

// Contains an asset attribute property. For more information, see Attributes
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#attributes)
// in the IoT SiteWise User Guide.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The default value of the asset model property attribute. All assets that
	// you create from the asset model contain this attribute value. You can update
	// an attribute's value after you create an asset. For more information, see
	// Updating attribute values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html)
	// in the IoT SiteWise User Guide.
	DefaultValue *string `locationName:"defaultValue" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Attribute"}
	if s.DefaultValue != nil && len(*s.DefaultValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *Attribute) SetDefaultValue(v string) *Attribute {
	s.DefaultValue = &v
	return s
}

type BatchAssociateProjectAssetsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the assets to be associated to the project.
	//
	// AssetIds is a required field
	AssetIds []*string `locationName:"assetIds" min:"1" type:"list" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the project to which to associate the assets.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateProjectAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateProjectAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateProjectAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAssociateProjectAssetsInput"}
	if s.AssetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetIds"))
	}
	if s.AssetIds != nil && len(s.AssetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetIds", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetIds sets the AssetIds field's value.
func (s *BatchAssociateProjectAssetsInput) SetAssetIds(v []*string) *BatchAssociateProjectAssetsInput {
	s.AssetIds = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *BatchAssociateProjectAssetsInput) SetClientToken(v string) *BatchAssociateProjectAssetsInput {
	s.ClientToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *BatchAssociateProjectAssetsInput) SetProjectId(v string) *BatchAssociateProjectAssetsInput {
	s.ProjectId = &v
	return s
}

type BatchAssociateProjectAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of associated error information, if any.
	Errors []*AssetErrorDetails `locationName:"errors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateProjectAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateProjectAssetsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchAssociateProjectAssetsOutput) SetErrors(v []*AssetErrorDetails) *BatchAssociateProjectAssetsOutput {
	s.Errors = v
	return s
}

type BatchDisassociateProjectAssetsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the assets to be disassociated from the project.
	//
	// AssetIds is a required field
	AssetIds []*string `locationName:"assetIds" min:"1" type:"list" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the project from which to disassociate the assets.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateProjectAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateProjectAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisassociateProjectAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisassociateProjectAssetsInput"}
	if s.AssetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetIds"))
	}
	if s.AssetIds != nil && len(s.AssetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetIds", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetIds sets the AssetIds field's value.
func (s *BatchDisassociateProjectAssetsInput) SetAssetIds(v []*string) *BatchDisassociateProjectAssetsInput {
	s.AssetIds = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *BatchDisassociateProjectAssetsInput) SetClientToken(v string) *BatchDisassociateProjectAssetsInput {
	s.ClientToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *BatchDisassociateProjectAssetsInput) SetProjectId(v string) *BatchDisassociateProjectAssetsInput {
	s.ProjectId = &v
	return s
}

type BatchDisassociateProjectAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of associated error information, if any.
	Errors []*AssetErrorDetails `locationName:"errors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateProjectAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateProjectAssetsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDisassociateProjectAssetsOutput) SetErrors(v []*AssetErrorDetails) *BatchDisassociateProjectAssetsOutput {
	s.Errors = v
	return s
}

// Contains information for an asset property aggregate entry that is associated
// with the BatchGetAssetPropertyAggregates (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html)
// API.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
type BatchGetAssetPropertyAggregatesEntry struct {
	_ struct{} `type:"structure"`

	// The data aggregating function.
	//
	// AggregateTypes is a required field
	AggregateTypes []*string `locationName:"aggregateTypes" min:"1" type:"list" required:"true" enum:"AggregateType"`

	// The ID of the asset in which the asset property was created.
	AssetId *string `locationName:"assetId" min:"36" type:"string"`

	// The inclusive end of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	//
	// EndDate is a required field
	EndDate *time.Time `locationName:"endDate" type:"timestamp" required:"true"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	PropertyAlias *string `locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `locationName:"propertyId" min:"36" type:"string"`

	// The quality by which to filter asset data.
	Qualities []*string `locationName:"qualities" min:"1" type:"list" enum:"Quality"`

	// The time interval over which to aggregate data.
	//
	// Resolution is a required field
	Resolution *string `locationName:"resolution" min:"2" type:"string" required:"true"`

	// The exclusive start of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	//
	// StartDate is a required field
	StartDate *time.Time `locationName:"startDate" type:"timestamp" required:"true"`

	// The chronological sorting order of the requested information.
	//
	// Default: ASCENDING
	TimeOrdering *string `locationName:"timeOrdering" type:"string" enum:"TimeOrdering"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetAssetPropertyAggregatesEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetAssetPropertyAggregatesEntry"}
	if s.AggregateTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregateTypes"))
	}
	if s.AggregateTypes != nil && len(s.AggregateTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AggregateTypes", 1))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.EntryId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntryId"))
	}
	if s.EntryId != nil && len(*s.EntryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntryId", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}
	if s.Qualities != nil && len(s.Qualities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualities", 1))
	}
	if s.Resolution == nil {
		invalidParams.Add(request.NewErrParamRequired("Resolution"))
	}
	if s.Resolution != nil && len(*s.Resolution) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Resolution", 2))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregateTypes sets the AggregateTypes field's value.
func (s *BatchGetAssetPropertyAggregatesEntry) SetAggregateTypes(v []*string) *BatchGetAssetPropertyAggregatesEntry {
	s.AggregateTypes = v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *BatchGetAssetPropertyAggregatesEntry) SetAssetId(v string) *BatchGetAssetPropertyAggregatesEntry {
	s.AssetId = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *BatchGetAssetPropertyAggregatesEntry) SetEndDate(v time.Time) *BatchGetAssetPropertyAggregatesEntry {
	s.EndDate = &v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyAggregatesEntry) SetEntryId(v string) *BatchGetAssetPropertyAggregatesEntry {
	s.EntryId = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *BatchGetAssetPropertyAggregatesEntry) SetPropertyAlias(v string) *BatchGetAssetPropertyAggregatesEntry {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *BatchGetAssetPropertyAggregatesEntry) SetPropertyId(v string) *BatchGetAssetPropertyAggregatesEntry {
	s.PropertyId = &v
	return s
}

// SetQualities sets the Qualities field's value.
func (s *BatchGetAssetPropertyAggregatesEntry) SetQualities(v []*string) *BatchGetAssetPropertyAggregatesEntry {
	s.Qualities = v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *BatchGetAssetPropertyAggregatesEntry) SetResolution(v string) *BatchGetAssetPropertyAggregatesEntry {
	s.Resolution = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *BatchGetAssetPropertyAggregatesEntry) SetStartDate(v time.Time) *BatchGetAssetPropertyAggregatesEntry {
	s.StartDate = &v
	return s
}

// SetTimeOrdering sets the TimeOrdering field's value.
func (s *BatchGetAssetPropertyAggregatesEntry) SetTimeOrdering(v string) *BatchGetAssetPropertyAggregatesEntry {
	s.TimeOrdering = &v
	return s
}

// Contains error information for an asset property aggregate entry that is
// associated with the BatchGetAssetPropertyAggregates (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html)
// API.
type BatchGetAssetPropertyAggregatesErrorEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"BatchGetAssetPropertyAggregatesErrorCode"`

	// The associated error message.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesErrorEntry) GoString() string {
	return s.String()
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyAggregatesErrorEntry) SetEntryId(v string) *BatchGetAssetPropertyAggregatesErrorEntry {
	s.EntryId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchGetAssetPropertyAggregatesErrorEntry) SetErrorCode(v string) *BatchGetAssetPropertyAggregatesErrorEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchGetAssetPropertyAggregatesErrorEntry) SetErrorMessage(v string) *BatchGetAssetPropertyAggregatesErrorEntry {
	s.ErrorMessage = &v
	return s
}

// Contains the error code and the timestamp for an asset property aggregate
// entry that is associated with the BatchGetAssetPropertyAggregates (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html)
// API.
type BatchGetAssetPropertyAggregatesErrorInfo struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"BatchGetAssetPropertyAggregatesErrorCode"`

	// The date the error occurred, in Unix epoch time.
	//
	// ErrorTimestamp is a required field
	ErrorTimestamp *time.Time `locationName:"errorTimestamp" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesErrorInfo) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchGetAssetPropertyAggregatesErrorInfo) SetErrorCode(v string) *BatchGetAssetPropertyAggregatesErrorInfo {
	s.ErrorCode = &v
	return s
}

// SetErrorTimestamp sets the ErrorTimestamp field's value.
func (s *BatchGetAssetPropertyAggregatesErrorInfo) SetErrorTimestamp(v time.Time) *BatchGetAssetPropertyAggregatesErrorInfo {
	s.ErrorTimestamp = &v
	return s
}

type BatchGetAssetPropertyAggregatesInput struct {
	_ struct{} `type:"structure"`

	// The list of asset property aggregate entries for the batch get request. You
	// can specify up to 16 entries per request.
	//
	// Entries is a required field
	Entries []*BatchGetAssetPropertyAggregatesEntry `locationName:"entries" type:"list" required:"true"`

	// The maximum number of results to return for each paginated request. A result
	// set is returned in the two cases, whichever occurs first.
	//
	//    * The size of the result set is less than 1 MB.
	//
	//    * The number of data points in the result set is less than the value of
	//    maxResults. The maximum value of maxResults is 4000.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetAssetPropertyAggregatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetAssetPropertyAggregatesInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *BatchGetAssetPropertyAggregatesInput) SetEntries(v []*BatchGetAssetPropertyAggregatesEntry) *BatchGetAssetPropertyAggregatesInput {
	s.Entries = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchGetAssetPropertyAggregatesInput) SetMaxResults(v int64) *BatchGetAssetPropertyAggregatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetAssetPropertyAggregatesInput) SetNextToken(v string) *BatchGetAssetPropertyAggregatesInput {
	s.NextToken = &v
	return s
}

type BatchGetAssetPropertyAggregatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the errors (if any) associated with the batch request. Each error
	// entry contains the entryId of the entry that failed.
	//
	// ErrorEntries is a required field
	ErrorEntries []*BatchGetAssetPropertyAggregatesErrorEntry `locationName:"errorEntries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of entries that were not processed by this batch request. because
	// these entries had been completely processed by previous paginated requests.
	// Each skipped entry contains the entryId of the entry that skipped.
	//
	// SkippedEntries is a required field
	SkippedEntries []*BatchGetAssetPropertyAggregatesSkippedEntry `locationName:"skippedEntries" type:"list" required:"true"`

	// A list of entries that were processed successfully by this batch request.
	// Each success entry contains the entryId of the entry that succeeded and the
	// latest query result.
	//
	// SuccessEntries is a required field
	SuccessEntries []*BatchGetAssetPropertyAggregatesSuccessEntry `locationName:"successEntries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchGetAssetPropertyAggregatesOutput) SetErrorEntries(v []*BatchGetAssetPropertyAggregatesErrorEntry) *BatchGetAssetPropertyAggregatesOutput {
	s.ErrorEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetAssetPropertyAggregatesOutput) SetNextToken(v string) *BatchGetAssetPropertyAggregatesOutput {
	s.NextToken = &v
	return s
}

// SetSkippedEntries sets the SkippedEntries field's value.
func (s *BatchGetAssetPropertyAggregatesOutput) SetSkippedEntries(v []*BatchGetAssetPropertyAggregatesSkippedEntry) *BatchGetAssetPropertyAggregatesOutput {
	s.SkippedEntries = v
	return s
}

// SetSuccessEntries sets the SuccessEntries field's value.
func (s *BatchGetAssetPropertyAggregatesOutput) SetSuccessEntries(v []*BatchGetAssetPropertyAggregatesSuccessEntry) *BatchGetAssetPropertyAggregatesOutput {
	s.SuccessEntries = v
	return s
}

// Contains information for an entry that has been processed by the previous
// BatchGetAssetPropertyAggregates (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html)
// request.
type BatchGetAssetPropertyAggregatesSkippedEntry struct {
	_ struct{} `type:"structure"`

	// The completion status of each entry that is associated with the BatchGetAssetPropertyAggregates
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html)
	// API.
	//
	// CompletionStatus is a required field
	CompletionStatus *string `locationName:"completionStatus" type:"string" required:"true" enum:"BatchEntryCompletionStatus"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The error information, such as the error code and the timestamp.
	ErrorInfo *BatchGetAssetPropertyAggregatesErrorInfo `locationName:"errorInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesSkippedEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesSkippedEntry) GoString() string {
	return s.String()
}

// SetCompletionStatus sets the CompletionStatus field's value.
func (s *BatchGetAssetPropertyAggregatesSkippedEntry) SetCompletionStatus(v string) *BatchGetAssetPropertyAggregatesSkippedEntry {
	s.CompletionStatus = &v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyAggregatesSkippedEntry) SetEntryId(v string) *BatchGetAssetPropertyAggregatesSkippedEntry {
	s.EntryId = &v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *BatchGetAssetPropertyAggregatesSkippedEntry) SetErrorInfo(v *BatchGetAssetPropertyAggregatesErrorInfo) *BatchGetAssetPropertyAggregatesSkippedEntry {
	s.ErrorInfo = v
	return s
}

// Contains success information for an entry that is associated with the BatchGetAssetPropertyAggregates
// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html)
// API.
type BatchGetAssetPropertyAggregatesSuccessEntry struct {
	_ struct{} `type:"structure"`

	// The requested aggregated asset property values (for example, average, minimum,
	// and maximum).
	//
	// AggregatedValues is a required field
	AggregatedValues []*AggregatedValue `locationName:"aggregatedValues" type:"list" required:"true"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesSuccessEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyAggregatesSuccessEntry) GoString() string {
	return s.String()
}

// SetAggregatedValues sets the AggregatedValues field's value.
func (s *BatchGetAssetPropertyAggregatesSuccessEntry) SetAggregatedValues(v []*AggregatedValue) *BatchGetAssetPropertyAggregatesSuccessEntry {
	s.AggregatedValues = v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyAggregatesSuccessEntry) SetEntryId(v string) *BatchGetAssetPropertyAggregatesSuccessEntry {
	s.EntryId = &v
	return s
}

// Contains information for an asset property value entry that is associated
// with the BatchGetAssetPropertyValue (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html)
// API.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
type BatchGetAssetPropertyValueEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the asset in which the asset property was created.
	AssetId *string `locationName:"assetId" min:"36" type:"string"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	PropertyAlias *string `locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `locationName:"propertyId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetAssetPropertyValueEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetAssetPropertyValueEntry"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.EntryId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntryId"))
	}
	if s.EntryId != nil && len(*s.EntryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntryId", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *BatchGetAssetPropertyValueEntry) SetAssetId(v string) *BatchGetAssetPropertyValueEntry {
	s.AssetId = &v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyValueEntry) SetEntryId(v string) *BatchGetAssetPropertyValueEntry {
	s.EntryId = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *BatchGetAssetPropertyValueEntry) SetPropertyAlias(v string) *BatchGetAssetPropertyValueEntry {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *BatchGetAssetPropertyValueEntry) SetPropertyId(v string) *BatchGetAssetPropertyValueEntry {
	s.PropertyId = &v
	return s
}

// Contains error information for an asset property value entry that is associated
// with the BatchGetAssetPropertyValue (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html)
// API.
type BatchGetAssetPropertyValueErrorEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"BatchGetAssetPropertyValueErrorCode"`

	// The associated error message.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueErrorEntry) GoString() string {
	return s.String()
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyValueErrorEntry) SetEntryId(v string) *BatchGetAssetPropertyValueErrorEntry {
	s.EntryId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchGetAssetPropertyValueErrorEntry) SetErrorCode(v string) *BatchGetAssetPropertyValueErrorEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchGetAssetPropertyValueErrorEntry) SetErrorMessage(v string) *BatchGetAssetPropertyValueErrorEntry {
	s.ErrorMessage = &v
	return s
}

// The error information, such as the error code and the timestamp.
type BatchGetAssetPropertyValueErrorInfo struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"BatchGetAssetPropertyValueErrorCode"`

	// The date the error occurred, in Unix epoch time.
	//
	// ErrorTimestamp is a required field
	ErrorTimestamp *time.Time `locationName:"errorTimestamp" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueErrorInfo) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchGetAssetPropertyValueErrorInfo) SetErrorCode(v string) *BatchGetAssetPropertyValueErrorInfo {
	s.ErrorCode = &v
	return s
}

// SetErrorTimestamp sets the ErrorTimestamp field's value.
func (s *BatchGetAssetPropertyValueErrorInfo) SetErrorTimestamp(v time.Time) *BatchGetAssetPropertyValueErrorInfo {
	s.ErrorTimestamp = &v
	return s
}

// Contains information for an asset property historical value entry that is
// associated with the BatchGetAssetPropertyValueHistory (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html)
// API.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
type BatchGetAssetPropertyValueHistoryEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the asset in which the asset property was created.
	AssetId *string `locationName:"assetId" min:"36" type:"string"`

	// The inclusive end of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	EndDate *time.Time `locationName:"endDate" type:"timestamp"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	PropertyAlias *string `locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `locationName:"propertyId" min:"36" type:"string"`

	// The quality by which to filter asset data.
	Qualities []*string `locationName:"qualities" min:"1" type:"list" enum:"Quality"`

	// The exclusive start of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	StartDate *time.Time `locationName:"startDate" type:"timestamp"`

	// The chronological sorting order of the requested information.
	//
	// Default: ASCENDING
	TimeOrdering *string `locationName:"timeOrdering" type:"string" enum:"TimeOrdering"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistoryEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistoryEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetAssetPropertyValueHistoryEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetAssetPropertyValueHistoryEntry"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.EntryId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntryId"))
	}
	if s.EntryId != nil && len(*s.EntryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntryId", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}
	if s.Qualities != nil && len(s.Qualities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualities", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *BatchGetAssetPropertyValueHistoryEntry) SetAssetId(v string) *BatchGetAssetPropertyValueHistoryEntry {
	s.AssetId = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *BatchGetAssetPropertyValueHistoryEntry) SetEndDate(v time.Time) *BatchGetAssetPropertyValueHistoryEntry {
	s.EndDate = &v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyValueHistoryEntry) SetEntryId(v string) *BatchGetAssetPropertyValueHistoryEntry {
	s.EntryId = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *BatchGetAssetPropertyValueHistoryEntry) SetPropertyAlias(v string) *BatchGetAssetPropertyValueHistoryEntry {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *BatchGetAssetPropertyValueHistoryEntry) SetPropertyId(v string) *BatchGetAssetPropertyValueHistoryEntry {
	s.PropertyId = &v
	return s
}

// SetQualities sets the Qualities field's value.
func (s *BatchGetAssetPropertyValueHistoryEntry) SetQualities(v []*string) *BatchGetAssetPropertyValueHistoryEntry {
	s.Qualities = v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *BatchGetAssetPropertyValueHistoryEntry) SetStartDate(v time.Time) *BatchGetAssetPropertyValueHistoryEntry {
	s.StartDate = &v
	return s
}

// SetTimeOrdering sets the TimeOrdering field's value.
func (s *BatchGetAssetPropertyValueHistoryEntry) SetTimeOrdering(v string) *BatchGetAssetPropertyValueHistoryEntry {
	s.TimeOrdering = &v
	return s
}

// A list of the errors (if any) associated with the batch request. Each error
// entry contains the entryId of the entry that failed.
type BatchGetAssetPropertyValueHistoryErrorEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"BatchGetAssetPropertyValueHistoryErrorCode"`

	// The associated error message.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistoryErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistoryErrorEntry) GoString() string {
	return s.String()
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyValueHistoryErrorEntry) SetEntryId(v string) *BatchGetAssetPropertyValueHistoryErrorEntry {
	s.EntryId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchGetAssetPropertyValueHistoryErrorEntry) SetErrorCode(v string) *BatchGetAssetPropertyValueHistoryErrorEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchGetAssetPropertyValueHistoryErrorEntry) SetErrorMessage(v string) *BatchGetAssetPropertyValueHistoryErrorEntry {
	s.ErrorMessage = &v
	return s
}

// The error information, such as the error code and the timestamp.
type BatchGetAssetPropertyValueHistoryErrorInfo struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"BatchGetAssetPropertyValueHistoryErrorCode"`

	// The date the error occurred, in Unix epoch time.
	//
	// ErrorTimestamp is a required field
	ErrorTimestamp *time.Time `locationName:"errorTimestamp" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistoryErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistoryErrorInfo) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchGetAssetPropertyValueHistoryErrorInfo) SetErrorCode(v string) *BatchGetAssetPropertyValueHistoryErrorInfo {
	s.ErrorCode = &v
	return s
}

// SetErrorTimestamp sets the ErrorTimestamp field's value.
func (s *BatchGetAssetPropertyValueHistoryErrorInfo) SetErrorTimestamp(v time.Time) *BatchGetAssetPropertyValueHistoryErrorInfo {
	s.ErrorTimestamp = &v
	return s
}

type BatchGetAssetPropertyValueHistoryInput struct {
	_ struct{} `type:"structure"`

	// The list of asset property historical value entries for the batch get request.
	// You can specify up to 16 entries per request.
	//
	// Entries is a required field
	Entries []*BatchGetAssetPropertyValueHistoryEntry `locationName:"entries" type:"list" required:"true"`

	// The maximum number of results to return for each paginated request. A result
	// set is returned in the two cases, whichever occurs first.
	//
	//    * The size of the result set is less than 1 MB.
	//
	//    * The number of data points in the result set is less than the value of
	//    maxResults. The maximum value of maxResults is 4000.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetAssetPropertyValueHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetAssetPropertyValueHistoryInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *BatchGetAssetPropertyValueHistoryInput) SetEntries(v []*BatchGetAssetPropertyValueHistoryEntry) *BatchGetAssetPropertyValueHistoryInput {
	s.Entries = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchGetAssetPropertyValueHistoryInput) SetMaxResults(v int64) *BatchGetAssetPropertyValueHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetAssetPropertyValueHistoryInput) SetNextToken(v string) *BatchGetAssetPropertyValueHistoryInput {
	s.NextToken = &v
	return s
}

type BatchGetAssetPropertyValueHistoryOutput struct {
	_ struct{} `type:"structure"`

	// A list of the errors (if any) associated with the batch request. Each error
	// entry contains the entryId of the entry that failed.
	//
	// ErrorEntries is a required field
	ErrorEntries []*BatchGetAssetPropertyValueHistoryErrorEntry `locationName:"errorEntries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of entries that were not processed by this batch request. because
	// these entries had been completely processed by previous paginated requests.
	// Each skipped entry contains the entryId of the entry that skipped.
	//
	// SkippedEntries is a required field
	SkippedEntries []*BatchGetAssetPropertyValueHistorySkippedEntry `locationName:"skippedEntries" type:"list" required:"true"`

	// A list of entries that were processed successfully by this batch request.
	// Each success entry contains the entryId of the entry that succeeded and the
	// latest query result.
	//
	// SuccessEntries is a required field
	SuccessEntries []*BatchGetAssetPropertyValueHistorySuccessEntry `locationName:"successEntries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistoryOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchGetAssetPropertyValueHistoryOutput) SetErrorEntries(v []*BatchGetAssetPropertyValueHistoryErrorEntry) *BatchGetAssetPropertyValueHistoryOutput {
	s.ErrorEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetAssetPropertyValueHistoryOutput) SetNextToken(v string) *BatchGetAssetPropertyValueHistoryOutput {
	s.NextToken = &v
	return s
}

// SetSkippedEntries sets the SkippedEntries field's value.
func (s *BatchGetAssetPropertyValueHistoryOutput) SetSkippedEntries(v []*BatchGetAssetPropertyValueHistorySkippedEntry) *BatchGetAssetPropertyValueHistoryOutput {
	s.SkippedEntries = v
	return s
}

// SetSuccessEntries sets the SuccessEntries field's value.
func (s *BatchGetAssetPropertyValueHistoryOutput) SetSuccessEntries(v []*BatchGetAssetPropertyValueHistorySuccessEntry) *BatchGetAssetPropertyValueHistoryOutput {
	s.SuccessEntries = v
	return s
}

// Contains information for an entry that has been processed by the previous
// BatchGetAssetPropertyValueHistory (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html)
// request.
type BatchGetAssetPropertyValueHistorySkippedEntry struct {
	_ struct{} `type:"structure"`

	// The completion status of each entry that is associated with the BatchGetAssetPropertyValueHistory
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html)
	// API.
	//
	// CompletionStatus is a required field
	CompletionStatus *string `locationName:"completionStatus" type:"string" required:"true" enum:"BatchEntryCompletionStatus"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The error information, such as the error code and the timestamp.
	ErrorInfo *BatchGetAssetPropertyValueHistoryErrorInfo `locationName:"errorInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistorySkippedEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistorySkippedEntry) GoString() string {
	return s.String()
}

// SetCompletionStatus sets the CompletionStatus field's value.
func (s *BatchGetAssetPropertyValueHistorySkippedEntry) SetCompletionStatus(v string) *BatchGetAssetPropertyValueHistorySkippedEntry {
	s.CompletionStatus = &v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyValueHistorySkippedEntry) SetEntryId(v string) *BatchGetAssetPropertyValueHistorySkippedEntry {
	s.EntryId = &v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *BatchGetAssetPropertyValueHistorySkippedEntry) SetErrorInfo(v *BatchGetAssetPropertyValueHistoryErrorInfo) *BatchGetAssetPropertyValueHistorySkippedEntry {
	s.ErrorInfo = v
	return s
}

// Contains success information for an entry that is associated with the BatchGetAssetPropertyValueHistory
// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html)
// API.
type BatchGetAssetPropertyValueHistorySuccessEntry struct {
	_ struct{} `type:"structure"`

	// The requested historical values for the specified asset property.
	//
	// AssetPropertyValueHistory is a required field
	AssetPropertyValueHistory []*AssetPropertyValue `locationName:"assetPropertyValueHistory" type:"list" required:"true"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistorySuccessEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueHistorySuccessEntry) GoString() string {
	return s.String()
}

// SetAssetPropertyValueHistory sets the AssetPropertyValueHistory field's value.
func (s *BatchGetAssetPropertyValueHistorySuccessEntry) SetAssetPropertyValueHistory(v []*AssetPropertyValue) *BatchGetAssetPropertyValueHistorySuccessEntry {
	s.AssetPropertyValueHistory = v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyValueHistorySuccessEntry) SetEntryId(v string) *BatchGetAssetPropertyValueHistorySuccessEntry {
	s.EntryId = &v
	return s
}

type BatchGetAssetPropertyValueInput struct {
	_ struct{} `type:"structure"`

	// The list of asset property value entries for the batch get request. You can
	// specify up to 16 entries per request.
	//
	// Entries is a required field
	Entries []*BatchGetAssetPropertyValueEntry `locationName:"entries" type:"list" required:"true"`

	// The token to be used for the next set of paginated results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetAssetPropertyValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetAssetPropertyValueInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *BatchGetAssetPropertyValueInput) SetEntries(v []*BatchGetAssetPropertyValueEntry) *BatchGetAssetPropertyValueInput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetAssetPropertyValueInput) SetNextToken(v string) *BatchGetAssetPropertyValueInput {
	s.NextToken = &v
	return s
}

type BatchGetAssetPropertyValueOutput struct {
	_ struct{} `type:"structure"`

	// A list of the errors (if any) associated with the batch request. Each error
	// entry contains the entryId of the entry that failed.
	//
	// ErrorEntries is a required field
	ErrorEntries []*BatchGetAssetPropertyValueErrorEntry `locationName:"errorEntries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of entries that were not processed by this batch request. because
	// these entries had been completely processed by previous paginated requests.
	// Each skipped entry contains the entryId of the entry that skipped.
	//
	// SkippedEntries is a required field
	SkippedEntries []*BatchGetAssetPropertyValueSkippedEntry `locationName:"skippedEntries" type:"list" required:"true"`

	// A list of entries that were processed successfully by this batch request.
	// Each success entry contains the entryId of the entry that succeeded and the
	// latest query result.
	//
	// SuccessEntries is a required field
	SuccessEntries []*BatchGetAssetPropertyValueSuccessEntry `locationName:"successEntries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchGetAssetPropertyValueOutput) SetErrorEntries(v []*BatchGetAssetPropertyValueErrorEntry) *BatchGetAssetPropertyValueOutput {
	s.ErrorEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetAssetPropertyValueOutput) SetNextToken(v string) *BatchGetAssetPropertyValueOutput {
	s.NextToken = &v
	return s
}

// SetSkippedEntries sets the SkippedEntries field's value.
func (s *BatchGetAssetPropertyValueOutput) SetSkippedEntries(v []*BatchGetAssetPropertyValueSkippedEntry) *BatchGetAssetPropertyValueOutput {
	s.SkippedEntries = v
	return s
}

// SetSuccessEntries sets the SuccessEntries field's value.
func (s *BatchGetAssetPropertyValueOutput) SetSuccessEntries(v []*BatchGetAssetPropertyValueSuccessEntry) *BatchGetAssetPropertyValueOutput {
	s.SuccessEntries = v
	return s
}

// Contains information for an entry that has been processed by the previous
// BatchGetAssetPropertyValue (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html)
// request.
type BatchGetAssetPropertyValueSkippedEntry struct {
	_ struct{} `type:"structure"`

	// The completion status of each entry that is associated with the BatchGetAssetPropertyValue
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html)
	// request.
	//
	// CompletionStatus is a required field
	CompletionStatus *string `locationName:"completionStatus" type:"string" required:"true" enum:"BatchEntryCompletionStatus"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The error information, such as the error code and the timestamp.
	ErrorInfo *BatchGetAssetPropertyValueErrorInfo `locationName:"errorInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueSkippedEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueSkippedEntry) GoString() string {
	return s.String()
}

// SetCompletionStatus sets the CompletionStatus field's value.
func (s *BatchGetAssetPropertyValueSkippedEntry) SetCompletionStatus(v string) *BatchGetAssetPropertyValueSkippedEntry {
	s.CompletionStatus = &v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyValueSkippedEntry) SetEntryId(v string) *BatchGetAssetPropertyValueSkippedEntry {
	s.EntryId = &v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *BatchGetAssetPropertyValueSkippedEntry) SetErrorInfo(v *BatchGetAssetPropertyValueErrorInfo) *BatchGetAssetPropertyValueSkippedEntry {
	s.ErrorInfo = v
	return s
}

// Contains success information for an entry that is associated with the BatchGetAssetPropertyValue
// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html)
// API.
type BatchGetAssetPropertyValueSuccessEntry struct {
	_ struct{} `type:"structure"`

	// Contains asset property value information.
	AssetPropertyValue *AssetPropertyValue `locationName:"assetPropertyValue" type:"structure"`

	// The ID of the entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueSuccessEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAssetPropertyValueSuccessEntry) GoString() string {
	return s.String()
}

// SetAssetPropertyValue sets the AssetPropertyValue field's value.
func (s *BatchGetAssetPropertyValueSuccessEntry) SetAssetPropertyValue(v *AssetPropertyValue) *BatchGetAssetPropertyValueSuccessEntry {
	s.AssetPropertyValue = v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *BatchGetAssetPropertyValueSuccessEntry) SetEntryId(v string) *BatchGetAssetPropertyValueSuccessEntry {
	s.EntryId = &v
	return s
}

// Contains error information from updating a batch of asset property values.
type BatchPutAssetPropertyError struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"BatchPutAssetPropertyValueErrorCode"`

	// The associated error message.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" type:"string" required:"true"`

	// A list of timestamps for each error, if any.
	//
	// Timestamps is a required field
	Timestamps []*TimeInNanos `locationName:"timestamps" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutAssetPropertyError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutAssetPropertyError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchPutAssetPropertyError) SetErrorCode(v string) *BatchPutAssetPropertyError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchPutAssetPropertyError) SetErrorMessage(v string) *BatchPutAssetPropertyError {
	s.ErrorMessage = &v
	return s
}

// SetTimestamps sets the Timestamps field's value.
func (s *BatchPutAssetPropertyError) SetTimestamps(v []*TimeInNanos) *BatchPutAssetPropertyError {
	s.Timestamps = v
	return s
}

// Contains error information for asset property value entries that are associated
// with the BatchPutAssetPropertyValue (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html)
// API.
type BatchPutAssetPropertyErrorEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the failed entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The list of update property value errors.
	//
	// Errors is a required field
	Errors []*BatchPutAssetPropertyError `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutAssetPropertyErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutAssetPropertyErrorEntry) GoString() string {
	return s.String()
}

// SetEntryId sets the EntryId field's value.
func (s *BatchPutAssetPropertyErrorEntry) SetEntryId(v string) *BatchPutAssetPropertyErrorEntry {
	s.EntryId = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchPutAssetPropertyErrorEntry) SetErrors(v []*BatchPutAssetPropertyError) *BatchPutAssetPropertyErrorEntry {
	s.Errors = v
	return s
}

type BatchPutAssetPropertyValueInput struct {
	_ struct{} `type:"structure"`

	// The list of asset property value entries for the batch put request. You can
	// specify up to 10 entries per request.
	//
	// Entries is a required field
	Entries []*PutAssetPropertyValueEntry `locationName:"entries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutAssetPropertyValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutAssetPropertyValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutAssetPropertyValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutAssetPropertyValueInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *BatchPutAssetPropertyValueInput) SetEntries(v []*PutAssetPropertyValueEntry) *BatchPutAssetPropertyValueInput {
	s.Entries = v
	return s
}

type BatchPutAssetPropertyValueOutput struct {
	_ struct{} `type:"structure"`

	// A list of the errors (if any) associated with the batch put request. Each
	// error entry contains the entryId of the entry that failed.
	//
	// ErrorEntries is a required field
	ErrorEntries []*BatchPutAssetPropertyErrorEntry `locationName:"errorEntries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutAssetPropertyValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutAssetPropertyValueOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchPutAssetPropertyValueOutput) SetErrorEntries(v []*BatchPutAssetPropertyErrorEntry) *BatchPutAssetPropertyValueOutput {
	s.ErrorEntries = v
	return s
}

// Contains information about a composite model property on an asset.
type CompositeModelProperty struct {
	_ struct{} `type:"structure"`

	// Contains asset property information.
	//
	// AssetProperty is a required field
	AssetProperty *Property `locationName:"assetProperty" type:"structure" required:"true"`

	// The name of the property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The type of the composite model that defines this property.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositeModelProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositeModelProperty) GoString() string {
	return s.String()
}

// SetAssetProperty sets the AssetProperty field's value.
func (s *CompositeModelProperty) SetAssetProperty(v *Property) *CompositeModelProperty {
	s.AssetProperty = v
	return s
}

// SetName sets the Name field's value.
func (s *CompositeModelProperty) SetName(v string) *CompositeModelProperty {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *CompositeModelProperty) SetType(v string) *CompositeModelProperty {
	s.Type = &v
	return s
}

// Contains the details of an IoT SiteWise configuration error.
type ConfigurationErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"ErrorCode"`

	// The error message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationErrorDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ConfigurationErrorDetails) SetCode(v string) *ConfigurationErrorDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ConfigurationErrorDetails) SetMessage(v string) *ConfigurationErrorDetails {
	s.Message = &v
	return s
}

// Contains current status information for the configuration.
type ConfigurationStatus struct {
	_ struct{} `type:"structure"`

	// Contains associated error information, if any.
	Error *ConfigurationErrorDetails `locationName:"error" type:"structure"`

	// The current state of the configuration.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"ConfigurationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationStatus) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *ConfigurationStatus) SetError(v *ConfigurationErrorDetails) *ConfigurationStatus {
	s.Error = v
	return s
}

// SetState sets the State field's value.
func (s *ConfigurationStatus) SetState(v string) *ConfigurationStatus {
	s.State = &v
	return s
}

// Your request has conflicting operations. This can occur if you're trying
// to perform more than one operation on the same resource at the same time.
type ConflictingOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ARN of the resource that conflicts with this operation.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The ID of the resource that conflicts with this operation.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictingOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictingOperationException) GoString() string {
	return s.String()
}

func newErrorConflictingOperationException(v protocol.ResponseMetadata) error {
	return &ConflictingOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictingOperationException) Code() string {
	return "ConflictingOperationException"
}

// Message returns the exception's message.
func (s *ConflictingOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictingOperationException) OrigErr() error {
	return nil
}

func (s *ConflictingOperationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictingOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictingOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The identity for this access policy. Choose an Amazon Web Services SSO user,
	// an Amazon Web Services SSO group, or an IAM user.
	//
	// AccessPolicyIdentity is a required field
	AccessPolicyIdentity *Identity `locationName:"accessPolicyIdentity" type:"structure" required:"true"`

	// The permission level for this access policy. Note that a project ADMINISTRATOR
	// is also known as a project owner.
	//
	// AccessPolicyPermission is a required field
	AccessPolicyPermission *string `locationName:"accessPolicyPermission" type:"string" required:"true" enum:"Permission"`

	// The IoT SiteWise Monitor resource for this access policy. Choose either a
	// portal or a project.
	//
	// AccessPolicyResource is a required field
	AccessPolicyResource *Resource `locationName:"accessPolicyResource" type:"structure" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A list of key-value pairs that contain metadata for the access policy. For
	// more information, see Tagging your IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessPolicyInput"}
	if s.AccessPolicyIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyIdentity"))
	}
	if s.AccessPolicyPermission == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyPermission"))
	}
	if s.AccessPolicyResource == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyResource"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.AccessPolicyIdentity != nil {
		if err := s.AccessPolicyIdentity.Validate(); err != nil {
			invalidParams.AddNested("AccessPolicyIdentity", err.(request.ErrInvalidParams))
		}
	}
	if s.AccessPolicyResource != nil {
		if err := s.AccessPolicyResource.Validate(); err != nil {
			invalidParams.AddNested("AccessPolicyResource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicyIdentity sets the AccessPolicyIdentity field's value.
func (s *CreateAccessPolicyInput) SetAccessPolicyIdentity(v *Identity) *CreateAccessPolicyInput {
	s.AccessPolicyIdentity = v
	return s
}

// SetAccessPolicyPermission sets the AccessPolicyPermission field's value.
func (s *CreateAccessPolicyInput) SetAccessPolicyPermission(v string) *CreateAccessPolicyInput {
	s.AccessPolicyPermission = &v
	return s
}

// SetAccessPolicyResource sets the AccessPolicyResource field's value.
func (s *CreateAccessPolicyInput) SetAccessPolicyResource(v *Resource) *CreateAccessPolicyInput {
	s.AccessPolicyResource = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAccessPolicyInput) SetClientToken(v string) *CreateAccessPolicyInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccessPolicyInput) SetTags(v map[string]*string) *CreateAccessPolicyInput {
	s.Tags = v
	return s
}

type CreateAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the access policy, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}
	//
	// AccessPolicyArn is a required field
	AccessPolicyArn *string `locationName:"accessPolicyArn" min:"1" type:"string" required:"true"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `locationName:"accessPolicyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPolicyOutput) GoString() string {
	return s.String()
}

// SetAccessPolicyArn sets the AccessPolicyArn field's value.
func (s *CreateAccessPolicyOutput) SetAccessPolicyArn(v string) *CreateAccessPolicyOutput {
	s.AccessPolicyArn = &v
	return s
}

// SetAccessPolicyId sets the AccessPolicyId field's value.
func (s *CreateAccessPolicyOutput) SetAccessPolicyId(v string) *CreateAccessPolicyOutput {
	s.AccessPolicyId = &v
	return s
}

type CreateAssetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset model from which to create the asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// A unique, friendly name for the asset.
	//
	// AssetName is a required field
	AssetName *string `locationName:"assetName" min:"1" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A list of key-value pairs that contain metadata for the asset. For more information,
	// see Tagging your IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssetInput"}
	if s.AssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelId"))
	}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelId", 36))
	}
	if s.AssetName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetName"))
	}
	if s.AssetName != nil && len(*s.AssetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *CreateAssetInput) SetAssetModelId(v string) *CreateAssetInput {
	s.AssetModelId = &v
	return s
}

// SetAssetName sets the AssetName field's value.
func (s *CreateAssetInput) SetAssetName(v string) *CreateAssetInput {
	s.AssetName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAssetInput) SetClientToken(v string) *CreateAssetInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAssetInput) SetTags(v map[string]*string) *CreateAssetInput {
	s.Tags = v
	return s
}

type CreateAssetModelInput struct {
	_ struct{} `type:"structure"`

	// The composite asset models that are part of this asset model. Composite asset
	// models are asset models that contain specific properties. Each composite
	// model has a type that defines the properties that the composite model supports.
	// Use composite asset models to define alarms on this asset model.
	AssetModelCompositeModels []*AssetModelCompositeModelDefinition `locationName:"assetModelCompositeModels" type:"list"`

	// A description for the asset model.
	AssetModelDescription *string `locationName:"assetModelDescription" min:"1" type:"string"`

	// The hierarchy definitions of the asset model. Each hierarchy specifies an
	// asset model whose assets can be children of any other assets created from
	// this asset model. For more information, see Asset hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the IoT SiteWise User Guide.
	//
	// You can specify up to 10 hierarchies per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the IoT SiteWise User Guide.
	AssetModelHierarchies []*AssetModelHierarchyDefinition `locationName:"assetModelHierarchies" type:"list"`

	// A unique, friendly name for the asset model.
	//
	// AssetModelName is a required field
	AssetModelName *string `locationName:"assetModelName" min:"1" type:"string" required:"true"`

	// The property definitions of the asset model. For more information, see Asset
	// properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html)
	// in the IoT SiteWise User Guide.
	//
	// You can specify up to 200 properties per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the IoT SiteWise User Guide.
	AssetModelProperties []*AssetModelPropertyDefinition `locationName:"assetModelProperties" type:"list"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A list of key-value pairs that contain metadata for the asset model. For
	// more information, see Tagging your IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssetModelInput"}
	if s.AssetModelDescription != nil && len(*s.AssetModelDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelDescription", 1))
	}
	if s.AssetModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelName"))
	}
	if s.AssetModelName != nil && len(*s.AssetModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.AssetModelCompositeModels != nil {
		for i, v := range s.AssetModelCompositeModels {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelCompositeModels", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AssetModelHierarchies != nil {
		for i, v := range s.AssetModelHierarchies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelHierarchies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AssetModelProperties != nil {
		for i, v := range s.AssetModelProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelCompositeModels sets the AssetModelCompositeModels field's value.
func (s *CreateAssetModelInput) SetAssetModelCompositeModels(v []*AssetModelCompositeModelDefinition) *CreateAssetModelInput {
	s.AssetModelCompositeModels = v
	return s
}

// SetAssetModelDescription sets the AssetModelDescription field's value.
func (s *CreateAssetModelInput) SetAssetModelDescription(v string) *CreateAssetModelInput {
	s.AssetModelDescription = &v
	return s
}

// SetAssetModelHierarchies sets the AssetModelHierarchies field's value.
func (s *CreateAssetModelInput) SetAssetModelHierarchies(v []*AssetModelHierarchyDefinition) *CreateAssetModelInput {
	s.AssetModelHierarchies = v
	return s
}

// SetAssetModelName sets the AssetModelName field's value.
func (s *CreateAssetModelInput) SetAssetModelName(v string) *CreateAssetModelInput {
	s.AssetModelName = &v
	return s
}

// SetAssetModelProperties sets the AssetModelProperties field's value.
func (s *CreateAssetModelInput) SetAssetModelProperties(v []*AssetModelPropertyDefinition) *CreateAssetModelInput {
	s.AssetModelProperties = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAssetModelInput) SetClientToken(v string) *CreateAssetModelInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAssetModelInput) SetTags(v map[string]*string) *CreateAssetModelInput {
	s.Tags = v
	return s
}

type CreateAssetModelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset model, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// AssetModelArn is a required field
	AssetModelArn *string `locationName:"assetModelArn" min:"1" type:"string" required:"true"`

	// The ID of the asset model. You can use this ID when you call other IoT SiteWise
	// APIs.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The status of the asset model, which contains a state (CREATING after successfully
	// calling this operation) and any error message.
	//
	// AssetModelStatus is a required field
	AssetModelStatus *AssetModelStatus `locationName:"assetModelStatus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetModelOutput) GoString() string {
	return s.String()
}

// SetAssetModelArn sets the AssetModelArn field's value.
func (s *CreateAssetModelOutput) SetAssetModelArn(v string) *CreateAssetModelOutput {
	s.AssetModelArn = &v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *CreateAssetModelOutput) SetAssetModelId(v string) *CreateAssetModelOutput {
	s.AssetModelId = &v
	return s
}

// SetAssetModelStatus sets the AssetModelStatus field's value.
func (s *CreateAssetModelOutput) SetAssetModelStatus(v *AssetModelStatus) *CreateAssetModelOutput {
	s.AssetModelStatus = v
	return s
}

type CreateAssetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// AssetArn is a required field
	AssetArn *string `locationName:"assetArn" min:"1" type:"string" required:"true"`

	// The ID of the asset. This ID uniquely identifies the asset within IoT SiteWise
	// and can be used with other IoT SiteWise APIs.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The status of the asset, which contains a state (CREATING after successfully
	// calling this operation) and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetOutput) GoString() string {
	return s.String()
}

// SetAssetArn sets the AssetArn field's value.
func (s *CreateAssetOutput) SetAssetArn(v string) *CreateAssetOutput {
	s.AssetArn = &v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *CreateAssetOutput) SetAssetId(v string) *CreateAssetOutput {
	s.AssetId = &v
	return s
}

// SetAssetStatus sets the AssetStatus field's value.
func (s *CreateAssetOutput) SetAssetStatus(v *AssetStatus) *CreateAssetOutput {
	s.AssetStatus = v
	return s
}

type CreateDashboardInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The dashboard definition specified in a JSON literal. For detailed information,
	// see Creating dashboards (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html)
	// in the IoT SiteWise User Guide.
	//
	// DashboardDefinition is a required field
	DashboardDefinition *string `locationName:"dashboardDefinition" type:"string" required:"true"`

	// A description for the dashboard.
	DashboardDescription *string `locationName:"dashboardDescription" min:"1" type:"string"`

	// A friendly name for the dashboard.
	//
	// DashboardName is a required field
	DashboardName *string `locationName:"dashboardName" min:"1" type:"string" required:"true"`

	// The ID of the project in which to create the dashboard.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the dashboard. For more
	// information, see Tagging your IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDashboardInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.DashboardDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardDefinition"))
	}
	if s.DashboardDescription != nil && len(*s.DashboardDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardDescription", 1))
	}
	if s.DashboardName == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardName"))
	}
	if s.DashboardName != nil && len(*s.DashboardName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardName", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDashboardInput) SetClientToken(v string) *CreateDashboardInput {
	s.ClientToken = &v
	return s
}

// SetDashboardDefinition sets the DashboardDefinition field's value.
func (s *CreateDashboardInput) SetDashboardDefinition(v string) *CreateDashboardInput {
	s.DashboardDefinition = &v
	return s
}

// SetDashboardDescription sets the DashboardDescription field's value.
func (s *CreateDashboardInput) SetDashboardDescription(v string) *CreateDashboardInput {
	s.DashboardDescription = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *CreateDashboardInput) SetDashboardName(v string) *CreateDashboardInput {
	s.DashboardName = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *CreateDashboardInput) SetProjectId(v string) *CreateDashboardInput {
	s.ProjectId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDashboardInput) SetTags(v map[string]*string) *CreateDashboardInput {
	s.Tags = v
	return s
}

type CreateDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the dashboard, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}
	//
	// DashboardArn is a required field
	DashboardArn *string `locationName:"dashboardArn" min:"1" type:"string" required:"true"`

	// The ID of the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `locationName:"dashboardId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardOutput) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *CreateDashboardOutput) SetDashboardArn(v string) *CreateDashboardOutput {
	s.DashboardArn = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *CreateDashboardOutput) SetDashboardId(v string) *CreateDashboardOutput {
	s.DashboardId = &v
	return s
}

type CreateGatewayInput struct {
	_ struct{} `type:"structure"`

	// A unique, friendly name for the gateway.
	//
	// GatewayName is a required field
	GatewayName *string `locationName:"gatewayName" min:"1" type:"string" required:"true"`

	// The gateway's platform. You can only specify one platform in a gateway.
	//
	// GatewayPlatform is a required field
	GatewayPlatform *GatewayPlatform `locationName:"gatewayPlatform" type:"structure" required:"true"`

	// A list of key-value pairs that contain metadata for the gateway. For more
	// information, see Tagging your IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGatewayInput"}
	if s.GatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayName"))
	}
	if s.GatewayName != nil && len(*s.GatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayName", 1))
	}
	if s.GatewayPlatform == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayPlatform"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.GatewayPlatform != nil {
		if err := s.GatewayPlatform.Validate(); err != nil {
			invalidParams.AddNested("GatewayPlatform", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayName sets the GatewayName field's value.
func (s *CreateGatewayInput) SetGatewayName(v string) *CreateGatewayInput {
	s.GatewayName = &v
	return s
}

// SetGatewayPlatform sets the GatewayPlatform field's value.
func (s *CreateGatewayInput) SetGatewayPlatform(v *GatewayPlatform) *CreateGatewayInput {
	s.GatewayPlatform = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGatewayInput) SetTags(v map[string]*string) *CreateGatewayInput {
	s.Tags = v
	return s
}

type CreateGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the gateway, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}
	//
	// GatewayArn is a required field
	GatewayArn *string `locationName:"gatewayArn" min:"1" type:"string" required:"true"`

	// The ID of the gateway device. You can use this ID when you call other IoT
	// SiteWise APIs.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *CreateGatewayOutput) SetGatewayArn(v string) *CreateGatewayOutput {
	s.GatewayArn = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *CreateGatewayOutput) SetGatewayId(v string) *CreateGatewayOutput {
	s.GatewayId = &v
	return s
}

type CreatePortalInput struct {
	_ struct{} `type:"structure"`

	// Contains the configuration information of an alarm created in an IoT SiteWise
	// Monitor portal. You can use the alarm to monitor an asset property and get
	// notified when the asset property value is outside a specified range. For
	// more information, see Monitoring with alarms (https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html)
	// in the IoT SiteWise Application Guide.
	Alarms *Alarms `locationName:"alarms" type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The email address that sends alarm notifications.
	//
	// If you use the IoT Events managed Lambda function (https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html)
	// to manage your emails, you must verify the sender email address in Amazon
	// SES (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html).
	NotificationSenderEmail *string `locationName:"notificationSenderEmail" min:"1" type:"string"`

	// The service to use to authenticate users to the portal. Choose from the following
	// options:
	//
	//    * SSO – The portal uses Amazon Web Services Single Sign On to authenticate
	//    users and manage user permissions. Before you can create a portal that
	//    uses Amazon Web Services SSO, you must enable Amazon Web Services SSO.
	//    For more information, see Enabling Amazon Web Services SSO (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso)
	//    in the IoT SiteWise User Guide. This option is only available in Amazon
	//    Web Services Regions other than the China Regions.
	//
	//    * IAM – The portal uses Identity and Access Management to authenticate
	//    users and manage user permissions.
	//
	// You can't change this value after you create a portal.
	//
	// Default: SSO
	PortalAuthMode *string `locationName:"portalAuthMode" type:"string" enum:"AuthMode"`

	// The Amazon Web Services administrator's contact email address.
	//
	// PortalContactEmail is a required field
	PortalContactEmail *string `locationName:"portalContactEmail" min:"1" type:"string" required:"true"`

	// A description for the portal.
	PortalDescription *string `locationName:"portalDescription" min:"1" type:"string"`

	// A logo image to display in the portal. Upload a square, high-resolution image.
	// The image is displayed on a dark background.
	PortalLogoImageFile *ImageFile `locationName:"portalLogoImageFile" type:"structure"`

	// A friendly name for the portal.
	//
	// PortalName is a required field
	PortalName *string `locationName:"portalName" min:"1" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a service role that allows the portal's users to access your IoT SiteWise
	// resources on your behalf. For more information, see Using service roles for
	// IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the IoT SiteWise User Guide.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the portal. For more
	// information, see Tagging your IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePortalInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.NotificationSenderEmail != nil && len(*s.NotificationSenderEmail) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NotificationSenderEmail", 1))
	}
	if s.PortalContactEmail == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalContactEmail"))
	}
	if s.PortalContactEmail != nil && len(*s.PortalContactEmail) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalContactEmail", 1))
	}
	if s.PortalDescription != nil && len(*s.PortalDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalDescription", 1))
	}
	if s.PortalName == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalName"))
	}
	if s.PortalName != nil && len(*s.PortalName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Alarms != nil {
		if err := s.Alarms.Validate(); err != nil {
			invalidParams.AddNested("Alarms", err.(request.ErrInvalidParams))
		}
	}
	if s.PortalLogoImageFile != nil {
		if err := s.PortalLogoImageFile.Validate(); err != nil {
			invalidParams.AddNested("PortalLogoImageFile", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarms sets the Alarms field's value.
func (s *CreatePortalInput) SetAlarms(v *Alarms) *CreatePortalInput {
	s.Alarms = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePortalInput) SetClientToken(v string) *CreatePortalInput {
	s.ClientToken = &v
	return s
}

// SetNotificationSenderEmail sets the NotificationSenderEmail field's value.
func (s *CreatePortalInput) SetNotificationSenderEmail(v string) *CreatePortalInput {
	s.NotificationSenderEmail = &v
	return s
}

// SetPortalAuthMode sets the PortalAuthMode field's value.
func (s *CreatePortalInput) SetPortalAuthMode(v string) *CreatePortalInput {
	s.PortalAuthMode = &v
	return s
}

// SetPortalContactEmail sets the PortalContactEmail field's value.
func (s *CreatePortalInput) SetPortalContactEmail(v string) *CreatePortalInput {
	s.PortalContactEmail = &v
	return s
}

// SetPortalDescription sets the PortalDescription field's value.
func (s *CreatePortalInput) SetPortalDescription(v string) *CreatePortalInput {
	s.PortalDescription = &v
	return s
}

// SetPortalLogoImageFile sets the PortalLogoImageFile field's value.
func (s *CreatePortalInput) SetPortalLogoImageFile(v *ImageFile) *CreatePortalInput {
	s.PortalLogoImageFile = v
	return s
}

// SetPortalName sets the PortalName field's value.
func (s *CreatePortalInput) SetPortalName(v string) *CreatePortalInput {
	s.PortalName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreatePortalInput) SetRoleArn(v string) *CreatePortalInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePortalInput) SetTags(v map[string]*string) *CreatePortalInput {
	s.Tags = v
	return s
}

type CreatePortalOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the portal, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"1" type:"string" required:"true"`

	// The ID of the created portal.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// The URL for the IoT SiteWise Monitor portal. You can use this URL to access
	// portals that use Amazon Web Services SSO for authentication. For portals
	// that use IAM for authentication, you must use the IoT SiteWise console to
	// get a URL that you can use to access the portal.
	//
	// PortalStartUrl is a required field
	PortalStartUrl *string `locationName:"portalStartUrl" min:"1" type:"string" required:"true"`

	// The status of the portal, which contains a state (CREATING after successfully
	// calling this operation) and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`

	// The associated Amazon Web Services SSO application ID, if the portal uses
	// Amazon Web Services SSO.
	//
	// SsoApplicationId is a required field
	SsoApplicationId *string `locationName:"ssoApplicationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePortalOutput) GoString() string {
	return s.String()
}

// SetPortalArn sets the PortalArn field's value.
func (s *CreatePortalOutput) SetPortalArn(v string) *CreatePortalOutput {
	s.PortalArn = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *CreatePortalOutput) SetPortalId(v string) *CreatePortalOutput {
	s.PortalId = &v
	return s
}

// SetPortalStartUrl sets the PortalStartUrl field's value.
func (s *CreatePortalOutput) SetPortalStartUrl(v string) *CreatePortalOutput {
	s.PortalStartUrl = &v
	return s
}

// SetPortalStatus sets the PortalStatus field's value.
func (s *CreatePortalOutput) SetPortalStatus(v *PortalStatus) *CreatePortalOutput {
	s.PortalStatus = v
	return s
}

// SetSsoApplicationId sets the SsoApplicationId field's value.
func (s *CreatePortalOutput) SetSsoApplicationId(v string) *CreatePortalOutput {
	s.SsoApplicationId = &v
	return s
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the portal in which to create the project.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// A description for the project.
	ProjectDescription *string `locationName:"projectDescription" min:"1" type:"string"`

	// A friendly name for the project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the project. For more
	// information, see Tagging your IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PortalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PortalId", 36))
	}
	if s.ProjectDescription != nil && len(*s.ProjectDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectDescription", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateProjectInput) SetClientToken(v string) *CreateProjectInput {
	s.ClientToken = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *CreateProjectInput) SetPortalId(v string) *CreateProjectInput {
	s.PortalId = &v
	return s
}

// SetProjectDescription sets the ProjectDescription field's value.
func (s *CreateProjectInput) SetProjectDescription(v string) *CreateProjectInput {
	s.ProjectDescription = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateProjectInput) SetProjectName(v string) *CreateProjectInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProjectInput) SetTags(v map[string]*string) *CreateProjectInput {
	s.Tags = v
	return s
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the project, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"1" type:"string" required:"true"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateProjectOutput) SetProjectArn(v string) *CreateProjectOutput {
	s.ProjectArn = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *CreateProjectOutput) SetProjectId(v string) *CreateProjectOutput {
	s.ProjectId = &v
	return s
}

// Contains information about a customer managed Amazon S3 bucket.
type CustomerManagedS3Storage struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Identity and Access Management role that allows IoT SiteWise to send
	// data to Amazon S3.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Amazon S3 object. For more information about how to find the ARN for
	// an Amazon S3 object, see Amazon S3 resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html)
	// in the Amazon Simple Storage Service User Guide.
	//
	// S3ResourceArn is a required field
	S3ResourceArn *string `locationName:"s3ResourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomerManagedS3Storage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomerManagedS3Storage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomerManagedS3Storage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomerManagedS3Storage"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.S3ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("S3ResourceArn"))
	}
	if s.S3ResourceArn != nil && len(*s.S3ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *CustomerManagedS3Storage) SetRoleArn(v string) *CustomerManagedS3Storage {
	s.RoleArn = &v
	return s
}

// SetS3ResourceArn sets the S3ResourceArn field's value.
func (s *CustomerManagedS3Storage) SetS3ResourceArn(v string) *CustomerManagedS3Storage {
	s.S3ResourceArn = &v
	return s
}

// Contains a dashboard summary.
type DashboardSummary struct {
	_ struct{} `type:"structure"`

	// The date the dashboard was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The dashboard's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the dashboard.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the dashboard was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The name of the dashboard
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardSummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DashboardSummary) SetCreationDate(v time.Time) *DashboardSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DashboardSummary) SetDescription(v string) *DashboardSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *DashboardSummary) SetId(v string) *DashboardSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *DashboardSummary) SetLastUpdateDate(v time.Time) *DashboardSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DashboardSummary) SetName(v string) *DashboardSummary {
	s.Name = &v
	return s
}

type DeleteAccessPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the access policy to be deleted.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `location:"uri" locationName:"accessPolicyId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPolicyInput"}
	if s.AccessPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyId"))
	}
	if s.AccessPolicyId != nil && len(*s.AccessPolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AccessPolicyId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicyId sets the AccessPolicyId field's value.
func (s *DeleteAccessPolicyInput) SetAccessPolicyId(v string) *DeleteAccessPolicyInput {
	s.AccessPolicyId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAccessPolicyInput) SetClientToken(v string) *DeleteAccessPolicyInput {
	s.ClientToken = &v
	return s
}

type DeleteAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPolicyOutput) GoString() string {
	return s.String()
}

type DeleteAssetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset to delete.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssetInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *DeleteAssetInput) SetAssetId(v string) *DeleteAssetInput {
	s.AssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAssetInput) SetClientToken(v string) *DeleteAssetInput {
	s.ClientToken = &v
	return s
}

type DeleteAssetModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset model to delete.
	//
	// AssetModelId is a required field
	AssetModelId *string `location:"uri" locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssetModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssetModelInput"}
	if s.AssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelId"))
	}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *DeleteAssetModelInput) SetAssetModelId(v string) *DeleteAssetModelInput {
	s.AssetModelId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAssetModelInput) SetClientToken(v string) *DeleteAssetModelInput {
	s.ClientToken = &v
	return s
}

type DeleteAssetModelOutput struct {
	_ struct{} `type:"structure"`

	// The status of the asset model, which contains a state (DELETING after successfully
	// calling this operation) and any error message.
	//
	// AssetModelStatus is a required field
	AssetModelStatus *AssetModelStatus `locationName:"assetModelStatus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetModelOutput) GoString() string {
	return s.String()
}

// SetAssetModelStatus sets the AssetModelStatus field's value.
func (s *DeleteAssetModelOutput) SetAssetModelStatus(v *AssetModelStatus) *DeleteAssetModelOutput {
	s.AssetModelStatus = v
	return s
}

type DeleteAssetOutput struct {
	_ struct{} `type:"structure"`

	// The status of the asset, which contains a state (DELETING after successfully
	// calling this operation) and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetOutput) GoString() string {
	return s.String()
}

// SetAssetStatus sets the AssetStatus field's value.
func (s *DeleteAssetOutput) SetAssetStatus(v *AssetStatus) *DeleteAssetOutput {
	s.AssetStatus = v
	return s
}

type DeleteDashboardInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the dashboard to delete.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"dashboardId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDashboardInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteDashboardInput) SetClientToken(v string) *DeleteDashboardInput {
	s.ClientToken = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DeleteDashboardInput) SetDashboardId(v string) *DeleteDashboardInput {
	s.DashboardId = &v
	return s
}

type DeleteDashboardOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardOutput) GoString() string {
	return s.String()
}

type DeleteGatewayInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the gateway to delete.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGatewayInput"}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayId sets the GatewayId field's value.
func (s *DeleteGatewayInput) SetGatewayId(v string) *DeleteGatewayInput {
	s.GatewayId = &v
	return s
}

type DeleteGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayOutput) GoString() string {
	return s.String()
}

type DeletePortalInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the portal to delete.
	//
	// PortalId is a required field
	PortalId *string `location:"uri" locationName:"portalId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePortalInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PortalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PortalId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeletePortalInput) SetClientToken(v string) *DeletePortalInput {
	s.ClientToken = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *DeletePortalInput) SetPortalId(v string) *DeletePortalInput {
	s.PortalId = &v
	return s
}

type DeletePortalOutput struct {
	_ struct{} `type:"structure"`

	// The status of the portal, which contains a state (DELETING after successfully
	// calling this operation) and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePortalOutput) GoString() string {
	return s.String()
}

// SetPortalStatus sets the PortalStatus field's value.
func (s *DeletePortalOutput) SetPortalStatus(v *PortalStatus) *DeletePortalOutput {
	s.PortalStatus = v
	return s
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteProjectInput) SetClientToken(v string) *DeleteProjectInput {
	s.ClientToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *DeleteProjectInput) SetProjectId(v string) *DeleteProjectInput {
	s.ProjectId = &v
	return s
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

type DeleteTimeSeriesInput struct {
	_ struct{} `type:"structure"`

	// The alias that identifies the time series.
	Alias *string `location:"querystring" locationName:"alias" min:"1" type:"string"`

	// The ID of the asset in which the asset property was created.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimeSeriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimeSeriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTimeSeriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTimeSeriesInput"}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *DeleteTimeSeriesInput) SetAlias(v string) *DeleteTimeSeriesInput {
	s.Alias = &v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *DeleteTimeSeriesInput) SetAssetId(v string) *DeleteTimeSeriesInput {
	s.AssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteTimeSeriesInput) SetClientToken(v string) *DeleteTimeSeriesInput {
	s.ClientToken = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *DeleteTimeSeriesInput) SetPropertyId(v string) *DeleteTimeSeriesInput {
	s.PropertyId = &v
	return s
}

type DeleteTimeSeriesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimeSeriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimeSeriesOutput) GoString() string {
	return s.String()
}

type DescribeAccessPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `location:"uri" locationName:"accessPolicyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccessPolicyInput"}
	if s.AccessPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyId"))
	}
	if s.AccessPolicyId != nil && len(*s.AccessPolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AccessPolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicyId sets the AccessPolicyId field's value.
func (s *DescribeAccessPolicyInput) SetAccessPolicyId(v string) *DescribeAccessPolicyInput {
	s.AccessPolicyId = &v
	return s
}

type DescribeAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the access policy, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}
	//
	// AccessPolicyArn is a required field
	AccessPolicyArn *string `locationName:"accessPolicyArn" min:"1" type:"string" required:"true"`

	// The date the access policy was created, in Unix epoch time.
	//
	// AccessPolicyCreationDate is a required field
	AccessPolicyCreationDate *time.Time `locationName:"accessPolicyCreationDate" type:"timestamp" required:"true"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `locationName:"accessPolicyId" min:"36" type:"string" required:"true"`

	// The identity (Amazon Web Services SSO user, Amazon Web Services SSO group,
	// or IAM user) to which this access policy applies.
	//
	// AccessPolicyIdentity is a required field
	AccessPolicyIdentity *Identity `locationName:"accessPolicyIdentity" type:"structure" required:"true"`

	// The date the access policy was last updated, in Unix epoch time.
	//
	// AccessPolicyLastUpdateDate is a required field
	AccessPolicyLastUpdateDate *time.Time `locationName:"accessPolicyLastUpdateDate" type:"timestamp" required:"true"`

	// The access policy permission. Note that a project ADMINISTRATOR is also known
	// as a project owner.
	//
	// AccessPolicyPermission is a required field
	AccessPolicyPermission *string `locationName:"accessPolicyPermission" type:"string" required:"true" enum:"Permission"`

	// The IoT SiteWise Monitor resource (portal or project) to which this access
	// policy provides access.
	//
	// AccessPolicyResource is a required field
	AccessPolicyResource *Resource `locationName:"accessPolicyResource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessPolicyOutput) GoString() string {
	return s.String()
}

// SetAccessPolicyArn sets the AccessPolicyArn field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyArn(v string) *DescribeAccessPolicyOutput {
	s.AccessPolicyArn = &v
	return s
}

// SetAccessPolicyCreationDate sets the AccessPolicyCreationDate field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyCreationDate(v time.Time) *DescribeAccessPolicyOutput {
	s.AccessPolicyCreationDate = &v
	return s
}

// SetAccessPolicyId sets the AccessPolicyId field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyId(v string) *DescribeAccessPolicyOutput {
	s.AccessPolicyId = &v
	return s
}

// SetAccessPolicyIdentity sets the AccessPolicyIdentity field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyIdentity(v *Identity) *DescribeAccessPolicyOutput {
	s.AccessPolicyIdentity = v
	return s
}

// SetAccessPolicyLastUpdateDate sets the AccessPolicyLastUpdateDate field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyLastUpdateDate(v time.Time) *DescribeAccessPolicyOutput {
	s.AccessPolicyLastUpdateDate = &v
	return s
}

// SetAccessPolicyPermission sets the AccessPolicyPermission field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyPermission(v string) *DescribeAccessPolicyOutput {
	s.AccessPolicyPermission = &v
	return s
}

// SetAccessPolicyResource sets the AccessPolicyResource field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyResource(v *Resource) *DescribeAccessPolicyOutput {
	s.AccessPolicyResource = v
	return s
}

type DescribeAssetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssetInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *DescribeAssetInput) SetAssetId(v string) *DescribeAssetInput {
	s.AssetId = &v
	return s
}

type DescribeAssetModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset model.
	//
	// AssetModelId is a required field
	AssetModelId *string `location:"uri" locationName:"assetModelId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssetModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssetModelInput"}
	if s.AssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelId"))
	}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *DescribeAssetModelInput) SetAssetModelId(v string) *DescribeAssetModelInput {
	s.AssetModelId = &v
	return s
}

type DescribeAssetModelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset model, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// AssetModelArn is a required field
	AssetModelArn *string `locationName:"assetModelArn" min:"1" type:"string" required:"true"`

	// The list of composite asset models for the asset model.
	AssetModelCompositeModels []*AssetModelCompositeModel `locationName:"assetModelCompositeModels" type:"list"`

	// The date the asset model was created, in Unix epoch time.
	//
	// AssetModelCreationDate is a required field
	AssetModelCreationDate *time.Time `locationName:"assetModelCreationDate" type:"timestamp" required:"true"`

	// The asset model's description.
	//
	// AssetModelDescription is a required field
	AssetModelDescription *string `locationName:"assetModelDescription" min:"1" type:"string" required:"true"`

	// A list of asset model hierarchies that each contain a childAssetModelId and
	// a hierarchyId (named id). A hierarchy specifies allowed parent/child asset
	// relationships for an asset model.
	//
	// AssetModelHierarchies is a required field
	AssetModelHierarchies []*AssetModelHierarchy `locationName:"assetModelHierarchies" type:"list" required:"true"`

	// The ID of the asset model.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The date the asset model was last updated, in Unix epoch time.
	//
	// AssetModelLastUpdateDate is a required field
	AssetModelLastUpdateDate *time.Time `locationName:"assetModelLastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset model.
	//
	// AssetModelName is a required field
	AssetModelName *string `locationName:"assetModelName" min:"1" type:"string" required:"true"`

	// The list of asset properties for the asset model.
	//
	// This object doesn't include properties that you define in composite models.
	// You can find composite model properties in the assetModelCompositeModels
	// object.
	//
	// AssetModelProperties is a required field
	AssetModelProperties []*AssetModelProperty `locationName:"assetModelProperties" type:"list" required:"true"`

	// The current status of the asset model, which contains a state and any error
	// message.
	//
	// AssetModelStatus is a required field
	AssetModelStatus *AssetModelStatus `locationName:"assetModelStatus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetModelOutput) GoString() string {
	return s.String()
}

// SetAssetModelArn sets the AssetModelArn field's value.
func (s *DescribeAssetModelOutput) SetAssetModelArn(v string) *DescribeAssetModelOutput {
	s.AssetModelArn = &v
	return s
}

// SetAssetModelCompositeModels sets the AssetModelCompositeModels field's value.
func (s *DescribeAssetModelOutput) SetAssetModelCompositeModels(v []*AssetModelCompositeModel) *DescribeAssetModelOutput {
	s.AssetModelCompositeModels = v
	return s
}

// SetAssetModelCreationDate sets the AssetModelCreationDate field's value.
func (s *DescribeAssetModelOutput) SetAssetModelCreationDate(v time.Time) *DescribeAssetModelOutput {
	s.AssetModelCreationDate = &v
	return s
}

// SetAssetModelDescription sets the AssetModelDescription field's value.
func (s *DescribeAssetModelOutput) SetAssetModelDescription(v string) *DescribeAssetModelOutput {
	s.AssetModelDescription = &v
	return s
}

// SetAssetModelHierarchies sets the AssetModelHierarchies field's value.
func (s *DescribeAssetModelOutput) SetAssetModelHierarchies(v []*AssetModelHierarchy) *DescribeAssetModelOutput {
	s.AssetModelHierarchies = v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *DescribeAssetModelOutput) SetAssetModelId(v string) *DescribeAssetModelOutput {
	s.AssetModelId = &v
	return s
}

// SetAssetModelLastUpdateDate sets the AssetModelLastUpdateDate field's value.
func (s *DescribeAssetModelOutput) SetAssetModelLastUpdateDate(v time.Time) *DescribeAssetModelOutput {
	s.AssetModelLastUpdateDate = &v
	return s
}

// SetAssetModelName sets the AssetModelName field's value.
func (s *DescribeAssetModelOutput) SetAssetModelName(v string) *DescribeAssetModelOutput {
	s.AssetModelName = &v
	return s
}

// SetAssetModelProperties sets the AssetModelProperties field's value.
func (s *DescribeAssetModelOutput) SetAssetModelProperties(v []*AssetModelProperty) *DescribeAssetModelOutput {
	s.AssetModelProperties = v
	return s
}

// SetAssetModelStatus sets the AssetModelStatus field's value.
func (s *DescribeAssetModelOutput) SetAssetModelStatus(v *AssetModelStatus) *DescribeAssetModelOutput {
	s.AssetModelStatus = v
	return s
}

type DescribeAssetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// AssetArn is a required field
	AssetArn *string `locationName:"assetArn" min:"1" type:"string" required:"true"`

	// The composite models for the asset.
	AssetCompositeModels []*AssetCompositeModel `locationName:"assetCompositeModels" type:"list"`

	// The date the asset was created, in Unix epoch time.
	//
	// AssetCreationDate is a required field
	AssetCreationDate *time.Time `locationName:"assetCreationDate" type:"timestamp" required:"true"`

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// AssetHierarchies is a required field
	AssetHierarchies []*AssetHierarchy `locationName:"assetHierarchies" type:"list" required:"true"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The date the asset was last updated, in Unix epoch time.
	//
	// AssetLastUpdateDate is a required field
	AssetLastUpdateDate *time.Time `locationName:"assetLastUpdateDate" type:"timestamp" required:"true"`

	// The ID of the asset model that was used to create the asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The name of the asset.
	//
	// AssetName is a required field
	AssetName *string `locationName:"assetName" min:"1" type:"string" required:"true"`

	// The list of asset properties for the asset.
	//
	// This object doesn't include properties that you define in composite models.
	// You can find composite model properties in the assetCompositeModels object.
	//
	// AssetProperties is a required field
	AssetProperties []*AssetProperty `locationName:"assetProperties" type:"list" required:"true"`

	// The current status of the asset, which contains a state and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetOutput) GoString() string {
	return s.String()
}

// SetAssetArn sets the AssetArn field's value.
func (s *DescribeAssetOutput) SetAssetArn(v string) *DescribeAssetOutput {
	s.AssetArn = &v
	return s
}

// SetAssetCompositeModels sets the AssetCompositeModels field's value.
func (s *DescribeAssetOutput) SetAssetCompositeModels(v []*AssetCompositeModel) *DescribeAssetOutput {
	s.AssetCompositeModels = v
	return s
}

// SetAssetCreationDate sets the AssetCreationDate field's value.
func (s *DescribeAssetOutput) SetAssetCreationDate(v time.Time) *DescribeAssetOutput {
	s.AssetCreationDate = &v
	return s
}

// SetAssetHierarchies sets the AssetHierarchies field's value.
func (s *DescribeAssetOutput) SetAssetHierarchies(v []*AssetHierarchy) *DescribeAssetOutput {
	s.AssetHierarchies = v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *DescribeAssetOutput) SetAssetId(v string) *DescribeAssetOutput {
	s.AssetId = &v
	return s
}

// SetAssetLastUpdateDate sets the AssetLastUpdateDate field's value.
func (s *DescribeAssetOutput) SetAssetLastUpdateDate(v time.Time) *DescribeAssetOutput {
	s.AssetLastUpdateDate = &v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *DescribeAssetOutput) SetAssetModelId(v string) *DescribeAssetOutput {
	s.AssetModelId = &v
	return s
}

// SetAssetName sets the AssetName field's value.
func (s *DescribeAssetOutput) SetAssetName(v string) *DescribeAssetOutput {
	s.AssetName = &v
	return s
}

// SetAssetProperties sets the AssetProperties field's value.
func (s *DescribeAssetOutput) SetAssetProperties(v []*AssetProperty) *DescribeAssetOutput {
	s.AssetProperties = v
	return s
}

// SetAssetStatus sets the AssetStatus field's value.
func (s *DescribeAssetOutput) SetAssetStatus(v *AssetStatus) *DescribeAssetOutput {
	s.AssetStatus = v
	return s
}

type DescribeAssetPropertyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// The ID of the asset property.
	//
	// PropertyId is a required field
	PropertyId *string `location:"uri" locationName:"propertyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetPropertyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetPropertyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssetPropertyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssetPropertyInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.PropertyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyId"))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *DescribeAssetPropertyInput) SetAssetId(v string) *DescribeAssetPropertyInput {
	s.AssetId = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *DescribeAssetPropertyInput) SetPropertyId(v string) *DescribeAssetPropertyInput {
	s.PropertyId = &v
	return s
}

type DescribeAssetPropertyOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The ID of the asset model.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The name of the asset.
	//
	// AssetName is a required field
	AssetName *string `locationName:"assetName" min:"1" type:"string" required:"true"`

	// The asset property's definition, alias, and notification state.
	//
	// This response includes this object for normal asset properties. If you describe
	// an asset property in a composite model, this response includes the asset
	// property information in compositeModel.
	AssetProperty *Property `locationName:"assetProperty" type:"structure"`

	// The composite asset model that declares this asset property, if this asset
	// property exists in a composite model.
	CompositeModel *CompositeModelProperty `locationName:"compositeModel" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetPropertyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetPropertyOutput) GoString() string {
	return s.String()
}

// SetAssetId sets the AssetId field's value.
func (s *DescribeAssetPropertyOutput) SetAssetId(v string) *DescribeAssetPropertyOutput {
	s.AssetId = &v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *DescribeAssetPropertyOutput) SetAssetModelId(v string) *DescribeAssetPropertyOutput {
	s.AssetModelId = &v
	return s
}

// SetAssetName sets the AssetName field's value.
func (s *DescribeAssetPropertyOutput) SetAssetName(v string) *DescribeAssetPropertyOutput {
	s.AssetName = &v
	return s
}

// SetAssetProperty sets the AssetProperty field's value.
func (s *DescribeAssetPropertyOutput) SetAssetProperty(v *Property) *DescribeAssetPropertyOutput {
	s.AssetProperty = v
	return s
}

// SetCompositeModel sets the CompositeModel field's value.
func (s *DescribeAssetPropertyOutput) SetCompositeModel(v *CompositeModelProperty) *DescribeAssetPropertyOutput {
	s.CompositeModel = v
	return s
}

type DescribeDashboardInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"dashboardId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDashboardInput"}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardId sets the DashboardId field's value.
func (s *DescribeDashboardInput) SetDashboardId(v string) *DescribeDashboardInput {
	s.DashboardId = &v
	return s
}

type DescribeDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the dashboard, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}
	//
	// DashboardArn is a required field
	DashboardArn *string `locationName:"dashboardArn" min:"1" type:"string" required:"true"`

	// The date the dashboard was created, in Unix epoch time.
	//
	// DashboardCreationDate is a required field
	DashboardCreationDate *time.Time `locationName:"dashboardCreationDate" type:"timestamp" required:"true"`

	// The dashboard's definition JSON literal. For detailed information, see Creating
	// dashboards (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html)
	// in the IoT SiteWise User Guide.
	//
	// DashboardDefinition is a required field
	DashboardDefinition *string `locationName:"dashboardDefinition" type:"string" required:"true"`

	// The dashboard's description.
	DashboardDescription *string `locationName:"dashboardDescription" min:"1" type:"string"`

	// The ID of the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `locationName:"dashboardId" min:"36" type:"string" required:"true"`

	// The date the dashboard was last updated, in Unix epoch time.
	//
	// DashboardLastUpdateDate is a required field
	DashboardLastUpdateDate *time.Time `locationName:"dashboardLastUpdateDate" type:"timestamp" required:"true"`

	// The name of the dashboard.
	//
	// DashboardName is a required field
	DashboardName *string `locationName:"dashboardName" min:"1" type:"string" required:"true"`

	// The ID of the project that the dashboard is in.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardOutput) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *DescribeDashboardOutput) SetDashboardArn(v string) *DescribeDashboardOutput {
	s.DashboardArn = &v
	return s
}

// SetDashboardCreationDate sets the DashboardCreationDate field's value.
func (s *DescribeDashboardOutput) SetDashboardCreationDate(v time.Time) *DescribeDashboardOutput {
	s.DashboardCreationDate = &v
	return s
}

// SetDashboardDefinition sets the DashboardDefinition field's value.
func (s *DescribeDashboardOutput) SetDashboardDefinition(v string) *DescribeDashboardOutput {
	s.DashboardDefinition = &v
	return s
}

// SetDashboardDescription sets the DashboardDescription field's value.
func (s *DescribeDashboardOutput) SetDashboardDescription(v string) *DescribeDashboardOutput {
	s.DashboardDescription = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DescribeDashboardOutput) SetDashboardId(v string) *DescribeDashboardOutput {
	s.DashboardId = &v
	return s
}

// SetDashboardLastUpdateDate sets the DashboardLastUpdateDate field's value.
func (s *DescribeDashboardOutput) SetDashboardLastUpdateDate(v time.Time) *DescribeDashboardOutput {
	s.DashboardLastUpdateDate = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *DescribeDashboardOutput) SetDashboardName(v string) *DescribeDashboardOutput {
	s.DashboardName = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *DescribeDashboardOutput) SetProjectId(v string) *DescribeDashboardOutput {
	s.ProjectId = &v
	return s
}

type DescribeDefaultEncryptionConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDefaultEncryptionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDefaultEncryptionConfigurationInput) GoString() string {
	return s.String()
}

type DescribeDefaultEncryptionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The status of the account configuration. This contains the ConfigurationState.
	// If there's an error, it also contains the ErrorDetails.
	//
	// ConfigurationStatus is a required field
	ConfigurationStatus *ConfigurationStatus `locationName:"configurationStatus" type:"structure" required:"true"`

	// The type of encryption used for the encryption configuration.
	//
	// EncryptionType is a required field
	EncryptionType *string `locationName:"encryptionType" type:"string" required:"true" enum:"EncryptionType"`

	// The key ARN of the customer managed key used for KMS encryption if you use
	// KMS_BASED_ENCRYPTION.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDefaultEncryptionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDefaultEncryptionConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfigurationStatus sets the ConfigurationStatus field's value.
func (s *DescribeDefaultEncryptionConfigurationOutput) SetConfigurationStatus(v *ConfigurationStatus) *DescribeDefaultEncryptionConfigurationOutput {
	s.ConfigurationStatus = v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *DescribeDefaultEncryptionConfigurationOutput) SetEncryptionType(v string) *DescribeDefaultEncryptionConfigurationOutput {
	s.EncryptionType = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *DescribeDefaultEncryptionConfigurationOutput) SetKmsKeyArn(v string) *DescribeDefaultEncryptionConfigurationOutput {
	s.KmsKeyArn = &v
	return s
}

type DescribeGatewayCapabilityConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The namespace of the capability configuration. For example, if you configure
	// OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration
	// has the namespace iotsitewise:opcuacollector:version, where version is a
	// number such as 1.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `location:"uri" locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The ID of the gateway that defines the capability configuration.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayCapabilityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayCapabilityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayCapabilityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGatewayCapabilityConfigurationInput"}
	if s.CapabilityNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("CapabilityNamespace"))
	}
	if s.CapabilityNamespace != nil && len(*s.CapabilityNamespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapabilityNamespace", 1))
	}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilityNamespace sets the CapabilityNamespace field's value.
func (s *DescribeGatewayCapabilityConfigurationInput) SetCapabilityNamespace(v string) *DescribeGatewayCapabilityConfigurationInput {
	s.CapabilityNamespace = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *DescribeGatewayCapabilityConfigurationInput) SetGatewayId(v string) *DescribeGatewayCapabilityConfigurationInput {
	s.GatewayId = &v
	return s
}

type DescribeGatewayCapabilityConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The JSON document that defines the gateway capability's configuration. For
	// more information, see Configuring data sources (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli)
	// in the IoT SiteWise User Guide.
	//
	// CapabilityConfiguration is a required field
	CapabilityConfiguration *string `locationName:"capabilityConfiguration" min:"1" type:"string" required:"true"`

	// The namespace of the gateway capability.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The synchronization status of the capability configuration. The sync status
	// can be one of the following:
	//
	//    * IN_SYNC – The gateway is running the capability configuration.
	//
	//    * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
	//
	//    * SYNC_FAILED – The gateway rejected the capability configuration.
	//
	// CapabilitySyncStatus is a required field
	CapabilitySyncStatus *string `locationName:"capabilitySyncStatus" type:"string" required:"true" enum:"CapabilitySyncStatus"`

	// The ID of the gateway that defines the capability configuration.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayCapabilityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayCapabilityConfigurationOutput) GoString() string {
	return s.String()
}

// SetCapabilityConfiguration sets the CapabilityConfiguration field's value.
func (s *DescribeGatewayCapabilityConfigurationOutput) SetCapabilityConfiguration(v string) *DescribeGatewayCapabilityConfigurationOutput {
	s.CapabilityConfiguration = &v
	return s
}

// SetCapabilityNamespace sets the CapabilityNamespace field's value.
func (s *DescribeGatewayCapabilityConfigurationOutput) SetCapabilityNamespace(v string) *DescribeGatewayCapabilityConfigurationOutput {
	s.CapabilityNamespace = &v
	return s
}

// SetCapabilitySyncStatus sets the CapabilitySyncStatus field's value.
func (s *DescribeGatewayCapabilityConfigurationOutput) SetCapabilitySyncStatus(v string) *DescribeGatewayCapabilityConfigurationOutput {
	s.CapabilitySyncStatus = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *DescribeGatewayCapabilityConfigurationOutput) SetGatewayId(v string) *DescribeGatewayCapabilityConfigurationOutput {
	s.GatewayId = &v
	return s
}

type DescribeGatewayInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the gateway device.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGatewayInput"}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayId sets the GatewayId field's value.
func (s *DescribeGatewayInput) SetGatewayId(v string) *DescribeGatewayInput {
	s.GatewayId = &v
	return s
}

type DescribeGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The date the gateway was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the gateway, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}
	//
	// GatewayArn is a required field
	GatewayArn *string `locationName:"gatewayArn" min:"1" type:"string" required:"true"`

	// A list of gateway capability summaries that each contain a namespace and
	// status. Each gateway capability defines data sources for the gateway. To
	// retrieve a capability configuration's definition, use DescribeGatewayCapabilityConfiguration
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html).
	//
	// GatewayCapabilitySummaries is a required field
	GatewayCapabilitySummaries []*GatewayCapabilitySummary `locationName:"gatewayCapabilitySummaries" type:"list" required:"true"`

	// The ID of the gateway device.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" min:"36" type:"string" required:"true"`

	// The name of the gateway.
	//
	// GatewayName is a required field
	GatewayName *string `locationName:"gatewayName" min:"1" type:"string" required:"true"`

	// The gateway's platform.
	GatewayPlatform *GatewayPlatform `locationName:"gatewayPlatform" type:"structure"`

	// The date the gateway was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeGatewayOutput) SetCreationDate(v time.Time) *DescribeGatewayOutput {
	s.CreationDate = &v
	return s
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *DescribeGatewayOutput) SetGatewayArn(v string) *DescribeGatewayOutput {
	s.GatewayArn = &v
	return s
}

// SetGatewayCapabilitySummaries sets the GatewayCapabilitySummaries field's value.
func (s *DescribeGatewayOutput) SetGatewayCapabilitySummaries(v []*GatewayCapabilitySummary) *DescribeGatewayOutput {
	s.GatewayCapabilitySummaries = v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *DescribeGatewayOutput) SetGatewayId(v string) *DescribeGatewayOutput {
	s.GatewayId = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *DescribeGatewayOutput) SetGatewayName(v string) *DescribeGatewayOutput {
	s.GatewayName = &v
	return s
}

// SetGatewayPlatform sets the GatewayPlatform field's value.
func (s *DescribeGatewayOutput) SetGatewayPlatform(v *GatewayPlatform) *DescribeGatewayOutput {
	s.GatewayPlatform = v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *DescribeGatewayOutput) SetLastUpdateDate(v time.Time) *DescribeGatewayOutput {
	s.LastUpdateDate = &v
	return s
}

type DescribeLoggingOptionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingOptionsInput) GoString() string {
	return s.String()
}

type DescribeLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The current logging options.
	//
	// LoggingOptions is a required field
	LoggingOptions *LoggingOptions `locationName:"loggingOptions" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingOptionsOutput) GoString() string {
	return s.String()
}

// SetLoggingOptions sets the LoggingOptions field's value.
func (s *DescribeLoggingOptionsOutput) SetLoggingOptions(v *LoggingOptions) *DescribeLoggingOptionsOutput {
	s.LoggingOptions = v
	return s
}

type DescribePortalInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the portal.
	//
	// PortalId is a required field
	PortalId *string `location:"uri" locationName:"portalId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePortalInput"}
	if s.PortalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PortalId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalId sets the PortalId field's value.
func (s *DescribePortalInput) SetPortalId(v string) *DescribePortalInput {
	s.PortalId = &v
	return s
}

type DescribePortalOutput struct {
	_ struct{} `type:"structure"`

	// Contains the configuration information of an alarm created in an IoT SiteWise
	// Monitor portal.
	Alarms *Alarms `locationName:"alarms" type:"structure"`

	// The email address that sends alarm notifications.
	NotificationSenderEmail *string `locationName:"notificationSenderEmail" min:"1" type:"string"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the portal, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"1" type:"string" required:"true"`

	// The service to use to authenticate users to the portal.
	PortalAuthMode *string `locationName:"portalAuthMode" type:"string" enum:"AuthMode"`

	// The Amazon Web Services SSO application generated client ID (used with Amazon
	// Web Services SSO APIs). IoT SiteWise includes portalClientId for only portals
	// that use Amazon Web Services SSO to authenticate users.
	//
	// PortalClientId is a required field
	PortalClientId *string `locationName:"portalClientId" min:"1" type:"string" required:"true"`

	// The Amazon Web Services administrator's contact email address.
	//
	// PortalContactEmail is a required field
	PortalContactEmail *string `locationName:"portalContactEmail" min:"1" type:"string" required:"true"`

	// The date the portal was created, in Unix epoch time.
	//
	// PortalCreationDate is a required field
	PortalCreationDate *time.Time `locationName:"portalCreationDate" type:"timestamp" required:"true"`

	// The portal's description.
	PortalDescription *string `locationName:"portalDescription" min:"1" type:"string"`

	// The ID of the portal.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// The date the portal was last updated, in Unix epoch time.
	//
	// PortalLastUpdateDate is a required field
	PortalLastUpdateDate *time.Time `locationName:"portalLastUpdateDate" type:"timestamp" required:"true"`

	// The portal's logo image, which is available at a URL.
	PortalLogoImageLocation *ImageLocation `locationName:"portalLogoImageLocation" type:"structure"`

	// The name of the portal.
	//
	// PortalName is a required field
	PortalName *string `locationName:"portalName" min:"1" type:"string" required:"true"`

	// The URL for the IoT SiteWise Monitor portal. You can use this URL to access
	// portals that use Amazon Web Services SSO for authentication. For portals
	// that use IAM for authentication, you must use the IoT SiteWise console to
	// get a URL that you can use to access the portal.
	//
	// PortalStartUrl is a required field
	PortalStartUrl *string `locationName:"portalStartUrl" min:"1" type:"string" required:"true"`

	// The current status of the portal, which contains a state and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the service role that allows the portal's users to access your IoT SiteWise
	// resources on your behalf. For more information, see Using service roles for
	// IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the IoT SiteWise User Guide.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePortalOutput) GoString() string {
	return s.String()
}

// SetAlarms sets the Alarms field's value.
func (s *DescribePortalOutput) SetAlarms(v *Alarms) *DescribePortalOutput {
	s.Alarms = v
	return s
}

// SetNotificationSenderEmail sets the NotificationSenderEmail field's value.
func (s *DescribePortalOutput) SetNotificationSenderEmail(v string) *DescribePortalOutput {
	s.NotificationSenderEmail = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *DescribePortalOutput) SetPortalArn(v string) *DescribePortalOutput {
	s.PortalArn = &v
	return s
}

// SetPortalAuthMode sets the PortalAuthMode field's value.
func (s *DescribePortalOutput) SetPortalAuthMode(v string) *DescribePortalOutput {
	s.PortalAuthMode = &v
	return s
}

// SetPortalClientId sets the PortalClientId field's value.
func (s *DescribePortalOutput) SetPortalClientId(v string) *DescribePortalOutput {
	s.PortalClientId = &v
	return s
}

// SetPortalContactEmail sets the PortalContactEmail field's value.
func (s *DescribePortalOutput) SetPortalContactEmail(v string) *DescribePortalOutput {
	s.PortalContactEmail = &v
	return s
}

// SetPortalCreationDate sets the PortalCreationDate field's value.
func (s *DescribePortalOutput) SetPortalCreationDate(v time.Time) *DescribePortalOutput {
	s.PortalCreationDate = &v
	return s
}

// SetPortalDescription sets the PortalDescription field's value.
func (s *DescribePortalOutput) SetPortalDescription(v string) *DescribePortalOutput {
	s.PortalDescription = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *DescribePortalOutput) SetPortalId(v string) *DescribePortalOutput {
	s.PortalId = &v
	return s
}

// SetPortalLastUpdateDate sets the PortalLastUpdateDate field's value.
func (s *DescribePortalOutput) SetPortalLastUpdateDate(v time.Time) *DescribePortalOutput {
	s.PortalLastUpdateDate = &v
	return s
}

// SetPortalLogoImageLocation sets the PortalLogoImageLocation field's value.
func (s *DescribePortalOutput) SetPortalLogoImageLocation(v *ImageLocation) *DescribePortalOutput {
	s.PortalLogoImageLocation = v
	return s
}

// SetPortalName sets the PortalName field's value.
func (s *DescribePortalOutput) SetPortalName(v string) *DescribePortalOutput {
	s.PortalName = &v
	return s
}

// SetPortalStartUrl sets the PortalStartUrl field's value.
func (s *DescribePortalOutput) SetPortalStartUrl(v string) *DescribePortalOutput {
	s.PortalStartUrl = &v
	return s
}

// SetPortalStatus sets the PortalStatus field's value.
func (s *DescribePortalOutput) SetPortalStatus(v *PortalStatus) *DescribePortalOutput {
	s.PortalStatus = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribePortalOutput) SetRoleArn(v string) *DescribePortalOutput {
	s.RoleArn = &v
	return s
}

type DescribeProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectId sets the ProjectId field's value.
func (s *DescribeProjectInput) SetProjectId(v string) *DescribeProjectInput {
	s.ProjectId = &v
	return s
}

type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the portal that the project is in.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the project, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"1" type:"string" required:"true"`

	// The date the project was created, in Unix epoch time.
	//
	// ProjectCreationDate is a required field
	ProjectCreationDate *time.Time `locationName:"projectCreationDate" type:"timestamp" required:"true"`

	// The project's description.
	ProjectDescription *string `locationName:"projectDescription" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`

	// The date the project was last updated, in Unix epoch time.
	//
	// ProjectLastUpdateDate is a required field
	ProjectLastUpdateDate *time.Time `locationName:"projectLastUpdateDate" type:"timestamp" required:"true"`

	// The name of the project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectOutput) GoString() string {
	return s.String()
}

// SetPortalId sets the PortalId field's value.
func (s *DescribeProjectOutput) SetPortalId(v string) *DescribeProjectOutput {
	s.PortalId = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *DescribeProjectOutput) SetProjectArn(v string) *DescribeProjectOutput {
	s.ProjectArn = &v
	return s
}

// SetProjectCreationDate sets the ProjectCreationDate field's value.
func (s *DescribeProjectOutput) SetProjectCreationDate(v time.Time) *DescribeProjectOutput {
	s.ProjectCreationDate = &v
	return s
}

// SetProjectDescription sets the ProjectDescription field's value.
func (s *DescribeProjectOutput) SetProjectDescription(v string) *DescribeProjectOutput {
	s.ProjectDescription = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *DescribeProjectOutput) SetProjectId(v string) *DescribeProjectOutput {
	s.ProjectId = &v
	return s
}

// SetProjectLastUpdateDate sets the ProjectLastUpdateDate field's value.
func (s *DescribeProjectOutput) SetProjectLastUpdateDate(v time.Time) *DescribeProjectOutput {
	s.ProjectLastUpdateDate = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeProjectOutput) SetProjectName(v string) *DescribeProjectOutput {
	s.ProjectName = &v
	return s
}

type DescribeStorageConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageConfigurationInput) GoString() string {
	return s.String()
}

type DescribeStorageConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Contains current status information for the configuration.
	//
	// ConfigurationStatus is a required field
	ConfigurationStatus *ConfigurationStatus `locationName:"configurationStatus" type:"structure" required:"true"`

	// Contains the storage configuration for time series (data streams) that aren't
	// associated with asset properties. The disassociatedDataStorage can be one
	// of the following values:
	//
	//    * ENABLED – IoT SiteWise accepts time series that aren't associated
	//    with asset properties. After the disassociatedDataStorage is enabled,
	//    you can't disable it.
	//
	//    * DISABLED – IoT SiteWise doesn't accept time series (data streams)
	//    that aren't associated with asset properties.
	//
	// For more information, see Data streams (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html)
	// in the IoT SiteWise User Guide.
	DisassociatedDataStorage *string `locationName:"disassociatedDataStorage" type:"string" enum:"DisassociatedDataStorageState"`

	// The date the storage configuration was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// Contains information about the storage destination.
	MultiLayerStorage *MultiLayerStorage `locationName:"multiLayerStorage" type:"structure"`

	// How many days your data is kept in the hot tier. By default, your data is
	// kept indefinitely in the hot tier.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// The storage tier that you specified for your data. The storageType parameter
	// can be one of the following values:
	//
	//    * SITEWISE_DEFAULT_STORAGE – IoT SiteWise saves your data into the hot
	//    tier. The hot tier is a service-managed database.
	//
	//    * MULTI_LAYER_STORAGE – IoT SiteWise saves your data in both the cold
	//    tier and the cold tier. The cold tier is a customer-managed Amazon S3
	//    bucket.
	//
	// StorageType is a required field
	StorageType *string `locationName:"storageType" type:"string" required:"true" enum:"StorageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfigurationStatus sets the ConfigurationStatus field's value.
func (s *DescribeStorageConfigurationOutput) SetConfigurationStatus(v *ConfigurationStatus) *DescribeStorageConfigurationOutput {
	s.ConfigurationStatus = v
	return s
}

// SetDisassociatedDataStorage sets the DisassociatedDataStorage field's value.
func (s *DescribeStorageConfigurationOutput) SetDisassociatedDataStorage(v string) *DescribeStorageConfigurationOutput {
	s.DisassociatedDataStorage = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *DescribeStorageConfigurationOutput) SetLastUpdateDate(v time.Time) *DescribeStorageConfigurationOutput {
	s.LastUpdateDate = &v
	return s
}

// SetMultiLayerStorage sets the MultiLayerStorage field's value.
func (s *DescribeStorageConfigurationOutput) SetMultiLayerStorage(v *MultiLayerStorage) *DescribeStorageConfigurationOutput {
	s.MultiLayerStorage = v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *DescribeStorageConfigurationOutput) SetRetentionPeriod(v *RetentionPeriod) *DescribeStorageConfigurationOutput {
	s.RetentionPeriod = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DescribeStorageConfigurationOutput) SetStorageType(v string) *DescribeStorageConfigurationOutput {
	s.StorageType = &v
	return s
}

type DescribeTimeSeriesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias that identifies the time series.
	Alias *string `location:"querystring" locationName:"alias" min:"1" type:"string"`

	// The ID of the asset in which the asset property was created.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTimeSeriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTimeSeriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTimeSeriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTimeSeriesInput"}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *DescribeTimeSeriesInput) SetAlias(v string) *DescribeTimeSeriesInput {
	s.Alias = &v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *DescribeTimeSeriesInput) SetAssetId(v string) *DescribeTimeSeriesInput {
	s.AssetId = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *DescribeTimeSeriesInput) SetPropertyId(v string) *DescribeTimeSeriesInput {
	s.PropertyId = &v
	return s
}

type DescribeTimeSeriesOutput struct {
	_ struct{} `type:"structure"`

	// The alias that identifies the time series.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The ID of the asset in which the asset property was created.
	AssetId *string `locationName:"assetId" min:"36" type:"string"`

	// The data type of the time series.
	//
	// If you specify STRUCT, you must also specify dataTypeSpec to identify the
	// type of the structure for this time series.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"PropertyDataType"`

	// The data type of the structure for this time series. This parameter is required
	// for time series that have the STRUCT data type.
	//
	// The options for this parameter depend on the type of the composite model
	// in which you created the asset property that is associated with your time
	// series. Use AWS/ALARM_STATE for alarm state in alarm composite models.
	DataTypeSpec *string `locationName:"dataTypeSpec" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `locationName:"propertyId" min:"36" type:"string"`

	// The date that the time series was created, in Unix epoch time.
	//
	// TimeSeriesCreationDate is a required field
	TimeSeriesCreationDate *time.Time `locationName:"timeSeriesCreationDate" type:"timestamp" required:"true"`

	// The ID of the time series.
	//
	// TimeSeriesId is a required field
	TimeSeriesId *string `locationName:"timeSeriesId" min:"36" type:"string" required:"true"`

	// The date that the time series was last updated, in Unix epoch time.
	//
	// TimeSeriesLastUpdateDate is a required field
	TimeSeriesLastUpdateDate *time.Time `locationName:"timeSeriesLastUpdateDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTimeSeriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTimeSeriesOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *DescribeTimeSeriesOutput) SetAlias(v string) *DescribeTimeSeriesOutput {
	s.Alias = &v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *DescribeTimeSeriesOutput) SetAssetId(v string) *DescribeTimeSeriesOutput {
	s.AssetId = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *DescribeTimeSeriesOutput) SetDataType(v string) *DescribeTimeSeriesOutput {
	s.DataType = &v
	return s
}

// SetDataTypeSpec sets the DataTypeSpec field's value.
func (s *DescribeTimeSeriesOutput) SetDataTypeSpec(v string) *DescribeTimeSeriesOutput {
	s.DataTypeSpec = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *DescribeTimeSeriesOutput) SetPropertyId(v string) *DescribeTimeSeriesOutput {
	s.PropertyId = &v
	return s
}

// SetTimeSeriesCreationDate sets the TimeSeriesCreationDate field's value.
func (s *DescribeTimeSeriesOutput) SetTimeSeriesCreationDate(v time.Time) *DescribeTimeSeriesOutput {
	s.TimeSeriesCreationDate = &v
	return s
}

// SetTimeSeriesId sets the TimeSeriesId field's value.
func (s *DescribeTimeSeriesOutput) SetTimeSeriesId(v string) *DescribeTimeSeriesOutput {
	s.TimeSeriesId = &v
	return s
}

// SetTimeSeriesLastUpdateDate sets the TimeSeriesLastUpdateDate field's value.
func (s *DescribeTimeSeriesOutput) SetTimeSeriesLastUpdateDate(v time.Time) *DescribeTimeSeriesOutput {
	s.TimeSeriesLastUpdateDate = &v
	return s
}

// Contains detailed error information.
type DetailedError struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"DetailedErrorCode"`

	// The error message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetailedError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetailedError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *DetailedError) SetCode(v string) *DetailedError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DetailedError) SetMessage(v string) *DetailedError {
	s.Message = &v
	return s
}

type DisassociateAssetsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the parent asset from which to disassociate the child asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// The ID of the child asset to disassociate.
	//
	// ChildAssetId is a required field
	ChildAssetId *string `locationName:"childAssetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of a hierarchy in the parent asset's model. Hierarchies allow different
	// groupings of assets to be formed that all come from the same asset model.
	// You can use the hierarchy ID to identify the correct asset to disassociate.
	// For more information, see Asset hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the IoT SiteWise User Guide.
	//
	// HierarchyId is a required field
	HierarchyId *string `locationName:"hierarchyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateAssetsInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ChildAssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildAssetId"))
	}
	if s.ChildAssetId != nil && len(*s.ChildAssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ChildAssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.HierarchyId == nil {
		invalidParams.Add(request.NewErrParamRequired("HierarchyId"))
	}
	if s.HierarchyId != nil && len(*s.HierarchyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *DisassociateAssetsInput) SetAssetId(v string) *DisassociateAssetsInput {
	s.AssetId = &v
	return s
}

// SetChildAssetId sets the ChildAssetId field's value.
func (s *DisassociateAssetsInput) SetChildAssetId(v string) *DisassociateAssetsInput {
	s.ChildAssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateAssetsInput) SetClientToken(v string) *DisassociateAssetsInput {
	s.ClientToken = &v
	return s
}

// SetHierarchyId sets the HierarchyId field's value.
func (s *DisassociateAssetsInput) SetHierarchyId(v string) *DisassociateAssetsInput {
	s.HierarchyId = &v
	return s
}

type DisassociateAssetsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAssetsOutput) GoString() string {
	return s.String()
}

type DisassociateTimeSeriesFromAssetPropertyInput struct {
	_ struct{} `type:"structure"`

	// The alias that identifies the time series.
	//
	// Alias is a required field
	Alias *string `location:"querystring" locationName:"alias" min:"1" type:"string" required:"true"`

	// The ID of the asset in which the asset property was created.
	//
	// AssetId is a required field
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the asset property.
	//
	// PropertyId is a required field
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTimeSeriesFromAssetPropertyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTimeSeriesFromAssetPropertyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateTimeSeriesFromAssetPropertyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateTimeSeriesFromAssetPropertyInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PropertyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyId"))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *DisassociateTimeSeriesFromAssetPropertyInput) SetAlias(v string) *DisassociateTimeSeriesFromAssetPropertyInput {
	s.Alias = &v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *DisassociateTimeSeriesFromAssetPropertyInput) SetAssetId(v string) *DisassociateTimeSeriesFromAssetPropertyInput {
	s.AssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateTimeSeriesFromAssetPropertyInput) SetClientToken(v string) *DisassociateTimeSeriesFromAssetPropertyInput {
	s.ClientToken = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *DisassociateTimeSeriesFromAssetPropertyInput) SetPropertyId(v string) *DisassociateTimeSeriesFromAssetPropertyInput {
	s.PropertyId = &v
	return s
}

type DisassociateTimeSeriesFromAssetPropertyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTimeSeriesFromAssetPropertyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTimeSeriesFromAssetPropertyOutput) GoString() string {
	return s.String()
}

// Contains the details of an IoT SiteWise error.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"ErrorCode"`

	// A list of detailed errors.
	Details []*DetailedError `locationName:"details" type:"list"`

	// The error message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ErrorDetails) SetCode(v string) *ErrorDetails {
	s.Code = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *ErrorDetails) SetDetails(v []*DetailedError) *ErrorDetails {
	s.Details = v
	return s
}

// SetMessage sets the Message field's value.
func (s *ErrorDetails) SetMessage(v string) *ErrorDetails {
	s.Message = &v
	return s
}

// Contains expression variable information.
type ExpressionVariable struct {
	_ struct{} `type:"structure"`

	// The friendly name of the variable to be used in the expression.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The variable that identifies an asset property from which to use values.
	//
	// Value is a required field
	Value *VariableValue `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpressionVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpressionVariable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExpressionVariable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExpressionVariable"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ExpressionVariable) SetName(v string) *ExpressionVariable {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ExpressionVariable) SetValue(v *VariableValue) *ExpressionVariable {
	s.Value = v
	return s
}

// The forwarding configuration for a given property.
type ForwardingConfig struct {
	_ struct{} `type:"structure"`

	// The forwarding state for the given property.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"ForwardingConfigState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForwardingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForwardingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForwardingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForwardingConfig"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetState sets the State field's value.
func (s *ForwardingConfig) SetState(v string) *ForwardingConfig {
	s.State = &v
	return s
}

// Contains a summary of a gateway capability configuration.
type GatewayCapabilitySummary struct {
	_ struct{} `type:"structure"`

	// The namespace of the capability configuration. For example, if you configure
	// OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration
	// has the namespace iotsitewise:opcuacollector:version, where version is a
	// number such as 1.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The synchronization status of the capability configuration. The sync status
	// can be one of the following:
	//
	//    * IN_SYNC – The gateway is running the capability configuration.
	//
	//    * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
	//
	//    * SYNC_FAILED – The gateway rejected the capability configuration.
	//
	// CapabilitySyncStatus is a required field
	CapabilitySyncStatus *string `locationName:"capabilitySyncStatus" type:"string" required:"true" enum:"CapabilitySyncStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayCapabilitySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayCapabilitySummary) GoString() string {
	return s.String()
}

// SetCapabilityNamespace sets the CapabilityNamespace field's value.
func (s *GatewayCapabilitySummary) SetCapabilityNamespace(v string) *GatewayCapabilitySummary {
	s.CapabilityNamespace = &v
	return s
}

// SetCapabilitySyncStatus sets the CapabilitySyncStatus field's value.
func (s *GatewayCapabilitySummary) SetCapabilitySyncStatus(v string) *GatewayCapabilitySummary {
	s.CapabilitySyncStatus = &v
	return s
}

// Contains a gateway's platform information.
type GatewayPlatform struct {
	_ struct{} `type:"structure"`

	// A gateway that runs on IoT Greengrass.
	Greengrass *Greengrass `locationName:"greengrass" type:"structure"`

	// A gateway that runs on IoT Greengrass V2.
	GreengrassV2 *GreengrassV2 `locationName:"greengrassV2" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayPlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayPlatform) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GatewayPlatform) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GatewayPlatform"}
	if s.Greengrass != nil {
		if err := s.Greengrass.Validate(); err != nil {
			invalidParams.AddNested("Greengrass", err.(request.ErrInvalidParams))
		}
	}
	if s.GreengrassV2 != nil {
		if err := s.GreengrassV2.Validate(); err != nil {
			invalidParams.AddNested("GreengrassV2", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGreengrass sets the Greengrass field's value.
func (s *GatewayPlatform) SetGreengrass(v *Greengrass) *GatewayPlatform {
	s.Greengrass = v
	return s
}

// SetGreengrassV2 sets the GreengrassV2 field's value.
func (s *GatewayPlatform) SetGreengrassV2(v *GreengrassV2) *GatewayPlatform {
	s.GreengrassV2 = v
	return s
}

// Contains a summary of a gateway.
type GatewaySummary struct {
	_ struct{} `type:"structure"`

	// The date the gateway was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// A list of gateway capability summaries that each contain a namespace and
	// status. Each gateway capability defines data sources for the gateway. To
	// retrieve a capability configuration's definition, use DescribeGatewayCapabilityConfiguration
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html).
	GatewayCapabilitySummaries []*GatewayCapabilitySummary `locationName:"gatewayCapabilitySummaries" type:"list"`

	// The ID of the gateway device.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" min:"36" type:"string" required:"true"`

	// The name of the asset.
	//
	// GatewayName is a required field
	GatewayName *string `locationName:"gatewayName" min:"1" type:"string" required:"true"`

	// Contains a gateway's platform information.
	GatewayPlatform *GatewayPlatform `locationName:"gatewayPlatform" type:"structure"`

	// The date the gateway was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewaySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewaySummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *GatewaySummary) SetCreationDate(v time.Time) *GatewaySummary {
	s.CreationDate = &v
	return s
}

// SetGatewayCapabilitySummaries sets the GatewayCapabilitySummaries field's value.
func (s *GatewaySummary) SetGatewayCapabilitySummaries(v []*GatewayCapabilitySummary) *GatewaySummary {
	s.GatewayCapabilitySummaries = v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *GatewaySummary) SetGatewayId(v string) *GatewaySummary {
	s.GatewayId = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *GatewaySummary) SetGatewayName(v string) *GatewaySummary {
	s.GatewayName = &v
	return s
}

// SetGatewayPlatform sets the GatewayPlatform field's value.
func (s *GatewaySummary) SetGatewayPlatform(v *GatewayPlatform) *GatewaySummary {
	s.GatewayPlatform = v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *GatewaySummary) SetLastUpdateDate(v time.Time) *GatewaySummary {
	s.LastUpdateDate = &v
	return s
}

type GetAssetPropertyAggregatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The data aggregating function.
	//
	// AggregateTypes is a required field
	AggregateTypes []*string `location:"querystring" locationName:"aggregateTypes" min:"1" type:"list" required:"true" enum:"AggregateType"`

	// The ID of the asset.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The inclusive end of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	//
	// EndDate is a required field
	EndDate *time.Time `location:"querystring" locationName:"endDate" type:"timestamp" required:"true"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 100
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	PropertyAlias *string `location:"querystring" locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`

	// The quality by which to filter asset data.
	Qualities []*string `location:"querystring" locationName:"qualities" min:"1" type:"list" enum:"Quality"`

	// The time interval over which to aggregate data.
	//
	// Resolution is a required field
	Resolution *string `location:"querystring" locationName:"resolution" min:"2" type:"string" required:"true"`

	// The exclusive start of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	//
	// StartDate is a required field
	StartDate *time.Time `location:"querystring" locationName:"startDate" type:"timestamp" required:"true"`

	// The chronological sorting order of the requested information.
	//
	// Default: ASCENDING
	TimeOrdering *string `location:"querystring" locationName:"timeOrdering" type:"string" enum:"TimeOrdering"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyAggregatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyAggregatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetPropertyAggregatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetPropertyAggregatesInput"}
	if s.AggregateTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregateTypes"))
	}
	if s.AggregateTypes != nil && len(s.AggregateTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AggregateTypes", 1))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}
	if s.Qualities != nil && len(s.Qualities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualities", 1))
	}
	if s.Resolution == nil {
		invalidParams.Add(request.NewErrParamRequired("Resolution"))
	}
	if s.Resolution != nil && len(*s.Resolution) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Resolution", 2))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregateTypes sets the AggregateTypes field's value.
func (s *GetAssetPropertyAggregatesInput) SetAggregateTypes(v []*string) *GetAssetPropertyAggregatesInput {
	s.AggregateTypes = v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *GetAssetPropertyAggregatesInput) SetAssetId(v string) *GetAssetPropertyAggregatesInput {
	s.AssetId = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *GetAssetPropertyAggregatesInput) SetEndDate(v time.Time) *GetAssetPropertyAggregatesInput {
	s.EndDate = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAssetPropertyAggregatesInput) SetMaxResults(v int64) *GetAssetPropertyAggregatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAssetPropertyAggregatesInput) SetNextToken(v string) *GetAssetPropertyAggregatesInput {
	s.NextToken = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *GetAssetPropertyAggregatesInput) SetPropertyAlias(v string) *GetAssetPropertyAggregatesInput {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *GetAssetPropertyAggregatesInput) SetPropertyId(v string) *GetAssetPropertyAggregatesInput {
	s.PropertyId = &v
	return s
}

// SetQualities sets the Qualities field's value.
func (s *GetAssetPropertyAggregatesInput) SetQualities(v []*string) *GetAssetPropertyAggregatesInput {
	s.Qualities = v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *GetAssetPropertyAggregatesInput) SetResolution(v string) *GetAssetPropertyAggregatesInput {
	s.Resolution = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *GetAssetPropertyAggregatesInput) SetStartDate(v time.Time) *GetAssetPropertyAggregatesInput {
	s.StartDate = &v
	return s
}

// SetTimeOrdering sets the TimeOrdering field's value.
func (s *GetAssetPropertyAggregatesInput) SetTimeOrdering(v string) *GetAssetPropertyAggregatesInput {
	s.TimeOrdering = &v
	return s
}

type GetAssetPropertyAggregatesOutput struct {
	_ struct{} `type:"structure"`

	// The requested aggregated values.
	//
	// AggregatedValues is a required field
	AggregatedValues []*AggregatedValue `locationName:"aggregatedValues" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyAggregatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyAggregatesOutput) GoString() string {
	return s.String()
}

// SetAggregatedValues sets the AggregatedValues field's value.
func (s *GetAssetPropertyAggregatesOutput) SetAggregatedValues(v []*AggregatedValue) *GetAssetPropertyAggregatesOutput {
	s.AggregatedValues = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAssetPropertyAggregatesOutput) SetNextToken(v string) *GetAssetPropertyAggregatesOutput {
	s.NextToken = &v
	return s
}

type GetAssetPropertyValueHistoryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The inclusive end of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	EndDate *time.Time `location:"querystring" locationName:"endDate" type:"timestamp"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 100
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	PropertyAlias *string `location:"querystring" locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`

	// The quality by which to filter asset data.
	Qualities []*string `location:"querystring" locationName:"qualities" min:"1" type:"list" enum:"Quality"`

	// The exclusive start of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	StartDate *time.Time `location:"querystring" locationName:"startDate" type:"timestamp"`

	// The chronological sorting order of the requested information.
	//
	// Default: ASCENDING
	TimeOrdering *string `location:"querystring" locationName:"timeOrdering" type:"string" enum:"TimeOrdering"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyValueHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyValueHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetPropertyValueHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetPropertyValueHistoryInput"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}
	if s.Qualities != nil && len(s.Qualities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualities", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *GetAssetPropertyValueHistoryInput) SetAssetId(v string) *GetAssetPropertyValueHistoryInput {
	s.AssetId = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *GetAssetPropertyValueHistoryInput) SetEndDate(v time.Time) *GetAssetPropertyValueHistoryInput {
	s.EndDate = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAssetPropertyValueHistoryInput) SetMaxResults(v int64) *GetAssetPropertyValueHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAssetPropertyValueHistoryInput) SetNextToken(v string) *GetAssetPropertyValueHistoryInput {
	s.NextToken = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *GetAssetPropertyValueHistoryInput) SetPropertyAlias(v string) *GetAssetPropertyValueHistoryInput {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *GetAssetPropertyValueHistoryInput) SetPropertyId(v string) *GetAssetPropertyValueHistoryInput {
	s.PropertyId = &v
	return s
}

// SetQualities sets the Qualities field's value.
func (s *GetAssetPropertyValueHistoryInput) SetQualities(v []*string) *GetAssetPropertyValueHistoryInput {
	s.Qualities = v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *GetAssetPropertyValueHistoryInput) SetStartDate(v time.Time) *GetAssetPropertyValueHistoryInput {
	s.StartDate = &v
	return s
}

// SetTimeOrdering sets the TimeOrdering field's value.
func (s *GetAssetPropertyValueHistoryInput) SetTimeOrdering(v string) *GetAssetPropertyValueHistoryInput {
	s.TimeOrdering = &v
	return s
}

type GetAssetPropertyValueHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The asset property's value history.
	//
	// AssetPropertyValueHistory is a required field
	AssetPropertyValueHistory []*AssetPropertyValue `locationName:"assetPropertyValueHistory" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyValueHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyValueHistoryOutput) GoString() string {
	return s.String()
}

// SetAssetPropertyValueHistory sets the AssetPropertyValueHistory field's value.
func (s *GetAssetPropertyValueHistoryOutput) SetAssetPropertyValueHistory(v []*AssetPropertyValue) *GetAssetPropertyValueHistoryOutput {
	s.AssetPropertyValueHistory = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAssetPropertyValueHistoryOutput) SetNextToken(v string) *GetAssetPropertyValueHistoryOutput {
	s.NextToken = &v
	return s
}

type GetAssetPropertyValueInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	PropertyAlias *string `location:"querystring" locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetPropertyValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetPropertyValueInput"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *GetAssetPropertyValueInput) SetAssetId(v string) *GetAssetPropertyValueInput {
	s.AssetId = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *GetAssetPropertyValueInput) SetPropertyAlias(v string) *GetAssetPropertyValueInput {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *GetAssetPropertyValueInput) SetPropertyId(v string) *GetAssetPropertyValueInput {
	s.PropertyId = &v
	return s
}

type GetAssetPropertyValueOutput struct {
	_ struct{} `type:"structure"`

	// The current asset property value.
	PropertyValue *AssetPropertyValue `locationName:"propertyValue" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetPropertyValueOutput) GoString() string {
	return s.String()
}

// SetPropertyValue sets the PropertyValue field's value.
func (s *GetAssetPropertyValueOutput) SetPropertyValue(v *AssetPropertyValue) *GetAssetPropertyValueOutput {
	s.PropertyValue = v
	return s
}

type GetInterpolatedAssetPropertyValuesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The inclusive end of the range from which to interpolate data, expressed
	// in seconds in Unix epoch time.
	//
	// EndTimeInSeconds is a required field
	EndTimeInSeconds *int64 `location:"querystring" locationName:"endTimeInSeconds" min:"1" type:"long" required:"true"`

	// The nanosecond offset converted from endTimeInSeconds.
	EndTimeOffsetInNanos *int64 `location:"querystring" locationName:"endTimeOffsetInNanos" type:"integer"`

	// The time interval in seconds over which to interpolate data. Each interval
	// starts when the previous one ends.
	//
	// IntervalInSeconds is a required field
	IntervalInSeconds *int64 `location:"querystring" locationName:"intervalInSeconds" min:"1" type:"long" required:"true"`

	// The query interval for the window, in seconds. IoT SiteWise computes each
	// interpolated value by using data points from the timestamp of each interval,
	// minus the window to the timestamp of each interval plus the window. If not
	// specified, the window ranges between the start time minus the interval and
	// the end time plus the interval.
	//
	//    * If you specify a value for the intervalWindowInSeconds parameter, the
	//    value for the type parameter must be LINEAR_INTERPOLATION.
	//
	//    * If a data point isn't found during the specified query window, IoT SiteWise
	//    won't return an interpolated value for the interval. This indicates that
	//    there's a gap in the ingested data points.
	//
	// For example, you can get the interpolated temperature values for a wind turbine
	// every 24 hours over a duration of 7 days. If the interpolation starts on
	// July 1, 2021, at 9 AM with a window of 2 hours, IoT SiteWise uses the data
	// points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July
	// 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses
	// the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours)
	// on July 3, 2021 to compute the second interpolated value, and so on.
	IntervalWindowInSeconds *int64 `location:"querystring" locationName:"intervalWindowInSeconds" min:"1" type:"long"`

	// The maximum number of results to return for each paginated request. If not
	// specified, the default value is 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	PropertyAlias *string `location:"querystring" locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`

	// The quality of the asset property value. You can use this parameter as a
	// filter to choose only the asset property values that have a specific quality.
	//
	// Quality is a required field
	Quality *string `location:"querystring" locationName:"quality" type:"string" required:"true" enum:"Quality"`

	// The exclusive start of the range from which to interpolate data, expressed
	// in seconds in Unix epoch time.
	//
	// StartTimeInSeconds is a required field
	StartTimeInSeconds *int64 `location:"querystring" locationName:"startTimeInSeconds" min:"1" type:"long" required:"true"`

	// The nanosecond offset converted from startTimeInSeconds.
	StartTimeOffsetInNanos *int64 `location:"querystring" locationName:"startTimeOffsetInNanos" type:"integer"`

	// The interpolation type.
	//
	// Valid values: LINEAR_INTERPOLATION | LOCF_INTERPOLATION
	//
	//    * LINEAR_INTERPOLATION – Estimates missing data using linear interpolation
	//    (https://en.wikipedia.org/wiki/Linear_interpolation). For example, you
	//    can use this operation to return the interpolated temperature values for
	//    a wind turbine every 24 hours over a duration of 7 days. If the interpolation
	//    starts July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated
	//    value on July 2, 2021, at 9 AM, the second interpolated value on July
	//    3, 2021, at 9 AM, and so on.
	//
	//    * LOCF_INTERPOLATION – Estimates missing data using last observation
	//    carried forward interpolation If no data point is found for an interval,
	//    IoT SiteWise returns the last observed data point for the previous interval
	//    and carries forward this interpolated value until a new data point is
	//    found. For example, you can get the state of an on-off valve every 24
	//    hours over a duration of 7 days. If the interpolation starts July 1, 2021,
	//    at 9 AM, IoT SiteWise returns the last observed data point between July
	//    1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first interpolated value.
	//    If a data point isn't found after 9 AM on July 2, 2021, IoT SiteWise uses
	//    the same interpolated value for the rest of the days.
	//
	// Type is a required field
	Type *string `location:"querystring" locationName:"type" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInterpolatedAssetPropertyValuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInterpolatedAssetPropertyValuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInterpolatedAssetPropertyValuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInterpolatedAssetPropertyValuesInput"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.EndTimeInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTimeInSeconds"))
	}
	if s.EndTimeInSeconds != nil && *s.EndTimeInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EndTimeInSeconds", 1))
	}
	if s.IntervalInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("IntervalInSeconds"))
	}
	if s.IntervalInSeconds != nil && *s.IntervalInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalInSeconds", 1))
	}
	if s.IntervalWindowInSeconds != nil && *s.IntervalWindowInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalWindowInSeconds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}
	if s.Quality == nil {
		invalidParams.Add(request.NewErrParamRequired("Quality"))
	}
	if s.StartTimeInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeInSeconds"))
	}
	if s.StartTimeInSeconds != nil && *s.StartTimeInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("StartTimeInSeconds", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetAssetId(v string) *GetInterpolatedAssetPropertyValuesInput {
	s.AssetId = &v
	return s
}

// SetEndTimeInSeconds sets the EndTimeInSeconds field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetEndTimeInSeconds(v int64) *GetInterpolatedAssetPropertyValuesInput {
	s.EndTimeInSeconds = &v
	return s
}

// SetEndTimeOffsetInNanos sets the EndTimeOffsetInNanos field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetEndTimeOffsetInNanos(v int64) *GetInterpolatedAssetPropertyValuesInput {
	s.EndTimeOffsetInNanos = &v
	return s
}

// SetIntervalInSeconds sets the IntervalInSeconds field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetIntervalInSeconds(v int64) *GetInterpolatedAssetPropertyValuesInput {
	s.IntervalInSeconds = &v
	return s
}

// SetIntervalWindowInSeconds sets the IntervalWindowInSeconds field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetIntervalWindowInSeconds(v int64) *GetInterpolatedAssetPropertyValuesInput {
	s.IntervalWindowInSeconds = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetMaxResults(v int64) *GetInterpolatedAssetPropertyValuesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetNextToken(v string) *GetInterpolatedAssetPropertyValuesInput {
	s.NextToken = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetPropertyAlias(v string) *GetInterpolatedAssetPropertyValuesInput {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetPropertyId(v string) *GetInterpolatedAssetPropertyValuesInput {
	s.PropertyId = &v
	return s
}

// SetQuality sets the Quality field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetQuality(v string) *GetInterpolatedAssetPropertyValuesInput {
	s.Quality = &v
	return s
}

// SetStartTimeInSeconds sets the StartTimeInSeconds field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetStartTimeInSeconds(v int64) *GetInterpolatedAssetPropertyValuesInput {
	s.StartTimeInSeconds = &v
	return s
}

// SetStartTimeOffsetInNanos sets the StartTimeOffsetInNanos field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetStartTimeOffsetInNanos(v int64) *GetInterpolatedAssetPropertyValuesInput {
	s.StartTimeOffsetInNanos = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetInterpolatedAssetPropertyValuesInput) SetType(v string) *GetInterpolatedAssetPropertyValuesInput {
	s.Type = &v
	return s
}

type GetInterpolatedAssetPropertyValuesOutput struct {
	_ struct{} `type:"structure"`

	// The requested interpolated values.
	//
	// InterpolatedAssetPropertyValues is a required field
	InterpolatedAssetPropertyValues []*InterpolatedAssetPropertyValue `locationName:"interpolatedAssetPropertyValues" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInterpolatedAssetPropertyValuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInterpolatedAssetPropertyValuesOutput) GoString() string {
	return s.String()
}

// SetInterpolatedAssetPropertyValues sets the InterpolatedAssetPropertyValues field's value.
func (s *GetInterpolatedAssetPropertyValuesOutput) SetInterpolatedAssetPropertyValues(v []*InterpolatedAssetPropertyValue) *GetInterpolatedAssetPropertyValuesOutput {
	s.InterpolatedAssetPropertyValues = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInterpolatedAssetPropertyValuesOutput) SetNextToken(v string) *GetInterpolatedAssetPropertyValuesOutput {
	s.NextToken = &v
	return s
}

// Contains details for a gateway that runs on IoT Greengrass. To create a gateway
// that runs on IoT Greengrass, you must add the IoT SiteWise connector to a
// Greengrass group and deploy it. Your Greengrass group must also have permissions
// to upload data to IoT SiteWise. For more information, see Ingesting data
// using a gateway (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html)
// in the IoT SiteWise User Guide.
type Greengrass struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Greengrass group. For more information about how to find a group's
	// ARN, see ListGroups (https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html)
	// and GetGroup (https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html)
	// in the IoT Greengrass API Reference.
	//
	// GroupArn is a required field
	GroupArn *string `locationName:"groupArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Greengrass) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Greengrass) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Greengrass) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Greengrass"}
	if s.GroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupArn"))
	}
	if s.GroupArn != nil && len(*s.GroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupArn sets the GroupArn field's value.
func (s *Greengrass) SetGroupArn(v string) *Greengrass {
	s.GroupArn = &v
	return s
}

// Contains details for a gateway that runs on IoT Greengrass V2. To create
// a gateway that runs on IoT Greengrass V2, you must deploy the IoT SiteWise
// Edge component to your gateway device. Your Greengrass device role (https://docs.aws.amazon.com/greengrass/v2/developerguide/device-service-role.html)
// must use the AWSIoTSiteWiseEdgeAccess policy. For more information, see Using
// IoT SiteWise at the edge (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/sw-gateways.html)
// in the IoT SiteWise User Guide.
type GreengrassV2 struct {
	_ struct{} `type:"structure"`

	// The name of the IoT thing for your IoT Greengrass V2 core device.
	//
	// CoreDeviceThingName is a required field
	CoreDeviceThingName *string `locationName:"coreDeviceThingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GreengrassV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GreengrassV2) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GreengrassV2) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GreengrassV2"}
	if s.CoreDeviceThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDeviceThingName"))
	}
	if s.CoreDeviceThingName != nil && len(*s.CoreDeviceThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDeviceThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDeviceThingName sets the CoreDeviceThingName field's value.
func (s *GreengrassV2) SetCoreDeviceThingName(v string) *GreengrassV2 {
	s.CoreDeviceThingName = &v
	return s
}

// Contains information for a group identity in an access policy.
type GroupIdentity struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services SSO ID of the group.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupIdentity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupIdentity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroupIdentity"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GroupIdentity) SetId(v string) *GroupIdentity {
	s.Id = &v
	return s
}

// Contains information about an Identity and Access Management role. For more
// information, see IAM roles (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html)
// in the IAM User Guide.
type IAMRoleIdentity struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role. For more information, see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IAMRoleIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IAMRoleIdentity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IAMRoleIdentity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IAMRoleIdentity"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *IAMRoleIdentity) SetArn(v string) *IAMRoleIdentity {
	s.Arn = &v
	return s
}

// Contains information about an Identity and Access Management user.
type IAMUserIdentity struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM user. For more information, see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	//
	// If you delete the IAM user, access policies that contain this identity include
	// an empty arn. You can delete the access policy for the IAM user that no longer
	// exists.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IAMUserIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IAMUserIdentity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IAMUserIdentity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IAMUserIdentity"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *IAMUserIdentity) SetArn(v string) *IAMUserIdentity {
	s.Arn = &v
	return s
}

// Contains an identity that can access an IoT SiteWise Monitor resource.
//
// Currently, you can't use Amazon Web Services APIs to retrieve Amazon Web
// Services SSO identity IDs. You can find the Amazon Web Services SSO identity
// IDs in the URL of user and group pages in the Amazon Web Services SSO console
// (https://console.aws.amazon.com/singlesignon).
type Identity struct {
	_ struct{} `type:"structure"`

	// An Amazon Web Services SSO group identity.
	Group *GroupIdentity `locationName:"group" type:"structure"`

	// An IAM role identity.
	IamRole *IAMRoleIdentity `locationName:"iamRole" type:"structure"`

	// An IAM user identity.
	IamUser *IAMUserIdentity `locationName:"iamUser" type:"structure"`

	// An Amazon Web Services SSO user identity.
	User *UserIdentity `locationName:"user" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Identity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Identity"}
	if s.Group != nil {
		if err := s.Group.Validate(); err != nil {
			invalidParams.AddNested("Group", err.(request.ErrInvalidParams))
		}
	}
	if s.IamRole != nil {
		if err := s.IamRole.Validate(); err != nil {
			invalidParams.AddNested("IamRole", err.(request.ErrInvalidParams))
		}
	}
	if s.IamUser != nil {
		if err := s.IamUser.Validate(); err != nil {
			invalidParams.AddNested("IamUser", err.(request.ErrInvalidParams))
		}
	}
	if s.User != nil {
		if err := s.User.Validate(); err != nil {
			invalidParams.AddNested("User", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *Identity) SetGroup(v *GroupIdentity) *Identity {
	s.Group = v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *Identity) SetIamRole(v *IAMRoleIdentity) *Identity {
	s.IamRole = v
	return s
}

// SetIamUser sets the IamUser field's value.
func (s *Identity) SetIamUser(v *IAMUserIdentity) *Identity {
	s.IamUser = v
	return s
}

// SetUser sets the User field's value.
func (s *Identity) SetUser(v *UserIdentity) *Identity {
	s.User = v
	return s
}

// Contains an image that is one of the following:
//
//    * An image file. Choose this option to upload a new image.
//
//    * The ID of an existing image. Choose this option to keep an existing
//    image.
type Image struct {
	_ struct{} `type:"structure"`

	// Contains an image file.
	File *ImageFile `locationName:"file" type:"structure"`

	// The ID of an existing image. Specify this parameter to keep an existing image.
	Id *string `locationName:"id" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Image) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Image) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Image"}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *Image) SetFile(v *ImageFile) *Image {
	s.File = v
	return s
}

// SetId sets the Id field's value.
func (s *Image) SetId(v string) *Image {
	s.Id = &v
	return s
}

// Contains an image file.
type ImageFile struct {
	_ struct{} `type:"structure"`

	// The image file contents, represented as a base64-encoded string. The file
	// size must be less than 1 MB.
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" min:"1" type:"blob" required:"true"`

	// The file type of the image.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ImageFileType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageFile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageFile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageFile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImageFile"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.Data != nil && len(s.Data) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Data", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *ImageFile) SetData(v []byte) *ImageFile {
	s.Data = v
	return s
}

// SetType sets the Type field's value.
func (s *ImageFile) SetType(v string) *ImageFile {
	s.Type = &v
	return s
}

// Contains an image that is uploaded to IoT SiteWise and available at a URL.
type ImageLocation struct {
	_ struct{} `type:"structure"`

	// The ID of the image.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The URL where the image is available. The URL is valid for 15 minutes so
	// that you can view and download the image
	//
	// Url is a required field
	Url *string `locationName:"url" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageLocation) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ImageLocation) SetId(v string) *ImageLocation {
	s.Id = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ImageLocation) SetUrl(v string) *ImageLocation {
	s.Url = &v
	return s
}

// IoT SiteWise can't process your request right now. Try again later.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about an interpolated asset property value.
type InterpolatedAssetPropertyValue struct {
	_ struct{} `type:"structure"`

	// Contains a timestamp with optional nanosecond granularity.
	//
	// Timestamp is a required field
	Timestamp *TimeInNanos `locationName:"timestamp" type:"structure" required:"true"`

	// Contains an asset property value (of a single type only).
	//
	// Value is a required field
	Value *Variant `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterpolatedAssetPropertyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterpolatedAssetPropertyValue) GoString() string {
	return s.String()
}

// SetTimestamp sets the Timestamp field's value.
func (s *InterpolatedAssetPropertyValue) SetTimestamp(v *TimeInNanos) *InterpolatedAssetPropertyValue {
	s.Timestamp = v
	return s
}

// SetValue sets the Value field's value.
func (s *InterpolatedAssetPropertyValue) SetValue(v *Variant) *InterpolatedAssetPropertyValue {
	s.Value = v
	return s
}

// The request isn't valid. This can occur if your request contains malformed
// JSON or unsupported characters. Check your request and try again.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You've reached the limit for a resource. For example, this can occur if you're
// trying to associate more than the allowed number of child assets or attempting
// to create more than the allowed number of properties for an asset model.
//
// For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
// in the IoT SiteWise User Guide.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAccessPoliciesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the IAM user. For more information, see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide. This parameter is required if you specify IAM for
	// identityType.
	IamArn *string `location:"querystring" locationName:"iamArn" min:"1" type:"string"`

	// The ID of the identity. This parameter is required if you specify USER or
	// GROUP for identityType.
	IdentityId *string `location:"querystring" locationName:"identityId" min:"1" type:"string"`

	// The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO
	// group, or IAM user). This parameter is required if you specify identityId.
	IdentityType *string `location:"querystring" locationName:"identityType" type:"string" enum:"IdentityType"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 50
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the resource. This parameter is required if you specify resourceType.
	ResourceId *string `location:"querystring" locationName:"resourceId" min:"36" type:"string"`

	// The type of resource (portal or project). This parameter is required if you
	// specify resourceId.
	ResourceType *string `location:"querystring" locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessPoliciesInput"}
	if s.IamArn != nil && len(*s.IamArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IamArn", 1))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIamArn sets the IamArn field's value.
func (s *ListAccessPoliciesInput) SetIamArn(v string) *ListAccessPoliciesInput {
	s.IamArn = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *ListAccessPoliciesInput) SetIdentityId(v string) *ListAccessPoliciesInput {
	s.IdentityId = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *ListAccessPoliciesInput) SetIdentityType(v string) *ListAccessPoliciesInput {
	s.IdentityType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessPoliciesInput) SetMaxResults(v int64) *ListAccessPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPoliciesInput) SetNextToken(v string) *ListAccessPoliciesInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ListAccessPoliciesInput) SetResourceId(v string) *ListAccessPoliciesInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListAccessPoliciesInput) SetResourceType(v string) *ListAccessPoliciesInput {
	s.ResourceType = &v
	return s
}

type ListAccessPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each access policy.
	//
	// AccessPolicySummaries is a required field
	AccessPolicySummaries []*AccessPolicySummary `locationName:"accessPolicySummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesOutput) GoString() string {
	return s.String()
}

// SetAccessPolicySummaries sets the AccessPolicySummaries field's value.
func (s *ListAccessPoliciesOutput) SetAccessPolicySummaries(v []*AccessPolicySummary) *ListAccessPoliciesOutput {
	s.AccessPolicySummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPoliciesOutput) SetNextToken(v string) *ListAccessPoliciesOutput {
	s.NextToken = &v
	return s
}

type ListAssetModelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 50
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssetModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssetModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssetModelsInput) SetMaxResults(v int64) *ListAssetModelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetModelsInput) SetNextToken(v string) *ListAssetModelsInput {
	s.NextToken = &v
	return s
}

type ListAssetModelsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each asset model.
	//
	// AssetModelSummaries is a required field
	AssetModelSummaries []*AssetModelSummary `locationName:"assetModelSummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetModelsOutput) GoString() string {
	return s.String()
}

// SetAssetModelSummaries sets the AssetModelSummaries field's value.
func (s *ListAssetModelsOutput) SetAssetModelSummaries(v []*AssetModelSummary) *ListAssetModelsOutput {
	s.AssetModelSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetModelsOutput) SetNextToken(v string) *ListAssetModelsOutput {
	s.NextToken = &v
	return s
}

type ListAssetRelationshipsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// The maximum number of results to return for each paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The type of traversal to use to identify asset relationships. Choose the
	// following option:
	//
	//    * PATH_TO_ROOT – Identify the asset's parent assets up to the root asset.
	//    The asset that you specify in assetId is the first result in the list
	//    of assetRelationshipSummaries, and the root asset is the last result.
	//
	// TraversalType is a required field
	TraversalType *string `location:"querystring" locationName:"traversalType" type:"string" required:"true" enum:"TraversalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetRelationshipsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetRelationshipsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssetRelationshipsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssetRelationshipsInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TraversalType == nil {
		invalidParams.Add(request.NewErrParamRequired("TraversalType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *ListAssetRelationshipsInput) SetAssetId(v string) *ListAssetRelationshipsInput {
	s.AssetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssetRelationshipsInput) SetMaxResults(v int64) *ListAssetRelationshipsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetRelationshipsInput) SetNextToken(v string) *ListAssetRelationshipsInput {
	s.NextToken = &v
	return s
}

// SetTraversalType sets the TraversalType field's value.
func (s *ListAssetRelationshipsInput) SetTraversalType(v string) *ListAssetRelationshipsInput {
	s.TraversalType = &v
	return s
}

type ListAssetRelationshipsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each asset relationship.
	//
	// AssetRelationshipSummaries is a required field
	AssetRelationshipSummaries []*AssetRelationshipSummary `locationName:"assetRelationshipSummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetRelationshipsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetRelationshipsOutput) GoString() string {
	return s.String()
}

// SetAssetRelationshipSummaries sets the AssetRelationshipSummaries field's value.
func (s *ListAssetRelationshipsOutput) SetAssetRelationshipSummaries(v []*AssetRelationshipSummary) *ListAssetRelationshipsOutput {
	s.AssetRelationshipSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetRelationshipsOutput) SetNextToken(v string) *ListAssetRelationshipsOutput {
	s.NextToken = &v
	return s
}

type ListAssetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset model by which to filter the list of assets. This parameter
	// is required if you choose ALL for filter.
	AssetModelId *string `location:"querystring" locationName:"assetModelId" min:"36" type:"string"`

	// The filter for the requested list of assets. Choose one of the following
	// options:
	//
	//    * ALL – The list includes all assets for a given asset model ID. The
	//    assetModelId parameter is required if you filter by ALL.
	//
	//    * TOP_LEVEL – The list includes only top-level assets in the asset hierarchy
	//    tree.
	//
	// Default: ALL
	Filter *string `location:"querystring" locationName:"filter" type:"string" enum:"ListAssetsFilter"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 50
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssetsInput"}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *ListAssetsInput) SetAssetModelId(v string) *ListAssetsInput {
	s.AssetModelId = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListAssetsInput) SetFilter(v string) *ListAssetsInput {
	s.Filter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssetsInput) SetMaxResults(v int64) *ListAssetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetsInput) SetNextToken(v string) *ListAssetsInput {
	s.NextToken = &v
	return s
}

type ListAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each asset.
	//
	// AssetSummaries is a required field
	AssetSummaries []*AssetSummary `locationName:"assetSummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetsOutput) GoString() string {
	return s.String()
}

// SetAssetSummaries sets the AssetSummaries field's value.
func (s *ListAssetsOutput) SetAssetSummaries(v []*AssetSummary) *ListAssetsOutput {
	s.AssetSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetsOutput) SetNextToken(v string) *ListAssetsOutput {
	s.NextToken = &v
	return s
}

type ListAssociatedAssetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the asset to query.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// The ID of the hierarchy by which child assets are associated to the asset.
	// To find a hierarchy ID, use the DescribeAsset (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html)
	// or DescribeAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html)
	// operations. This parameter is required if you choose CHILD for traversalDirection.
	//
	// For more information, see Asset hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the IoT SiteWise User Guide.
	HierarchyId *string `location:"querystring" locationName:"hierarchyId" min:"36" type:"string"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 50
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The direction to list associated assets. Choose one of the following options:
	//
	//    * CHILD – The list includes all child assets associated to the asset.
	//    The hierarchyId parameter is required if you choose CHILD.
	//
	//    * PARENT – The list includes the asset's parent asset.
	//
	// Default: CHILD
	TraversalDirection *string `location:"querystring" locationName:"traversalDirection" type:"string" enum:"TraversalDirection"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedAssetsInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.HierarchyId != nil && len(*s.HierarchyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchyId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *ListAssociatedAssetsInput) SetAssetId(v string) *ListAssociatedAssetsInput {
	s.AssetId = &v
	return s
}

// SetHierarchyId sets the HierarchyId field's value.
func (s *ListAssociatedAssetsInput) SetHierarchyId(v string) *ListAssociatedAssetsInput {
	s.HierarchyId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssociatedAssetsInput) SetMaxResults(v int64) *ListAssociatedAssetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedAssetsInput) SetNextToken(v string) *ListAssociatedAssetsInput {
	s.NextToken = &v
	return s
}

// SetTraversalDirection sets the TraversalDirection field's value.
func (s *ListAssociatedAssetsInput) SetTraversalDirection(v string) *ListAssociatedAssetsInput {
	s.TraversalDirection = &v
	return s
}

type ListAssociatedAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes the associated assets.
	//
	// AssetSummaries is a required field
	AssetSummaries []*AssociatedAssetsSummary `locationName:"assetSummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAssetsOutput) GoString() string {
	return s.String()
}

// SetAssetSummaries sets the AssetSummaries field's value.
func (s *ListAssociatedAssetsOutput) SetAssetSummaries(v []*AssociatedAssetsSummary) *ListAssociatedAssetsOutput {
	s.AssetSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedAssetsOutput) SetNextToken(v string) *ListAssociatedAssetsOutput {
	s.NextToken = &v
	return s
}

type ListDashboardsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 50
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `location:"querystring" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDashboardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDashboardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDashboardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDashboardsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDashboardsInput) SetMaxResults(v int64) *ListDashboardsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardsInput) SetNextToken(v string) *ListDashboardsInput {
	s.NextToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ListDashboardsInput) SetProjectId(v string) *ListDashboardsInput {
	s.ProjectId = &v
	return s
}

type ListDashboardsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each dashboard in the project.
	//
	// DashboardSummaries is a required field
	DashboardSummaries []*DashboardSummary `locationName:"dashboardSummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDashboardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDashboardsOutput) GoString() string {
	return s.String()
}

// SetDashboardSummaries sets the DashboardSummaries field's value.
func (s *ListDashboardsOutput) SetDashboardSummaries(v []*DashboardSummary) *ListDashboardsOutput {
	s.DashboardSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardsOutput) SetNextToken(v string) *ListDashboardsOutput {
	s.NextToken = &v
	return s
}

type ListGatewaysInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 50
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewaysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGatewaysInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGatewaysInput) SetMaxResults(v int64) *ListGatewaysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewaysInput) SetNextToken(v string) *ListGatewaysInput {
	s.NextToken = &v
	return s
}

type ListGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each gateway.
	//
	// GatewaySummaries is a required field
	GatewaySummaries []*GatewaySummary `locationName:"gatewaySummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysOutput) GoString() string {
	return s.String()
}

// SetGatewaySummaries sets the GatewaySummaries field's value.
func (s *ListGatewaysOutput) SetGatewaySummaries(v []*GatewaySummary) *ListGatewaysOutput {
	s.GatewaySummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewaysOutput) SetNextToken(v string) *ListGatewaysOutput {
	s.NextToken = &v
	return s
}

type ListPortalsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 50
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPortalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPortalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPortalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPortalsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPortalsInput) SetMaxResults(v int64) *ListPortalsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPortalsInput) SetNextToken(v string) *ListPortalsInput {
	s.NextToken = &v
	return s
}

type ListPortalsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list that summarizes each portal.
	PortalSummaries []*PortalSummary `locationName:"portalSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPortalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPortalsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPortalsOutput) SetNextToken(v string) *ListPortalsOutput {
	s.NextToken = &v
	return s
}

// SetPortalSummaries sets the PortalSummaries field's value.
func (s *ListPortalsOutput) SetPortalSummaries(v []*PortalSummary) *ListPortalsOutput {
	s.PortalSummaries = v
	return s
}

type ListProjectAssetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 50
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectAssetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectAssetsInput) SetMaxResults(v int64) *ListProjectAssetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectAssetsInput) SetNextToken(v string) *ListProjectAssetsInput {
	s.NextToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ListProjectAssetsInput) SetProjectId(v string) *ListProjectAssetsInput {
	s.ProjectId = &v
	return s
}

type ListProjectAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the IDs of each asset associated with the project.
	//
	// AssetIds is a required field
	AssetIds []*string `locationName:"assetIds" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectAssetsOutput) GoString() string {
	return s.String()
}

// SetAssetIds sets the AssetIds field's value.
func (s *ListProjectAssetsOutput) SetAssetIds(v []*string) *ListProjectAssetsOutput {
	s.AssetIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectAssetsOutput) SetNextToken(v string) *ListProjectAssetsOutput {
	s.NextToken = &v
	return s
}

type ListProjectsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for each paginated request.
	//
	// Default: 50
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the portal.
	//
	// PortalId is a required field
	PortalId *string `location:"querystring" locationName:"portalId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PortalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PortalId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectsInput) SetMaxResults(v int64) *ListProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *ListProjectsInput) SetPortalId(v string) *ListProjectsInput {
	s.PortalId = &v
	return s
}

type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list that summarizes each project in the portal.
	//
	// ProjectSummaries is a required field
	ProjectSummaries []*ProjectSummary `locationName:"projectSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjectSummaries sets the ProjectSummaries field's value.
func (s *ListProjectsOutput) SetProjectSummaries(v []*ProjectSummary) *ListProjectsOutput {
	s.ProjectSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of key-value pairs that contain metadata for the resource. For more
	// information, see Tagging your IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTimeSeriesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias prefix of the time series.
	AliasPrefix *string `location:"querystring" locationName:"aliasPrefix" min:"1" type:"string"`

	// The ID of the asset in which the asset property was created.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The maximum number of results to return for each paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The type of the time series. The time series type can be one of the following
	// values:
	//
	//    * ASSOCIATED – The time series is associated with an asset property.
	//
	//    * DISASSOCIATED – The time series isn't associated with any asset property.
	TimeSeriesType *string `location:"querystring" locationName:"timeSeriesType" type:"string" enum:"ListTimeSeriesType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTimeSeriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTimeSeriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTimeSeriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTimeSeriesInput"}
	if s.AliasPrefix != nil && len(*s.AliasPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasPrefix", 1))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasPrefix sets the AliasPrefix field's value.
func (s *ListTimeSeriesInput) SetAliasPrefix(v string) *ListTimeSeriesInput {
	s.AliasPrefix = &v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *ListTimeSeriesInput) SetAssetId(v string) *ListTimeSeriesInput {
	s.AssetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTimeSeriesInput) SetMaxResults(v int64) *ListTimeSeriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTimeSeriesInput) SetNextToken(v string) *ListTimeSeriesInput {
	s.NextToken = &v
	return s
}

// SetTimeSeriesType sets the TimeSeriesType field's value.
func (s *ListTimeSeriesInput) SetTimeSeriesType(v string) *ListTimeSeriesInput {
	s.TimeSeriesType = &v
	return s
}

type ListTimeSeriesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// One or more time series summaries to list.
	//
	// TimeSeriesSummaries is a required field
	TimeSeriesSummaries []*TimeSeriesSummary `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTimeSeriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTimeSeriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTimeSeriesOutput) SetNextToken(v string) *ListTimeSeriesOutput {
	s.NextToken = &v
	return s
}

// SetTimeSeriesSummaries sets the TimeSeriesSummaries field's value.
func (s *ListTimeSeriesOutput) SetTimeSeriesSummaries(v []*TimeSeriesSummary) *ListTimeSeriesOutput {
	s.TimeSeriesSummaries = v
	return s
}

// Contains logging options.
type LoggingOptions struct {
	_ struct{} `type:"structure"`

	// The IoT SiteWise logging verbosity level.
	//
	// Level is a required field
	Level *string `locationName:"level" type:"string" required:"true" enum:"LoggingLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingOptions"}
	if s.Level == nil {
		invalidParams.Add(request.NewErrParamRequired("Level"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLevel sets the Level field's value.
func (s *LoggingOptions) SetLevel(v string) *LoggingOptions {
	s.Level = &v
	return s
}

// Contains an asset measurement property. For more information, see Measurements
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#measurements)
// in the IoT SiteWise User Guide.
type Measurement struct {
	_ struct{} `type:"structure"`

	// The processing configuration for the given measurement property. You can
	// configure measurements to be kept at the edge or forwarded to the Amazon
	// Web Services Cloud. By default, measurements are forwarded to the cloud.
	ProcessingConfig *MeasurementProcessingConfig `locationName:"processingConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Measurement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Measurement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Measurement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Measurement"}
	if s.ProcessingConfig != nil {
		if err := s.ProcessingConfig.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProcessingConfig sets the ProcessingConfig field's value.
func (s *Measurement) SetProcessingConfig(v *MeasurementProcessingConfig) *Measurement {
	s.ProcessingConfig = v
	return s
}

// The processing configuration for the given measurement property. You can
// configure measurements to be kept at the edge or forwarded to the Amazon
// Web Services Cloud. By default, measurements are forwarded to the cloud.
type MeasurementProcessingConfig struct {
	_ struct{} `type:"structure"`

	// The forwarding configuration for the given measurement property.
	//
	// ForwardingConfig is a required field
	ForwardingConfig *ForwardingConfig `locationName:"forwardingConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeasurementProcessingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeasurementProcessingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeasurementProcessingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MeasurementProcessingConfig"}
	if s.ForwardingConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ForwardingConfig"))
	}
	if s.ForwardingConfig != nil {
		if err := s.ForwardingConfig.Validate(); err != nil {
			invalidParams.AddNested("ForwardingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForwardingConfig sets the ForwardingConfig field's value.
func (s *MeasurementProcessingConfig) SetForwardingConfig(v *ForwardingConfig) *MeasurementProcessingConfig {
	s.ForwardingConfig = v
	return s
}

// Contains an asset metric property. With metrics, you can calculate aggregate
// functions, such as an average, maximum, or minimum, as specified through
// an expression. A metric maps several values to a single value (such as a
// sum).
//
// The maximum number of dependent/cascading variables used in any one metric
// calculation is 10. Therefore, a root metric can have up to 10 cascading metrics
// in its computational dependency tree. Additionally, a metric can only have
// a data type of DOUBLE and consume properties with data types of INTEGER or
// DOUBLE.
//
// For more information, see Metrics (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#metrics)
// in the IoT SiteWise User Guide.
type Metric struct {
	_ struct{} `type:"structure"`

	// The mathematical expression that defines the metric aggregation function.
	// You can specify up to 10 variables per expression. You can specify up to
	// 10 functions per expression.
	//
	// For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the IoT SiteWise User Guide.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The processing configuration for the given metric property. You can configure
	// metrics to be computed at the edge or in the Amazon Web Services Cloud. By
	// default, metrics are forwarded to the cloud.
	ProcessingConfig *MetricProcessingConfig `locationName:"processingConfig" type:"structure"`

	// The list of variables used in the expression.
	//
	// Variables is a required field
	Variables []*ExpressionVariable `locationName:"variables" type:"list" required:"true"`

	// The window (time interval) over which IoT SiteWise computes the metric's
	// aggregation expression. IoT SiteWise computes one data point per window.
	//
	// Window is a required field
	Window *MetricWindow `locationName:"window" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Metric"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Variables == nil {
		invalidParams.Add(request.NewErrParamRequired("Variables"))
	}
	if s.Window == nil {
		invalidParams.Add(request.NewErrParamRequired("Window"))
	}
	if s.ProcessingConfig != nil {
		if err := s.ProcessingConfig.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Window != nil {
		if err := s.Window.Validate(); err != nil {
			invalidParams.AddNested("Window", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *Metric) SetExpression(v string) *Metric {
	s.Expression = &v
	return s
}

// SetProcessingConfig sets the ProcessingConfig field's value.
func (s *Metric) SetProcessingConfig(v *MetricProcessingConfig) *Metric {
	s.ProcessingConfig = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *Metric) SetVariables(v []*ExpressionVariable) *Metric {
	s.Variables = v
	return s
}

// SetWindow sets the Window field's value.
func (s *Metric) SetWindow(v *MetricWindow) *Metric {
	s.Window = v
	return s
}

// The processing configuration for the given metric property. You can configure
// metrics to be computed at the edge or in the Amazon Web Services Cloud. By
// default, metrics are forwarded to the cloud.
type MetricProcessingConfig struct {
	_ struct{} `type:"structure"`

	// The compute location for the given metric property.
	//
	// ComputeLocation is a required field
	ComputeLocation *string `locationName:"computeLocation" type:"string" required:"true" enum:"ComputeLocation"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricProcessingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricProcessingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricProcessingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricProcessingConfig"}
	if s.ComputeLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeLocation"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeLocation sets the ComputeLocation field's value.
func (s *MetricProcessingConfig) SetComputeLocation(v string) *MetricProcessingConfig {
	s.ComputeLocation = &v
	return s
}

// Contains a time interval window used for data aggregate computations (for
// example, average, sum, count, and so on).
type MetricWindow struct {
	_ struct{} `type:"structure"`

	// The tumbling time interval window.
	Tumbling *TumblingWindow `locationName:"tumbling" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricWindow) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricWindow) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricWindow"}
	if s.Tumbling != nil {
		if err := s.Tumbling.Validate(); err != nil {
			invalidParams.AddNested("Tumbling", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTumbling sets the Tumbling field's value.
func (s *MetricWindow) SetTumbling(v *TumblingWindow) *MetricWindow {
	s.Tumbling = v
	return s
}

// Contains IoT SiteWise Monitor error details.
type MonitorErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string" enum:"MonitorErrorCode"`

	// The error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitorErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitorErrorDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *MonitorErrorDetails) SetCode(v string) *MonitorErrorDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *MonitorErrorDetails) SetMessage(v string) *MonitorErrorDetails {
	s.Message = &v
	return s
}

// Contains information about the storage destination.
type MultiLayerStorage struct {
	_ struct{} `type:"structure"`

	// Contains information about a customer managed Amazon S3 bucket.
	//
	// CustomerManagedS3Storage is a required field
	CustomerManagedS3Storage *CustomerManagedS3Storage `locationName:"customerManagedS3Storage" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiLayerStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiLayerStorage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiLayerStorage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiLayerStorage"}
	if s.CustomerManagedS3Storage == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerManagedS3Storage"))
	}
	if s.CustomerManagedS3Storage != nil {
		if err := s.CustomerManagedS3Storage.Validate(); err != nil {
			invalidParams.AddNested("CustomerManagedS3Storage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerManagedS3Storage sets the CustomerManagedS3Storage field's value.
func (s *MultiLayerStorage) SetCustomerManagedS3Storage(v *CustomerManagedS3Storage) *MultiLayerStorage {
	s.CustomerManagedS3Storage = v
	return s
}

// Identifies an IoT SiteWise Monitor portal.
type PortalResource struct {
	_ struct{} `type:"structure"`

	// The ID of the portal.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortalResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortalResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortalResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortalResource"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *PortalResource) SetId(v string) *PortalResource {
	s.Id = &v
	return s
}

// Contains information about the current status of a portal.
type PortalStatus struct {
	_ struct{} `type:"structure"`

	// Contains associated error information, if any.
	Error *MonitorErrorDetails `locationName:"error" type:"structure"`

	// The current state of the portal.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"PortalState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortalStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortalStatus) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *PortalStatus) SetError(v *MonitorErrorDetails) *PortalStatus {
	s.Error = v
	return s
}

// SetState sets the State field's value.
func (s *PortalStatus) SetState(v string) *PortalStatus {
	s.State = &v
	return s
}

// Contains a portal summary.
type PortalSummary struct {
	_ struct{} `type:"structure"`

	// The date the portal was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The portal's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the portal.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the portal was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The name of the portal.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the service role that allows the portal's users to access your IoT SiteWise
	// resources on your behalf. For more information, see Using service roles for
	// IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the IoT SiteWise User Guide.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The URL for the IoT SiteWise Monitor portal. You can use this URL to access
	// portals that use Amazon Web Services SSO for authentication. For portals
	// that use IAM for authentication, you must use the IoT SiteWise console to
	// get a URL that you can use to access the portal.
	//
	// StartUrl is a required field
	StartUrl *string `locationName:"startUrl" min:"1" type:"string" required:"true"`

	// Contains information about the current status of a portal.
	//
	// Status is a required field
	Status *PortalStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortalSummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *PortalSummary) SetCreationDate(v time.Time) *PortalSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PortalSummary) SetDescription(v string) *PortalSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *PortalSummary) SetId(v string) *PortalSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *PortalSummary) SetLastUpdateDate(v time.Time) *PortalSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *PortalSummary) SetName(v string) *PortalSummary {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PortalSummary) SetRoleArn(v string) *PortalSummary {
	s.RoleArn = &v
	return s
}

// SetStartUrl sets the StartUrl field's value.
func (s *PortalSummary) SetStartUrl(v string) *PortalSummary {
	s.StartUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PortalSummary) SetStatus(v *PortalStatus) *PortalSummary {
	s.Status = v
	return s
}

// Identifies a specific IoT SiteWise Monitor project.
type ProjectResource struct {
	_ struct{} `type:"structure"`

	// The ID of the project.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectResource"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ProjectResource) SetId(v string) *ProjectResource {
	s.Id = &v
	return s
}

// Contains project summary information.
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// The date the project was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The project's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the project.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the project was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The name of the project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectSummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *ProjectSummary) SetCreationDate(v time.Time) *ProjectSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ProjectSummary) SetDescription(v string) *ProjectSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProjectSummary) SetId(v string) *ProjectSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *ProjectSummary) SetLastUpdateDate(v time.Time) *ProjectSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProjectSummary) SetName(v string) *ProjectSummary {
	s.Name = &v
	return s
}

// Contains asset property information.
type Property struct {
	_ struct{} `type:"structure"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The property data type.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"PropertyDataType"`

	// The ID of the asset property.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The asset property's notification topic and state. For more information,
	// see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
	Notification *PropertyNotification `locationName:"notification" type:"structure"`

	// The property type (see PropertyType). A property contains one type.
	Type *PropertyType `locationName:"type" type:"structure"`

	// The unit (such as Newtons or RPM) of the asset property.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Property) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Property) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *Property) SetAlias(v string) *Property {
	s.Alias = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Property) SetDataType(v string) *Property {
	s.DataType = &v
	return s
}

// SetId sets the Id field's value.
func (s *Property) SetId(v string) *Property {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Property) SetName(v string) *Property {
	s.Name = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *Property) SetNotification(v *PropertyNotification) *Property {
	s.Notification = v
	return s
}

// SetType sets the Type field's value.
func (s *Property) SetType(v *PropertyType) *Property {
	s.Type = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Property) SetUnit(v string) *Property {
	s.Unit = &v
	return s
}

// Contains asset property value notification information. When the notification
// state is enabled, IoT SiteWise publishes property value updates to a unique
// MQTT topic. For more information, see Interacting with other services (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html)
// in the IoT SiteWise User Guide.
type PropertyNotification struct {
	_ struct{} `type:"structure"`

	// The current notification state.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"PropertyNotificationState"`

	// The MQTT topic to which IoT SiteWise publishes property value update notifications.
	//
	// Topic is a required field
	Topic *string `locationName:"topic" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyNotification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyNotification) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *PropertyNotification) SetState(v string) *PropertyNotification {
	s.State = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *PropertyNotification) SetTopic(v string) *PropertyNotification {
	s.Topic = &v
	return s
}

// Contains a property type, which can be one of attribute, measurement, metric,
// or transform.
type PropertyType struct {
	_ struct{} `type:"structure"`

	// Specifies an asset attribute property. An attribute generally contains static
	// information, such as the serial number of an IIoT (https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications)
	// wind turbine.
	Attribute *Attribute `locationName:"attribute" type:"structure"`

	// Specifies an asset measurement property. A measurement represents a device's
	// raw sensor data stream, such as timestamped temperature values or timestamped
	// power values.
	Measurement *Measurement `locationName:"measurement" type:"structure"`

	// Specifies an asset metric property. A metric contains a mathematical expression
	// that uses aggregate functions to process all input data points over a time
	// interval and output a single data point, such as to calculate the average
	// hourly temperature.
	Metric *Metric `locationName:"metric" type:"structure"`

	// Specifies an asset transform property. A transform contains a mathematical
	// expression that maps a property's data points from one form to another, such
	// as a unit conversion from Celsius to Fahrenheit.
	Transform *Transform `locationName:"transform" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PropertyType"}
	if s.Attribute != nil {
		if err := s.Attribute.Validate(); err != nil {
			invalidParams.AddNested("Attribute", err.(request.ErrInvalidParams))
		}
	}
	if s.Measurement != nil {
		if err := s.Measurement.Validate(); err != nil {
			invalidParams.AddNested("Measurement", err.(request.ErrInvalidParams))
		}
	}
	if s.Metric != nil {
		if err := s.Metric.Validate(); err != nil {
			invalidParams.AddNested("Metric", err.(request.ErrInvalidParams))
		}
	}
	if s.Transform != nil {
		if err := s.Transform.Validate(); err != nil {
			invalidParams.AddNested("Transform", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *PropertyType) SetAttribute(v *Attribute) *PropertyType {
	s.Attribute = v
	return s
}

// SetMeasurement sets the Measurement field's value.
func (s *PropertyType) SetMeasurement(v *Measurement) *PropertyType {
	s.Measurement = v
	return s
}

// SetMetric sets the Metric field's value.
func (s *PropertyType) SetMetric(v *Metric) *PropertyType {
	s.Metric = v
	return s
}

// SetTransform sets the Transform field's value.
func (s *PropertyType) SetTransform(v *Transform) *PropertyType {
	s.Transform = v
	return s
}

// Contains a list of value updates for an asset property in the list of asset
// entries consumed by the BatchPutAssetPropertyValue (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html)
// API operation.
type PutAssetPropertyValueEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the asset to update.
	AssetId *string `locationName:"assetId" min:"36" type:"string"`

	// The user specified ID for the entry. You can use this ID to identify which
	// entries failed.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	PropertyAlias *string `locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property for this entry.
	PropertyId *string `locationName:"propertyId" min:"36" type:"string"`

	// The list of property values to upload. You can specify up to 10 propertyValues
	// array elements.
	//
	// PropertyValues is a required field
	PropertyValues []*AssetPropertyValue `locationName:"propertyValues" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAssetPropertyValueEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAssetPropertyValueEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAssetPropertyValueEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAssetPropertyValueEntry"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.EntryId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntryId"))
	}
	if s.EntryId != nil && len(*s.EntryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntryId", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}
	if s.PropertyValues == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyValues"))
	}
	if s.PropertyValues != nil {
		for i, v := range s.PropertyValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *PutAssetPropertyValueEntry) SetAssetId(v string) *PutAssetPropertyValueEntry {
	s.AssetId = &v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *PutAssetPropertyValueEntry) SetEntryId(v string) *PutAssetPropertyValueEntry {
	s.EntryId = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *PutAssetPropertyValueEntry) SetPropertyAlias(v string) *PutAssetPropertyValueEntry {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *PutAssetPropertyValueEntry) SetPropertyId(v string) *PutAssetPropertyValueEntry {
	s.PropertyId = &v
	return s
}

// SetPropertyValues sets the PropertyValues field's value.
func (s *PutAssetPropertyValueEntry) SetPropertyValues(v []*AssetPropertyValue) *PutAssetPropertyValueEntry {
	s.PropertyValues = v
	return s
}

type PutDefaultEncryptionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The type of encryption used for the encryption configuration.
	//
	// EncryptionType is a required field
	EncryptionType *string `locationName:"encryptionType" type:"string" required:"true" enum:"EncryptionType"`

	// The Key ID of the customer managed key used for KMS encryption. This is required
	// if you use KMS_BASED_ENCRYPTION.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDefaultEncryptionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDefaultEncryptionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDefaultEncryptionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDefaultEncryptionConfigurationInput"}
	if s.EncryptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionType"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *PutDefaultEncryptionConfigurationInput) SetEncryptionType(v string) *PutDefaultEncryptionConfigurationInput {
	s.EncryptionType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *PutDefaultEncryptionConfigurationInput) SetKmsKeyId(v string) *PutDefaultEncryptionConfigurationInput {
	s.KmsKeyId = &v
	return s
}

type PutDefaultEncryptionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The status of the account configuration. This contains the ConfigurationState.
	// If there is an error, it also contains the ErrorDetails.
	//
	// ConfigurationStatus is a required field
	ConfigurationStatus *ConfigurationStatus `locationName:"configurationStatus" type:"structure" required:"true"`

	// The type of encryption used for the encryption configuration.
	//
	// EncryptionType is a required field
	EncryptionType *string `locationName:"encryptionType" type:"string" required:"true" enum:"EncryptionType"`

	// The Key ARN of the KMS key used for KMS encryption if you use KMS_BASED_ENCRYPTION.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDefaultEncryptionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDefaultEncryptionConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfigurationStatus sets the ConfigurationStatus field's value.
func (s *PutDefaultEncryptionConfigurationOutput) SetConfigurationStatus(v *ConfigurationStatus) *PutDefaultEncryptionConfigurationOutput {
	s.ConfigurationStatus = v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *PutDefaultEncryptionConfigurationOutput) SetEncryptionType(v string) *PutDefaultEncryptionConfigurationOutput {
	s.EncryptionType = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *PutDefaultEncryptionConfigurationOutput) SetKmsKeyArn(v string) *PutDefaultEncryptionConfigurationOutput {
	s.KmsKeyArn = &v
	return s
}

type PutLoggingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The logging options to set.
	//
	// LoggingOptions is a required field
	LoggingOptions *LoggingOptions `locationName:"loggingOptions" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLoggingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLoggingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLoggingOptionsInput"}
	if s.LoggingOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingOptions"))
	}
	if s.LoggingOptions != nil {
		if err := s.LoggingOptions.Validate(); err != nil {
			invalidParams.AddNested("LoggingOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingOptions sets the LoggingOptions field's value.
func (s *PutLoggingOptionsInput) SetLoggingOptions(v *LoggingOptions) *PutLoggingOptionsInput {
	s.LoggingOptions = v
	return s
}

type PutLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLoggingOptionsOutput) GoString() string {
	return s.String()
}

type PutStorageConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Contains the storage configuration for time series (data streams) that aren't
	// associated with asset properties. The disassociatedDataStorage can be one
	// of the following values:
	//
	//    * ENABLED – IoT SiteWise accepts time series that aren't associated
	//    with asset properties. After the disassociatedDataStorage is enabled,
	//    you can't disable it.
	//
	//    * DISABLED – IoT SiteWise doesn't accept time series (data streams)
	//    that aren't associated with asset properties.
	//
	// For more information, see Data streams (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html)
	// in the IoT SiteWise User Guide.
	DisassociatedDataStorage *string `locationName:"disassociatedDataStorage" type:"string" enum:"DisassociatedDataStorageState"`

	// Identifies a storage destination. If you specified MULTI_LAYER_STORAGE for
	// the storage type, you must specify a MultiLayerStorage object.
	MultiLayerStorage *MultiLayerStorage `locationName:"multiLayerStorage" type:"structure"`

	// How many days your data is kept in the hot tier. By default, your data is
	// kept indefinitely in the hot tier.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// The storage tier that you specified for your data. The storageType parameter
	// can be one of the following values:
	//
	//    * SITEWISE_DEFAULT_STORAGE – IoT SiteWise saves your data into the hot
	//    tier. The hot tier is a service-managed database.
	//
	//    * MULTI_LAYER_STORAGE – IoT SiteWise saves your data in both the cold
	//    tier and the cold tier. The cold tier is a customer-managed Amazon S3
	//    bucket.
	//
	// StorageType is a required field
	StorageType *string `locationName:"storageType" type:"string" required:"true" enum:"StorageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutStorageConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutStorageConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutStorageConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutStorageConfigurationInput"}
	if s.StorageType == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageType"))
	}
	if s.MultiLayerStorage != nil {
		if err := s.MultiLayerStorage.Validate(); err != nil {
			invalidParams.AddNested("MultiLayerStorage", err.(request.ErrInvalidParams))
		}
	}
	if s.RetentionPeriod != nil {
		if err := s.RetentionPeriod.Validate(); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisassociatedDataStorage sets the DisassociatedDataStorage field's value.
func (s *PutStorageConfigurationInput) SetDisassociatedDataStorage(v string) *PutStorageConfigurationInput {
	s.DisassociatedDataStorage = &v
	return s
}

// SetMultiLayerStorage sets the MultiLayerStorage field's value.
func (s *PutStorageConfigurationInput) SetMultiLayerStorage(v *MultiLayerStorage) *PutStorageConfigurationInput {
	s.MultiLayerStorage = v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *PutStorageConfigurationInput) SetRetentionPeriod(v *RetentionPeriod) *PutStorageConfigurationInput {
	s.RetentionPeriod = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *PutStorageConfigurationInput) SetStorageType(v string) *PutStorageConfigurationInput {
	s.StorageType = &v
	return s
}

type PutStorageConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Contains current status information for the configuration.
	//
	// ConfigurationStatus is a required field
	ConfigurationStatus *ConfigurationStatus `locationName:"configurationStatus" type:"structure" required:"true"`

	// Contains the storage configuration for time series (data streams) that aren't
	// associated with asset properties. The disassociatedDataStorage can be one
	// of the following values:
	//
	//    * ENABLED – IoT SiteWise accepts time series that aren't associated
	//    with asset properties. After the disassociatedDataStorage is enabled,
	//    you can't disable it.
	//
	//    * DISABLED – IoT SiteWise doesn't accept time series (data streams)
	//    that aren't associated with asset properties.
	//
	// For more information, see Data streams (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html)
	// in the IoT SiteWise User Guide.
	DisassociatedDataStorage *string `locationName:"disassociatedDataStorage" type:"string" enum:"DisassociatedDataStorageState"`

	// Contains information about the storage destination.
	MultiLayerStorage *MultiLayerStorage `locationName:"multiLayerStorage" type:"structure"`

	// How many days your data is kept in the hot tier. By default, your data is
	// kept indefinitely in the hot tier.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// The storage tier that you specified for your data. The storageType parameter
	// can be one of the following values:
	//
	//    * SITEWISE_DEFAULT_STORAGE – IoT SiteWise saves your data into the hot
	//    tier. The hot tier is a service-managed database.
	//
	//    * MULTI_LAYER_STORAGE – IoT SiteWise saves your data in both the cold
	//    tier and the cold tier. The cold tier is a customer-managed Amazon S3
	//    bucket.
	//
	// StorageType is a required field
	StorageType *string `locationName:"storageType" type:"string" required:"true" enum:"StorageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutStorageConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutStorageConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfigurationStatus sets the ConfigurationStatus field's value.
func (s *PutStorageConfigurationOutput) SetConfigurationStatus(v *ConfigurationStatus) *PutStorageConfigurationOutput {
	s.ConfigurationStatus = v
	return s
}

// SetDisassociatedDataStorage sets the DisassociatedDataStorage field's value.
func (s *PutStorageConfigurationOutput) SetDisassociatedDataStorage(v string) *PutStorageConfigurationOutput {
	s.DisassociatedDataStorage = &v
	return s
}

// SetMultiLayerStorage sets the MultiLayerStorage field's value.
func (s *PutStorageConfigurationOutput) SetMultiLayerStorage(v *MultiLayerStorage) *PutStorageConfigurationOutput {
	s.MultiLayerStorage = v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *PutStorageConfigurationOutput) SetRetentionPeriod(v *RetentionPeriod) *PutStorageConfigurationOutput {
	s.RetentionPeriod = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *PutStorageConfigurationOutput) SetStorageType(v string) *PutStorageConfigurationOutput {
	s.StorageType = &v
	return s
}

// Contains an IoT SiteWise Monitor resource ID for a portal or project.
type Resource struct {
	_ struct{} `type:"structure"`

	// A portal resource.
	Portal *PortalResource `locationName:"portal" type:"structure"`

	// A project resource.
	Project *ProjectResource `locationName:"project" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Resource"}
	if s.Portal != nil {
		if err := s.Portal.Validate(); err != nil {
			invalidParams.AddNested("Portal", err.(request.ErrInvalidParams))
		}
	}
	if s.Project != nil {
		if err := s.Project.Validate(); err != nil {
			invalidParams.AddNested("Project", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortal sets the Portal field's value.
func (s *Resource) SetPortal(v *PortalResource) *Resource {
	s.Portal = v
	return s
}

// SetProject sets the Project field's value.
func (s *Resource) SetProject(v *ProjectResource) *Resource {
	s.Project = v
	return s
}

// The resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ARN of the resource that already exists.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The ID of the resource that already exists.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource can't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// How many days your data is kept in the hot tier. By default, your data is
// kept indefinitely in the hot tier.
type RetentionPeriod struct {
	_ struct{} `type:"structure"`

	// The number of days that your data is kept.
	//
	// If you specified a value for this parameter, the unlimited parameter must
	// be false.
	NumberOfDays *int64 `locationName:"numberOfDays" min:"30" type:"integer"`

	// If true, your data is kept indefinitely.
	//
	// If configured to true, you must not specify a value for the numberOfDays
	// parameter.
	Unlimited *bool `locationName:"unlimited" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetentionPeriod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetentionPeriod) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetentionPeriod) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetentionPeriod"}
	if s.NumberOfDays != nil && *s.NumberOfDays < 30 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfDays", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNumberOfDays sets the NumberOfDays field's value.
func (s *RetentionPeriod) SetNumberOfDays(v int64) *RetentionPeriod {
	s.NumberOfDays = &v
	return s
}

// SetUnlimited sets the Unlimited field's value.
func (s *RetentionPeriod) SetUnlimited(v bool) *RetentionPeriod {
	s.Unlimited = &v
	return s
}

// The requested service is unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tagging your IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the IoT SiteWise User Guide.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Your request exceeded a rate limit. For example, you might have exceeded
// the number of IoT SiteWise assets that can be created per second, the allowed
// number of messages per second, and so on.
//
// For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
// in the IoT SiteWise User Guide.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a timestamp with optional nanosecond granularity.
type TimeInNanos struct {
	_ struct{} `type:"structure"`

	// The nanosecond offset from timeInSeconds.
	OffsetInNanos *int64 `locationName:"offsetInNanos" type:"integer"`

	// The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond
	// data is provided by offsetInNanos.
	//
	// TimeInSeconds is a required field
	TimeInSeconds *int64 `locationName:"timeInSeconds" min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeInNanos) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeInNanos) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeInNanos) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeInNanos"}
	if s.TimeInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeInSeconds"))
	}
	if s.TimeInSeconds != nil && *s.TimeInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TimeInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOffsetInNanos sets the OffsetInNanos field's value.
func (s *TimeInNanos) SetOffsetInNanos(v int64) *TimeInNanos {
	s.OffsetInNanos = &v
	return s
}

// SetTimeInSeconds sets the TimeInSeconds field's value.
func (s *TimeInNanos) SetTimeInSeconds(v int64) *TimeInNanos {
	s.TimeInSeconds = &v
	return s
}

// Contains a summary of a time series (data stream).
type TimeSeriesSummary struct {
	_ struct{} `type:"structure"`

	// The alias that identifies the time series.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The ID of the asset in which the asset property was created.
	AssetId *string `locationName:"assetId" min:"36" type:"string"`

	// The data type of the time series.
	//
	// If you specify STRUCT, you must also specify dataTypeSpec to identify the
	// type of the structure for this time series.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"PropertyDataType"`

	// The data type of the structure for this time series. This parameter is required
	// for time series that have the STRUCT data type.
	//
	// The options for this parameter depend on the type of the composite model
	// in which you created the asset property that is associated with your time
	// series. Use AWS/ALARM_STATE for alarm state in alarm composite models.
	DataTypeSpec *string `locationName:"dataTypeSpec" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `locationName:"propertyId" min:"36" type:"string"`

	// The date that the time series was created, in Unix epoch time.
	//
	// TimeSeriesCreationDate is a required field
	TimeSeriesCreationDate *time.Time `locationName:"timeSeriesCreationDate" type:"timestamp" required:"true"`

	// The ID of the time series.
	//
	// TimeSeriesId is a required field
	TimeSeriesId *string `locationName:"timeSeriesId" min:"36" type:"string" required:"true"`

	// The date that the time series was last updated, in Unix epoch time.
	//
	// TimeSeriesLastUpdateDate is a required field
	TimeSeriesLastUpdateDate *time.Time `locationName:"timeSeriesLastUpdateDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSeriesSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSeriesSummary) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *TimeSeriesSummary) SetAlias(v string) *TimeSeriesSummary {
	s.Alias = &v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *TimeSeriesSummary) SetAssetId(v string) *TimeSeriesSummary {
	s.AssetId = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *TimeSeriesSummary) SetDataType(v string) *TimeSeriesSummary {
	s.DataType = &v
	return s
}

// SetDataTypeSpec sets the DataTypeSpec field's value.
func (s *TimeSeriesSummary) SetDataTypeSpec(v string) *TimeSeriesSummary {
	s.DataTypeSpec = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *TimeSeriesSummary) SetPropertyId(v string) *TimeSeriesSummary {
	s.PropertyId = &v
	return s
}

// SetTimeSeriesCreationDate sets the TimeSeriesCreationDate field's value.
func (s *TimeSeriesSummary) SetTimeSeriesCreationDate(v time.Time) *TimeSeriesSummary {
	s.TimeSeriesCreationDate = &v
	return s
}

// SetTimeSeriesId sets the TimeSeriesId field's value.
func (s *TimeSeriesSummary) SetTimeSeriesId(v string) *TimeSeriesSummary {
	s.TimeSeriesId = &v
	return s
}

// SetTimeSeriesLastUpdateDate sets the TimeSeriesLastUpdateDate field's value.
func (s *TimeSeriesSummary) SetTimeSeriesLastUpdateDate(v time.Time) *TimeSeriesSummary {
	s.TimeSeriesLastUpdateDate = &v
	return s
}

// You've reached the limit for the number of tags allowed for a resource. For
// more information, see Tag naming limits and requirements (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions)
// in the Amazon Web Services General Reference.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the resource with too many tags.
	ResourceName *string `locationName:"resourceName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains an asset transform property. A transform is a one-to-one mapping
// of a property's data points from one form to another. For example, you can
// use a transform to convert a Celsius data stream to Fahrenheit by applying
// the transformation expression to each data point of the Celsius stream. A
// transform can only have a data type of DOUBLE and consume properties with
// data types of INTEGER or DOUBLE.
//
// For more information, see Transforms (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms)
// in the IoT SiteWise User Guide.
type Transform struct {
	_ struct{} `type:"structure"`

	// The mathematical expression that defines the transformation function. You
	// can specify up to 10 variables per expression. You can specify up to 10 functions
	// per expression.
	//
	// For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the IoT SiteWise User Guide.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The processing configuration for the given transform property. You can configure
	// transforms to be kept at the edge or forwarded to the Amazon Web Services
	// Cloud. You can also configure transforms to be computed at the edge or in
	// the cloud.
	ProcessingConfig *TransformProcessingConfig `locationName:"processingConfig" type:"structure"`

	// The list of variables used in the expression.
	//
	// Variables is a required field
	Variables []*ExpressionVariable `locationName:"variables" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transform) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Transform) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Transform"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Variables == nil {
		invalidParams.Add(request.NewErrParamRequired("Variables"))
	}
	if s.ProcessingConfig != nil {
		if err := s.ProcessingConfig.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *Transform) SetExpression(v string) *Transform {
	s.Expression = &v
	return s
}

// SetProcessingConfig sets the ProcessingConfig field's value.
func (s *Transform) SetProcessingConfig(v *TransformProcessingConfig) *Transform {
	s.ProcessingConfig = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *Transform) SetVariables(v []*ExpressionVariable) *Transform {
	s.Variables = v
	return s
}

// The processing configuration for the given transform property. You can configure
// transforms to be kept at the edge or forwarded to the Amazon Web Services
// Cloud. You can also configure transforms to be computed at the edge or in
// the cloud.
type TransformProcessingConfig struct {
	_ struct{} `type:"structure"`

	// The compute location for the given transform property.
	//
	// ComputeLocation is a required field
	ComputeLocation *string `locationName:"computeLocation" type:"string" required:"true" enum:"ComputeLocation"`

	// The forwarding configuration for a given property.
	ForwardingConfig *ForwardingConfig `locationName:"forwardingConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransformProcessingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransformProcessingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformProcessingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransformProcessingConfig"}
	if s.ComputeLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeLocation"))
	}
	if s.ForwardingConfig != nil {
		if err := s.ForwardingConfig.Validate(); err != nil {
			invalidParams.AddNested("ForwardingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeLocation sets the ComputeLocation field's value.
func (s *TransformProcessingConfig) SetComputeLocation(v string) *TransformProcessingConfig {
	s.ComputeLocation = &v
	return s
}

// SetForwardingConfig sets the ForwardingConfig field's value.
func (s *TransformProcessingConfig) SetForwardingConfig(v *ForwardingConfig) *TransformProcessingConfig {
	s.ForwardingConfig = v
	return s
}

// Contains a tumbling window, which is a repeating fixed-sized, non-overlapping,
// and contiguous time window. You can use this window in metrics to aggregate
// data from properties and other assets.
//
// You can use m, h, d, and w when you specify an interval or offset. Note that
// m represents minutes, h represents hours, d represents days, and w represents
// weeks. You can also use s to represent seconds in offset.
//
// The interval and offset parameters support the ISO 8601 format (https://en.wikipedia.org/wiki/ISO_8601).
// For example, PT5S represents 5 seconds, PT5M represents 5 minutes, and PT5H
// represents 5 hours.
type TumblingWindow struct {
	_ struct{} `type:"structure"`

	// The time interval for the tumbling window. The interval time must be between
	// 1 minute and 1 week.
	//
	// IoT SiteWise computes the 1w interval the end of Sunday at midnight each
	// week (UTC), the 1d interval at the end of each day at midnight (UTC), the
	// 1h interval at the end of each hour, and so on.
	//
	// When IoT SiteWise aggregates data points for metric computations, the start
	// of each interval is exclusive and the end of each interval is inclusive.
	// IoT SiteWise places the computed data point at the end of the interval.
	//
	// Interval is a required field
	Interval *string `locationName:"interval" min:"2" type:"string" required:"true"`

	// The offset for the tumbling window. The offset parameter accepts the following:
	//
	//    * The offset time. For example, if you specify 18h for offset and 1d for
	//    interval, IoT SiteWise aggregates data in one of the following ways: If
	//    you create the metric before or at 6 PM (UTC), you get the first aggregation
	//    result at 6 PM (UTC) on the day when you create the metric. If you create
	//    the metric after 6 PM (UTC), you get the first aggregation result at 6
	//    PM (UTC) the next day.
	//
	//    * The ISO 8601 format. For example, if you specify PT18H for offset and
	//    1d for interval, IoT SiteWise aggregates data in one of the following
	//    ways: If you create the metric before or at 6 PM (UTC), you get the first
	//    aggregation result at 6 PM (UTC) on the day when you create the metric.
	//    If you create the metric after 6 PM (UTC), you get the first aggregation
	//    result at 6 PM (UTC) the next day.
	//
	//    * The 24-hour clock. For example, if you specify 00:03:00 for offset,
	//    5m for interval, and you create the metric at 2 PM (UTC), you get the
	//    first aggregation result at 2:03 PM (UTC). You get the second aggregation
	//    result at 2:08 PM (UTC).
	//
	//    * The offset time zone. For example, if you specify 2021-07-23T18:00-08
	//    for offset and 1d for interval, IoT SiteWise aggregates data in one of
	//    the following ways: If you create the metric before or at 6 PM (PST),
	//    you get the first aggregation result at 6 PM (PST) on the day when you
	//    create the metric. If you create the metric after 6 PM (PST), you get
	//    the first aggregation result at 6 PM (PST) the next day.
	Offset *string `locationName:"offset" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TumblingWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TumblingWindow) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TumblingWindow) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TumblingWindow"}
	if s.Interval == nil {
		invalidParams.Add(request.NewErrParamRequired("Interval"))
	}
	if s.Interval != nil && len(*s.Interval) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Interval", 2))
	}
	if s.Offset != nil && len(*s.Offset) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Offset", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterval sets the Interval field's value.
func (s *TumblingWindow) SetInterval(v string) *TumblingWindow {
	s.Interval = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *TumblingWindow) SetOffset(v string) *TumblingWindow {
	s.Offset = &v
	return s
}

// You are not authorized.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of keys for tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `location:"uri" locationName:"accessPolicyId" min:"36" type:"string" required:"true"`

	// The identity for this access policy. Choose an Amazon Web Services SSO user,
	// an Amazon Web Services SSO group, or an IAM user.
	//
	// AccessPolicyIdentity is a required field
	AccessPolicyIdentity *Identity `locationName:"accessPolicyIdentity" type:"structure" required:"true"`

	// The permission level for this access policy. Note that a project ADMINISTRATOR
	// is also known as a project owner.
	//
	// AccessPolicyPermission is a required field
	AccessPolicyPermission *string `locationName:"accessPolicyPermission" type:"string" required:"true" enum:"Permission"`

	// The IoT SiteWise Monitor resource for this access policy. Choose either a
	// portal or a project.
	//
	// AccessPolicyResource is a required field
	AccessPolicyResource *Resource `locationName:"accessPolicyResource" type:"structure" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccessPolicyInput"}
	if s.AccessPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyId"))
	}
	if s.AccessPolicyId != nil && len(*s.AccessPolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AccessPolicyId", 36))
	}
	if s.AccessPolicyIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyIdentity"))
	}
	if s.AccessPolicyPermission == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyPermission"))
	}
	if s.AccessPolicyResource == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyResource"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.AccessPolicyIdentity != nil {
		if err := s.AccessPolicyIdentity.Validate(); err != nil {
			invalidParams.AddNested("AccessPolicyIdentity", err.(request.ErrInvalidParams))
		}
	}
	if s.AccessPolicyResource != nil {
		if err := s.AccessPolicyResource.Validate(); err != nil {
			invalidParams.AddNested("AccessPolicyResource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicyId sets the AccessPolicyId field's value.
func (s *UpdateAccessPolicyInput) SetAccessPolicyId(v string) *UpdateAccessPolicyInput {
	s.AccessPolicyId = &v
	return s
}

// SetAccessPolicyIdentity sets the AccessPolicyIdentity field's value.
func (s *UpdateAccessPolicyInput) SetAccessPolicyIdentity(v *Identity) *UpdateAccessPolicyInput {
	s.AccessPolicyIdentity = v
	return s
}

// SetAccessPolicyPermission sets the AccessPolicyPermission field's value.
func (s *UpdateAccessPolicyInput) SetAccessPolicyPermission(v string) *UpdateAccessPolicyInput {
	s.AccessPolicyPermission = &v
	return s
}

// SetAccessPolicyResource sets the AccessPolicyResource field's value.
func (s *UpdateAccessPolicyInput) SetAccessPolicyResource(v *Resource) *UpdateAccessPolicyInput {
	s.AccessPolicyResource = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateAccessPolicyInput) SetClientToken(v string) *UpdateAccessPolicyInput {
	s.ClientToken = &v
	return s
}

type UpdateAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessPolicyOutput) GoString() string {
	return s.String()
}

type UpdateAssetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset to update.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// A unique, friendly name for the asset.
	//
	// AssetName is a required field
	AssetName *string `locationName:"assetName" min:"1" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssetInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.AssetName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetName"))
	}
	if s.AssetName != nil && len(*s.AssetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *UpdateAssetInput) SetAssetId(v string) *UpdateAssetInput {
	s.AssetId = &v
	return s
}

// SetAssetName sets the AssetName field's value.
func (s *UpdateAssetInput) SetAssetName(v string) *UpdateAssetInput {
	s.AssetName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateAssetInput) SetClientToken(v string) *UpdateAssetInput {
	s.ClientToken = &v
	return s
}

type UpdateAssetModelInput struct {
	_ struct{} `type:"structure"`

	// The composite asset models that are part of this asset model. Composite asset
	// models are asset models that contain specific properties. Each composite
	// model has a type that defines the properties that the composite model supports.
	// Use composite asset models to define alarms on this asset model.
	AssetModelCompositeModels []*AssetModelCompositeModel `locationName:"assetModelCompositeModels" type:"list"`

	// A description for the asset model.
	AssetModelDescription *string `locationName:"assetModelDescription" min:"1" type:"string"`

	// The updated hierarchy definitions of the asset model. Each hierarchy specifies
	// an asset model whose assets can be children of any other assets created from
	// this asset model. For more information, see Asset hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the IoT SiteWise User Guide.
	//
	// You can specify up to 10 hierarchies per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the IoT SiteWise User Guide.
	AssetModelHierarchies []*AssetModelHierarchy `locationName:"assetModelHierarchies" type:"list"`

	// The ID of the asset model to update.
	//
	// AssetModelId is a required field
	AssetModelId *string `location:"uri" locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// A unique, friendly name for the asset model.
	//
	// AssetModelName is a required field
	AssetModelName *string `locationName:"assetModelName" min:"1" type:"string" required:"true"`

	// The updated property definitions of the asset model. For more information,
	// see Asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html)
	// in the IoT SiteWise User Guide.
	//
	// You can specify up to 200 properties per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the IoT SiteWise User Guide.
	AssetModelProperties []*AssetModelProperty `locationName:"assetModelProperties" type:"list"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssetModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssetModelInput"}
	if s.AssetModelDescription != nil && len(*s.AssetModelDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelDescription", 1))
	}
	if s.AssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelId"))
	}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelId", 36))
	}
	if s.AssetModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelName"))
	}
	if s.AssetModelName != nil && len(*s.AssetModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.AssetModelCompositeModels != nil {
		for i, v := range s.AssetModelCompositeModels {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelCompositeModels", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AssetModelHierarchies != nil {
		for i, v := range s.AssetModelHierarchies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelHierarchies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AssetModelProperties != nil {
		for i, v := range s.AssetModelProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelCompositeModels sets the AssetModelCompositeModels field's value.
func (s *UpdateAssetModelInput) SetAssetModelCompositeModels(v []*AssetModelCompositeModel) *UpdateAssetModelInput {
	s.AssetModelCompositeModels = v
	return s
}

// SetAssetModelDescription sets the AssetModelDescription field's value.
func (s *UpdateAssetModelInput) SetAssetModelDescription(v string) *UpdateAssetModelInput {
	s.AssetModelDescription = &v
	return s
}

// SetAssetModelHierarchies sets the AssetModelHierarchies field's value.
func (s *UpdateAssetModelInput) SetAssetModelHierarchies(v []*AssetModelHierarchy) *UpdateAssetModelInput {
	s.AssetModelHierarchies = v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *UpdateAssetModelInput) SetAssetModelId(v string) *UpdateAssetModelInput {
	s.AssetModelId = &v
	return s
}

// SetAssetModelName sets the AssetModelName field's value.
func (s *UpdateAssetModelInput) SetAssetModelName(v string) *UpdateAssetModelInput {
	s.AssetModelName = &v
	return s
}

// SetAssetModelProperties sets the AssetModelProperties field's value.
func (s *UpdateAssetModelInput) SetAssetModelProperties(v []*AssetModelProperty) *UpdateAssetModelInput {
	s.AssetModelProperties = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateAssetModelInput) SetClientToken(v string) *UpdateAssetModelInput {
	s.ClientToken = &v
	return s
}

type UpdateAssetModelOutput struct {
	_ struct{} `type:"structure"`

	// The status of the asset model, which contains a state (UPDATING after successfully
	// calling this operation) and any error message.
	//
	// AssetModelStatus is a required field
	AssetModelStatus *AssetModelStatus `locationName:"assetModelStatus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetModelOutput) GoString() string {
	return s.String()
}

// SetAssetModelStatus sets the AssetModelStatus field's value.
func (s *UpdateAssetModelOutput) SetAssetModelStatus(v *AssetModelStatus) *UpdateAssetModelOutput {
	s.AssetModelStatus = v
	return s
}

type UpdateAssetOutput struct {
	_ struct{} `type:"structure"`

	// The status of the asset, which contains a state (UPDATING after successfully
	// calling this operation) and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetOutput) GoString() string {
	return s.String()
}

// SetAssetStatus sets the AssetStatus field's value.
func (s *UpdateAssetOutput) SetAssetStatus(v *AssetStatus) *UpdateAssetOutput {
	s.AssetStatus = v
	return s
}

type UpdateAssetPropertyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset to be updated.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more information,
	// see Mapping industrial data streams to asset properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	//
	// If you omit this parameter, the alias is removed from the property.
	PropertyAlias *string `locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property to be updated.
	//
	// PropertyId is a required field
	PropertyId *string `location:"uri" locationName:"propertyId" min:"36" type:"string" required:"true"`

	// The MQTT notification state (enabled or disabled) for this asset property.
	// When the notification state is enabled, IoT SiteWise publishes property value
	// updates to a unique MQTT topic. For more information, see Interacting with
	// other services (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html)
	// in the IoT SiteWise User Guide.
	//
	// If you omit this parameter, the notification state is set to DISABLED.
	PropertyNotificationState *string `locationName:"propertyNotificationState" type:"string" enum:"PropertyNotificationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetPropertyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetPropertyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssetPropertyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssetPropertyInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyId"))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *UpdateAssetPropertyInput) SetAssetId(v string) *UpdateAssetPropertyInput {
	s.AssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateAssetPropertyInput) SetClientToken(v string) *UpdateAssetPropertyInput {
	s.ClientToken = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *UpdateAssetPropertyInput) SetPropertyAlias(v string) *UpdateAssetPropertyInput {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *UpdateAssetPropertyInput) SetPropertyId(v string) *UpdateAssetPropertyInput {
	s.PropertyId = &v
	return s
}

// SetPropertyNotificationState sets the PropertyNotificationState field's value.
func (s *UpdateAssetPropertyInput) SetPropertyNotificationState(v string) *UpdateAssetPropertyInput {
	s.PropertyNotificationState = &v
	return s
}

type UpdateAssetPropertyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetPropertyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetPropertyOutput) GoString() string {
	return s.String()
}

type UpdateDashboardInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The new dashboard definition, as specified in a JSON literal. For detailed
	// information, see Creating dashboards (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html)
	// in the IoT SiteWise User Guide.
	//
	// DashboardDefinition is a required field
	DashboardDefinition *string `locationName:"dashboardDefinition" type:"string" required:"true"`

	// A new description for the dashboard.
	DashboardDescription *string `locationName:"dashboardDescription" min:"1" type:"string"`

	// The ID of the dashboard to update.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"dashboardId" min:"36" type:"string" required:"true"`

	// A new friendly name for the dashboard.
	//
	// DashboardName is a required field
	DashboardName *string `locationName:"dashboardName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDashboardInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.DashboardDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardDefinition"))
	}
	if s.DashboardDescription != nil && len(*s.DashboardDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardDescription", 1))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 36))
	}
	if s.DashboardName == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardName"))
	}
	if s.DashboardName != nil && len(*s.DashboardName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateDashboardInput) SetClientToken(v string) *UpdateDashboardInput {
	s.ClientToken = &v
	return s
}

// SetDashboardDefinition sets the DashboardDefinition field's value.
func (s *UpdateDashboardInput) SetDashboardDefinition(v string) *UpdateDashboardInput {
	s.DashboardDefinition = &v
	return s
}

// SetDashboardDescription sets the DashboardDescription field's value.
func (s *UpdateDashboardInput) SetDashboardDescription(v string) *UpdateDashboardInput {
	s.DashboardDescription = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *UpdateDashboardInput) SetDashboardId(v string) *UpdateDashboardInput {
	s.DashboardId = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *UpdateDashboardInput) SetDashboardName(v string) *UpdateDashboardInput {
	s.DashboardName = &v
	return s
}

type UpdateDashboardOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDashboardOutput) GoString() string {
	return s.String()
}

type UpdateGatewayCapabilityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that defines the configuration for the gateway capability.
	// For more information, see Configuring data sources (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli)
	// in the IoT SiteWise User Guide.
	//
	// CapabilityConfiguration is a required field
	CapabilityConfiguration *string `locationName:"capabilityConfiguration" min:"1" type:"string" required:"true"`

	// The namespace of the gateway capability configuration to be updated. For
	// example, if you configure OPC-UA sources from the IoT SiteWise console, your
	// OPC-UA capability configuration has the namespace iotsitewise:opcuacollector:version,
	// where version is a number such as 1.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The ID of the gateway to be updated.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayCapabilityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayCapabilityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayCapabilityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayCapabilityConfigurationInput"}
	if s.CapabilityConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("CapabilityConfiguration"))
	}
	if s.CapabilityConfiguration != nil && len(*s.CapabilityConfiguration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapabilityConfiguration", 1))
	}
	if s.CapabilityNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("CapabilityNamespace"))
	}
	if s.CapabilityNamespace != nil && len(*s.CapabilityNamespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapabilityNamespace", 1))
	}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilityConfiguration sets the CapabilityConfiguration field's value.
func (s *UpdateGatewayCapabilityConfigurationInput) SetCapabilityConfiguration(v string) *UpdateGatewayCapabilityConfigurationInput {
	s.CapabilityConfiguration = &v
	return s
}

// SetCapabilityNamespace sets the CapabilityNamespace field's value.
func (s *UpdateGatewayCapabilityConfigurationInput) SetCapabilityNamespace(v string) *UpdateGatewayCapabilityConfigurationInput {
	s.CapabilityNamespace = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *UpdateGatewayCapabilityConfigurationInput) SetGatewayId(v string) *UpdateGatewayCapabilityConfigurationInput {
	s.GatewayId = &v
	return s
}

type UpdateGatewayCapabilityConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The namespace of the gateway capability.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The synchronization status of the capability configuration. The sync status
	// can be one of the following:
	//
	//    * IN_SYNC – The gateway is running the capability configuration.
	//
	//    * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
	//
	//    * SYNC_FAILED – The gateway rejected the capability configuration.
	//
	// After you update a capability configuration, its sync status is OUT_OF_SYNC
	// until the gateway receives and applies or rejects the updated configuration.
	//
	// CapabilitySyncStatus is a required field
	CapabilitySyncStatus *string `locationName:"capabilitySyncStatus" type:"string" required:"true" enum:"CapabilitySyncStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayCapabilityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayCapabilityConfigurationOutput) GoString() string {
	return s.String()
}

// SetCapabilityNamespace sets the CapabilityNamespace field's value.
func (s *UpdateGatewayCapabilityConfigurationOutput) SetCapabilityNamespace(v string) *UpdateGatewayCapabilityConfigurationOutput {
	s.CapabilityNamespace = &v
	return s
}

// SetCapabilitySyncStatus sets the CapabilitySyncStatus field's value.
func (s *UpdateGatewayCapabilityConfigurationOutput) SetCapabilitySyncStatus(v string) *UpdateGatewayCapabilityConfigurationOutput {
	s.CapabilitySyncStatus = &v
	return s
}

type UpdateGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the gateway to update.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`

	// A unique, friendly name for the gateway.
	//
	// GatewayName is a required field
	GatewayName *string `locationName:"gatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayInput"}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayId", 36))
	}
	if s.GatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayName"))
	}
	if s.GatewayName != nil && len(*s.GatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayId sets the GatewayId field's value.
func (s *UpdateGatewayInput) SetGatewayId(v string) *UpdateGatewayInput {
	s.GatewayId = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *UpdateGatewayInput) SetGatewayName(v string) *UpdateGatewayInput {
	s.GatewayName = &v
	return s
}

type UpdateGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayOutput) GoString() string {
	return s.String()
}

type UpdatePortalInput struct {
	_ struct{} `type:"structure"`

	// Contains the configuration information of an alarm created in an IoT SiteWise
	// Monitor portal. You can use the alarm to monitor an asset property and get
	// notified when the asset property value is outside a specified range. For
	// more information, see Monitoring with alarms (https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html)
	// in the IoT SiteWise Application Guide.
	Alarms *Alarms `locationName:"alarms" type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The email address that sends alarm notifications.
	NotificationSenderEmail *string `locationName:"notificationSenderEmail" min:"1" type:"string"`

	// The Amazon Web Services administrator's contact email address.
	//
	// PortalContactEmail is a required field
	PortalContactEmail *string `locationName:"portalContactEmail" min:"1" type:"string" required:"true"`

	// A new description for the portal.
	PortalDescription *string `locationName:"portalDescription" min:"1" type:"string"`

	// The ID of the portal to update.
	//
	// PortalId is a required field
	PortalId *string `location:"uri" locationName:"portalId" min:"36" type:"string" required:"true"`

	// Contains an image that is one of the following:
	//
	//    * An image file. Choose this option to upload a new image.
	//
	//    * The ID of an existing image. Choose this option to keep an existing
	//    image.
	PortalLogoImage *Image `locationName:"portalLogoImage" type:"structure"`

	// A new friendly name for the portal.
	//
	// PortalName is a required field
	PortalName *string `locationName:"portalName" min:"1" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a service role that allows the portal's users to access your IoT SiteWise
	// resources on your behalf. For more information, see Using service roles for
	// IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the IoT SiteWise User Guide.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePortalInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.NotificationSenderEmail != nil && len(*s.NotificationSenderEmail) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NotificationSenderEmail", 1))
	}
	if s.PortalContactEmail == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalContactEmail"))
	}
	if s.PortalContactEmail != nil && len(*s.PortalContactEmail) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalContactEmail", 1))
	}
	if s.PortalDescription != nil && len(*s.PortalDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalDescription", 1))
	}
	if s.PortalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PortalId", 36))
	}
	if s.PortalName == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalName"))
	}
	if s.PortalName != nil && len(*s.PortalName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Alarms != nil {
		if err := s.Alarms.Validate(); err != nil {
			invalidParams.AddNested("Alarms", err.(request.ErrInvalidParams))
		}
	}
	if s.PortalLogoImage != nil {
		if err := s.PortalLogoImage.Validate(); err != nil {
			invalidParams.AddNested("PortalLogoImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarms sets the Alarms field's value.
func (s *UpdatePortalInput) SetAlarms(v *Alarms) *UpdatePortalInput {
	s.Alarms = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdatePortalInput) SetClientToken(v string) *UpdatePortalInput {
	s.ClientToken = &v
	return s
}

// SetNotificationSenderEmail sets the NotificationSenderEmail field's value.
func (s *UpdatePortalInput) SetNotificationSenderEmail(v string) *UpdatePortalInput {
	s.NotificationSenderEmail = &v
	return s
}

// SetPortalContactEmail sets the PortalContactEmail field's value.
func (s *UpdatePortalInput) SetPortalContactEmail(v string) *UpdatePortalInput {
	s.PortalContactEmail = &v
	return s
}

// SetPortalDescription sets the PortalDescription field's value.
func (s *UpdatePortalInput) SetPortalDescription(v string) *UpdatePortalInput {
	s.PortalDescription = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *UpdatePortalInput) SetPortalId(v string) *UpdatePortalInput {
	s.PortalId = &v
	return s
}

// SetPortalLogoImage sets the PortalLogoImage field's value.
func (s *UpdatePortalInput) SetPortalLogoImage(v *Image) *UpdatePortalInput {
	s.PortalLogoImage = v
	return s
}

// SetPortalName sets the PortalName field's value.
func (s *UpdatePortalInput) SetPortalName(v string) *UpdatePortalInput {
	s.PortalName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdatePortalInput) SetRoleArn(v string) *UpdatePortalInput {
	s.RoleArn = &v
	return s
}

type UpdatePortalOutput struct {
	_ struct{} `type:"structure"`

	// The status of the portal, which contains a state (UPDATING after successfully
	// calling this operation) and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePortalOutput) GoString() string {
	return s.String()
}

// SetPortalStatus sets the PortalStatus field's value.
func (s *UpdatePortalOutput) SetPortalStatus(v *PortalStatus) *UpdatePortalOutput {
	s.PortalStatus = v
	return s
}

type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A new description for the project.
	ProjectDescription *string `locationName:"projectDescription" min:"1" type:"string"`

	// The ID of the project to update.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`

	// A new friendly name for the project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ProjectDescription != nil && len(*s.ProjectDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectDescription", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateProjectInput) SetClientToken(v string) *UpdateProjectInput {
	s.ClientToken = &v
	return s
}

// SetProjectDescription sets the ProjectDescription field's value.
func (s *UpdateProjectInput) SetProjectDescription(v string) *UpdateProjectInput {
	s.ProjectDescription = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *UpdateProjectInput) SetProjectId(v string) *UpdateProjectInput {
	s.ProjectId = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *UpdateProjectInput) SetProjectName(v string) *UpdateProjectInput {
	s.ProjectName = &v
	return s
}

type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

// Contains information for a user identity in an access policy.
type UserIdentity struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services SSO ID of the user.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserIdentity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserIdentity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserIdentity"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UserIdentity) SetId(v string) *UserIdentity {
	s.Id = &v
	return s
}

// Identifies a property value used in an expression.
type VariableValue struct {
	_ struct{} `type:"structure"`

	// The ID of the hierarchy to query for the property ID. You can use the hierarchy's
	// name instead of the hierarchy's ID.
	//
	// You use a hierarchy ID instead of a model ID because you can have several
	// hierarchies using the same model and therefore the same propertyId. For example,
	// you might have separately grouped assets that come from the same asset model.
	// For more information, see Asset hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the IoT SiteWise User Guide.
	HierarchyId *string `locationName:"hierarchyId" min:"1" type:"string"`

	// The ID of the property to use as the variable. You can use the property name
	// if it's from the same asset model.
	//
	// PropertyId is a required field
	PropertyId *string `locationName:"propertyId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariableValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VariableValue"}
	if s.HierarchyId != nil && len(*s.HierarchyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchyId", 1))
	}
	if s.PropertyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyId"))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHierarchyId sets the HierarchyId field's value.
func (s *VariableValue) SetHierarchyId(v string) *VariableValue {
	s.HierarchyId = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *VariableValue) SetPropertyId(v string) *VariableValue {
	s.PropertyId = &v
	return s
}

// Contains an asset property value (of a single type only).
type Variant struct {
	_ struct{} `type:"structure"`

	// Asset property data of type Boolean (true or false).
	BooleanValue *bool `locationName:"booleanValue" type:"boolean"`

	// Asset property data of type double (floating point number).
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// Asset property data of type integer (whole number).
	IntegerValue *int64 `locationName:"integerValue" type:"integer"`

	// Asset property data of type string (sequence of characters).
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Variant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Variant) GoString() string {
	return s.String()
}

// SetBooleanValue sets the BooleanValue field's value.
func (s *Variant) SetBooleanValue(v bool) *Variant {
	s.BooleanValue = &v
	return s
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *Variant) SetDoubleValue(v float64) *Variant {
	s.DoubleValue = &v
	return s
}

// SetIntegerValue sets the IntegerValue field's value.
func (s *Variant) SetIntegerValue(v int64) *Variant {
	s.IntegerValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *Variant) SetStringValue(v string) *Variant {
	s.StringValue = &v
	return s
}

const (
	// AggregateTypeAverage is a AggregateType enum value
	AggregateTypeAverage = "AVERAGE"

	// AggregateTypeCount is a AggregateType enum value
	AggregateTypeCount = "COUNT"

	// AggregateTypeMaximum is a AggregateType enum value
	AggregateTypeMaximum = "MAXIMUM"

	// AggregateTypeMinimum is a AggregateType enum value
	AggregateTypeMinimum = "MINIMUM"

	// AggregateTypeSum is a AggregateType enum value
	AggregateTypeSum = "SUM"

	// AggregateTypeStandardDeviation is a AggregateType enum value
	AggregateTypeStandardDeviation = "STANDARD_DEVIATION"
)

// AggregateType_Values returns all elements of the AggregateType enum
func AggregateType_Values() []string {
	return []string{
		AggregateTypeAverage,
		AggregateTypeCount,
		AggregateTypeMaximum,
		AggregateTypeMinimum,
		AggregateTypeSum,
		AggregateTypeStandardDeviation,
	}
}

const (
	// AssetErrorCodeInternalFailure is a AssetErrorCode enum value
	AssetErrorCodeInternalFailure = "INTERNAL_FAILURE"
)

// AssetErrorCode_Values returns all elements of the AssetErrorCode enum
func AssetErrorCode_Values() []string {
	return []string{
		AssetErrorCodeInternalFailure,
	}
}

const (
	// AssetModelStateCreating is a AssetModelState enum value
	AssetModelStateCreating = "CREATING"

	// AssetModelStateActive is a AssetModelState enum value
	AssetModelStateActive = "ACTIVE"

	// AssetModelStateUpdating is a AssetModelState enum value
	AssetModelStateUpdating = "UPDATING"

	// AssetModelStatePropagating is a AssetModelState enum value
	AssetModelStatePropagating = "PROPAGATING"

	// AssetModelStateDeleting is a AssetModelState enum value
	AssetModelStateDeleting = "DELETING"

	// AssetModelStateFailed is a AssetModelState enum value
	AssetModelStateFailed = "FAILED"
)

// AssetModelState_Values returns all elements of the AssetModelState enum
func AssetModelState_Values() []string {
	return []string{
		AssetModelStateCreating,
		AssetModelStateActive,
		AssetModelStateUpdating,
		AssetModelStatePropagating,
		AssetModelStateDeleting,
		AssetModelStateFailed,
	}
}

const (
	// AssetRelationshipTypeHierarchy is a AssetRelationshipType enum value
	AssetRelationshipTypeHierarchy = "HIERARCHY"
)

// AssetRelationshipType_Values returns all elements of the AssetRelationshipType enum
func AssetRelationshipType_Values() []string {
	return []string{
		AssetRelationshipTypeHierarchy,
	}
}

const (
	// AssetStateCreating is a AssetState enum value
	AssetStateCreating = "CREATING"

	// AssetStateActive is a AssetState enum value
	AssetStateActive = "ACTIVE"

	// AssetStateUpdating is a AssetState enum value
	AssetStateUpdating = "UPDATING"

	// AssetStateDeleting is a AssetState enum value
	AssetStateDeleting = "DELETING"

	// AssetStateFailed is a AssetState enum value
	AssetStateFailed = "FAILED"
)

// AssetState_Values returns all elements of the AssetState enum
func AssetState_Values() []string {
	return []string{
		AssetStateCreating,
		AssetStateActive,
		AssetStateUpdating,
		AssetStateDeleting,
		AssetStateFailed,
	}
}

const (
	// AuthModeIam is a AuthMode enum value
	AuthModeIam = "IAM"

	// AuthModeSso is a AuthMode enum value
	AuthModeSso = "SSO"
)

// AuthMode_Values returns all elements of the AuthMode enum
func AuthMode_Values() []string {
	return []string{
		AuthModeIam,
		AuthModeSso,
	}
}

const (
	// BatchEntryCompletionStatusSuccess is a BatchEntryCompletionStatus enum value
	BatchEntryCompletionStatusSuccess = "SUCCESS"

	// BatchEntryCompletionStatusError is a BatchEntryCompletionStatus enum value
	BatchEntryCompletionStatusError = "ERROR"
)

// BatchEntryCompletionStatus_Values returns all elements of the BatchEntryCompletionStatus enum
func BatchEntryCompletionStatus_Values() []string {
	return []string{
		BatchEntryCompletionStatusSuccess,
		BatchEntryCompletionStatusError,
	}
}

const (
	// BatchGetAssetPropertyAggregatesErrorCodeResourceNotFoundException is a BatchGetAssetPropertyAggregatesErrorCode enum value
	BatchGetAssetPropertyAggregatesErrorCodeResourceNotFoundException = "ResourceNotFoundException"

	// BatchGetAssetPropertyAggregatesErrorCodeInvalidRequestException is a BatchGetAssetPropertyAggregatesErrorCode enum value
	BatchGetAssetPropertyAggregatesErrorCodeInvalidRequestException = "InvalidRequestException"

	// BatchGetAssetPropertyAggregatesErrorCodeAccessDeniedException is a BatchGetAssetPropertyAggregatesErrorCode enum value
	BatchGetAssetPropertyAggregatesErrorCodeAccessDeniedException = "AccessDeniedException"
)

// BatchGetAssetPropertyAggregatesErrorCode_Values returns all elements of the BatchGetAssetPropertyAggregatesErrorCode enum
func BatchGetAssetPropertyAggregatesErrorCode_Values() []string {
	return []string{
		BatchGetAssetPropertyAggregatesErrorCodeResourceNotFoundException,
		BatchGetAssetPropertyAggregatesErrorCodeInvalidRequestException,
		BatchGetAssetPropertyAggregatesErrorCodeAccessDeniedException,
	}
}

const (
	// BatchGetAssetPropertyValueErrorCodeResourceNotFoundException is a BatchGetAssetPropertyValueErrorCode enum value
	BatchGetAssetPropertyValueErrorCodeResourceNotFoundException = "ResourceNotFoundException"

	// BatchGetAssetPropertyValueErrorCodeInvalidRequestException is a BatchGetAssetPropertyValueErrorCode enum value
	BatchGetAssetPropertyValueErrorCodeInvalidRequestException = "InvalidRequestException"

	// BatchGetAssetPropertyValueErrorCodeAccessDeniedException is a BatchGetAssetPropertyValueErrorCode enum value
	BatchGetAssetPropertyValueErrorCodeAccessDeniedException = "AccessDeniedException"
)

// BatchGetAssetPropertyValueErrorCode_Values returns all elements of the BatchGetAssetPropertyValueErrorCode enum
func BatchGetAssetPropertyValueErrorCode_Values() []string {
	return []string{
		BatchGetAssetPropertyValueErrorCodeResourceNotFoundException,
		BatchGetAssetPropertyValueErrorCodeInvalidRequestException,
		BatchGetAssetPropertyValueErrorCodeAccessDeniedException,
	}
}

const (
	// BatchGetAssetPropertyValueHistoryErrorCodeResourceNotFoundException is a BatchGetAssetPropertyValueHistoryErrorCode enum value
	BatchGetAssetPropertyValueHistoryErrorCodeResourceNotFoundException = "ResourceNotFoundException"

	// BatchGetAssetPropertyValueHistoryErrorCodeInvalidRequestException is a BatchGetAssetPropertyValueHistoryErrorCode enum value
	BatchGetAssetPropertyValueHistoryErrorCodeInvalidRequestException = "InvalidRequestException"

	// BatchGetAssetPropertyValueHistoryErrorCodeAccessDeniedException is a BatchGetAssetPropertyValueHistoryErrorCode enum value
	BatchGetAssetPropertyValueHistoryErrorCodeAccessDeniedException = "AccessDeniedException"
)

// BatchGetAssetPropertyValueHistoryErrorCode_Values returns all elements of the BatchGetAssetPropertyValueHistoryErrorCode enum
func BatchGetAssetPropertyValueHistoryErrorCode_Values() []string {
	return []string{
		BatchGetAssetPropertyValueHistoryErrorCodeResourceNotFoundException,
		BatchGetAssetPropertyValueHistoryErrorCodeInvalidRequestException,
		BatchGetAssetPropertyValueHistoryErrorCodeAccessDeniedException,
	}
}

const (
	// BatchPutAssetPropertyValueErrorCodeResourceNotFoundException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeResourceNotFoundException = "ResourceNotFoundException"

	// BatchPutAssetPropertyValueErrorCodeInvalidRequestException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeInvalidRequestException = "InvalidRequestException"

	// BatchPutAssetPropertyValueErrorCodeInternalFailureException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeInternalFailureException = "InternalFailureException"

	// BatchPutAssetPropertyValueErrorCodeServiceUnavailableException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeServiceUnavailableException = "ServiceUnavailableException"

	// BatchPutAssetPropertyValueErrorCodeThrottlingException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeThrottlingException = "ThrottlingException"

	// BatchPutAssetPropertyValueErrorCodeLimitExceededException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeLimitExceededException = "LimitExceededException"

	// BatchPutAssetPropertyValueErrorCodeConflictingOperationException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeConflictingOperationException = "ConflictingOperationException"

	// BatchPutAssetPropertyValueErrorCodeTimestampOutOfRangeException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeTimestampOutOfRangeException = "TimestampOutOfRangeException"

	// BatchPutAssetPropertyValueErrorCodeAccessDeniedException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeAccessDeniedException = "AccessDeniedException"
)

// BatchPutAssetPropertyValueErrorCode_Values returns all elements of the BatchPutAssetPropertyValueErrorCode enum
func BatchPutAssetPropertyValueErrorCode_Values() []string {
	return []string{
		BatchPutAssetPropertyValueErrorCodeResourceNotFoundException,
		BatchPutAssetPropertyValueErrorCodeInvalidRequestException,
		BatchPutAssetPropertyValueErrorCodeInternalFailureException,
		BatchPutAssetPropertyValueErrorCodeServiceUnavailableException,
		BatchPutAssetPropertyValueErrorCodeThrottlingException,
		BatchPutAssetPropertyValueErrorCodeLimitExceededException,
		BatchPutAssetPropertyValueErrorCodeConflictingOperationException,
		BatchPutAssetPropertyValueErrorCodeTimestampOutOfRangeException,
		BatchPutAssetPropertyValueErrorCodeAccessDeniedException,
	}
}

const (
	// CapabilitySyncStatusInSync is a CapabilitySyncStatus enum value
	CapabilitySyncStatusInSync = "IN_SYNC"

	// CapabilitySyncStatusOutOfSync is a CapabilitySyncStatus enum value
	CapabilitySyncStatusOutOfSync = "OUT_OF_SYNC"

	// CapabilitySyncStatusSyncFailed is a CapabilitySyncStatus enum value
	CapabilitySyncStatusSyncFailed = "SYNC_FAILED"

	// CapabilitySyncStatusUnknown is a CapabilitySyncStatus enum value
	CapabilitySyncStatusUnknown = "UNKNOWN"
)

// CapabilitySyncStatus_Values returns all elements of the CapabilitySyncStatus enum
func CapabilitySyncStatus_Values() []string {
	return []string{
		CapabilitySyncStatusInSync,
		CapabilitySyncStatusOutOfSync,
		CapabilitySyncStatusSyncFailed,
		CapabilitySyncStatusUnknown,
	}
}

const (
	// ComputeLocationEdge is a ComputeLocation enum value
	ComputeLocationEdge = "EDGE"

	// ComputeLocationCloud is a ComputeLocation enum value
	ComputeLocationCloud = "CLOUD"
)

// ComputeLocation_Values returns all elements of the ComputeLocation enum
func ComputeLocation_Values() []string {
	return []string{
		ComputeLocationEdge,
		ComputeLocationCloud,
	}
}

const (
	// ConfigurationStateActive is a ConfigurationState enum value
	ConfigurationStateActive = "ACTIVE"

	// ConfigurationStateUpdateInProgress is a ConfigurationState enum value
	ConfigurationStateUpdateInProgress = "UPDATE_IN_PROGRESS"

	// ConfigurationStateUpdateFailed is a ConfigurationState enum value
	ConfigurationStateUpdateFailed = "UPDATE_FAILED"
)

// ConfigurationState_Values returns all elements of the ConfigurationState enum
func ConfigurationState_Values() []string {
	return []string{
		ConfigurationStateActive,
		ConfigurationStateUpdateInProgress,
		ConfigurationStateUpdateFailed,
	}
}

const (
	// DetailedErrorCodeIncompatibleComputeLocation is a DetailedErrorCode enum value
	DetailedErrorCodeIncompatibleComputeLocation = "INCOMPATIBLE_COMPUTE_LOCATION"

	// DetailedErrorCodeIncompatibleForwardingConfiguration is a DetailedErrorCode enum value
	DetailedErrorCodeIncompatibleForwardingConfiguration = "INCOMPATIBLE_FORWARDING_CONFIGURATION"
)

// DetailedErrorCode_Values returns all elements of the DetailedErrorCode enum
func DetailedErrorCode_Values() []string {
	return []string{
		DetailedErrorCodeIncompatibleComputeLocation,
		DetailedErrorCodeIncompatibleForwardingConfiguration,
	}
}

const (
	// DisassociatedDataStorageStateEnabled is a DisassociatedDataStorageState enum value
	DisassociatedDataStorageStateEnabled = "ENABLED"

	// DisassociatedDataStorageStateDisabled is a DisassociatedDataStorageState enum value
	DisassociatedDataStorageStateDisabled = "DISABLED"
)

// DisassociatedDataStorageState_Values returns all elements of the DisassociatedDataStorageState enum
func DisassociatedDataStorageState_Values() []string {
	return []string{
		DisassociatedDataStorageStateEnabled,
		DisassociatedDataStorageStateDisabled,
	}
}

const (
	// EncryptionTypeSitewiseDefaultEncryption is a EncryptionType enum value
	EncryptionTypeSitewiseDefaultEncryption = "SITEWISE_DEFAULT_ENCRYPTION"

	// EncryptionTypeKmsBasedEncryption is a EncryptionType enum value
	EncryptionTypeKmsBasedEncryption = "KMS_BASED_ENCRYPTION"
)

// EncryptionType_Values returns all elements of the EncryptionType enum
func EncryptionType_Values() []string {
	return []string{
		EncryptionTypeSitewiseDefaultEncryption,
		EncryptionTypeKmsBasedEncryption,
	}
}

const (
	// ErrorCodeValidationError is a ErrorCode enum value
	ErrorCodeValidationError = "VALIDATION_ERROR"

	// ErrorCodeInternalFailure is a ErrorCode enum value
	ErrorCodeInternalFailure = "INTERNAL_FAILURE"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeValidationError,
		ErrorCodeInternalFailure,
	}
}

const (
	// ForwardingConfigStateDisabled is a ForwardingConfigState enum value
	ForwardingConfigStateDisabled = "DISABLED"

	// ForwardingConfigStateEnabled is a ForwardingConfigState enum value
	ForwardingConfigStateEnabled = "ENABLED"
)

// ForwardingConfigState_Values returns all elements of the ForwardingConfigState enum
func ForwardingConfigState_Values() []string {
	return []string{
		ForwardingConfigStateDisabled,
		ForwardingConfigStateEnabled,
	}
}

const (
	// IdentityTypeUser is a IdentityType enum value
	IdentityTypeUser = "USER"

	// IdentityTypeGroup is a IdentityType enum value
	IdentityTypeGroup = "GROUP"

	// IdentityTypeIam is a IdentityType enum value
	IdentityTypeIam = "IAM"
)

// IdentityType_Values returns all elements of the IdentityType enum
func IdentityType_Values() []string {
	return []string{
		IdentityTypeUser,
		IdentityTypeGroup,
		IdentityTypeIam,
	}
}

const (
	// ImageFileTypePng is a ImageFileType enum value
	ImageFileTypePng = "PNG"
)

// ImageFileType_Values returns all elements of the ImageFileType enum
func ImageFileType_Values() []string {
	return []string{
		ImageFileTypePng,
	}
}

const (
	// ListAssetsFilterAll is a ListAssetsFilter enum value
	ListAssetsFilterAll = "ALL"

	// ListAssetsFilterTopLevel is a ListAssetsFilter enum value
	ListAssetsFilterTopLevel = "TOP_LEVEL"
)

// ListAssetsFilter_Values returns all elements of the ListAssetsFilter enum
func ListAssetsFilter_Values() []string {
	return []string{
		ListAssetsFilterAll,
		ListAssetsFilterTopLevel,
	}
}

const (
	// ListTimeSeriesTypeAssociated is a ListTimeSeriesType enum value
	ListTimeSeriesTypeAssociated = "ASSOCIATED"

	// ListTimeSeriesTypeDisassociated is a ListTimeSeriesType enum value
	ListTimeSeriesTypeDisassociated = "DISASSOCIATED"
)

// ListTimeSeriesType_Values returns all elements of the ListTimeSeriesType enum
func ListTimeSeriesType_Values() []string {
	return []string{
		ListTimeSeriesTypeAssociated,
		ListTimeSeriesTypeDisassociated,
	}
}

const (
	// LoggingLevelError is a LoggingLevel enum value
	LoggingLevelError = "ERROR"

	// LoggingLevelInfo is a LoggingLevel enum value
	LoggingLevelInfo = "INFO"

	// LoggingLevelOff is a LoggingLevel enum value
	LoggingLevelOff = "OFF"
)

// LoggingLevel_Values returns all elements of the LoggingLevel enum
func LoggingLevel_Values() []string {
	return []string{
		LoggingLevelError,
		LoggingLevelInfo,
		LoggingLevelOff,
	}
}

const (
	// MonitorErrorCodeInternalFailure is a MonitorErrorCode enum value
	MonitorErrorCodeInternalFailure = "INTERNAL_FAILURE"

	// MonitorErrorCodeValidationError is a MonitorErrorCode enum value
	MonitorErrorCodeValidationError = "VALIDATION_ERROR"

	// MonitorErrorCodeLimitExceeded is a MonitorErrorCode enum value
	MonitorErrorCodeLimitExceeded = "LIMIT_EXCEEDED"
)

// MonitorErrorCode_Values returns all elements of the MonitorErrorCode enum
func MonitorErrorCode_Values() []string {
	return []string{
		MonitorErrorCodeInternalFailure,
		MonitorErrorCodeValidationError,
		MonitorErrorCodeLimitExceeded,
	}
}

const (
	// PermissionAdministrator is a Permission enum value
	PermissionAdministrator = "ADMINISTRATOR"

	// PermissionViewer is a Permission enum value
	PermissionViewer = "VIEWER"
)

// Permission_Values returns all elements of the Permission enum
func Permission_Values() []string {
	return []string{
		PermissionAdministrator,
		PermissionViewer,
	}
}

const (
	// PortalStateCreating is a PortalState enum value
	PortalStateCreating = "CREATING"

	// PortalStateUpdating is a PortalState enum value
	PortalStateUpdating = "UPDATING"

	// PortalStateDeleting is a PortalState enum value
	PortalStateDeleting = "DELETING"

	// PortalStateActive is a PortalState enum value
	PortalStateActive = "ACTIVE"

	// PortalStateFailed is a PortalState enum value
	PortalStateFailed = "FAILED"
)

// PortalState_Values returns all elements of the PortalState enum
func PortalState_Values() []string {
	return []string{
		PortalStateCreating,
		PortalStateUpdating,
		PortalStateDeleting,
		PortalStateActive,
		PortalStateFailed,
	}
}

const (
	// PropertyDataTypeString is a PropertyDataType enum value
	PropertyDataTypeString = "STRING"

	// PropertyDataTypeInteger is a PropertyDataType enum value
	PropertyDataTypeInteger = "INTEGER"

	// PropertyDataTypeDouble is a PropertyDataType enum value
	PropertyDataTypeDouble = "DOUBLE"

	// PropertyDataTypeBoolean is a PropertyDataType enum value
	PropertyDataTypeBoolean = "BOOLEAN"

	// PropertyDataTypeStruct is a PropertyDataType enum value
	PropertyDataTypeStruct = "STRUCT"
)

// PropertyDataType_Values returns all elements of the PropertyDataType enum
func PropertyDataType_Values() []string {
	return []string{
		PropertyDataTypeString,
		PropertyDataTypeInteger,
		PropertyDataTypeDouble,
		PropertyDataTypeBoolean,
		PropertyDataTypeStruct,
	}
}

const (
	// PropertyNotificationStateEnabled is a PropertyNotificationState enum value
	PropertyNotificationStateEnabled = "ENABLED"

	// PropertyNotificationStateDisabled is a PropertyNotificationState enum value
	PropertyNotificationStateDisabled = "DISABLED"
)

// PropertyNotificationState_Values returns all elements of the PropertyNotificationState enum
func PropertyNotificationState_Values() []string {
	return []string{
		PropertyNotificationStateEnabled,
		PropertyNotificationStateDisabled,
	}
}

const (
	// QualityGood is a Quality enum value
	QualityGood = "GOOD"

	// QualityBad is a Quality enum value
	QualityBad = "BAD"

	// QualityUncertain is a Quality enum value
	QualityUncertain = "UNCERTAIN"
)

// Quality_Values returns all elements of the Quality enum
func Quality_Values() []string {
	return []string{
		QualityGood,
		QualityBad,
		QualityUncertain,
	}
}

const (
	// ResourceTypePortal is a ResourceType enum value
	ResourceTypePortal = "PORTAL"

	// ResourceTypeProject is a ResourceType enum value
	ResourceTypeProject = "PROJECT"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypePortal,
		ResourceTypeProject,
	}
}

const (
	// StorageTypeSitewiseDefaultStorage is a StorageType enum value
	StorageTypeSitewiseDefaultStorage = "SITEWISE_DEFAULT_STORAGE"

	// StorageTypeMultiLayerStorage is a StorageType enum value
	StorageTypeMultiLayerStorage = "MULTI_LAYER_STORAGE"
)

// StorageType_Values returns all elements of the StorageType enum
func StorageType_Values() []string {
	return []string{
		StorageTypeSitewiseDefaultStorage,
		StorageTypeMultiLayerStorage,
	}
}

const (
	// TimeOrderingAscending is a TimeOrdering enum value
	TimeOrderingAscending = "ASCENDING"

	// TimeOrderingDescending is a TimeOrdering enum value
	TimeOrderingDescending = "DESCENDING"
)

// TimeOrdering_Values returns all elements of the TimeOrdering enum
func TimeOrdering_Values() []string {
	return []string{
		TimeOrderingAscending,
		TimeOrderingDescending,
	}
}

const (
	// TraversalDirectionParent is a TraversalDirection enum value
	TraversalDirectionParent = "PARENT"

	// TraversalDirectionChild is a TraversalDirection enum value
	TraversalDirectionChild = "CHILD"
)

// TraversalDirection_Values returns all elements of the TraversalDirection enum
func TraversalDirection_Values() []string {
	return []string{
		TraversalDirectionParent,
		TraversalDirectionChild,
	}
}

const (
	// TraversalTypePathToRoot is a TraversalType enum value
	TraversalTypePathToRoot = "PATH_TO_ROOT"
)

// TraversalType_Values returns all elements of the TraversalType enum
func TraversalType_Values() []string {
	return []string{
		TraversalTypePathToRoot,
	}
}
