// Copyright 2018 Keybase, Inc. All rights reserved. Use of
// this source code is governed by the included BSD license.

package saltpack

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/require"
)

func requireErrSuffix(t *testing.T, err error, suffix string) {
	require.True(t, strings.HasSuffix(err.Error(), suffix), "err=%v, suffix=%s", err, suffix)
}

func requireErrContains(t *testing.T, err error, substr string) {
	require.True(t, strings.Contains(err.Error(), substr), "err=%v, substr=%s", err, substr)
}
