/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AISchemaGenerationOptions;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.impl.AIDatabaseSnapshotService;
import org.jkiss.dbeaver.model.ai.impl.ChatTruncator;
import org.jkiss.dbeaver.model.ai.impl.TokenCounter;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class AIEngineRequestFactory {
    private static final String DB_SNAPSHOT_SECTION_HEADER = "Database snapshot:\n";
    private static final int SYSTEM_PROMPT_TOKEN_BUDGET_PERCENT = 80;
    private static final int REPLY_TOKEN_RESERVE = 2000;
    private static final int OVERHEAD_TOKEN_RESERVE = 100;
    private final AIDatabaseSnapshotService databaseSnapshotService;
    private final TokenCounter tokenCounter;

    public AIEngineRequestFactory(@NotNull AIDatabaseSnapshotService databaseSnapshotService, @NotNull TokenCounter tokenCounter) {
        this.databaseSnapshotService = databaseSnapshotService;
        this.tokenCounter = tokenCounter;
    }

    public AIEngineRequest build(@NotNull DBRProgressMonitor monitor, @NotNull String systemPrompt, @Nullable AIDatabaseContext aiDatabaseContext, @NotNull List<AIMessage> messages, int maxContextWindowSize) throws DBException {
        int availableContextTokens = maxContextWindowSize - 2000 - 100;
        if (availableContextTokens < 0) {
            availableContextTokens = 0;
        }
        int systemPromptTokenBudget = availableContextTokens * 80 / 100;
        int snapshotHeaderTokenCount = this.tokenCounter.count(DB_SNAPSHOT_SECTION_HEADER);
        int systemPromptTokenCount = this.tokenCounter.count(systemPrompt);
        int dbSnapshotTokenBudget = systemPromptTokenBudget - systemPromptTokenCount - snapshotHeaderTokenCount;
        if (dbSnapshotTokenBudget < 0) {
            dbSnapshotTokenBudget = 0;
        }
        String dbSnapshot = "";
        if (aiDatabaseContext != null && dbSnapshotTokenBudget > 0) {
            AISchemaGenerationOptions ddlOptions = this.buildOptions(dbSnapshotTokenBudget);
            dbSnapshot = this.databaseSnapshotService.createDbSnapshot(monitor, aiDatabaseContext, ddlOptions);
        }
        String fullSystemPrompt = dbSnapshot.isBlank() ? systemPrompt : systemPrompt + "\nDatabase snapshot:\n" + dbSnapshot;
        AIMessage systemMessage = AIMessage.systemMessage(fullSystemPrompt);
        ChatTruncator chatTruncator = ChatTruncator.builder().maxTokens(maxContextWindowSize).reserveForSystem(systemPromptTokenBudget).reserveForReply(2000).reserveForOverhead(100).tokenCounter(this.tokenCounter).build();
        ArrayList<AIMessage> allMessages = new ArrayList<AIMessage>(1 + messages.size());
        allMessages.add(systemMessage);
        allMessages.addAll(messages);
        List<AIMessage> truncated = chatTruncator.truncate(allMessages);
        return new AIEngineRequest(truncated);
    }

    protected AISchemaGenerationOptions buildOptions(int dbSnapshotTokenBudget) {
        DBPPreferenceStore prefs = DBWorkbench.getPlatform().getPreferenceStore();
        return AISchemaGenerationOptions.builder().withMaxDbSnapshotTokens(dbSnapshotTokenBudget).withSendObjectComment(prefs.getBoolean("ai.completion.description")).withSendColumnTypes(prefs.getBoolean("ai.completion.sendType")).build();
    }
}

