/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/whispersystems/signalservice/api/crypto/BetterCipherInputStream;", "Ljava/io/FilterInputStream;", "inputStream", "Ljava/io/InputStream;", "cipher", "Ljavax/crypto/Cipher;", "<init>", "(Ljava/io/InputStream;Ljavax/crypto/Cipher;)V", "getCipher", "()Ljavax/crypto/Cipher;", "done", "", "overflowBuffer", "", "read", "", "buffer", "offset", "length", "markSupported", "readIncremental", "outputBuffer", "originalOffset", "originalLength", "readFinal", "signal-service-java"})
public final class BetterCipherInputStream
extends FilterInputStream {
    @NotNull
    private final Cipher cipher;
    private boolean done;
    @Nullable
    private byte[] overflowBuffer;

    public BetterCipherInputStream(@NotNull InputStream inputStream, @NotNull Cipher cipher) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        super(inputStream);
        this.cipher = cipher;
    }

    @NotNull
    public final Cipher getCipher() {
        return this.cipher;
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int read = this.read(buffer);
        while (read == 0) {
            read = this.read(buffer);
        }
        if (read == -1) {
            return read;
        }
        return buffer[0] & 0xFF;
    }

    @Override
    public int read(@Nonnull @NotNull byte[] buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(@Nonnull @NotNull byte[] buffer, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return !this.done ? this.readIncremental(buffer, offset, length) : -1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private final int readIncremental(byte[] outputBuffer, int originalOffset, int originalLength) throws IOException {
        int offset = 0;
        offset = originalOffset;
        int length = 0;
        length = originalLength;
        int readLength = 0;
        if (this.overflowBuffer != null) {
            byte[] overflow = this.overflowBuffer;
            boolean bl = false;
            if (overflow.length > length) {
                ArraysKt.copyInto$default((byte[])overflow, (byte[])outputBuffer, (int)offset, (int)0, (int)length, (int)4, null);
                this.overflowBuffer = ArraysKt.copyOfRange((byte[])overflow, (int)length, (int)overflow.length);
                return length;
            }
            if (overflow.length == length) {
                ArraysKt.copyInto$default((byte[])overflow, (byte[])outputBuffer, (int)offset, (int)0, (int)0, (int)12, null);
                this.overflowBuffer = null;
                return length;
            }
            ArraysKt.copyInto$default((byte[])overflow, (byte[])outputBuffer, (int)offset, (int)0, (int)0, (int)12, null);
            offset += (readLength += overflow.length);
            length -= readLength;
            this.overflowBuffer = null;
        }
        byte[] ciphertextBuffer = new byte[length];
        int ciphertextRead = super.read(ciphertextBuffer, 0, ciphertextBuffer.length);
        if (ciphertextRead == -1) {
            return this.readFinal(outputBuffer, offset, length);
        }
        try {
            int plaintextLength = this.cipher.getOutputSize(ciphertextRead);
            if (plaintextLength <= length) {
                return readLength += this.cipher.update(ciphertextBuffer, 0, ciphertextRead, outputBuffer, offset);
            }
            byte[] plaintextBuffer = new byte[plaintextLength];
            if ((plaintextLength = this.cipher.update(ciphertextBuffer, 0, ciphertextRead, plaintextBuffer, 0)) <= length) {
                ArraysKt.copyInto$default((byte[])plaintextBuffer, (byte[])outputBuffer, (int)offset, (int)0, (int)plaintextLength, (int)4, null);
                readLength += plaintextLength;
            } else {
                ArraysKt.copyInto$default((byte[])plaintextBuffer, (byte[])outputBuffer, (int)offset, (int)0, (int)length, (int)4, null);
                this.overflowBuffer = ArraysKt.copyOfRange((byte[])plaintextBuffer, (int)length, (int)plaintextLength);
                readLength += length;
            }
            return readLength;
        }
        catch (ShortBufferException e) {
            throw new AssertionError((Object)e);
        }
    }

    private final int readFinal(byte[] buffer, int offset, int length) throws IOException {
        try {
            byte[] internal = new byte[buffer.length];
            int actualLength = Math.min(length, this.cipher.doFinal(internal, 0));
            ArraysKt.copyInto$default((byte[])internal, (byte[])buffer, (int)offset, (int)0, (int)actualLength, (int)4, null);
            this.done = true;
            return actualLength;
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e);
        }
        catch (BadPaddingException e) {
            throw new IOException(e);
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
    }
}

