/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.groups;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.storage.groups.GroupStore;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.DistributionId;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.internal.util.Hex;

public class LegacyGroupStore {
    private static final Logger logger = LoggerFactory.getLogger(LegacyGroupStore.class);

    public static void migrate(Storage storage, File groupCachePath, RecipientResolver recipientResolver, GroupStore groupStore) {
        List<GroupInfo> groups = storage.groups.stream().map(g -> {
            GroupMasterKey masterKey;
            if (g instanceof Storage.GroupV1) {
                Storage.GroupV1 g1 = (Storage.GroupV1)g;
                Set<RecipientId> members = g1.members.stream().map(m -> {
                    if (m.recipientId == null) {
                        return recipientResolver.resolveRecipient(new RecipientAddress(ServiceId.ACI.parseOrNull((String)m.uuid), m.number));
                    }
                    return recipientResolver.resolveRecipient(m.recipientId);
                }).filter(Objects::nonNull).collect(Collectors.toSet());
                return new GroupInfoV1(GroupIdV1.fromBase64(g1.groupId), g1.expectedV2Id == null ? null : GroupIdV2.fromBase64(g1.expectedV2Id), g1.name, members, g1.color, g1.messageExpirationTime, g1.blocked, g1.archived, null);
            }
            Storage.GroupV2 g2 = (Storage.GroupV2)g;
            GroupIdV2 groupId = GroupIdV2.fromBase64(g2.groupId);
            try {
                masterKey = new GroupMasterKey(Base64.getDecoder().decode(g2.masterKey));
            }
            catch (IllegalArgumentException | InvalidInputException e) {
                throw new AssertionError((Object)("Invalid master key for group " + groupId.toBase64()));
            }
            return new GroupInfoV2(groupId, masterKey, LegacyGroupStore.loadDecryptedGroupLocked(groupId, groupCachePath), g2.distributionId == null ? DistributionId.create() : DistributionId.from((String)g2.distributionId), g2.blocked, true, g2.permissionDenied, null, recipientResolver);
        }).toList();
        groupStore.addLegacyGroups(groups);
        LegacyGroupStore.removeGroupCache(groupCachePath);
    }

    private static void removeGroupCache(File groupCachePath) {
        File[] files = groupCachePath.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.error("Failed to delete group cache file {}: {}", (Object)file, (Object)e.getMessage());
            }
        }
        try {
            Files.delete(groupCachePath.toPath());
        }
        catch (IOException e) {
            logger.error("Failed to delete group cache directory {}: {}", (Object)groupCachePath, (Object)e.getMessage());
        }
    }

    private static DecryptedGroup loadDecryptedGroupLocked(GroupIdV2 groupIdV2, File groupCachePath) {
        DecryptedGroup decryptedGroup;
        File groupFile = LegacyGroupStore.getGroupV2File(groupIdV2, groupCachePath);
        if (!groupFile.exists()) {
            groupFile = LegacyGroupStore.getGroupV2FileLegacy(groupIdV2, groupCachePath);
        }
        if (!groupFile.exists()) {
            return null;
        }
        FileInputStream stream = new FileInputStream(groupFile);
        try {
            decryptedGroup = (DecryptedGroup)DecryptedGroup.ADAPTER.decode((InputStream)stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored) {
                return null;
            }
        }
        stream.close();
        return decryptedGroup;
    }

    private static File getGroupV2FileLegacy(GroupId groupId, File groupCachePath) {
        return new File(groupCachePath, Hex.toStringCondensed((byte[])groupId.serialize()));
    }

    private static File getGroupV2File(GroupId groupId, File groupCachePath) {
        return new File(groupCachePath, groupId.toBase64().replace("/", "_"));
    }

    public record Storage(@JsonDeserialize(using=GroupsDeserializer.class) List<Record> groups) {

        public record GroupV2(String groupId, String masterKey, String distributionId, @JsonInclude(value=JsonInclude.Include.NON_DEFAULT) boolean blocked, @JsonInclude(value=JsonInclude.Include.NON_DEFAULT) boolean permissionDenied) {
        }

        public record GroupV1(String groupId, String expectedV2Id, String name, String color, int messageExpirationTime, boolean blocked, boolean archived, @JsonDeserialize(using=MembersDeserializer.class) List<Member> members) {

            private static class MembersDeserializer
            extends JsonDeserializer<List<Member>> {
                private MembersDeserializer() {
                }

                public List<Member> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    ArrayList<Member> addresses = new ArrayList<Member>();
                    JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    for (JsonNode n : node) {
                        if (n.isTextual()) {
                            addresses.add(new Member(null, null, n.textValue()));
                            continue;
                        }
                        if (n.isNumber()) {
                            addresses.add(new Member(n.numberValue().longValue(), null, null));
                            continue;
                        }
                        JsonRecipientAddress address = (JsonRecipientAddress)jsonParser.getCodec().treeToValue((TreeNode)n, JsonRecipientAddress.class);
                        addresses.add(new Member(null, address.uuid, address.number));
                    }
                    return addresses;
                }
            }

            public record JsonRecipientAddress(String uuid, String number) {
            }

            public record Member(Long recipientId, String uuid, String number) {
            }
        }
    }

    private static class GroupsDeserializer
    extends JsonDeserializer<List<Object>> {
        private GroupsDeserializer() {
        }

        public List<Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ArrayList<Object> groups = new ArrayList<Object>();
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            for (JsonNode n : node) {
                Object g = n.hasNonNull("masterKey") ? jsonParser.getCodec().treeToValue((TreeNode)n, Storage.GroupV2.class) : jsonParser.getCodec().treeToValue((TreeNode)n, Storage.GroupV1.class);
                groups.add(g);
            }
            return groups;
        }
    }
}

