/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.util.Base64;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.SendMessageResultUtils;

public class SendPaymentNotificationCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "sendPaymentNotification";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Send a payment notification.");
        subparser.addArgument(new String[]{"recipient"}).help("Specify the recipient's phone number.");
        subparser.addArgument(new String[]{"--receipt"}).required(true).help("The base64 encoded receipt blob.");
        subparser.addArgument(new String[]{"--note"}).help("Specify a note for the payment notification.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        String recipientString = ns.getString("recipient");
        RecipientIdentifier.Single recipientIdentifier = CommandUtil.getSingleRecipientIdentifier(recipientString, m.getSelfNumber());
        String receiptString = ns.getString("receipt");
        byte[] receipt = Base64.getDecoder().decode(receiptString);
        String note = ns.getString("note");
        try {
            SendMessageResults results = m.sendPaymentNotificationMessage(receipt, note, recipientIdentifier);
            SendMessageResultUtils.outputResult(outputWriter, results);
        }
        catch (IOException e) {
            throw new UnexpectedErrorException("Failed to send message: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
    }
}

